/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.helpers.util;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.helpers.util.LogLevel;
import com.gridnine.xtrip.common.model.helpers.util.LogOutputStream;
import com.gridnine.xtrip.common.model.helpers.util.LogUtil;
import com.gridnine.xtrip.common.xml.XUtil;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import org.slf4j.Logger;

public class G9Logger {
    private final Logger log;
    private final String prefix;
    private final LogUtil logUtil;

    public G9Logger(Logger log, LogUtil logUtil) {
        this(log, logUtil, null);
    }

    public G9Logger(Logger log, LogUtil logUtil, String prefix) {
        this.log = log;
        this.prefix = prefix;
        this.logUtil = logUtil;
    }

    public boolean isDebugEnabled() {
        return this.log.isDebugEnabled();
    }

    public boolean isInfoEnabled() {
        return this.log.isInfoEnabled();
    }

    public boolean isErrorEnabled() {
        return this.log.isErrorEnabled();
    }

    public void debug(Object obj, Throwable throwable) {
        if (this.log.isDebugEnabled()) {
            this.log.debug(this.message(obj), throwable);
        }
    }

    public void debug(Object ... args) {
        if (this.log.isDebugEnabled()) {
            this.log.debug(this.message(args));
        }
    }

    public void debugXSerializable(EntityContainer<?> ctr) {
        if (!this.log.isDebugEnabled()) {
            return;
        }
        LogOutputStream os = new LogOutputStream(this.log, LogLevel.DEBUG);
        try {
            XUtil.serialize(ctr, (OutputStream)os);
        }
        catch (Exception e) {
            this.log.error("failed to serialize", (Throwable)e);
        }
        try {
            ((OutputStream)os).close();
        }
        catch (IOException e) {
            this.log.error("failed to close stream", (Throwable)e);
        }
    }

    public void info(Object obj, Throwable throwable) {
        if (this.log.isInfoEnabled()) {
            this.log.info(this.message(obj), throwable);
        }
    }

    public void info(Object ... args) {
        if (this.log.isInfoEnabled()) {
            this.log.info(this.message(args));
        }
    }

    public void error(Object obj, Throwable throwable) {
        if (this.log.isErrorEnabled()) {
            this.log.error(this.message(obj), throwable);
        }
    }

    public void error(Object ... args) {
        if (this.log.isErrorEnabled()) {
            this.log.error(this.message(args));
        }
    }

    private String message(Object ... args) {
        StringBuilder sb = this.prefix != null ? new StringBuilder(this.prefix) : new StringBuilder();
        for (Object o : args) {
            String s = o instanceof String ? (String)o : (o instanceof Enum ? ((Enum)o).name() : (o instanceof BigDecimal ? o.toString() : (o instanceof Integer ? o.toString() : this.logUtil.info(o))));
            sb.append(s);
        }
        return sb.toString();
    }
}

