/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.helpers.util;

import java.util.ArrayList;
import java.util.List;

public class G9Timing {
    private final List<Long> ticks = new ArrayList<Long>(2);
    private final List<String> labels = new ArrayList<String>(2);
    private boolean active = true;

    public G9Timing() {
        this.tick("started");
    }

    public void stop() {
        if (!this.active) {
            throw new RuntimeException("it is inactive");
        }
        this.tick("finished");
        this.active = false;
    }

    public void tick(String text) {
        this.ticks.add(System.currentTimeMillis());
        this.labels.add(text);
    }

    public long duration() {
        long t0 = this.ticks.get(0);
        long t1 = this.active ? System.currentTimeMillis() : this.ticks.get(this.ticks.size() - 1);
        return t1 - t0;
    }

    public String toString() {
        long duration = this.duration();
        int numOfTicks = this.ticks.size();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < numOfTicks; ++i) {
            Long time = this.ticks.get(i);
            String text = this.labels.get(i);
            sb.append(String.format("%tT - %s; ", time, text));
        }
        if (this.active) {
            sb.append("... ");
        }
        sb.append("duration: ").append(duration);
        return sb.toString();
    }
}

