/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.helpers.vat.hotel;

import com.gridnine.xtrip.common.model.booking.VatBasisType;
import com.gridnine.xtrip.common.model.booking.VatComponent;
import com.gridnine.xtrip.common.model.booking.VatDetalization;
import com.gridnine.xtrip.common.model.booking.xtriphotels.AdditionalService;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProduct;
import com.gridnine.xtrip.common.model.helpers.HotelProductHelper;
import com.gridnine.xtrip.common.model.system.VatAmount;
import com.gridnine.xtrip.common.util.MiscUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class HotelProductVatFiller {
    public static void updateVat(HotelProduct product) {
        if (product == null) {
            return;
        }
        product.setVendorVatDetalization(HotelProductVatFiller.getVendorVatDetalization(product));
    }

    public static VatDetalization getVendorVatDetalization(HotelProduct product) {
        VatDetalization result = new VatDetalization();
        result.getComponents().addAll(HotelProductVatFiller.createComponents(product));
        result.setDetalized(true);
        return result;
    }

    private static List<VatComponent> createComponents(HotelProduct prod) {
        ArrayList<VatComponent> result = new ArrayList<VatComponent>();
        HotelProductVatFiller.addVatComponent(result, HotelProductHelper.getEquivalentFare(prod), HotelProductHelper.getEquivalentVatFare(prod), VatBasisType.FARE);
        HotelProductVatFiller.addVatComponent(result, HotelProductHelper.calculateTaxesEquivalentAmount(prod), HotelProductHelper.calculateTaxesEquivalentVatAmount(prod), VatBasisType.TAXES);
        Map<Double, VatComponent> serviceVatComponents = prod.getAdditionalServices().stream().collect(Collectors.toMap(AdditionalService::getEquivalentVatRate, HotelProductVatFiller::toVatComponent, HotelProductVatFiller::composeVatComponents));
        result.addAll(serviceVatComponents.values());
        HotelProductVatFiller.addVatComponent(result, HotelProductHelper.calculatePenaltyEquivalentAmount(prod, true), HotelProductHelper.calculatePenaltyEquivalentVatAmount(prod, true), VatBasisType.PENALTY);
        return result;
    }

    private static void addVatComponent(List<VatComponent> components, BigDecimal total, BigDecimal vat, VatBasisType vatBasisType) {
        if (vat == null) {
            return;
        }
        VatComponent component = new VatComponent();
        VatAmount vatAmount = HotelProductVatFiller.createVatAmount(total, vat);
        component.setBasis(vatAmount.getTotal());
        Double rate = vatAmount.getVat();
        component.setRate(rate == null ? null : Double.valueOf(Math.round(rate)));
        component.setSum(vatAmount.getVatAmount());
        component.getBasisTypes().add(vatBasisType);
        components.add(component);
    }

    private static VatAmount createVatAmount(BigDecimal total, BigDecimal vatAmount) {
        VatAmount result = new VatAmount();
        result.setTotalVatAmount(total, vatAmount);
        return result;
    }

    private static VatComponent toVatComponent(AdditionalService addService) {
        VatComponent result = new VatComponent();
        result.setBasis(addService.getEquivalentAmount());
        result.setSum(addService.getEquivalentVatAmount());
        result.setRate(addService.getEquivalentVatRate());
        result.getBasisTypes().add(VatBasisType.SERVICE);
        return result;
    }

    private static VatComponent composeVatComponents(VatComponent vc1, VatComponent vc2) {
        vc1.setBasis(MiscUtil.sum((BigDecimal[])new BigDecimal[]{vc1.getBasis(), vc2.getBasis()}));
        vc1.setSum(MiscUtil.sum((BigDecimal[])new BigDecimal[]{vc1.getSum(), vc2.getSum()}));
        return vc1;
    }
}

