/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.localization.routeLine;

import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.localization.routeLine.CodeType;
import com.gridnine.xtrip.common.model.localization.routeLine.DictionaryReferenseLocalizer;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.Locale;
import java.util.StringTokenizer;

public class AviaLocalizer
extends DictionaryReferenseLocalizer<GeoLocation> {
    public static AviaLocalizer get() {
        return Holder.INSTANCE;
    }

    @Override
    public CodeType getCodeType() {
        return CodeType.AVIA;
    }

    @Override
    public Class<GeoLocation> getDictonaryCls() {
        return GeoLocation.class;
    }

    @Override
    public String localize(String code, Locale locale) {
        if (TextUtil.isBlank((String)code)) {
            return code;
        }
        StringTokenizer tokenizer = new StringTokenizer(code, "~");
        StringBuilder res = new StringBuilder();
        while (tokenizer.hasMoreTokens()) {
            if (res.length() > 0) {
                res.append(';');
            }
            res.append(super.localize(tokenizer.nextToken(), locale));
        }
        return res.toString();
    }

    private static class Holder {
        private static final AviaLocalizer INSTANCE = new AviaLocalizer();

        private Holder() {
        }
    }
}

