/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.localization.routeLine;

import com.gridnine.xtrip.common.model.localization.routeLine.CodeType;
import com.gridnine.xtrip.common.util.EnumUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Locale;
import java.util.Objects;
import java.util.stream.Stream;

public abstract class BaseLocalizer<T> {
    public static final String SEPARATOR_ROUTE = "<%>";
    public static final String SEPARATOR_CODE = "~";

    public abstract CodeType getCodeType();

    public abstract String getCode(T var1);

    public abstract String localize(String var1, Locale var2);

    public String getSeparatorLocalize() {
        return " \u2014 ";
    }

    public String localization(Locale locale, Stream<String> stream) {
        if (stream == null) {
            return null;
        }
        StringBuilder res = new StringBuilder();
        stream.filter(TextUtil::nonBlank).map(code -> this.localize((String)code, locale)).filter(TextUtil::nonBlank).forEach(s -> {
            if (res.length() > 0) {
                res.append(this.getSeparatorLocalize());
            }
            res.append((String)s);
        });
        return res.toString();
    }

    public <TT extends T> String encode(Stream<TT> stream) {
        if (stream == null) {
            return null;
        }
        StringBuilder res = new StringBuilder();
        res.append(EnumUtil.nameOf((Enum)this.getCodeType()));
        stream.filter(Objects::nonNull).map(this::getCode).filter(TextUtil::nonBlank).forEach(code -> {
            res.append(SEPARATOR_ROUTE);
            res.append((String)code);
        });
        return res.toString();
    }

    public String localization(Locale locale, String ... codes) {
        return this.localization(locale, codes != null ? Arrays.stream(codes) : null);
    }

    public String localization(Locale locale, Collection<String> codes) {
        return this.localization(locale, codes != null ? codes.stream() : null);
    }

    public <TT extends T> String encode(TT ... ts) {
        return this.encode(ts != null ? Arrays.stream(ts) : null);
    }

    public <TT extends T> String encode(Collection<TT> collection) {
        return this.encode(collection != null ? collection.stream() : null);
    }
}

