/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.meta;

import com.gridnine.xtrip.common.model.meta.OrganizationCwtPortraitDataRenamer;
import com.gridnine.xtrip.common.model.profile.CwtProfileData;
import com.gridnine.xtrip.common.util.IoUtil;
import com.gridnine.xtrip.common.util.XmlUtil;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class OrganizationCwtPortraitDataRenamerTest {
    @Test
    public void renameProperties() throws Exception {
        OrganizationCwtPortraitDataRenamer renamer = new OrganizationCwtPortraitDataRenamer();
        Document document = OrganizationCwtPortraitDataRenamerTest.getInputXML(IoUtil.url2file((URL)OrganizationCwtPortraitDataRenamerTest.class.getResource("testdata/testOrg.xml")));
        Element element = document.getDocumentElement();
        Element[] oldElements = XmlUtil.getElements((Element)element, (String)"travellerTypeNames/item");
        ArrayList<CwtProfileData> oldDataList = new ArrayList<CwtProfileData>();
        for (Element elem : oldElements) {
            String value = XmlUtil.getValue((Element)elem);
            CwtProfileData data = new CwtProfileData();
            data.setTravellerTypeName(value);
            oldDataList.add(data);
        }
        renamer.renameProperties(element);
        Assert.assertNull((Object)XmlUtil.getElement((Element)element, (String)"travellerTypeNames"));
        Assert.assertNotNull((Object)XmlUtil.getElement((Element)element, (String)"personCwtPortraitData"));
        Element[] newElements = XmlUtil.getElements((Element)element, (String)"personCwtPortraitData/item");
        Assert.assertThat((Object)oldElements.length, (Matcher)CoreMatchers.is((Object)newElements.length));
        ArrayList<CwtProfileData> newDataList = new ArrayList<CwtProfileData>();
        for (Element elem : newElements) {
            String value = XmlUtil.getValue((Element)XmlUtil.getChildren((Element)elem)[1]);
            CwtProfileData data = new CwtProfileData();
            data.setTravellerTypeName(value);
            newDataList.add(data);
        }
        for (CwtProfileData newData : newDataList) {
            Assert.assertTrue((boolean)oldDataList.stream().anyMatch(oldData -> oldData.getTravellerTypeName().equals(newData.getTravellerTypeName())));
        }
    }

    private static Document getInputXML(File file) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        return builder.parse(file);
    }
}

