/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.meta;

import com.gridnine.xtrip.common.meta.PropertiesRenamer;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.XmlUtil;
import com.gridnine.xtrip.common.xml.XHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Element;

public class ProductStatisticalDataRenamer
implements PropertiesRenamer {
    private static final List<String> MULTI_TRAVELLER_CLASSES = Arrays.asList("com.gridnine.xtrip.common.model.booking.bus.BusProduct", "com.gridnine.xtrip.common.model.booking.carrental.CarRentalProduct", "com.gridnine.xtrip.common.model.booking.cwt.CwtGeneralProduct", "com.gridnine.xtrip.common.model.booking.insurance.InsuranceTouristic", "com.gridnine.xtrip.common.model.booking.railway.RailwayMcoProduct", "com.gridnine.xtrip.common.model.booking.railway.RailwayProduct", "com.gridnine.xtrip.common.model.booking.taxi.TaxiProduct", "com.gridnine.xtrip.common.model.booking.transfers.Transfer", "com.gridnine.xtrip.common.model.booking.misc.UniversalProduct", "com.gridnine.xtrip.common.model.booking.visa.VisaProduct", "com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProduct", "com.gridnine.xtrip.common.vip.model.booking.transfers.TransferProduct");
    private static final Map<String, String> PRODUCT_TRAVELLER_PATH_MAP = new HashMap<String, String>();

    public void renameProperties(Element elm) {
        String productClass = elm.getAttribute("class");
        this.processCostCodes(elm, productClass);
    }

    private boolean isMultiTraveller(String productClass) {
        return MULTI_TRAVELLER_CLASSES.contains(productClass);
    }

    private void processCostCodes(Element productEl, String productClass) {
        Element[] travellerCostCodesItems;
        Element sdEl = XmlUtil.getElement((Element)productEl, (String)"statisticalData");
        if (sdEl == null) {
            return;
        }
        boolean isMultiTraveller = this.isMultiTraveller(productClass);
        Element costCodesEl = XmlUtil.getElement((Element)sdEl, (String)"costCodes");
        Element[] costCodesItems = costCodesEl == null ? new Element[]{} : XmlUtil.getElements((Element)costCodesEl, (String)"item");
        Element travellerCostCodesEl = XmlUtil.getElement((Element)sdEl, (String)"travellerCostCodes");
        Element[] elementArray = travellerCostCodesItems = travellerCostCodesEl == null ? new Element[]{} : XmlUtil.getElements((Element)travellerCostCodesEl, (String)"item");
        if (costCodesItems.length == 0 && travellerCostCodesItems.length == 0) {
            return;
        }
        if (isMultiTraveller && costCodesItems.length == 0) {
            return;
        }
        if (isMultiTraveller && travellerCostCodesItems.length != 0) {
            this.checkTravellerCostCodesProperties(travellerCostCodesItems, costCodesItems);
            return;
        }
        if (isMultiTraveller && travellerCostCodesItems.length == 0) {
            this.moveCostCodesToTravellerCostCodes(sdEl, costCodesEl, productClass);
            return;
        }
        if (!isMultiTraveller && costCodesItems.length != 0) {
            this.moveCostCodesToTravellerCostCodes(sdEl, costCodesEl, productClass);
            return;
        }
        if (!isMultiTraveller && travellerCostCodesItems.length != 0) {
            return;
        }
    }

    private void checkTravellerCostCodesProperties(Element[] travellerCostCodesItems, Element[] costCodesItems) {
        ArrayList<String> processedPropertiesUids = new ArrayList<String>();
        for (Element travellerItem : travellerCostCodesItems) {
            for (Element trCostCodesEl : XmlUtil.getElements((Element)travellerItem, (String)"costCodes/item")) {
                String propUid;
                Element travellerProp = XmlUtil.getElement((Element)trCostCodesEl, (String)"costCodeProperties");
                if (travellerProp == null || TextUtil.isBlank((String)(propUid = travellerProp.getAttribute("uid"))) || processedPropertiesUids.contains(propUid)) continue;
                processedPropertiesUids.add(propUid);
                Element propEl = this.findPropertiesElement(propUid, costCodesItems);
                if (propEl == null) continue;
                trCostCodesEl.removeChild(travellerProp);
                trCostCodesEl.appendChild(propEl);
            }
        }
    }

    private Element findPropertiesElement(String propUid, Element[] costCodesItems) {
        for (Element element : costCodesItems) {
            String uid;
            Element propEl = XmlUtil.getElement((Element)element, (String)"costCodeProperties");
            if (propEl == null || !MiscUtil.equals((Object)propUid, (Object)(uid = XHelper.readString((Element)propEl, (String)"uid")))) continue;
            return propEl;
        }
        return null;
    }

    private void moveCostCodesToTravellerCostCodes(Element sdEl, Element costCodesEl, String productClass) {
        Element[] travellerCostCodesItems;
        if (costCodesEl == null) {
            return;
        }
        Element travellerCostCodesEl = XmlUtil.getElement((Element)sdEl, (String)"travellerCostCodes");
        if (travellerCostCodesEl == null) {
            travellerCostCodesEl = XmlUtil.addElement((Element)sdEl, (String)"travellerCostCodes");
        }
        if ((travellerCostCodesItems = XmlUtil.getElements((Element)travellerCostCodesEl, (String)"item")).length == 0) {
            Element el = XmlUtil.addElement((Element)travellerCostCodesEl, (String)"item");
            el.setAttribute("class", "com.gridnine.xtrip.common.model.booking.TravellerCostCodes");
        }
        for (Element tccItem : travellerCostCodesItems = XmlUtil.getElements((Element)travellerCostCodesEl, (String)"item")) {
            Element travellerEl;
            String travellerUid;
            String path = PRODUCT_TRAVELLER_PATH_MAP.get(productClass);
            if (TextUtil.nonBlank((String)path) && TextUtil.nonBlank((String)(travellerUid = XHelper.readString((Element)((Element)sdEl.getParentNode()), (String)path))) && (travellerEl = XmlUtil.getElement((Element)tccItem, (String)"traveller")) == null) {
                travellerEl = XmlUtil.addElement((Element)tccItem, (String)"traveller");
                travellerEl.setAttribute("class", "com.gridnine.xtrip.common.model.booking.Traveller");
                travellerEl.setAttribute("uid", travellerUid);
            }
            XmlUtil.deleteChild((Element)tccItem, (String)"costCodes");
            tccItem.appendChild(costCodesEl.cloneNode(true));
        }
    }

    static {
        PRODUCT_TRAVELLER_PATH_MAP.put("com.gridnine.xtrip.common.model.booking.insurance.InsuranceAccident", "travellerUid");
        PRODUCT_TRAVELLER_PATH_MAP.put("com.gridnine.xtrip.common.model.booking.misc.UniversalProduct", "travellersUids/item");
        PRODUCT_TRAVELLER_PATH_MAP.put("com.gridnine.xtrip.common.model.booking.taxi.TaxiProduct", "travellers/item@uid");
        PRODUCT_TRAVELLER_PATH_MAP.put("com.gridnine.xtrip.common.model.booking.additionalservice.AdditionalServiceProduct", "travellers/item@uid");
        PRODUCT_TRAVELLER_PATH_MAP.put("com.gridnine.xtrip.common.model.delivery.Delivery", null);
        PRODUCT_TRAVELLER_PATH_MAP.put("com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProduct", "travellers/item@uid");
        PRODUCT_TRAVELLER_PATH_MAP.put("com.gridnine.xtrip.common.model.booking.AeroexpressTicket", "traveller@uid");
        PRODUCT_TRAVELLER_PATH_MAP.put("com.gridnine.xtrip.common.model.booking.railway.RailwayCrimeaMco", "passengers/item@uid");
        PRODUCT_TRAVELLER_PATH_MAP.put("com.gridnine.xtrip.common.model.booking.insurance.InsuranceTouristic", "travellersUids/item");
        PRODUCT_TRAVELLER_PATH_MAP.put("com.gridnine.xtrip.common.model.booking.visa.VisaProduct", "travellers/item@uid");
        PRODUCT_TRAVELLER_PATH_MAP.put("com.gridnine.xtrip.common.model.booking.misc.AgentTouch", null);
        PRODUCT_TRAVELLER_PATH_MAP.put("com.gridnine.xtrip.common.model.booking.agencymemo.AgencyMemoProduct", null);
        PRODUCT_TRAVELLER_PATH_MAP.put("com.gridnine.xtrip.common.model.booking.transfers.Transfer", "travellers/item@uid");
        PRODUCT_TRAVELLER_PATH_MAP.put("com.gridnine.xtrip.common.model.booking.air.Product", "traveller@uid");
        PRODUCT_TRAVELLER_PATH_MAP.put("com.gridnine.xtrip.common.model.booking.railway.RailwayMcoProduct", "passengers/item@uid");
        PRODUCT_TRAVELLER_PATH_MAP.put("com.gridnine.xtrip.common.model.booking.railway.RailwayProduct", "passengers/item@uid");
        PRODUCT_TRAVELLER_PATH_MAP.put("com.gridnine.xtrip.common.model.booking.misc.ProductVoiding", null);
        PRODUCT_TRAVELLER_PATH_MAP.put("com.gridnine.xtrip.common.model.booking.bus.BusProduct", "travellers/item@uid");
        PRODUCT_TRAVELLER_PATH_MAP.put("com.gridnine.xtrip.common.model.booking.railway.RailwayReferenceMCO", null);
        PRODUCT_TRAVELLER_PATH_MAP.put("com.gridnine.xtrip.common.model.booking.carrental.CarRentalProduct", "travellers/item@uid");
        PRODUCT_TRAVELLER_PATH_MAP.put("com.gridnine.xtrip.common.model.booking.MiscProduct", null);
        PRODUCT_TRAVELLER_PATH_MAP.put("com.gridnine.xtrip.common.model.booking.MCOFees", "travellerUid");
        PRODUCT_TRAVELLER_PATH_MAP.put("com.gridnine.xtrip.common.model.vip.VctFakeFinanceProduct", null);
        PRODUCT_TRAVELLER_PATH_MAP.put("com.gridnine.xtrip.common.model.booking.insurance.InsuranceTripCancel", "travellerUid");
        PRODUCT_TRAVELLER_PATH_MAP.put("com.gridnine.xtrip.common.vip.model.passnfly.PassnflyCheckinProduct", "travellers/item@uid");
        PRODUCT_TRAVELLER_PATH_MAP.put("com.gridnine.xtrip.common.model.booking.cwt.CwtGeneralProduct", "travellers/item@uid");
        PRODUCT_TRAVELLER_PATH_MAP.put("com.gridnine.xtrip.common.vip.model.booking.transfers.TransferProduct", "travellers/item@uid");
    }
}

