/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.meta;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.meta.PropertiesRenamer;
import com.gridnine.xtrip.common.model.dict.GeoRegion;
import com.gridnine.xtrip.common.model.dict.GeoRegionProvider;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.XmlUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class RegionAddressRenamer
implements PropertiesRenamer {
    private static final Logger log = LoggerFactory.getLogger(RegionAddressRenamer.class);

    public void renameProperties(Element elm) {
        String value;
        Element regionElm = XmlUtil.getElement((Element)elm, (String)"region");
        if (regionElm == null || TextUtil.nonBlank((String)regionElm.getAttribute("class"))) {
            return;
        }
        String code = value = XmlUtil.getValue((Element)regionElm);
        if (value != null) {
            try {
                ((GeoRegionProvider)Environment.getPublished(GeoRegionProvider.class)).saveGeoRegion(value);
                code = RegionAddressRenamer.getGeoRegionCode(value);
            }
            catch (Exception e) {
                log.error(String.format("failed to save GeoRegion from value %s", value), (Throwable)e);
            }
        }
        XmlUtil.setValue((Element)regionElm, (String)code);
        regionElm.setAttribute("caption", code);
        regionElm.setAttribute("class", GeoRegion.class.getName());
    }

    private static String getGeoRegionCode(String value) {
        String code = DictHelper.getGeoRegionCode(DictHelper.getTranslationsFromL10nString(value));
        if (TextUtil.nonBlank((String)code)) {
            return code;
        }
        return value;
    }
}

