/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.redapp.sws;

import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class PassengerType {
    public static final PassengerType ADULT = new PassengerType("ADT", L10nResourcesManager.getStr((String)"ADULT", (Object[])new Object[0]));
    public static final PassengerType CHILD = new PassengerType("CNN", L10nResourcesManager.getStr((String)"CHILD", (Object[])new Object[0]));
    public static final PassengerType INFANT = new PassengerType("INF", L10nResourcesManager.getStr((String)"INFANT", (Object[])new Object[0]));
    public static final PassengerType INFANT_WITH_SEAT = new PassengerType("INS", L10nResourcesManager.getStr((String)"INFANT_WITH_SEAT", (Object[])new Object[0]));
    private final String code;
    private final String description;

    private PassengerType(String code, String description) {
        this.code = code;
        this.description = description;
    }

    public static PassengerType ofCode(String code) {
        if (StringUtils.isEmpty((String)code)) {
            return null;
        }
        if (Pattern.compile("C\\d{2}").matcher(code).matches()) {
            return CHILD;
        }
        switch (code) {
            case "ADT": {
                return ADULT;
            }
            case "CNN": {
                return CHILD;
            }
            case "INF": {
                return INFANT;
            }
            case "INS": {
                return INFANT_WITH_SEAT;
            }
        }
        return new PassengerType(code, null);
    }

    public String getCode() {
        return this.code;
    }

    public String getDescription() {
        return this.description;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.code == null ? 0 : this.code.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PassengerType other = (PassengerType)obj;
        if (this.code == null) {
            return other.code == null;
        }
        return this.code.equals(other.code);
    }

    public String toString() {
        return this.code;
    }
}

