/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.redapp.sws.remark;

import com.gridnine.xtrip.common.Disposable;
import com.gridnine.xtrip.common.model.redapp.sws.Remark;
import com.gridnine.xtrip.common.model.redapp.sws.remark.ConsoleRemark;
import com.gridnine.xtrip.common.model.redapp.sws.remark.RemarkController;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public final class RemarkParserRegistry
implements Disposable {
    private final Map<String, RemarkController<? extends ConsoleRemark>> remarkControllers = new HashMap<String, RemarkController<? extends ConsoleRemark>>();

    public void registerConsoleRemarkController(RemarkController<? extends ConsoleRemark> controller) {
        Class<? extends ConsoleRemark> remarkClass = controller.getRemarkClass();
        if (remarkClass == null) {
            throw new IllegalStateException(String.format("Remark class is undefined for controller [%s]", controller.getClass().getSimpleName()));
        }
        RemarkController<? extends ConsoleRemark> existed = this.remarkControllers.putIfAbsent(remarkClass.getName(), controller);
        if (existed != null) {
            throw new IllegalStateException(String.format("Controller for remark [%s] is already registered", controller.getRemarkClass().getName()));
        }
    }

    public <T extends ConsoleRemark> Remark compose(T remark) {
        if (remark == null) {
            return null;
        }
        RemarkController<T> controller = this.getController(remark.getClass());
        return controller.compose(remark);
    }

    private <T extends ConsoleRemark> RemarkController<T> getController(Class<? extends ConsoleRemark> remarkClass) {
        RemarkController<? extends ConsoleRemark> controller = this.remarkControllers.get(remarkClass.getName());
        if (controller == null) {
            throw new IllegalStateException(String.format("Cannot find controller for remark [%s]", remarkClass.getName()));
        }
        return controller;
    }

    public ConsoleRemark parse(Remark remark) {
        if (remark == null) {
            return null;
        }
        return this.remarkControllers.values().stream().filter(c -> c.match(remark)).findFirst().map(c -> c.parse(remark)).orElse(null);
    }

    public <T extends ConsoleRemark> List<T> filterAndParse(List<Remark> remarks, Class<T> targetRemarkClass) {
        RemarkController<T> controller = this.getController(targetRemarkClass);
        return remarks.stream().filter(controller::match).map(controller::parse).collect(Collectors.toList());
    }

    public void dispose() {
    }
}

