/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.redapp.vat.handlers;

import com.gridnine.xtrip.common.model.redapp.VatDetalization;
import com.gridnine.xtrip.common.model.redapp.sws.Remark;
import com.gridnine.xtrip.common.model.redapp.sws.remark.RemarkParserRegistry;
import com.gridnine.xtrip.common.model.redapp.vat.handlers.AbstractVatDetalizationHandler;
import com.gridnine.xtrip.common.model.redapp.vat.handlers.VatAppEnvironment;
import com.gridnine.xtrip.common.model.redapp.vat.parsers.remark.VatHistoricalRemark;
import com.gridnine.xtrip.common.model.redapp.vat.parsers.remark.VatInvoiceRemark;
import com.gridnine.xtrip.common.model.redapp.vat.parsers.remark.VatRateRemark;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;

public class VatDetalizationSuHandler
extends AbstractVatDetalizationHandler {
    public static final String VAT_SU_ENDORSEMENT_ENTRY = "\\/?INCL VAT ([0-9.-]*)[A-Z]{0,3}";

    @Override
    public String createVatForEndorsement() {
        return "INCL VAT " + this.getVatSumAmount() + "RUB";
    }

    @Override
    public String removeVatFromEndorsement(String endorsement) {
        return endorsement.replaceAll(VAT_SU_ENDORSEMENT_ENTRY, "");
    }

    @Override
    public Collection<Remark> buildRemarks(String travelerNumber, String ticket) {
        RemarkParserRegistry registry = VatAppEnvironment.get().getRemarkParserRegistry();
        ArrayList<Remark> result = new ArrayList<Remark>();
        String vatAmount = this.getVatSumAmount();
        String vatRate = this.vatDetails.stream().filter(d -> d.getFare() != null).findFirst().map(VatDetalization::getVatRate).map(r -> this.formatRate((BigDecimal)r)).orElse("-");
        result.add(registry.compose(new VatRateRemark(null, vatAmount, vatRate, travelerNumber)));
        result.add(registry.compose(new VatInvoiceRemark(null, vatAmount, travelerNumber, ticket)));
        result.add(registry.compose(new VatHistoricalRemark(null, vatAmount, travelerNumber, ticket)));
        return result;
    }

    private String getVatSumAmount() {
        return this.vatDetails.stream().map(VatDetalization::getVatAmount).filter(Objects::nonNull).reduce(BigDecimal::add).filter(v -> BigDecimal.ZERO.compareTo((BigDecimal)v) != 0).map(BigDecimal::toString).orElse("0");
    }

    @Override
    protected boolean hasVatEntry(String text) {
        return text != null && text.matches("(.*)\\/?INCL VAT ([0-9.-]*)[A-Z]{0,3}(.*)");
    }

    @Override
    protected boolean hasOnlyVatEndorsement(String text) {
        return text != null && text.matches("ED\\/?INCL VAT ([0-9.-]*)[A-Z]{0,3}");
    }
}

