/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.redapp.vat.handlers;

import com.gridnine.xtrip.common.model.redapp.Tax;
import com.gridnine.xtrip.common.model.redapp.VatDetalization;
import com.gridnine.xtrip.common.model.redapp.sws.Remark;
import com.gridnine.xtrip.common.model.redapp.sws.remark.RemarkParserRegistry;
import com.gridnine.xtrip.common.model.redapp.vat.handlers.AbstractVatDetalizationHandler;
import com.gridnine.xtrip.common.model.redapp.vat.handlers.VatAppEnvironment;
import com.gridnine.xtrip.common.model.redapp.vat.parsers.remark.TchVatHistoricalRemark;
import com.gridnine.xtrip.common.model.redapp.vat.parsers.remark.TchVatInvoiceRemark;
import com.gridnine.xtrip.common.model.redapp.vat.parsers.remark.TchVatRateRemark;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;

public class VatDetalizationTchHandler
extends AbstractVatDetalizationHandler {
    private static final String TCH_VAT_ENDORSEMENT_ENTRY = "\\/?NDSA\\/[CK][0-9.-]* NDSZZ[0-9.-]*";

    @Override
    public String createVatForEndorsement() {
        return "NDSA/C" + this.getTicketVatAmount() + " NDSZZ" + this.getZZVatAmount(this.findZzDetalizationOpt());
    }

    @Override
    public String removeVatFromEndorsement(String endorsement) {
        return endorsement.replaceAll(TCH_VAT_ENDORSEMENT_ENTRY, "");
    }

    @Override
    public Collection<Remark> buildRemarks(String travelerNumber, String ticket) {
        RemarkParserRegistry registry = VatAppEnvironment.get().getRemarkParserRegistry();
        String ticketVatAmount = this.getTicketVatAmount();
        String ticketVatRate = this.vatDetails.stream().filter(d -> d.getFare() != null).findFirst().map(VatDetalization::getVatRate).map(r -> this.formatRate((BigDecimal)r)).orElse("-");
        Optional<VatDetalization> zzDetalization = this.findZzDetalizationOpt();
        String zzVatAmount = this.getZZVatAmount(zzDetalization);
        String zzVatRate = zzDetalization.map(VatDetalization::getVatRate).map(r -> this.formatRate((BigDecimal)r)).orElse("-");
        ArrayList<Remark> result = new ArrayList<Remark>();
        result.add(registry.compose(new TchVatRateRemark(null, ticketVatAmount, ticketVatRate, zzVatAmount, zzVatRate, travelerNumber)));
        result.add(registry.compose(new TchVatInvoiceRemark(null, ticketVatAmount, zzVatAmount, travelerNumber, ticket)));
        result.add(registry.compose(new TchVatHistoricalRemark(null, ticketVatAmount, zzVatAmount, travelerNumber, ticket)));
        return result;
    }

    public Optional<VatDetalization> findZzDetalizationOpt() {
        return this.vatDetails.stream().filter(d -> !d.getTaxes().isEmpty() && d.getTaxes().stream().map(Tax::getCode).allMatch("ZZ"::equalsIgnoreCase)).findFirst();
    }

    private String getTicketVatAmount() {
        String value = this.vatDetails.stream().filter(d -> d.getTaxes().stream().noneMatch(t -> "ZZ".equals(t.getCode()))).findFirst().orElse(null) == null ? "0.00" : "-";
        return this.vatDetails.stream().filter(d -> d.getTaxes().stream().noneMatch(t -> "ZZ".equals(t.getCode()))).map(VatDetalization::getVatAmount).filter(Objects::nonNull).reduce(BigDecimal::add).map(BigDecimal::toString).orElse(value);
    }

    private String getZZVatAmount(Optional<VatDetalization> zzDetalization) {
        return zzDetalization.map(VatDetalization::getVatAmount).map(BigDecimal::toString).orElse("-");
    }

    @Override
    protected boolean hasVatEntry(String text) {
        return text != null && text.matches("(.*)\\/?NDSA\\/[CK][0-9.-]* NDSZZ[0-9.-]*(.*)");
    }

    @Override
    protected boolean hasOnlyVatEndorsement(String text) {
        return text != null && text.matches("ED\\/?NDSA\\/[CK][0-9.-]* NDSZZ[0-9.-]*");
    }
}

