/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.redapp.vat.handlers;

import com.gridnine.xtrip.common.Disposable;
import com.gridnine.xtrip.common.model.redapp.Tax;
import com.gridnine.xtrip.common.model.redapp.VatDetalization;
import com.gridnine.xtrip.common.model.redapp.vat.handlers.AbstractVatDetalizationHandler;
import com.gridnine.xtrip.common.model.redapp.vat.handlers.VatDetalizationHandler;
import com.gridnine.xtrip.common.model.redapp.vat.handlers.VatDetalizationSuHandler;
import com.gridnine.xtrip.common.model.redapp.vat.handlers.VatDetalizationTchHandler;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class VatHandlersRegistry
implements Disposable {
    private static final Map<String, AbstractVatDetalizationHandler> HANDLERS = new HashMap<String, AbstractVatDetalizationHandler>(){
        {
            this.put(VatDetalizationTchHandler.class.getName(), new VatDetalizationTchHandler());
            this.put(VatDetalizationSuHandler.class.getName(), new VatDetalizationSuHandler());
        }
    };

    public static VatDetalizationHandler getHandler(List<VatDetalization> details) {
        AbstractVatDetalizationHandler handler = VatHandlersRegistry.isZzTaxPresent(details) ? HANDLERS.get(VatDetalizationTchHandler.class.getName()) : HANDLERS.get(VatDetalizationSuHandler.class.getName());
        handler.acceptVatDetalization(details);
        return handler;
    }

    public static boolean hasAnyVatEntry(String text) {
        return HANDLERS.values().stream().anyMatch(h -> h.hasVatEntry(text));
    }

    public static boolean hasOnlyVatEntry(String text) {
        return HANDLERS.values().stream().anyMatch(h -> h.hasOnlyVatEndorsement(text));
    }

    public static String removeAnyVatEntry(String text) {
        String result = text;
        for (AbstractVatDetalizationHandler handler : HANDLERS.values()) {
            result = handler.removeVatFromEndorsement(result);
        }
        return result;
    }

    private static boolean isZzTaxPresent(List<VatDetalization> details) {
        return details.stream().map(VatDetalization::getTaxes).flatMap(Collection::stream).map(Tax::getCode).anyMatch("ZZ"::equalsIgnoreCase);
    }

    public void dispose() {
        HANDLERS.clear();
    }
}

