/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.redapp.vat.parsers.remark;

import com.gridnine.xtrip.common.model.redapp.sws.Remark;
import com.gridnine.xtrip.common.model.redapp.sws.RemarkType;
import com.gridnine.xtrip.common.model.redapp.sws.remark.RemarkController;
import com.gridnine.xtrip.common.model.redapp.vat.parsers.remark.TchVatInvoiceRemark;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TchVatInvoiceRemarkParser
implements RemarkController<TchVatInvoiceRemark> {
    private static final Pattern PATTERN = Pattern.compile("XVAT\\*(?<ticketNumber>[^\\*]*)\\*NDSA\\/C(?<ticketVat>[0-9.-]*) NDSZZ(?<zzVat>[0-9.-]*)-(?<travelerNumber>[0-9]{1,2}\\.[0-9]{1,2})?");

    @Override
    public boolean match(Remark remark) {
        return remark.getType() == RemarkType.Invoice && PATTERN.matcher(remark.getText()).matches();
    }

    @Override
    public TchVatInvoiceRemark parse(Remark remark) {
        Matcher matcher = PATTERN.matcher(remark.getText());
        if (matcher.matches()) {
            return new TchVatInvoiceRemark(remark.getRph(), matcher.group("ticketVat"), matcher.group("zzVat"), matcher.group("travelerNumber"), matcher.group("ticketNumber"));
        }
        throw new IllegalStateException(String.format("Cannot parse remark [ %s ]", remark.getText()));
    }

    @Override
    public Remark compose(TchVatInvoiceRemark consoleRemark) {
        StringBuilder sb = new StringBuilder("XVAT*");
        if (consoleRemark.getTicketNumber() != null) {
            sb.append(consoleRemark.getTicketNumber());
        }
        sb.append("*NDSA/C");
        if (consoleRemark.getTicketVatAmount() != null) {
            sb.append(consoleRemark.getTicketVatAmount());
        }
        sb.append(" NDSZZ");
        if (consoleRemark.getZzTaxVatAmount() != null) {
            sb.append(consoleRemark.getZzTaxVatAmount());
        }
        sb.append("-");
        if (consoleRemark.getTravelerNameNumber() != null) {
            sb.append(consoleRemark.getTravelerNameNumber());
        }
        Remark result = new Remark();
        result.setType(RemarkType.Invoice);
        result.setText(sb.toString());
        return result;
    }

    @Override
    public Class<TchVatInvoiceRemark> getRemarkClass() {
        return TchVatInvoiceRemark.class;
    }
}

