/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.redapp.vat.parsers.remark;

import com.gridnine.xtrip.common.model.redapp.sws.Remark;
import com.gridnine.xtrip.common.model.redapp.sws.RemarkType;
import com.gridnine.xtrip.common.model.redapp.sws.remark.RemarkController;
import com.gridnine.xtrip.common.model.redapp.vat.parsers.remark.VatInvoiceRemark;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class VatInvoiceRemarkParser
implements RemarkController<VatInvoiceRemark> {
    private static final Pattern PATTERN = Pattern.compile("XVAT\\*(?<ticketNumber>[^\\*]*)\\*INCL VAT A\\/C(?<ticketVat>[0-9.-]*)-(?<travelerNumber>[0-9]{1,2}\\.[0-9]{1,2})?");

    @Override
    public boolean match(Remark remark) {
        return remark.getType() == RemarkType.Invoice && PATTERN.matcher(remark.getText()).matches();
    }

    @Override
    public VatInvoiceRemark parse(Remark remark) {
        Matcher matcher = PATTERN.matcher(remark.getText());
        if (matcher.matches()) {
            return new VatInvoiceRemark(remark.getRph(), matcher.group("ticketVat"), matcher.group("travelerNumber"), matcher.group("ticketNumber"));
        }
        throw new IllegalStateException(String.format("Cannot parse remark [ %s ]", remark.getText()));
    }

    @Override
    public Remark compose(VatInvoiceRemark consoleRemark) {
        StringBuilder sb = new StringBuilder("XVAT*");
        if (consoleRemark.getTicketNumber() != null) {
            sb.append(consoleRemark.getTicketNumber());
        }
        sb.append("*INCL VAT A/C");
        if (consoleRemark.getTicketVatAmount() != null) {
            sb.append(consoleRemark.getTicketVatAmount());
        }
        sb.append("-");
        if (consoleRemark.getTravelerNameNumber() != null) {
            sb.append(consoleRemark.getTravelerNameNumber());
        }
        Remark result = new Remark();
        result.setType(RemarkType.Invoice);
        result.setText(sb.toString());
        return result;
    }

    @Override
    public Class<VatInvoiceRemark> getRemarkClass() {
        return VatInvoiceRemark.class;
    }
}

