/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.restriction.resource;

import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.GeneralProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.SalesChain;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.handlers.HandlersRegistry;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.profile.ContractRelationDescription;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.restriction.resource.ModelRestrictionEntityResources;
import com.gridnine.xtrip.common.model.restriction.resource.ModelRestrictionResourceProxyBuilders;
import com.gridnine.xtrip.common.restriction.resource.RestrictionMatchable;
import com.gridnine.xtrip.common.restriction.resource.RestrictionResourceProperty;
import com.gridnine.xtrip.common.restriction.resource.RestrictionResourceProxy;
import com.gridnine.xtrip.common.restriction.resource.standard.StandardRestrictionResourcePropertyCategory;
import java.util.ArrayList;

public enum ModelRestrictionContractRelationDataResourceProperties implements RestrictionResourceProperty,
RestrictionMatchable
{
    CONTRACT_TYPE{

        @Override
        public String getIdSuffix() {
            return "contractType";
        }

        public String getName() {
            return "\u0422\u0438\u043f \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430";
        }

        public Class<?> getType() {
            return ContractType.class;
        }

        public boolean isCollection() {
            return false;
        }

        public boolean isTimeIncluded() {
            return false;
        }

        public String getCategoryId() {
            return StandardRestrictionResourcePropertyCategory.ENUM.name();
        }

        public void init(RestrictionResourceProxy proxy, Object object) {
            proxy.getProperties().put(this.getId(), GeneralProductHelper.getContractType((EntityReference<ContractRelationDescription>)((GeneralProductContractRelationData)object).getDescription()));
        }
    }
    ,
    CONTRACTOR{

        @Override
        public String getIdSuffix() {
            return "contractor";
        }

        public String getName() {
            return "\u041a\u043e\u043d\u0442\u0440\u0430\u0433\u0435\u043d\u0442";
        }

        public Class<?> getType() {
            return Organization.class;
        }

        public boolean isCollection() {
            return false;
        }

        public boolean isTimeIncluded() {
            return false;
        }

        public String getCategoryId() {
            return StandardRestrictionResourcePropertyCategory.ENTITY.name();
        }

        public void init(RestrictionResourceProxy proxy, Object object) {
            GeneralProductContractRelationData contractRelationData = (GeneralProductContractRelationData)object;
            ContractType contractType = GeneralProductHelper.getContractType((EntityReference<ContractRelationDescription>)contractRelationData.getDescription());
            ArrayList<EntityReference<Organization>> contractors = new ArrayList<EntityReference<Organization>>();
            for (RestrictionResourceProxy parentProxy = proxy.getParent(); parentProxy != null; parentProxy = parentProxy.getParent()) {
                EntityReference<Organization> customer;
                if (!parentProxy.getResourceId().equals(ModelRestrictionResourceProxyBuilders.PROXY_BUILDER_ENTITY_PRODUCT.getResourceId())) continue;
                BaseProduct baseProduct = (BaseProduct)parentProxy.getObject();
                ProductHandler<?> handler = HandlersRegistry.get().findProductHandler(baseProduct.getClass());
                if (handler == null) continue;
                SalesChain salesChain = handler.getSalesChain(baseProduct);
                EntityReference<Organization> supplier = GeneralProductHelper.getContractRelationSupplier((EntityReference<ContractRelationDescription>)contractRelationData.getDescription(), salesChain);
                if (supplier != null) {
                    contractors.add(supplier);
                }
                EntityReference<Organization> entityReference = customer = contractType == ContractType.CLIENT ? baseProduct.getReservation().getBookingFile().getCustomerProfile() : GeneralProductHelper.getContractRelationCustomer((EntityReference<ContractRelationDescription>)contractRelationData.getDescription(), salesChain);
                if (customer == null) continue;
                contractors.add(customer);
            }
            proxy.getProperties().put(this.getId(), contractors);
        }
    };


    public abstract String getIdSuffix();

    public String getId() {
        return String.format("%s.%s", this.getResourceId(), this.getIdSuffix());
    }

    public String getDescriprion() {
        return this.getName();
    }

    public String getResourceId() {
        return ModelRestrictionEntityResources.ENTITY_CONTRACT_RELATION_DATA.getId();
    }

    public Object getValue(RestrictionResourceProxy proxy) {
        return proxy.getProperties().get(this.getId());
    }
}

