/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.restriction.resource;

import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.profile.Contract;
import com.gridnine.xtrip.common.model.profile.ContractCustomerInfo;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.restriction.resource.ModelRestrictionEntityResources;
import com.gridnine.xtrip.common.restriction.resource.RestrictionMatchable;
import com.gridnine.xtrip.common.restriction.resource.RestrictionResourceProperty;
import com.gridnine.xtrip.common.restriction.resource.RestrictionResourceProxy;
import com.gridnine.xtrip.common.restriction.resource.standard.StandardRestrictionResourcePropertyCategory;
import java.util.ArrayList;

public enum ModelRestrictionContractResourceProperties implements RestrictionResourceProperty,
RestrictionMatchable
{
    OWNERSHIP{

        @Override
        public String getIdSuffix() {
            return "ownership";
        }

        public String getName() {
            return "\u041f\u0440\u0438\u043d\u0430\u0434\u043b\u0435\u0436\u043d\u043e\u0441\u0442\u044c";
        }

        public Class<?> getType() {
            return Contract.class;
        }

        public boolean isCollection() {
            return false;
        }

        public boolean isTimeIncluded() {
            return false;
        }

        public String getCategoryId() {
            return StandardRestrictionResourcePropertyCategory.ENTITY.name();
        }

        public void init(RestrictionResourceProxy proxy, Object object) {
            proxy.getProperties().put(this.getId(), new EntityReference(proxy.containerUid(), Contract.class, null));
        }
    }
    ,
    TYPE{

        @Override
        public String getIdSuffix() {
            return "type";
        }

        public String getName() {
            return "\u0422\u0438\u043f";
        }

        public Class<?> getType() {
            return ContractType.class;
        }

        public boolean isCollection() {
            return false;
        }

        public boolean isTimeIncluded() {
            return false;
        }

        public String getCategoryId() {
            return StandardRestrictionResourcePropertyCategory.ENUM.name();
        }

        public void init(RestrictionResourceProxy proxy, Object object) {
            proxy.getProperties().put(this.getId(), ((Contract)object).getContractType());
        }
    }
    ,
    BLANK_OWNER{

        @Override
        public String getIdSuffix() {
            return "blankOwner";
        }

        public String getName() {
            return "\u0412\u043b\u0430\u0434\u0435\u043b\u0435\u0446 \u0431\u043b\u0430\u043d\u043a\u043e\u0432";
        }

        public Class<?> getType() {
            return Organization.class;
        }

        public boolean isCollection() {
            return false;
        }

        public boolean isTimeIncluded() {
            return false;
        }

        public String getCategoryId() {
            return StandardRestrictionResourcePropertyCategory.ENTITY.name();
        }

        public void init(RestrictionResourceProxy proxy, Object object) {
            proxy.getProperties().put(this.getId(), ((Contract)object).getVendor());
        }
    }
    ,
    SUPPLIER{

        @Override
        public String getIdSuffix() {
            return "supplier";
        }

        public String getName() {
            return "\u041f\u043e\u0441\u0442\u0430\u0432\u0449\u0438\u043a";
        }

        public Class<?> getType() {
            return Organization.class;
        }

        public boolean isCollection() {
            return false;
        }

        public boolean isTimeIncluded() {
            return false;
        }

        public String getCategoryId() {
            return StandardRestrictionResourcePropertyCategory.ENTITY.name();
        }

        public void init(RestrictionResourceProxy proxy, Object object) {
            proxy.getProperties().put(this.getId(), ((Contract)object).getSupplier());
        }
    }
    ,
    AGENCY_OR_CLIENT{

        @Override
        public String getIdSuffix() {
            return "agencyOrClient";
        }

        public String getName() {
            return "\u0410\u0433\u0435\u043d\u0442\u0441\u0442\u0432\u043e/\u041a\u043b\u0438\u0435\u043d\u0442";
        }

        public Class<?> getType() {
            return Organization.class;
        }

        public boolean isCollection() {
            return true;
        }

        public boolean isTimeIncluded() {
            return false;
        }

        public String getCategoryId() {
            return StandardRestrictionResourcePropertyCategory.ENTITY.name();
        }

        public void init(RestrictionResourceProxy proxy, Object object) {
            ArrayList<EntityReference> organizations = new ArrayList<EntityReference>();
            for (ContractCustomerInfo info : ((Contract)object).getCustomers()) {
                organizations.add(info.getCustomer());
            }
            proxy.getProperties().put(this.getId(), organizations);
        }
    }
    ,
    DISABLED{

        @Override
        public String getIdSuffix() {
            return "disabled";
        }

        public String getName() {
            return "\u041d\u0435 \u043e\u0442\u043e\u0431\u0440\u0430\u0436\u0430\u0442\u044c \u0432 \u0441\u043f\u0438\u0441\u043a\u0430\u0445";
        }

        public Class<?> getType() {
            return Boolean.class;
        }

        public boolean isCollection() {
            return false;
        }

        public boolean isTimeIncluded() {
            return false;
        }

        public String getCategoryId() {
            return StandardRestrictionResourcePropertyCategory.BOOLEAN.name();
        }

        public void init(RestrictionResourceProxy proxy, Object object) {
            proxy.getProperties().put(this.getId(), ((Contract)object).isDisabled());
        }
    };


    public abstract String getIdSuffix();

    public String getId() {
        return String.format("%s.%s", this.getResourceId(), this.getIdSuffix());
    }

    public String getDescriprion() {
        return this.getName();
    }

    public String getResourceId() {
        return ModelRestrictionEntityResources.ENTITY_CONTRACT.getId();
    }

    public Object getValue(RestrictionResourceProxy proxy) {
        return proxy.getProperties().get(this.getId());
    }
}

