/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.restriction.resource;

import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.commission.ProductType;
import com.gridnine.xtrip.common.model.booking.misc.UniversalProductDescription;
import com.gridnine.xtrip.common.model.dict.ProfileGroup;
import com.gridnine.xtrip.common.model.dict.ProfileGroupReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.handlers.HandlersRegistry;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.model.restriction.resource.ModelRestrictionEntityResources;
import com.gridnine.xtrip.common.model.system.MetadataKey;
import com.gridnine.xtrip.common.restriction.resource.RestrictionMatchable;
import com.gridnine.xtrip.common.restriction.resource.RestrictionResourceProperty;
import com.gridnine.xtrip.common.restriction.resource.RestrictionResourceProxy;
import com.gridnine.xtrip.common.restriction.resource.standard.StandardRestrictionResourcePropertyCategory;
import com.gridnine.xtrip.common.util.MiscUtil;
import java.util.Collections;
import java.util.Date;
import java.util.Optional;
import java.util.stream.Collectors;

public enum ModelRestrictionProductResourceProperties implements RestrictionResourceProperty,
RestrictionMatchable
{
    TYPE{

        @Override
        public String getIdSuffix() {
            return "type";
        }

        public String getName() {
            return "\u0422\u0438\u043f";
        }

        public Class<?> getType() {
            return ProductType.class;
        }

        public boolean isCollection() {
            return false;
        }

        public boolean isTimeIncluded() {
            return false;
        }

        public String getCategoryId() {
            return StandardRestrictionResourcePropertyCategory.ENUM.name();
        }

        public void init(RestrictionResourceProxy proxy, Object object) {
            BaseProduct baseProduct = (BaseProduct)object;
            ProductHandler<?> handler = HandlersRegistry.get().findProductHandler(baseProduct.getClass());
            if (handler != null) {
                proxy.getProperties().put(this.getId(), handler.getProductType(baseProduct));
            }
        }
    }
    ,
    STATUS{

        @Override
        public String getIdSuffix() {
            return "status";
        }

        public String getName() {
            return "\u0421\u0442\u0430\u0442\u0443\u0441";
        }

        public Class<?> getType() {
            return ProductStatus.class;
        }

        public boolean isCollection() {
            return false;
        }

        public boolean isTimeIncluded() {
            return false;
        }

        public String getCategoryId() {
            return StandardRestrictionResourcePropertyCategory.ENUM.name();
        }

        public void init(RestrictionResourceProxy proxy, Object object) {
            BaseProduct baseProduct = (BaseProduct)object;
            ProductHandler<?> handler = HandlersRegistry.get().findProductHandler(baseProduct.getClass());
            if (handler != null) {
                proxy.getProperties().put(this.getId(), handler.getStatus(baseProduct));
            }
        }
    }
    ,
    BLANK_OWNER{

        @Override
        public String getIdSuffix() {
            return "blankOwner";
        }

        public String getName() {
            return "\u0412\u043b\u0430\u0434\u0435\u043b\u0435\u0446 \u0431\u043b\u0430\u043d\u043a\u043e\u0432";
        }

        public Class<?> getType() {
            return Organization.class;
        }

        public boolean isCollection() {
            return false;
        }

        public boolean isTimeIncluded() {
            return false;
        }

        public String getCategoryId() {
            return StandardRestrictionResourcePropertyCategory.ENTITY.name();
        }

        public void init(RestrictionResourceProxy proxy, Object object) {
            BaseProduct baseProduct = (BaseProduct)object;
            ProductHandler<?> handler = HandlersRegistry.get().findProductHandler(baseProduct.getClass());
            if (handler != null) {
                proxy.getProperties().put(this.getId(), handler.getBlankOwner(baseProduct));
            }
        }
    }
    ,
    PROVIDER{

        @Override
        public String getIdSuffix() {
            return "provider";
        }

        public String getName() {
            return "\u041f\u0440\u043e\u0432\u0430\u0439\u0434\u0435\u0440";
        }

        public Class<?> getType() {
            return Organization.class;
        }

        public boolean isCollection() {
            return false;
        }

        public boolean isTimeIncluded() {
            return false;
        }

        public String getCategoryId() {
            return StandardRestrictionResourcePropertyCategory.ENTITY.name();
        }

        public void init(RestrictionResourceProxy proxy, Object object) {
            BaseProduct baseProduct = (BaseProduct)object;
            ProductHandler<?> handler = HandlersRegistry.get().findProductHandler(baseProduct.getClass());
            if (handler != null) {
                proxy.getProperties().put(this.getId(), handler.getProvider(baseProduct));
            }
        }
    }
    ,
    SUPPLIER{

        @Override
        public String getIdSuffix() {
            return "supplier";
        }

        public String getName() {
            return "\u041f\u043e\u0441\u0442\u0430\u0432\u0449\u0438\u043a";
        }

        public Class<?> getType() {
            return Organization.class;
        }

        public boolean isCollection() {
            return false;
        }

        public boolean isTimeIncluded() {
            return false;
        }

        public String getCategoryId() {
            return StandardRestrictionResourcePropertyCategory.ENTITY.name();
        }

        public void init(RestrictionResourceProxy proxy, Object object) {
            BaseProduct baseProduct = (BaseProduct)object;
            ProductHandler<?> handler = HandlersRegistry.get().findProductHandler(baseProduct.getClass());
            if (handler != null) {
                proxy.getProperties().put(this.getId(), GeneralProductHelper.getSupplier(baseProduct));
            }
        }
    }
    ,
    ISSUE_DATE{

        @Override
        public String getIdSuffix() {
            return "issueDate";
        }

        public String getName() {
            return "\u0414\u0430\u0442\u0430 \u0432\u044b\u043f\u0438\u0441\u043a\u0438";
        }

        public Class<?> getType() {
            return Date.class;
        }

        public boolean isCollection() {
            return false;
        }

        public boolean isTimeIncluded() {
            return true;
        }

        public String getCategoryId() {
            return StandardRestrictionResourcePropertyCategory.DATE.name();
        }

        public void init(RestrictionResourceProxy proxy, Object object) {
            BaseProduct baseProduct = (BaseProduct)object;
            ProductHandler<?> handler = HandlersRegistry.get().findProductHandler(baseProduct.getClass());
            if (handler != null) {
                proxy.getProperties().put(this.getId(), handler.findIssueDate(baseProduct));
            }
        }
    }
    ,
    AGENCY{

        @Override
        public String getIdSuffix() {
            return "agency";
        }

        public String getName() {
            return "\u0410\u0433\u0435\u043d\u0442\u0441\u0442\u0432\u043e";
        }

        public Class<?> getType() {
            return Organization.class;
        }

        public boolean isCollection() {
            return false;
        }

        public boolean isTimeIncluded() {
            return false;
        }

        public String getCategoryId() {
            return StandardRestrictionResourcePropertyCategory.ENTITY.name();
        }

        public void init(RestrictionResourceProxy proxy, Object object) {
            BaseProduct baseProduct = (BaseProduct)object;
            ProductHandler<?> handler = HandlersRegistry.get().findProductHandler(baseProduct.getClass());
            if (handler != null) {
                proxy.getProperties().put(this.getId(), GeneralProductHelper.getAgency(baseProduct));
            }
        }
    }
    ,
    SUBAGENCY{

        @Override
        public String getIdSuffix() {
            return "subagency";
        }

        public String getName() {
            return "\u0421\u0443\u0431\u0430\u0433\u0435\u043d\u0442\u0441\u0442\u0432\u043e";
        }

        public Class<?> getType() {
            return Organization.class;
        }

        public boolean isCollection() {
            return false;
        }

        public boolean isTimeIncluded() {
            return false;
        }

        public String getCategoryId() {
            return StandardRestrictionResourcePropertyCategory.ENTITY.name();
        }

        public void init(RestrictionResourceProxy proxy, Object object) {
            BaseProduct baseProduct = (BaseProduct)object;
            ProductHandler<?> handler = HandlersRegistry.get().findProductHandler(baseProduct.getClass());
            if (handler != null) {
                proxy.getProperties().put(this.getId(), GeneralProductHelper.getSubagency(baseProduct));
            }
        }
    }
    ,
    SALES_POINT{

        @Override
        public String getIdSuffix() {
            return "salesPoint";
        }

        public String getName() {
            return "\u0422\u043e\u0447\u043a\u0430 \u043f\u0440\u043e\u0434\u0430\u0436";
        }

        public Class<?> getType() {
            return SalesPoint.class;
        }

        public boolean isCollection() {
            return false;
        }

        public boolean isTimeIncluded() {
            return false;
        }

        public String getCategoryId() {
            return StandardRestrictionResourcePropertyCategory.ENTITY.name();
        }

        public void init(RestrictionResourceProxy proxy, Object object) {
            BaseProduct baseProduct = (BaseProduct)object;
            ProductHandler<?> handler = HandlersRegistry.get().findProductHandler(baseProduct.getClass());
            if (handler != null) {
                proxy.getProperties().put(this.getId(), handler.findSalesPoint(baseProduct));
            }
        }
    }
    ,
    AGENT{

        @Override
        public String getIdSuffix() {
            return "agent";
        }

        public String getName() {
            return "\u0410\u0433\u0435\u043d\u0442";
        }

        public Class<?> getType() {
            return Person.class;
        }

        public boolean isCollection() {
            return false;
        }

        public boolean isTimeIncluded() {
            return false;
        }

        public String getCategoryId() {
            return StandardRestrictionResourcePropertyCategory.ENTITY.name();
        }

        public void init(RestrictionResourceProxy proxy, Object object) {
            BaseProduct baseProduct = (BaseProduct)object;
            ProductHandler<?> handler = HandlersRegistry.get().findProductHandler(baseProduct.getClass());
            if (handler != null) {
                proxy.getProperties().put(this.getId(), handler.findIssuingAgent(baseProduct));
            }
        }
    }
    ,
    TRAVELLERS{

        @Override
        public String getIdSuffix() {
            return "travellers";
        }

        public String getName() {
            return "\u041f\u0443\u0442\u0435\u0448\u0435\u0441\u0442\u0432\u0435\u043d\u043d\u0438\u043a\u0438";
        }

        public Class<?> getType() {
            return Person.class;
        }

        public boolean isCollection() {
            return true;
        }

        public boolean isTimeIncluded() {
            return false;
        }

        public String getCategoryId() {
            return StandardRestrictionResourcePropertyCategory.ENTITY.name();
        }

        public void init(RestrictionResourceProxy proxy, Object object) {
            BaseProduct baseProduct = (BaseProduct)object;
            ProductHandler<?> handler = HandlersRegistry.get().findProductHandler(baseProduct.getClass());
            if (handler != null) {
                proxy.getProperties().put(this.getId(), handler.getTravellers(baseProduct).stream().map(item -> item.getPassenger()).filter(item -> item != null).collect(Collectors.toList()));
            }
        }
    }
    ,
    TRAVELLERS_GROUPS{

        @Override
        public String getIdSuffix() {
            return "travellersGroups";
        }

        public String getName() {
            return "\u0413\u0440\u0443\u043f\u043f\u044b \u043f\u0443\u0442\u0435\u0448\u0435\u0441\u0442\u0432\u0435\u043d\u043d\u0438\u043a\u043e\u0432";
        }

        public Class<?> getType() {
            return ProfileGroup.class;
        }

        public boolean isCollection() {
            return true;
        }

        public boolean isTimeIncluded() {
            return false;
        }

        public String getCategoryId() {
            return StandardRestrictionResourcePropertyCategory.DICTIONARY.name();
        }

        public void init(RestrictionResourceProxy proxy, Object object) {
            BaseProduct baseProduct = (BaseProduct)object;
            ProductHandler<?> handler = HandlersRegistry.get().findProductHandler(baseProduct.getClass());
            if (handler != null) {
                proxy.getProperties().put(this.getId(), handler.getTravellers(baseProduct).stream().map(item -> EntityStorage.get().resolve(item.getPassenger())).filter(item -> item != null).flatMap(item -> ((Person)item.getEntity()).getMetadata().stream()).filter(item -> item.getKey() != null && item.getValue() != null && MiscUtil.equals((Object)item.getKey().getCode(), (Object)MetadataKey.KEY_PERSON_PROFILE_GROUP.name())).map(item -> (ProfileGroupReference)item.getValue()).collect(Collectors.toSet()));
            }
        }
    }
    ,
    AGENTS_GROUPS{

        @Override
        public String getIdSuffix() {
            return "agentsGroups";
        }

        public String getName() {
            return "\u0413\u0440\u0443\u043f\u043f\u044b \u0430\u0433\u0435\u043d\u0442\u043e\u0432";
        }

        public Class<?> getType() {
            return ProfileGroup.class;
        }

        public boolean isCollection() {
            return true;
        }

        public boolean isTimeIncluded() {
            return false;
        }

        public String getCategoryId() {
            return StandardRestrictionResourcePropertyCategory.DICTIONARY.name();
        }

        public void init(RestrictionResourceProxy proxy, Object object) {
            BaseProduct baseProduct = (BaseProduct)object;
            ProductHandler<?> handler = HandlersRegistry.get().findProductHandler(baseProduct.getClass());
            if (handler != null) {
                proxy.getProperties().put(this.getId(), Optional.ofNullable(EntityStorage.get().resolve(handler.findIssuingAgent(baseProduct))).map(item -> ((Person)item.getEntity()).getMetadata()).orElse(Collections.emptyList()).stream().filter(item -> item.getKey() != null && item.getValue() != null && MiscUtil.equals((Object)item.getKey().getCode(), (Object)MetadataKey.KEY_PERSON_PROFILE_GROUP.name())).map(item -> (ProfileGroupReference)item.getValue()).collect(Collectors.toSet()));
            }
        }
    }
    ,
    CHECKED{

        @Override
        public String getIdSuffix() {
            return "checked";
        }

        public String getName() {
            return "\u041f\u0440\u043e\u0432\u0435\u0440\u0435\u043d";
        }

        public Class<?> getType() {
            return Boolean.class;
        }

        public boolean isCollection() {
            return false;
        }

        public boolean isTimeIncluded() {
            return false;
        }

        public String getCategoryId() {
            return StandardRestrictionResourcePropertyCategory.BOOLEAN.name();
        }

        public void init(RestrictionResourceProxy proxy, Object object) {
            BaseProduct baseProduct = (BaseProduct)object;
            ProductHandler<?> handler = HandlersRegistry.get().findProductHandler(baseProduct.getClass());
            if (handler != null) {
                proxy.getProperties().put(this.getId(), handler.isChecked(baseProduct));
            }
        }
    }
    ,
    COMPLETED{

        @Override
        public String getIdSuffix() {
            return "completed";
        }

        public String getName() {
            return "\u0417\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u043e";
        }

        public Class<?> getType() {
            return Boolean.class;
        }

        public boolean isCollection() {
            return false;
        }

        public boolean isTimeIncluded() {
            return false;
        }

        public String getCategoryId() {
            return StandardRestrictionResourcePropertyCategory.BOOLEAN.name();
        }

        public void init(RestrictionResourceProxy proxy, Object object) {
            BaseProduct baseProduct = (BaseProduct)object;
            ProductHandler<?> handler = HandlersRegistry.get().findProductHandler(baseProduct.getClass());
            if (handler != null) {
                proxy.getProperties().put(this.getId(), handler.isCompleted(baseProduct));
            }
        }
    }
    ,
    DESCRIPTION{

        @Override
        public String getIdSuffix() {
            return "description";
        }

        public String getName() {
            return "\u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u0443\u043d\u0438\u0432\u0435\u0440\u0441\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u0430";
        }

        public Class<?> getType() {
            return UniversalProductDescription.class;
        }

        public boolean isCollection() {
            return false;
        }

        public boolean isTimeIncluded() {
            return false;
        }

        public String getCategoryId() {
            return StandardRestrictionResourcePropertyCategory.ENTITY.name();
        }

        public void init(RestrictionResourceProxy proxy, Object object) {
            BaseProduct baseProduct = (BaseProduct)object;
            ProductHandler<?> handler = HandlersRegistry.get().findProductHandler(baseProduct.getClass());
            if (handler != null) {
                proxy.getProperties().put(this.getId(), handler.getUniversalProductDescription(baseProduct));
            }
        }
    };


    public abstract String getIdSuffix();

    public String getId() {
        return String.format("%s.%s", this.getResourceId(), this.getIdSuffix());
    }

    public String getDescriprion() {
        return this.getName();
    }

    public String getResourceId() {
        return ModelRestrictionEntityResources.ENTITY_PRODUCT.getId();
    }

    public Object getValue(RestrictionResourceProxy proxy) {
        return proxy.getProperties().get(this.getId());
    }
}

