/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.restriction.resource;

import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.BaseIdentity;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.FopDetalization;
import com.gridnine.xtrip.common.model.booking.GeneralProductCommission;
import com.gridnine.xtrip.common.model.booking.GeneralProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.GeneralProductFop;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.archive.BookingArchiveSettings;
import com.gridnine.xtrip.common.model.booking.commission.CommissionProperties;
import com.gridnine.xtrip.common.model.booking.commission.DiscountProperties;
import com.gridnine.xtrip.common.model.booking.commission.FeeProperties;
import com.gridnine.xtrip.common.model.booking.commission.PaymentFeeProperties;
import com.gridnine.xtrip.common.model.booking.misc.UniversalProductDescription;
import com.gridnine.xtrip.common.model.export.BaseCommonConnectionSettings;
import com.gridnine.xtrip.common.model.export.BaseCommonExportSettings;
import com.gridnine.xtrip.common.model.export.BaseExportSettings;
import com.gridnine.xtrip.common.model.finance.ChartOfAccountsSettings;
import com.gridnine.xtrip.common.model.finance.CreditBankTransferOrder;
import com.gridnine.xtrip.common.model.finance.CreditSlip;
import com.gridnine.xtrip.common.model.finance.DebitBankTransferOrder;
import com.gridnine.xtrip.common.model.finance.DebitSlip;
import com.gridnine.xtrip.common.model.finance.FinanceDocument;
import com.gridnine.xtrip.common.model.finance.Shipment;
import com.gridnine.xtrip.common.model.finance.Transaction;
import com.gridnine.xtrip.common.model.fiscal.Receipt;
import com.gridnine.xtrip.common.model.handlers.HandlersRegistry;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.l10n.Messages;
import com.gridnine.xtrip.common.model.profile.Branch;
import com.gridnine.xtrip.common.model.profile.Cash;
import com.gridnine.xtrip.common.model.profile.CashRegister;
import com.gridnine.xtrip.common.model.profile.CashRegisterWorkplace;
import com.gridnine.xtrip.common.model.profile.Contract;
import com.gridnine.xtrip.common.model.profile.Holding;
import com.gridnine.xtrip.common.model.profile.ModelContract;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.PersonEmployment;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.model.profile.TrashBinItem;
import com.gridnine.xtrip.common.model.profile.TripartiteContract;
import com.gridnine.xtrip.common.model.restriction.resource.ModelRestrictionEntityResources;
import com.gridnine.xtrip.common.model.restriction.resource.ModelRestrictionResourceProxy;
import com.gridnine.xtrip.common.model.rules.RulesMigrationSettings;
import com.gridnine.xtrip.common.model.stockcontrol.ETicketQuota;
import com.gridnine.xtrip.common.model.stockcontrol.StockBlank;
import com.gridnine.xtrip.common.model.system.AccountingEntry;
import com.gridnine.xtrip.common.model.system.BaseSystemSettings;
import com.gridnine.xtrip.common.model.system.BillingTransaction;
import com.gridnine.xtrip.common.model.system.CleanupObjectsSettings;
import com.gridnine.xtrip.common.model.system.DeleteVersionsSettings;
import com.gridnine.xtrip.common.model.system.EntityEventNotification;
import com.gridnine.xtrip.common.model.system.RollbackVersionsSettings;
import com.gridnine.xtrip.common.model.system.ScheduledTaskSettings;
import com.gridnine.xtrip.common.model.system.TemplateDocument;
import com.gridnine.xtrip.common.model.system.Worklog;
import com.gridnine.xtrip.common.parsers.model.TchXmlCommissionsImportSettings;
import com.gridnine.xtrip.common.restriction.resource.RestrictionMatchable;
import com.gridnine.xtrip.common.restriction.resource.RestrictionResourceProperty;
import com.gridnine.xtrip.common.restriction.resource.RestrictionResourceProxy;
import com.gridnine.xtrip.common.restriction.resource.RestrictionResourceProxyBuilder;
import com.gridnine.xtrip.common.restriction.resource.RestrictionResourcesRegistry;
import com.gridnine.xtrip.common.security.acl.helper.AclHelper;
import com.gridnine.xtrip.common.util.MiscUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public enum ModelRestrictionResourceProxyBuilders implements RestrictionResourceProxyBuilder
{
    PROXY_BUILDER_ENTITY_BOOKING_FILE{

        public String getName() {
            return "\u0417\u0430\u043a\u0430\u0437";
        }

        public String getDescription() {
            return null;
        }

        @Override
        public String getResourceId() {
            return ModelRestrictionEntityResources.ENTITY_BOOKING_FILE.getId();
        }

        public List<RestrictionResourceProxy> build(Object object, String containerUid, RestrictionResourceProxy parent, RestrictionResourcesRegistry registry) throws Exception {
            ArrayList<RestrictionResourceProxy> proxies = new ArrayList<RestrictionResourceProxy>();
            BookingFile bookingFile = (BookingFile)object;
            ModelRestrictionResourceProxy proxy = new ModelRestrictionResourceProxy(bookingFile.getUid(), this.getResourceId(), parent, bookingFile, containerUid);
            this.init(proxy, bookingFile, registry);
            proxies.add(proxy);
            return proxies;
        }
    }
    ,
    PROXY_BUILDER_ENTITY_BOOKING_FILE_CLIENT{

        public String getName() {
            return "\u041a\u043b\u0438\u0435\u043d\u0442";
        }

        public String getDescription() {
            return null;
        }

        @Override
        public String getResourceId() {
            return ModelRestrictionEntityResources.ENTITY_BOOKING_FILE_CLIENT.getId();
        }

        public List<RestrictionResourceProxy> build(Object object, String containerUid, RestrictionResourceProxy parent, RestrictionResourcesRegistry registry) throws Exception {
            ArrayList<RestrictionResourceProxy> proxies = new ArrayList<RestrictionResourceProxy>();
            BookingFile bookingFile = (BookingFile)object;
            EntityReference client = bookingFile.getCustomerProfile();
            ModelRestrictionResourceProxy proxy = new ModelRestrictionResourceProxy(AclHelper.createCompoundId((String)bookingFile.getUid(), (String)this.getResourceId()), this.getResourceId(), parent, client, containerUid);
            this.init(proxy, client, registry);
            proxies.add(proxy);
            return proxies;
        }
    }
    ,
    PROXY_BUILDER_ENTITY_RESERVATION{

        public String getName() {
            return "\u0411\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435";
        }

        public String getDescription() {
            return null;
        }

        @Override
        public String getResourceId() {
            return ModelRestrictionEntityResources.ENTITY_RESERVATION.getId();
        }

        public List<RestrictionResourceProxy> build(Object object, String containerUid, RestrictionResourceProxy parent, RestrictionResourcesRegistry registry) throws Exception {
            ArrayList<RestrictionResourceProxy> proxies = new ArrayList<RestrictionResourceProxy>();
            BookingFile bookingFile = (BookingFile)object;
            for (Reservation reservation : bookingFile.getReservations()) {
                ModelRestrictionResourceProxy proxy = new ModelRestrictionResourceProxy(reservation.getUid(), this.getResourceId(), parent, reservation, containerUid);
                this.init(proxy, reservation, registry);
                proxies.add(proxy);
            }
            return proxies;
        }
    }
    ,
    PROXY_BUILDER_ENTITY_PRODUCT{

        public String getName() {
            return "\u041f\u0440\u043e\u0434\u0443\u043a\u0442";
        }

        public String getDescription() {
            return null;
        }

        @Override
        public String getResourceId() {
            return ModelRestrictionEntityResources.ENTITY_PRODUCT.getId();
        }

        public List<RestrictionResourceProxy> build(Object object, String containerUid, RestrictionResourceProxy parent, RestrictionResourcesRegistry registry) throws Exception {
            ArrayList<RestrictionResourceProxy> proxies = new ArrayList<RestrictionResourceProxy>();
            BookingFile bookingFile = (BookingFile)object;
            for (Reservation reservation : bookingFile.getReservations()) {
                if (!reservation.getUid().equals(parent.getId())) continue;
                for (BaseProduct baseProduct : reservation.getProducts()) {
                    ModelRestrictionResourceProxy proxy = new ModelRestrictionResourceProxy(baseProduct.getUid(), this.getResourceId(), parent, baseProduct, containerUid);
                    this.init(proxy, baseProduct, registry);
                    proxies.add(proxy);
                }
            }
            return proxies;
        }
    }
    ,
    PROXY_BUILDER_ENTITY_PRODUCT_SALES_POINT{

        public String getName() {
            return "\u0422\u043e\u0447\u043a\u0430 \u043f\u0440\u043e\u0434\u0430\u0436";
        }

        public String getDescription() {
            return null;
        }

        @Override
        public String getResourceId() {
            return ModelRestrictionEntityResources.ENTITY_PRODUCT_SALES_POINT.getId();
        }

        public List<RestrictionResourceProxy> build(Object object, String containerUid, RestrictionResourceProxy parent, RestrictionResourcesRegistry registry) throws Exception {
            ArrayList<RestrictionResourceProxy> proxies = new ArrayList<RestrictionResourceProxy>();
            BookingFile bookingFile = (BookingFile)object;
            BaseProduct product = bookingFile.getReservations().stream().flatMap(item -> item.getProducts().stream()).filter(item -> MiscUtil.equals((Object)item.getUid(), (Object)parent.getId())).findFirst().orElse(null);
            if (product != null) {
                EntityReference<SalesPoint> salesPoint = ProductHandler.of(product).findSalesPoint(product);
                ModelRestrictionResourceProxy proxy = new ModelRestrictionResourceProxy(AclHelper.createCompoundId((String)product.getUid(), (String)this.getResourceId()), this.getResourceId(), parent, salesPoint, containerUid);
                this.init(proxy, salesPoint, registry);
                proxies.add(proxy);
            }
            return proxies;
        }
    }
    ,
    PROXY_BUILDER_ENTITY_PRODUCT_AGENT{

        public String getName() {
            return "\u0410\u0433\u0435\u043d\u0442";
        }

        public String getDescription() {
            return null;
        }

        @Override
        public String getResourceId() {
            return ModelRestrictionEntityResources.ENTITY_PRODUCT_AGENT.getId();
        }

        public List<RestrictionResourceProxy> build(Object object, String containerUid, RestrictionResourceProxy parent, RestrictionResourcesRegistry registry) throws Exception {
            ArrayList<RestrictionResourceProxy> proxies = new ArrayList<RestrictionResourceProxy>();
            BookingFile bookingFile = (BookingFile)object;
            BaseProduct product = bookingFile.getReservations().stream().flatMap(item -> item.getProducts().stream()).filter(item -> MiscUtil.equals((Object)item.getUid(), (Object)parent.getId())).findFirst().orElse(null);
            if (product != null) {
                EntityReference<Person> agent = ProductHandler.of(product).findIssuingAgent(product);
                ModelRestrictionResourceProxy proxy = new ModelRestrictionResourceProxy(AclHelper.createCompoundId((String)product.getUid(), (String)this.getResourceId()), this.getResourceId(), parent, agent, containerUid);
                this.init(proxy, agent, registry);
                proxies.add(proxy);
            }
            return proxies;
        }
    }
    ,
    PROXY_CLIENT_SHIPMENTS_DATE{

        public String getName() {
            return L10nResourcesManager.getStr((String)Messages.RestrictionResources_productClientShipmentsDate, (Object[])new Object[0]);
        }

        public String getDescription() {
            return null;
        }

        @Override
        public String getResourceId() {
            return ModelRestrictionEntityResources.ENTITY_PRODUCT_CLIENT_SHIPMENTS_DATE.getId();
        }

        public List<RestrictionResourceProxy> build(Object object, String containerUid, RestrictionResourceProxy parent, RestrictionResourcesRegistry registry) throws Exception {
            ArrayList<RestrictionResourceProxy> proxies = new ArrayList<RestrictionResourceProxy>();
            BookingFile bookingFile = (BookingFile)object;
            BaseProduct product = bookingFile.getReservations().stream().flatMap(item -> item.getProducts().stream()).filter(item -> MiscUtil.equals((Object)item.getUid(), (Object)parent.getId())).findFirst().orElse(null);
            if (product != null) {
                Set fopUids = GeneralProductHelper.getClientFops(product).stream().map(BaseIdentity::getUid).collect(Collectors.toSet());
                boolean hasClientShipment = product.getFopDetalizations().entrySet().stream().filter(it -> fopUids.contains(it.getKey())).flatMap(it -> ((FopDetalization)it.getValue()).getComponents().stream()).anyMatch(it -> it.getShipment() != null);
                ModelRestrictionResourceProxy proxy = new ModelRestrictionResourceProxy(AclHelper.createCompoundId((String)product.getUid(), (String)this.getResourceId()), this.getResourceId(), parent, hasClientShipment, containerUid);
                this.init(proxy, hasClientShipment, registry);
                proxies.add(proxy);
            }
            return proxies;
        }
    }
    ,
    PROXY_SUBAGENT_SHIPMENTS_DATE{

        public String getName() {
            return L10nResourcesManager.getStr((String)Messages.RestrictionResources_productSubagentShipmentsDate, (Object[])new Object[0]);
        }

        public String getDescription() {
            return null;
        }

        @Override
        public String getResourceId() {
            return ModelRestrictionEntityResources.ENTITY_PRODUCT_SUBAGENT_SHIPMENTS_DATE.getId();
        }

        public List<RestrictionResourceProxy> build(Object object, String containerUid, RestrictionResourceProxy parent, RestrictionResourcesRegistry registry) throws Exception {
            ArrayList<RestrictionResourceProxy> proxies = new ArrayList<RestrictionResourceProxy>();
            BookingFile bookingFile = (BookingFile)object;
            BaseProduct product = bookingFile.getReservations().stream().flatMap(item -> item.getProducts().stream()).filter(item -> MiscUtil.equals((Object)item.getUid(), (Object)parent.getId())).findFirst().orElse(null);
            if (product != null) {
                Set fopUids = GeneralProductHelper.getSubagentFops(product).stream().map(BaseIdentity::getUid).collect(Collectors.toSet());
                boolean hasSubagentShipment = product.getFopDetalizations().entrySet().stream().filter(it -> fopUids.contains(it.getKey())).flatMap(it -> ((FopDetalization)it.getValue()).getComponents().stream()).anyMatch(it -> it.getShipment() != null);
                ModelRestrictionResourceProxy proxy = new ModelRestrictionResourceProxy(AclHelper.createCompoundId((String)product.getUid(), (String)this.getResourceId()), this.getResourceId(), parent, hasSubagentShipment, containerUid);
                this.init(proxy, hasSubagentShipment, registry);
                proxies.add(proxy);
            }
            return proxies;
        }
    }
    ,
    PROXY_ENTITY_PRODUCT_SUBAGENCY{

        public String getName() {
            return "\u0421\u0443\u0431\u0430\u0433\u0435\u043d\u0441\u0442\u0432\u043e";
        }

        public String getDescription() {
            return null;
        }

        @Override
        public String getResourceId() {
            return ModelRestrictionEntityResources.ENTITY_PRODUCT_SUBAGENCY.getId();
        }

        public List<RestrictionResourceProxy> build(Object object, String containerUid, RestrictionResourceProxy parent, RestrictionResourcesRegistry registry) throws Exception {
            ArrayList<RestrictionResourceProxy> proxies = new ArrayList<RestrictionResourceProxy>();
            BookingFile bookingFile = (BookingFile)object;
            BaseProduct product = bookingFile.getReservations().stream().flatMap(item -> item.getProducts().stream()).filter(item -> MiscUtil.equals((Object)item.getUid(), (Object)parent.getId())).findFirst().orElse(null);
            if (product != null) {
                EntityReference<Organization> subagency = GeneralProductHelper.getSubagency(product);
                ModelRestrictionResourceProxy proxy = new ModelRestrictionResourceProxy(AclHelper.createCompoundId((String)product.getUid(), (String)this.getResourceId()), this.getResourceId(), parent, subagency, containerUid);
                this.init(proxy, subagency, registry);
                proxies.add(proxy);
            }
            return proxies;
        }
    }
    ,
    PROXY_BUILDER_ENTITY_PRODUCT_TOUR_CODE{

        public String getName() {
            return "\u041a\u043e\u0434 \u0442\u0443\u0440\u0430";
        }

        public String getDescription() {
            return null;
        }

        @Override
        public String getResourceId() {
            return ModelRestrictionEntityResources.ENTITY_PRODUCT_TOUR_CODE.getId();
        }

        public List<RestrictionResourceProxy> build(Object object, String containerUid, RestrictionResourceProxy parent, RestrictionResourcesRegistry registry) throws Exception {
            ArrayList<RestrictionResourceProxy> proxies = new ArrayList<RestrictionResourceProxy>();
            BookingFile bookingFile = (BookingFile)object;
            BaseProduct product = bookingFile.getReservations().stream().flatMap(item -> item.getProducts().stream()).filter(item -> MiscUtil.equals((Object)item.getUid(), (Object)parent.getId())).findFirst().orElse(null);
            if (product != null) {
                String tourCode = ProductHandler.of(product).getTourCode(product);
                ModelRestrictionResourceProxy proxy = new ModelRestrictionResourceProxy(AclHelper.createCompoundId((String)product.getUid(), (String)this.getResourceId()), this.getResourceId(), parent, tourCode, containerUid);
                this.init(proxy, tourCode, registry);
                proxies.add(proxy);
            }
            return proxies;
        }
    }
    ,
    PROXY_BUILDER_ENTITY_CONTRACT_RELATION_DATA{

        public String getName() {
            return "\u0414\u0430\u043d\u043d\u044b\u0435 \u043f\u043e \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u043d\u044b\u043c \u043e\u0442\u043d\u043e\u0448\u0435\u043d\u0438\u044f\u043c";
        }

        public String getDescription() {
            return null;
        }

        @Override
        public String getResourceId() {
            return ModelRestrictionEntityResources.ENTITY_CONTRACT_RELATION_DATA.getId();
        }

        public List<RestrictionResourceProxy> build(Object object, String containerUid, RestrictionResourceProxy parent, RestrictionResourcesRegistry registry) throws Exception {
            ArrayList<RestrictionResourceProxy> proxies = new ArrayList<RestrictionResourceProxy>();
            BookingFile bookingFile = (BookingFile)object;
            block0: for (Reservation reservation : bookingFile.getReservations()) {
                for (BaseProduct baseProduct : reservation.getProducts()) {
                    if (!baseProduct.getUid().equals(parent.getId())) continue;
                    ProductHandler<?> handler = HandlersRegistry.get().findProductHandler(baseProduct.getClass());
                    if (handler == null) continue block0;
                    for (GeneralProductContractRelationData contractRelationData : handler.getUnmodifiableContractRelations(baseProduct)) {
                        ModelRestrictionResourceProxy proxy = new ModelRestrictionResourceProxy(contractRelationData.getUid(), this.getResourceId(), parent, contractRelationData, containerUid);
                        this.init(proxy, contractRelationData, registry);
                        proxies.add(proxy);
                    }
                    continue block0;
                }
            }
            return proxies;
        }
    }
    ,
    PROXY_BUILDER_ENTITY_FOP{

        public String getName() {
            return "\u0424\u041e\u041f";
        }

        public String getDescription() {
            return null;
        }

        @Override
        public String getResourceId() {
            return ModelRestrictionEntityResources.ENTITY_FOP.getId();
        }

        public List<RestrictionResourceProxy> build(Object object, String containerUid, RestrictionResourceProxy parent, RestrictionResourcesRegistry registry) throws Exception {
            ArrayList<RestrictionResourceProxy> proxies = new ArrayList<RestrictionResourceProxy>();
            BookingFile bookingFile = (BookingFile)object;
            for (Reservation reservation : bookingFile.getReservations()) {
                block1: for (BaseProduct baseProduct : reservation.getProducts()) {
                    ProductHandler<?> handler = HandlersRegistry.get().findProductHandler(baseProduct.getClass());
                    if (handler == null) continue;
                    for (GeneralProductContractRelationData contractRelationData : handler.getUnmodifiableContractRelations(baseProduct)) {
                        if (!contractRelationData.getUid().equals(parent.getId())) continue;
                        for (GeneralProductFop fop : contractRelationData.getFops()) {
                            ModelRestrictionResourceProxy proxy = new ModelRestrictionResourceProxy(fop.getUid(), this.getResourceId(), parent, fop, containerUid);
                            this.init(proxy, fop, registry);
                            proxies.add(proxy);
                        }
                        continue block1;
                    }
                }
            }
            return proxies;
        }
    }
    ,
    PROXY_BUILDER_ENTITY_COMMISSION{

        public String getName() {
            return "\u041a\u043e\u043c\u0438\u0441\u0441\u0438\u044f";
        }

        public String getDescription() {
            return null;
        }

        @Override
        public String getResourceId() {
            return ModelRestrictionEntityResources.ENTITY_COMMISSION.getId();
        }

        public List<RestrictionResourceProxy> build(Object object, String containerUid, RestrictionResourceProxy parent, RestrictionResourcesRegistry registry) throws Exception {
            ArrayList<RestrictionResourceProxy> proxies = new ArrayList<RestrictionResourceProxy>();
            BookingFile bookingFile = (BookingFile)object;
            for (Reservation reservation : bookingFile.getReservations()) {
                block1: for (BaseProduct baseProduct : reservation.getProducts()) {
                    ProductHandler<?> handler = HandlersRegistry.get().findProductHandler(baseProduct.getClass());
                    if (handler == null) continue;
                    for (GeneralProductContractRelationData contractRelationData : handler.getUnmodifiableContractRelations(baseProduct)) {
                        if (!contractRelationData.getUid().equals(parent.getId())) continue;
                        for (GeneralProductCommission commission : contractRelationData.getCommissions()) {
                            ModelRestrictionResourceProxy proxy = new ModelRestrictionResourceProxy(commission.getUid(), this.getResourceId(), parent, commission, containerUid);
                            this.init(proxy, commission, registry);
                            proxies.add(proxy);
                        }
                        continue block1;
                    }
                }
            }
            return proxies;
        }
    }
    ,
    PROXY_BUILDER_ENTITY_HOLDING{

        public String getName() {
            return "\u0425\u043e\u043b\u0434\u0438\u043d\u0433";
        }

        public String getDescription() {
            return null;
        }

        @Override
        public String getResourceId() {
            return ModelRestrictionEntityResources.ENTITY_HOLDING.getId();
        }

        public List<RestrictionResourceProxy> build(Object object, String containerUid, RestrictionResourceProxy parent, RestrictionResourcesRegistry registry) throws Exception {
            ArrayList<RestrictionResourceProxy> proxies = new ArrayList<RestrictionResourceProxy>();
            Holding holding = (Holding)object;
            ModelRestrictionResourceProxy proxy = new ModelRestrictionResourceProxy(holding.getUid(), this.getResourceId(), parent, holding, containerUid);
            this.init(proxy, holding, registry);
            proxies.add(proxy);
            return proxies;
        }
    }
    ,
    PROXY_BUILDER_ENTITY_ORGANIZATION{

        public String getName() {
            return "\u041e\u0440\u0433\u0430\u043d\u0438\u0437\u0430\u0446\u0438\u044f";
        }

        public String getDescription() {
            return null;
        }

        @Override
        public String getResourceId() {
            return ModelRestrictionEntityResources.ENTITY_ORGANIZATION.getId();
        }

        public List<RestrictionResourceProxy> build(Object object, String containerUid, RestrictionResourceProxy parent, RestrictionResourcesRegistry registry) throws Exception {
            ArrayList<RestrictionResourceProxy> proxies = new ArrayList<RestrictionResourceProxy>();
            Organization organization = (Organization)object;
            ModelRestrictionResourceProxy proxy = new ModelRestrictionResourceProxy(organization.getUid(), this.getResourceId(), parent, organization, containerUid);
            this.init(proxy, organization, registry);
            proxies.add(proxy);
            return proxies;
        }
    }
    ,
    PROXY_BUILDER_ENTITY_ORGANIZATION_CODE{

        public String getName() {
            return "\u041a\u043e\u0434";
        }

        public String getDescription() {
            return null;
        }

        @Override
        public String getResourceId() {
            return ModelRestrictionEntityResources.ENTITY_ORGANIZATION_CODE.getId();
        }

        public List<RestrictionResourceProxy> build(Object object, String containerUid, RestrictionResourceProxy parent, RestrictionResourcesRegistry registry) throws Exception {
            ArrayList<RestrictionResourceProxy> proxies = new ArrayList<RestrictionResourceProxy>();
            Organization organization = (Organization)object;
            String code = organization.getCode();
            ModelRestrictionResourceProxy proxy = new ModelRestrictionResourceProxy(AclHelper.createCompoundId((String)organization.getUid(), (String)this.getResourceId()), this.getResourceId(), parent, code, containerUid);
            this.init(proxy, code, registry);
            proxies.add(proxy);
            return proxies;
        }
    }
    ,
    PROXY_BUILDER_ENTITY_BRANCH{

        public String getName() {
            return "\u041f\u043e\u0434\u0440\u0430\u0437\u0434\u0435\u043b\u0435\u043d\u0438\u0435";
        }

        public String getDescription() {
            return null;
        }

        @Override
        public String getResourceId() {
            return ModelRestrictionEntityResources.ENTITY_BRANCH.getId();
        }

        public List<RestrictionResourceProxy> build(Object object, String containerUid, RestrictionResourceProxy parent, RestrictionResourcesRegistry registry) throws Exception {
            ArrayList<RestrictionResourceProxy> proxies = new ArrayList<RestrictionResourceProxy>();
            Branch branch = (Branch)object;
            ModelRestrictionResourceProxy proxy = new ModelRestrictionResourceProxy(branch.getUid(), this.getResourceId(), parent, branch, containerUid);
            this.init(proxy, branch, registry);
            proxies.add(proxy);
            return proxies;
        }
    }
    ,
    PROXY_BUILDER_ENTITY_SALES_POINT{

        public String getName() {
            return "\u0422\u043e\u0447\u043a\u0430 \u043f\u0440\u043e\u0434\u0430\u0436";
        }

        public String getDescription() {
            return null;
        }

        @Override
        public String getResourceId() {
            return ModelRestrictionEntityResources.ENTITY_SALES_POINT.getId();
        }

        public List<RestrictionResourceProxy> build(Object object, String containerUid, RestrictionResourceProxy parent, RestrictionResourcesRegistry registry) throws Exception {
            ArrayList<RestrictionResourceProxy> proxies = new ArrayList<RestrictionResourceProxy>();
            SalesPoint salesPoint = (SalesPoint)object;
            ModelRestrictionResourceProxy proxy = new ModelRestrictionResourceProxy(salesPoint.getUid(), this.getResourceId(), parent, salesPoint, containerUid);
            this.init(proxy, salesPoint, registry);
            proxies.add(proxy);
            return proxies;
        }
    }
    ,
    PROXY_BUILDER_ENTITY_CASH{

        public String getName() {
            return "\u041a\u0430\u0441\u0441\u0430";
        }

        public String getDescription() {
            return null;
        }

        @Override
        public String getResourceId() {
            return ModelRestrictionEntityResources.ENTITY_CASH.getId();
        }

        public List<RestrictionResourceProxy> build(Object object, String containerUid, RestrictionResourceProxy parent, RestrictionResourcesRegistry registry) throws Exception {
            ArrayList<RestrictionResourceProxy> proxies = new ArrayList<RestrictionResourceProxy>();
            Cash cash = (Cash)object;
            ModelRestrictionResourceProxy proxy = new ModelRestrictionResourceProxy(cash.getUid(), this.getResourceId(), parent, cash, containerUid);
            this.init(proxy, cash, registry);
            proxies.add(proxy);
            return proxies;
        }
    }
    ,
    PROXY_BUILDER_ENTITY_CASH_REGISTER{

        public String getName() {
            return "\u041a\u0430\u0441\u0441\u043e\u0432\u044b\u0439 \u0430\u043f\u043f\u0430\u0440\u0430\u0442";
        }

        public String getDescription() {
            return null;
        }

        @Override
        public String getResourceId() {
            return ModelRestrictionEntityResources.ENTITY_CASH_REGISTER.getId();
        }

        public List<RestrictionResourceProxy> build(Object object, String containerUid, RestrictionResourceProxy parent, RestrictionResourcesRegistry registry) throws Exception {
            ArrayList<RestrictionResourceProxy> proxies = new ArrayList<RestrictionResourceProxy>();
            CashRegister cashRegister = (CashRegister)object;
            ModelRestrictionResourceProxy proxy = new ModelRestrictionResourceProxy(cashRegister.getUid(), this.getResourceId(), parent, cashRegister, containerUid);
            this.init(proxy, cashRegister, registry);
            proxies.add(proxy);
            return proxies;
        }
    }
    ,
    PROXY_BUILDER_ENTITY_CASH_REGISTER_WORKPLACE{

        public String getName() {
            return "\u0420\u0430\u0431\u043e\u0447\u0435\u0435 \u043c\u0435\u0441\u0442\u043e";
        }

        public String getDescription() {
            return null;
        }

        @Override
        public String getResourceId() {
            return ModelRestrictionEntityResources.ENTITY_CASH_REGISTER_WORKPLACE.getId();
        }

        public List<RestrictionResourceProxy> build(Object object, String containerUid, RestrictionResourceProxy parent, RestrictionResourcesRegistry registry) throws Exception {
            ArrayList<RestrictionResourceProxy> proxies = new ArrayList<RestrictionResourceProxy>();
            CashRegisterWorkplace cashRegisterWorkplace = (CashRegisterWorkplace)object;
            ModelRestrictionResourceProxy proxy = new ModelRestrictionResourceProxy(cashRegisterWorkplace.getUid(), this.getResourceId(), parent, cashRegisterWorkplace, containerUid);
            this.init(proxy, cashRegisterWorkplace, registry);
            proxies.add(proxy);
            return proxies;
        }
    }
    ,
    PROXY_BUILDER_ENTITY_PERSON{

        public String getName() {
            return "\u0424\u0438\u0437\u0438\u0447\u0435\u0441\u043a\u043e\u0435 \u043b\u0438\u0446\u043e";
        }

        public String getDescription() {
            return null;
        }

        @Override
        public String getResourceId() {
            return ModelRestrictionEntityResources.ENTITY_PERSON.getId();
        }

        public List<RestrictionResourceProxy> build(Object object, String containerUid, RestrictionResourceProxy parent, RestrictionResourcesRegistry registry) throws Exception {
            ArrayList<RestrictionResourceProxy> proxies = new ArrayList<RestrictionResourceProxy>();
            Person person = (Person)object;
            ModelRestrictionResourceProxy proxy = new ModelRestrictionResourceProxy(person.getUid(), this.getResourceId(), parent, person, containerUid);
            this.init(proxy, person, registry);
            proxies.add(proxy);
            return proxies;
        }
    }
    ,
    PROXY_BUILDER_ENTITY_PERSON_CODE{

        public String getName() {
            return "\u041a\u043e\u0434";
        }

        public String getDescription() {
            return null;
        }

        @Override
        public String getResourceId() {
            return ModelRestrictionEntityResources.ENTITY_PERSON_CODE.getId();
        }

        public List<RestrictionResourceProxy> build(Object object, String containerUid, RestrictionResourceProxy parent, RestrictionResourcesRegistry registry) throws Exception {
            ArrayList<RestrictionResourceProxy> proxies = new ArrayList<RestrictionResourceProxy>();
            Person person = (Person)object;
            String code = person.getCode();
            ModelRestrictionResourceProxy proxy = new ModelRestrictionResourceProxy(AclHelper.createCompoundId((String)person.getUid(), (String)this.getResourceId()), this.getResourceId(), parent, code, containerUid);
            this.init(proxy, code, registry);
            proxies.add(proxy);
            return proxies;
        }
    }
    ,
    PROXY_BUILDER_ENTITY_PERSON_EMPLOYMENT{

        public String getName() {
            return "\u041c\u0435\u0441\u0442\u043e \u0440\u0430\u0431\u043e\u0442\u044b";
        }

        public String getDescription() {
            return null;
        }

        @Override
        public String getResourceId() {
            return ModelRestrictionEntityResources.ENTITY_PERSON_EMPLOYMENT.getId();
        }

        public List<RestrictionResourceProxy> build(Object object, String containerUid, RestrictionResourceProxy parent, RestrictionResourcesRegistry registry) throws Exception {
            ArrayList<RestrictionResourceProxy> proxies = new ArrayList<RestrictionResourceProxy>();
            Person person = (Person)object;
            for (PersonEmployment personEmployment : person.getEmployments()) {
                ModelRestrictionResourceProxy proxy = new ModelRestrictionResourceProxy(personEmployment.getUid(), this.getResourceId(), parent, personEmployment, containerUid);
                this.init(proxy, personEmployment, registry);
                proxies.add(proxy);
            }
            return proxies;
        }
    }
    ,
    PROXY_BUILDER_ENTITY_CONTRACT{

        public String getName() {
            return "\u0414\u043e\u0433\u043e\u0432\u043e\u0440";
        }

        public String getDescription() {
            return null;
        }

        @Override
        public String getResourceId() {
            return ModelRestrictionEntityResources.ENTITY_CONTRACT.getId();
        }

        public List<RestrictionResourceProxy> build(Object object, String containerUid, RestrictionResourceProxy parent, RestrictionResourcesRegistry registry) throws Exception {
            ArrayList<RestrictionResourceProxy> proxies = new ArrayList<RestrictionResourceProxy>();
            Contract contract = (Contract)object;
            ModelRestrictionResourceProxy proxy = new ModelRestrictionResourceProxy(contract.getUid(), this.getResourceId(), parent, contract, containerUid);
            this.init(proxy, contract, registry);
            proxies.add(proxy);
            return proxies;
        }
    }
    ,
    PROXY_BUILDER_ENTITY_MODEL_CONTRACT{

        public String getName() {
            return ModelRestrictionEntityResources.ENTITY_MODEL_CONTRACT.getName();
        }

        public String getDescription() {
            return ModelRestrictionEntityResources.ENTITY_MODEL_CONTRACT.getDescription();
        }

        @Override
        public String getResourceId() {
            return ModelRestrictionEntityResources.ENTITY_MODEL_CONTRACT.getId();
        }

        public List<RestrictionResourceProxy> build(Object object, String containerUid, RestrictionResourceProxy parent, RestrictionResourcesRegistry registry) throws Exception {
            ModelContract modelContract = (ModelContract)object;
            ModelRestrictionResourceProxy proxy = new ModelRestrictionResourceProxy(modelContract.getUid(), this.getResourceId(), parent, modelContract, containerUid);
            this.init(proxy, modelContract, registry);
            return Collections.singletonList(proxy);
        }
    }
    ,
    PROXY_BUILDER_ENTITY_TRIPARTITE_CONTRACT{

        public String getName() {
            return "\u0414\u043e\u0433\u043e\u0432\u043e\u0440 \u0442\u0440\u0435\u0445\u0441\u0442\u043e\u0440\u043e\u043d\u043d\u0438\u0439";
        }

        public String getDescription() {
            return null;
        }

        @Override
        public String getResourceId() {
            return ModelRestrictionEntityResources.ENTITY_TRIPARTITE_CONTRACT.getId();
        }

        public List<RestrictionResourceProxy> build(Object object, String containerUid, RestrictionResourceProxy parent, RestrictionResourcesRegistry registry) throws Exception {
            ArrayList<RestrictionResourceProxy> proxies = new ArrayList<RestrictionResourceProxy>();
            TripartiteContract tripartiteContract = (TripartiteContract)object;
            ModelRestrictionResourceProxy proxy = new ModelRestrictionResourceProxy(tripartiteContract.getUid(), this.getResourceId(), parent, tripartiteContract, containerUid);
            this.init(proxy, tripartiteContract, registry);
            proxies.add(proxy);
            return proxies;
        }
    }
    ,
    PROXY_BUILDER_ENTITY_COMMISSION_PROPERTIES{

        public String getName() {
            return "\u0422\u0438\u043f \u043a\u043e\u043c\u0438\u0441\u0441\u0438\u0438";
        }

        public String getDescription() {
            return null;
        }

        @Override
        public String getResourceId() {
            return ModelRestrictionEntityResources.ENTITY_COMMISSION_PROPERTIES.getId();
        }

        public List<RestrictionResourceProxy> build(Object object, String containerUid, RestrictionResourceProxy parent, RestrictionResourcesRegistry registry) throws Exception {
            ArrayList<RestrictionResourceProxy> proxies = new ArrayList<RestrictionResourceProxy>();
            CommissionProperties commissionProperties = (CommissionProperties)object;
            ModelRestrictionResourceProxy proxy = new ModelRestrictionResourceProxy(commissionProperties.getUid(), this.getResourceId(), parent, commissionProperties, containerUid);
            this.init(proxy, commissionProperties, registry);
            proxies.add(proxy);
            return proxies;
        }
    }
    ,
    PROXY_BUILDER_ENTITY_FEE_PROPERTIES{

        public String getName() {
            return "\u0421\u0432\u043e\u0439\u0441\u0442\u0432\u043e \u0441\u0435\u0440\u0432\u0438\u0441\u043d\u043e\u0433\u043e \u0441\u0431\u043e\u0440\u0430";
        }

        public String getDescription() {
            return null;
        }

        @Override
        public String getResourceId() {
            return ModelRestrictionEntityResources.ENTITY_FEE_PROPERTIES.getId();
        }

        public List<RestrictionResourceProxy> build(Object object, String containerUid, RestrictionResourceProxy parent, RestrictionResourcesRegistry registry) throws Exception {
            ArrayList<RestrictionResourceProxy> proxies = new ArrayList<RestrictionResourceProxy>();
            FeeProperties feeProperties = (FeeProperties)object;
            ModelRestrictionResourceProxy proxy = new ModelRestrictionResourceProxy(feeProperties.getUid(), this.getResourceId(), parent, feeProperties, containerUid);
            this.init(proxy, feeProperties, registry);
            proxies.add(proxy);
            return proxies;
        }
    }
    ,
    PROXY_BUILDER_ENTITY_PAYMENT_FEE_PROPERTIES{

        public String getName() {
            return "\u0421\u0432\u043e\u0439\u0441\u0442\u0432\u043e \u0441\u0431\u043e\u0440\u0430 \u0437\u0430 \u043e\u043f\u043b\u0430\u0442\u0443";
        }

        public String getDescription() {
            return null;
        }

        @Override
        public String getResourceId() {
            return ModelRestrictionEntityResources.ENTITY_PAYMENT_FEE_PROPERTIES.getId();
        }

        public List<RestrictionResourceProxy> build(Object object, String containerUid, RestrictionResourceProxy parent, RestrictionResourcesRegistry registry) throws Exception {
            ArrayList<RestrictionResourceProxy> proxies = new ArrayList<RestrictionResourceProxy>();
            PaymentFeeProperties paymentFeeProperties = (PaymentFeeProperties)object;
            ModelRestrictionResourceProxy proxy = new ModelRestrictionResourceProxy(paymentFeeProperties.getUid(), this.getResourceId(), parent, paymentFeeProperties, containerUid);
            this.init(proxy, paymentFeeProperties, registry);
            proxies.add(proxy);
            return proxies;
        }
    }
    ,
    PROXY_BUILDER_ENTITY_DISCOUNT_PROPERTIES{

        public String getName() {
            return "\u0421\u0432\u043e\u0439\u0441\u0442\u0432\u043e \u0441\u043a\u0438\u0434\u043a\u0438";
        }

        public String getDescription() {
            return null;
        }

        @Override
        public String getResourceId() {
            return ModelRestrictionEntityResources.ENTITY_DISCOUNT_PROPERTIES.getId();
        }

        public List<RestrictionResourceProxy> build(Object object, String containerUid, RestrictionResourceProxy parent, RestrictionResourcesRegistry registry) throws Exception {
            ArrayList<RestrictionResourceProxy> proxies = new ArrayList<RestrictionResourceProxy>();
            DiscountProperties discountProperties = (DiscountProperties)object;
            ModelRestrictionResourceProxy proxy = new ModelRestrictionResourceProxy(discountProperties.getUid(), this.getResourceId(), parent, discountProperties, containerUid);
            this.init(proxy, discountProperties, registry);
            proxies.add(proxy);
            return proxies;
        }
    }
    ,
    PROXY_BUILDER_ENTITY_STOCK_ORDER{

        public String getName() {
            return "\u0411\u043b\u0430\u043d\u043a";
        }

        public String getDescription() {
            return null;
        }

        @Override
        public String getResourceId() {
            return ModelRestrictionEntityResources.ENTITY_STOCK_BLANK.getId();
        }

        public List<RestrictionResourceProxy> build(Object object, String containerUid, RestrictionResourceProxy parent, RestrictionResourcesRegistry registry) throws Exception {
            ArrayList<RestrictionResourceProxy> proxies = new ArrayList<RestrictionResourceProxy>();
            StockBlank stockBlank = (StockBlank)object;
            ModelRestrictionResourceProxy proxy = new ModelRestrictionResourceProxy(stockBlank.getUid(), this.getResourceId(), parent, stockBlank, containerUid);
            this.init(proxy, stockBlank, registry);
            proxies.add(proxy);
            return proxies;
        }
    }
    ,
    PROXY_BUILDER_ENTITY_STOCK_BLANK{

        public String getName() {
            return "\u0411\u043b\u0430\u043d\u043a";
        }

        public String getDescription() {
            return null;
        }

        @Override
        public String getResourceId() {
            return ModelRestrictionEntityResources.ENTITY_STOCK_BLANK.getId();
        }

        public List<RestrictionResourceProxy> build(Object object, String containerUid, RestrictionResourceProxy parent, RestrictionResourcesRegistry registry) throws Exception {
            ArrayList<RestrictionResourceProxy> proxies = new ArrayList<RestrictionResourceProxy>();
            StockBlank stockBlank = (StockBlank)object;
            ModelRestrictionResourceProxy proxy = new ModelRestrictionResourceProxy(stockBlank.getUid(), this.getResourceId(), parent, stockBlank, containerUid);
            this.init(proxy, stockBlank, registry);
            proxies.add(proxy);
            return proxies;
        }
    }
    ,
    PROXY_BUILDER_ENTITY_ETICKET_QUOTA{

        public String getName() {
            return "\u041a\u0432\u043e\u0442\u0430 \u042d\u0411";
        }

        public String getDescription() {
            return null;
        }

        @Override
        public String getResourceId() {
            return ModelRestrictionEntityResources.ENTITY_ETICKET_QUOTA.getId();
        }

        public List<RestrictionResourceProxy> build(Object object, String containerUid, RestrictionResourceProxy parent, RestrictionResourcesRegistry registry) throws Exception {
            ArrayList<RestrictionResourceProxy> proxies = new ArrayList<RestrictionResourceProxy>();
            ETicketQuota eTicketQuota = (ETicketQuota)object;
            ModelRestrictionResourceProxy proxy = new ModelRestrictionResourceProxy(eTicketQuota.getUid(), this.getResourceId(), parent, eTicketQuota, containerUid);
            this.init(proxy, eTicketQuota, registry);
            proxies.add(proxy);
            return proxies;
        }
    }
    ,
    PROXY_BUILDER_ENTITY_BILLING_TRANSACTION{

        public String getName() {
            return "\u0422\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u044f (deprecated)";
        }

        public String getDescription() {
            return null;
        }

        @Override
        public String getResourceId() {
            return ModelRestrictionEntityResources.ENTITY_BILLING_TRANSACTION.getId();
        }

        public List<RestrictionResourceProxy> build(Object object, String containerUid, RestrictionResourceProxy parent, RestrictionResourcesRegistry registry) throws Exception {
            ArrayList<RestrictionResourceProxy> proxies = new ArrayList<RestrictionResourceProxy>();
            BillingTransaction billingTransaction = (BillingTransaction)object;
            ModelRestrictionResourceProxy proxy = new ModelRestrictionResourceProxy(billingTransaction.getUid(), this.getResourceId(), parent, billingTransaction, containerUid);
            this.init(proxy, billingTransaction, registry);
            proxies.add(proxy);
            return proxies;
        }
    }
    ,
    PROXY_BUILDER_ENTITY_TEMPLATE_DOCUMENT{

        public String getName() {
            return "\u0428\u0430\u0431\u043b\u043e\u043d";
        }

        public String getDescription() {
            return null;
        }

        @Override
        public String getResourceId() {
            return ModelRestrictionEntityResources.ENTITY_TEMPLATE_DOCUMENT.getId();
        }

        public List<RestrictionResourceProxy> build(Object object, String containerUid, RestrictionResourceProxy parent, RestrictionResourcesRegistry registry) throws Exception {
            ArrayList<RestrictionResourceProxy> proxies = new ArrayList<RestrictionResourceProxy>();
            TemplateDocument templateDocument = (TemplateDocument)object;
            ModelRestrictionResourceProxy proxy = new ModelRestrictionResourceProxy(templateDocument.getUid(), this.getResourceId(), parent, templateDocument, containerUid);
            this.init(proxy, templateDocument, registry);
            proxies.add(proxy);
            return proxies;
        }
    }
    ,
    PROXY_BUILDER_ENTITY_WORKLOG{

        public String getName() {
            return "\u041b\u043e\u0433 \u0440\u0430\u0431\u043e\u0447\u0435\u0433\u043e \u0432\u0440\u0435\u043c\u0435\u043d\u0438";
        }

        public String getDescription() {
            return null;
        }

        @Override
        public String getResourceId() {
            return ModelRestrictionEntityResources.ENTITY_WORKLOG.getId();
        }

        public List<RestrictionResourceProxy> build(Object object, String containerUid, RestrictionResourceProxy parent, RestrictionResourcesRegistry registry) throws Exception {
            ArrayList<RestrictionResourceProxy> proxies = new ArrayList<RestrictionResourceProxy>();
            Worklog worklog = (Worklog)object;
            ModelRestrictionResourceProxy proxy = new ModelRestrictionResourceProxy(worklog.getUid(), this.getResourceId(), parent, worklog, containerUid);
            this.init(proxy, worklog, registry);
            proxies.add(proxy);
            return proxies;
        }
    }
    ,
    PROXY_BUILDER_ENTITY_ACCOUNTING_ENTRY{

        public String getName() {
            return "\u041f\u0440\u043e\u0432\u043e\u0434\u043a\u0430";
        }

        public String getDescription() {
            return null;
        }

        @Override
        public String getResourceId() {
            return ModelRestrictionEntityResources.ENTITY_ACCOUNTING_ENTRY.getId();
        }

        public List<RestrictionResourceProxy> build(Object object, String containerUid, RestrictionResourceProxy parent, RestrictionResourcesRegistry registry) throws Exception {
            ArrayList<RestrictionResourceProxy> proxies = new ArrayList<RestrictionResourceProxy>();
            AccountingEntry accountingEntry = (AccountingEntry)object;
            ModelRestrictionResourceProxy proxy = new ModelRestrictionResourceProxy(accountingEntry.getUid(), this.getResourceId(), parent, accountingEntry, containerUid);
            this.init(proxy, accountingEntry, registry);
            proxies.add(proxy);
            return proxies;
        }
    }
    ,
    PROXY_BUILDER_ENTITY_TRANSACTION{

        public String getName() {
            return "\u0422\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u044f";
        }

        public String getDescription() {
            return null;
        }

        @Override
        public String getResourceId() {
            return ModelRestrictionEntityResources.ENTITY_TRANSACTION.getId();
        }

        public List<RestrictionResourceProxy> build(Object object, String containerUid, RestrictionResourceProxy parent, RestrictionResourcesRegistry registry) throws Exception {
            ArrayList<RestrictionResourceProxy> proxies = new ArrayList<RestrictionResourceProxy>();
            Transaction transaction = (Transaction)object;
            ModelRestrictionResourceProxy proxy = new ModelRestrictionResourceProxy(transaction.getUid(), this.getResourceId(), parent, transaction, containerUid);
            this.init(proxy, transaction, registry);
            proxies.add(proxy);
            return proxies;
        }
    }
    ,
    PROXY_BUILDER_ENTITY_SYSTEM_SETTINGS{

        public String getName() {
            return "\u0421\u0438\u0441\u0442\u0435\u043c\u043d\u044b\u0435 \u0441\u0432\u043e\u0439\u0441\u0442\u0432\u0430";
        }

        public String getDescription() {
            return null;
        }

        @Override
        public String getResourceId() {
            return ModelRestrictionEntityResources.ENTITY_SYSTEM_SETTINGS.getId();
        }

        public List<RestrictionResourceProxy> build(Object object, String containerUid, RestrictionResourceProxy parent, RestrictionResourcesRegistry registry) throws Exception {
            ArrayList<RestrictionResourceProxy> proxies = new ArrayList<RestrictionResourceProxy>();
            BaseSystemSettings systemSettings = (BaseSystemSettings)object;
            ModelRestrictionResourceProxy proxy = new ModelRestrictionResourceProxy(systemSettings.getUid(), this.getResourceId(), parent, systemSettings, containerUid);
            this.init(proxy, systemSettings, registry);
            proxies.add(proxy);
            return proxies;
        }
    }
    ,
    PROXY_BUILDER_ENTITY_RULES_MIGRATION_SETTINGS{

        public String getName() {
            return "\u041d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438 \u043f\u0435\u0440\u0435\u043d\u043e\u0441\u0430 \u043f\u0440\u0430\u0432\u0438\u043b";
        }

        public String getDescription() {
            return null;
        }

        @Override
        public String getResourceId() {
            return ModelRestrictionEntityResources.ENTITY_RULES_MIGRATION_SETTINGS.getId();
        }

        public List<RestrictionResourceProxy> build(Object object, String containerUid, RestrictionResourceProxy parent, RestrictionResourcesRegistry registry) throws Exception {
            ArrayList<RestrictionResourceProxy> proxies = new ArrayList<RestrictionResourceProxy>();
            RulesMigrationSettings rulesMigrationSettings = (RulesMigrationSettings)object;
            ModelRestrictionResourceProxy proxy = new ModelRestrictionResourceProxy(rulesMigrationSettings.getUid(), this.getResourceId(), parent, rulesMigrationSettings, containerUid);
            this.init(proxy, rulesMigrationSettings, registry);
            proxies.add(proxy);
            return proxies;
        }
    }
    ,
    PROXY_BUILDER_ENTITY_BOOKING_ARCHIVE_SETTINGS{

        public String getName() {
            return "\u041d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438 \u0430\u0440\u0445\u0438\u0432\u0430\u0446\u0438\u0438 \u0437\u0430\u043a\u0430\u0437\u043e\u0432";
        }

        public String getDescription() {
            return null;
        }

        @Override
        public String getResourceId() {
            return ModelRestrictionEntityResources.ENTITY_BOOKING_ARCHIVE_SETTINGS.getId();
        }

        public List<RestrictionResourceProxy> build(Object object, String containerUid, RestrictionResourceProxy parent, RestrictionResourcesRegistry registry) throws Exception {
            ArrayList<RestrictionResourceProxy> proxies = new ArrayList<RestrictionResourceProxy>();
            BookingArchiveSettings bookingArchiveSettings = (BookingArchiveSettings)object;
            ModelRestrictionResourceProxy proxy = new ModelRestrictionResourceProxy(bookingArchiveSettings.getUid(), this.getResourceId(), parent, bookingArchiveSettings, containerUid);
            this.init(proxy, bookingArchiveSettings, registry);
            proxies.add(proxy);
            return proxies;
        }
    }
    ,
    PROXY_BUILDER_ENTITY_CLEANUP_OBJECTS_SETTINGS{

        public String getName() {
            return "\u041d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438 \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u044f \u043e\u0431\u044a\u0435\u043a\u0442\u043e\u0432";
        }

        public String getDescription() {
            return null;
        }

        @Override
        public String getResourceId() {
            return ModelRestrictionEntityResources.ENTITY_CLEANUP_OBJECTS_SETTINGS.getId();
        }

        public List<RestrictionResourceProxy> build(Object object, String containerUid, RestrictionResourceProxy parent, RestrictionResourcesRegistry registry) throws Exception {
            ArrayList<RestrictionResourceProxy> proxies = new ArrayList<RestrictionResourceProxy>();
            CleanupObjectsSettings cleanupObjectsSettings = (CleanupObjectsSettings)object;
            ModelRestrictionResourceProxy proxy = new ModelRestrictionResourceProxy(cleanupObjectsSettings.getUid(), this.getResourceId(), parent, cleanupObjectsSettings, containerUid);
            this.init(proxy, cleanupObjectsSettings, registry);
            proxies.add(proxy);
            return proxies;
        }
    }
    ,
    PROXY_BUILDER_ENTITY_SCHEDULED_TASK_SETTINGS{

        public String getName() {
            return "\u041d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438 \u0437\u0430\u0434\u0430\u0447\u0438 \u043f\u043b\u0430\u043d\u0438\u0440\u043e\u0432\u0449\u0438\u043a\u0430";
        }

        public String getDescription() {
            return null;
        }

        @Override
        public String getResourceId() {
            return ModelRestrictionEntityResources.ENTITY_SCHEDULED_TASK_SETTINGS.getId();
        }

        public List<RestrictionResourceProxy> build(Object object, String containerUid, RestrictionResourceProxy parent, RestrictionResourcesRegistry registry) throws Exception {
            ArrayList<RestrictionResourceProxy> proxies = new ArrayList<RestrictionResourceProxy>();
            ScheduledTaskSettings scheduledTaskSettings = (ScheduledTaskSettings)object;
            ModelRestrictionResourceProxy proxy = new ModelRestrictionResourceProxy(scheduledTaskSettings.getUid(), this.getResourceId(), parent, scheduledTaskSettings, containerUid);
            this.init(proxy, scheduledTaskSettings, registry);
            proxies.add(proxy);
            return proxies;
        }
    }
    ,
    PROXY_BUILDER_ENTITY_DELETE_VERSIONS_SETTINGS{

        public String getName() {
            return "\u041d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438 \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u044f \u0432\u0435\u0440\u0441\u0438\u0439";
        }

        public String getDescription() {
            return null;
        }

        @Override
        public String getResourceId() {
            return ModelRestrictionEntityResources.ENTITY_DELETE_VERSIONS_SETTINGS.getId();
        }

        public List<RestrictionResourceProxy> build(Object object, String containerUid, RestrictionResourceProxy parent, RestrictionResourcesRegistry registry) throws Exception {
            ArrayList<RestrictionResourceProxy> proxies = new ArrayList<RestrictionResourceProxy>();
            DeleteVersionsSettings deleteVersionsSettings = (DeleteVersionsSettings)object;
            ModelRestrictionResourceProxy proxy = new ModelRestrictionResourceProxy(deleteVersionsSettings.getUid(), this.getResourceId(), parent, deleteVersionsSettings, containerUid);
            this.init(proxy, deleteVersionsSettings, registry);
            proxies.add(proxy);
            return proxies;
        }
    }
    ,
    PROXY_BUILDER_ENTITY_ROLLBACK_VERSIONS_SETTINGS{

        public String getName() {
            return "\u041d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438 \u0432\u043e\u0441\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u044f \u0432\u0435\u0440\u0441\u0438\u0439";
        }

        public String getDescription() {
            return null;
        }

        @Override
        public String getResourceId() {
            return ModelRestrictionEntityResources.ENTITY_ROLLBACK_VERSIONS_SETTINGS.getId();
        }

        public List<RestrictionResourceProxy> build(Object object, String containerUid, RestrictionResourceProxy parent, RestrictionResourcesRegistry registry) throws Exception {
            ArrayList<RestrictionResourceProxy> proxies = new ArrayList<RestrictionResourceProxy>();
            RollbackVersionsSettings rollbackVersionsSettings = (RollbackVersionsSettings)object;
            ModelRestrictionResourceProxy proxy = new ModelRestrictionResourceProxy(rollbackVersionsSettings.getUid(), this.getResourceId(), parent, rollbackVersionsSettings, containerUid);
            this.init(proxy, rollbackVersionsSettings, registry);
            proxies.add(proxy);
            return proxies;
        }
    }
    ,
    PROXY_BUILDER_ENTITY_TCH_XML_COMMISSIONS_IMPORT_SETTINGS{

        public String getName() {
            return "\u041d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438 \u0438\u043c\u043f\u043e\u0440\u0442\u0430 \u043a\u043e\u043c\u0438\u0441\u0441\u0438\u0439 \u0422\u041a\u041f";
        }

        public String getDescription() {
            return null;
        }

        @Override
        public String getResourceId() {
            return ModelRestrictionEntityResources.ENTITY_TCH_XML_COMMISSIONS_IMPORT_SETTINGS.getId();
        }

        public List<RestrictionResourceProxy> build(Object object, String containerUid, RestrictionResourceProxy parent, RestrictionResourcesRegistry registry) throws Exception {
            ArrayList<RestrictionResourceProxy> proxies = new ArrayList<RestrictionResourceProxy>();
            TchXmlCommissionsImportSettings tchXmlCommissionsImportSettings = (TchXmlCommissionsImportSettings)object;
            ModelRestrictionResourceProxy proxy = new ModelRestrictionResourceProxy(tchXmlCommissionsImportSettings.getUid(), this.getResourceId(), parent, tchXmlCommissionsImportSettings, containerUid);
            this.init(proxy, tchXmlCommissionsImportSettings, registry);
            proxies.add(proxy);
            return proxies;
        }
    }
    ,
    PROXY_BUILDER_ENTITY_CHART_OF_ACCOUNTS_SETTINGS{

        public String getName() {
            return "\u041d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438 \u043f\u043b\u0430\u043d\u0430 \u0441\u0447\u0435\u0442\u043e\u0432";
        }

        public String getDescription() {
            return null;
        }

        @Override
        public String getResourceId() {
            return ModelRestrictionEntityResources.ENTITY_CHART_OF_ACCOUNTS_SETTINGS.getId();
        }

        public List<RestrictionResourceProxy> build(Object object, String containerUid, RestrictionResourceProxy parent, RestrictionResourcesRegistry registry) throws Exception {
            ArrayList<RestrictionResourceProxy> proxies = new ArrayList<RestrictionResourceProxy>();
            ChartOfAccountsSettings chartOfAccountsSettings = (ChartOfAccountsSettings)object;
            ModelRestrictionResourceProxy proxy = new ModelRestrictionResourceProxy(chartOfAccountsSettings.getUid(), this.getResourceId(), parent, chartOfAccountsSettings, containerUid);
            this.init(proxy, chartOfAccountsSettings, registry);
            proxies.add(proxy);
            return proxies;
        }
    }
    ,
    PROXY_BUILDER_ENTITY_COMMON_CONNECTION_SETTINGS{

        public String getName() {
            return "\u041e\u0431\u0449\u0438\u0435 \u043d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438 \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u044f";
        }

        public String getDescription() {
            return null;
        }

        @Override
        public String getResourceId() {
            return ModelRestrictionEntityResources.ENTITY_COMMON_CONNECTION_SETTINGS.getId();
        }

        public List<RestrictionResourceProxy> build(Object object, String containerUid, RestrictionResourceProxy parent, RestrictionResourcesRegistry registry) throws Exception {
            ArrayList<RestrictionResourceProxy> proxies = new ArrayList<RestrictionResourceProxy>();
            BaseCommonConnectionSettings commonConnectionSettings = (BaseCommonConnectionSettings)object;
            ModelRestrictionResourceProxy proxy = new ModelRestrictionResourceProxy(commonConnectionSettings.getUid(), this.getResourceId(), parent, commonConnectionSettings, containerUid);
            this.init(proxy, commonConnectionSettings, registry);
            proxies.add(proxy);
            return proxies;
        }
    }
    ,
    PROXY_BUILDER_ENTITY_EXPORT_SETTINGS{

        public String getName() {
            return "\u041d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438 \u044d\u043a\u0441\u043f\u043e\u0440\u0442\u0430";
        }

        public String getDescription() {
            return null;
        }

        @Override
        public String getResourceId() {
            return ModelRestrictionEntityResources.ENTITY_EXPORT_SETTINGS.getId();
        }

        public List<RestrictionResourceProxy> build(Object object, String containerUid, RestrictionResourceProxy parent, RestrictionResourcesRegistry registry) throws Exception {
            ArrayList<RestrictionResourceProxy> proxies = new ArrayList<RestrictionResourceProxy>();
            BaseExportSettings exportSettings = (BaseExportSettings)object;
            ModelRestrictionResourceProxy proxy = new ModelRestrictionResourceProxy(exportSettings.getUid(), this.getResourceId(), parent, exportSettings, containerUid);
            this.init(proxy, exportSettings, registry);
            proxies.add(proxy);
            return proxies;
        }
    }
    ,
    PROXY_BUILDER_ENTITY_COMMON_EXPORT_SETTINGS{

        public String getName() {
            return "\u041e\u0431\u0449\u0438\u0435 \u043d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438 \u044d\u043a\u0441\u043f\u043e\u0440\u0442\u0430";
        }

        public String getDescription() {
            return null;
        }

        @Override
        public String getResourceId() {
            return ModelRestrictionEntityResources.ENTITY_COMMON_EXPORT_SETTINGS.getId();
        }

        public List<RestrictionResourceProxy> build(Object object, String containerUid, RestrictionResourceProxy parent, RestrictionResourcesRegistry registry) throws Exception {
            ArrayList<RestrictionResourceProxy> proxies = new ArrayList<RestrictionResourceProxy>();
            BaseCommonExportSettings commonExportSettings = (BaseCommonExportSettings)object;
            ModelRestrictionResourceProxy proxy = new ModelRestrictionResourceProxy(commonExportSettings.getUid(), this.getResourceId(), parent, commonExportSettings, containerUid);
            this.init(proxy, commonExportSettings, registry);
            proxies.add(proxy);
            return proxies;
        }
    }
    ,
    PROXY_BUILDER_ENTITY_FINANCE_DOCUMENT{

        public String getName() {
            return "\u0424\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u044b\u0439 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442";
        }

        public String getDescription() {
            return null;
        }

        @Override
        public String getResourceId() {
            return ModelRestrictionEntityResources.ENTITY_FINANCE_DOCUMENT.getId();
        }

        public List<RestrictionResourceProxy> build(Object object, String containerUid, RestrictionResourceProxy parent, RestrictionResourcesRegistry registry) throws Exception {
            ArrayList<RestrictionResourceProxy> proxies = new ArrayList<RestrictionResourceProxy>();
            FinanceDocument financeDocument = (FinanceDocument)object;
            ModelRestrictionResourceProxy proxy = new ModelRestrictionResourceProxy(financeDocument.getUid(), this.getResourceId(), parent, financeDocument, containerUid);
            this.init(proxy, financeDocument, registry);
            proxies.add(proxy);
            return proxies;
        }
    }
    ,
    PROXY_BUILDER_ENTITY_SHIPMENT{

        public String getName() {
            return "\u0420\u0435\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u044f";
        }

        public String getDescription() {
            return null;
        }

        @Override
        public String getResourceId() {
            return ModelRestrictionEntityResources.ENTITY_SHIPMENT.getId();
        }

        public List<RestrictionResourceProxy> build(Object object, String containerUid, RestrictionResourceProxy parent, RestrictionResourcesRegistry registry) throws Exception {
            ArrayList<RestrictionResourceProxy> proxies = new ArrayList<RestrictionResourceProxy>();
            Shipment shipment = (Shipment)object;
            ModelRestrictionResourceProxy proxy = new ModelRestrictionResourceProxy(shipment.getUid(), this.getResourceId(), parent, shipment, containerUid);
            this.init(proxy, shipment, registry);
            proxies.add(proxy);
            return proxies;
        }
    }
    ,
    PROXY_BUILDER_ENTITY_CREDIT_BANK_TRANSFER_ORDER{

        public String getName() {
            return "\u0421\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u0441 \u0420/\u0421";
        }

        public String getDescription() {
            return null;
        }

        @Override
        public String getResourceId() {
            return ModelRestrictionEntityResources.ENTITY_CREDIT_BANK_TRANSFER_ORDER.getId();
        }

        public List<RestrictionResourceProxy> build(Object object, String containerUid, RestrictionResourceProxy parent, RestrictionResourcesRegistry registry) throws Exception {
            ArrayList<RestrictionResourceProxy> proxies = new ArrayList<RestrictionResourceProxy>();
            CreditBankTransferOrder bankTransferOrder = (CreditBankTransferOrder)object;
            ModelRestrictionResourceProxy proxy = new ModelRestrictionResourceProxy(bankTransferOrder.getUid(), this.getResourceId(), parent, bankTransferOrder, containerUid);
            this.init(proxy, bankTransferOrder, registry);
            proxies.add(proxy);
            return proxies;
        }
    }
    ,
    PROXY_BUILDER_ENTITY_DEBIT_BANK_TRANSFER_ORDER{

        public String getName() {
            return "\u041f\u043e\u0441\u0442\u0443\u043f\u043b\u0435\u043d\u0438\u0435 \u043d\u0430 \u0420/\u0421";
        }

        public String getDescription() {
            return null;
        }

        @Override
        public String getResourceId() {
            return ModelRestrictionEntityResources.ENTITY_DEBIT_BANK_TRANSFER_ORDER.getId();
        }

        public List<RestrictionResourceProxy> build(Object object, String containerUid, RestrictionResourceProxy parent, RestrictionResourcesRegistry registry) throws Exception {
            ArrayList<RestrictionResourceProxy> proxies = new ArrayList<RestrictionResourceProxy>();
            DebitBankTransferOrder bankTransferOrder = (DebitBankTransferOrder)object;
            ModelRestrictionResourceProxy proxy = new ModelRestrictionResourceProxy(bankTransferOrder.getUid(), this.getResourceId(), parent, bankTransferOrder, containerUid);
            this.init(proxy, bankTransferOrder, registry);
            proxies.add(proxy);
            return proxies;
        }
    }
    ,
    PROXY_BUILDER_ENTITY_CREDIT_SLIP{

        public String getName() {
            return "\u041f\u041a\u041e";
        }

        public String getDescription() {
            return null;
        }

        @Override
        public String getResourceId() {
            return ModelRestrictionEntityResources.ENTITY_CREDIT_SLIP.getId();
        }

        public List<RestrictionResourceProxy> build(Object object, String containerUid, RestrictionResourceProxy parent, RestrictionResourcesRegistry registry) throws Exception {
            ArrayList<RestrictionResourceProxy> proxies = new ArrayList<RestrictionResourceProxy>();
            CreditSlip creditSlip = (CreditSlip)object;
            ModelRestrictionResourceProxy proxy = new ModelRestrictionResourceProxy(creditSlip.getUid(), this.getResourceId(), parent, creditSlip, containerUid);
            this.init(proxy, creditSlip, registry);
            proxies.add(proxy);
            return proxies;
        }
    }
    ,
    PROXY_BUILDER_ENTITY_DEBIT_SLIP{

        public String getName() {
            return "\u0420\u041a\u041e";
        }

        public String getDescription() {
            return null;
        }

        @Override
        public String getResourceId() {
            return ModelRestrictionEntityResources.ENTITY_DEBIT_SLIP.getId();
        }

        public List<RestrictionResourceProxy> build(Object object, String containerUid, RestrictionResourceProxy parent, RestrictionResourcesRegistry registry) throws Exception {
            ArrayList<RestrictionResourceProxy> proxies = new ArrayList<RestrictionResourceProxy>();
            DebitSlip debitSlip = (DebitSlip)object;
            ModelRestrictionResourceProxy proxy = new ModelRestrictionResourceProxy(debitSlip.getUid(), this.getResourceId(), parent, debitSlip, containerUid);
            this.init(proxy, debitSlip, registry);
            proxies.add(proxy);
            return proxies;
        }
    }
    ,
    PROXY_BUILDER_ENTITY_UNIVERSAL_PRODUCT_DESCRIPTION{

        public String getName() {
            return "\u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u0443\u043d\u0438\u0432\u0435\u0440\u0441\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u0430";
        }

        public String getDescription() {
            return null;
        }

        @Override
        public String getResourceId() {
            return ModelRestrictionEntityResources.ENTITY_UNIVERSAL_PRODUCT_DESCRIPTION.getId();
        }

        public List<RestrictionResourceProxy> build(Object object, String containerUid, RestrictionResourceProxy parent, RestrictionResourcesRegistry registry) throws Exception {
            ArrayList<RestrictionResourceProxy> proxies = new ArrayList<RestrictionResourceProxy>();
            UniversalProductDescription universalProductDescription = (UniversalProductDescription)object;
            ModelRestrictionResourceProxy proxy = new ModelRestrictionResourceProxy(universalProductDescription.getUid(), this.getResourceId(), parent, universalProductDescription, containerUid);
            this.init(proxy, universalProductDescription, registry);
            proxies.add(proxy);
            return proxies;
        }
    }
    ,
    PROXY_BUILDER_ENTITY_FISCAL_RECEIPT{

        public String getName() {
            return "\u041a\u0430\u0441\u0441\u043e\u0432\u044b\u0435 \u0447\u0435\u043a\u0438";
        }

        public String getDescription() {
            return null;
        }

        @Override
        public String getResourceId() {
            return ModelRestrictionEntityResources.ENTITY_FISCAL_RECEIPT.getId();
        }

        public List<RestrictionResourceProxy> build(Object object, String containerUid, RestrictionResourceProxy parent, RestrictionResourcesRegistry registry) throws Exception {
            ArrayList<RestrictionResourceProxy> proxies = new ArrayList<RestrictionResourceProxy>();
            Receipt receipt = (Receipt)object;
            ModelRestrictionResourceProxy proxy = new ModelRestrictionResourceProxy(receipt.getUid(), this.getResourceId(), parent, receipt, containerUid);
            this.init(proxy, receipt, registry);
            proxies.add(proxy);
            return proxies;
        }
    }
    ,
    PROXY_BUILDER_ENTITY_TRASH_BIN_ITEM{

        public String getName() {
            return "\u0423\u0434\u0430\u043b\u0435\u043d\u043d\u044b\u0435 \u043e\u0431\u044a\u0435\u043a\u0442\u044b";
        }

        public String getDescription() {
            return null;
        }

        @Override
        public String getResourceId() {
            return ModelRestrictionEntityResources.ENTITY_TRASH_BIN_ITEM.getId();
        }

        public List<RestrictionResourceProxy> build(Object object, String containerUid, RestrictionResourceProxy parent, RestrictionResourcesRegistry registry) throws Exception {
            ArrayList<RestrictionResourceProxy> proxies = new ArrayList<RestrictionResourceProxy>();
            TrashBinItem trashBinItem = (TrashBinItem)object;
            ModelRestrictionResourceProxy proxy = new ModelRestrictionResourceProxy(trashBinItem.getUid(), this.getResourceId(), parent, trashBinItem, containerUid);
            this.init(proxy, trashBinItem, registry);
            proxies.add(proxy);
            return proxies;
        }
    }
    ,
    PROXY_BUILDER_ENTITY_ENTITY_EVENT_NOTIFICATION{

        public String getName() {
            return "\u041d\u0430\u043f\u043e\u043c\u0438\u043d\u0430\u043d\u0438\u0435 \u043e \u0441\u043e\u0431\u044b\u0442\u0438\u0438";
        }

        public String getDescription() {
            return null;
        }

        @Override
        public String getResourceId() {
            return ModelRestrictionEntityResources.ENTITY_ENTITY_EVENT_NOTIFICATION.getId();
        }

        public List<RestrictionResourceProxy> build(Object object, String containerUid, RestrictionResourceProxy parent, RestrictionResourcesRegistry registry) throws Exception {
            ArrayList<RestrictionResourceProxy> proxies = new ArrayList<RestrictionResourceProxy>();
            EntityEventNotification entityEventNotification = (EntityEventNotification)object;
            ModelRestrictionResourceProxy proxy = new ModelRestrictionResourceProxy(entityEventNotification.getUid(), this.getResourceId(), parent, entityEventNotification, containerUid);
            this.init(proxy, entityEventNotification, registry);
            proxies.add(proxy);
            return proxies;
        }
    };


    public String getId() {
        return this.name();
    }

    public abstract String getResourceId();

    public void init(ModelRestrictionResourceProxy proxy, Object object, RestrictionResourcesRegistry registry) {
        for (String propertyId : registry.getResourceProperties(this.getResourceId())) {
            RestrictionResourceProperty property = registry.getProperty(propertyId);
            if (!(property instanceof RestrictionMatchable)) continue;
            ((RestrictionMatchable)property).init((RestrictionResourceProxy)proxy, object);
        }
    }
}

