/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.restriction.resource.helper;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.ProfileGroup;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.helpers.WorklogHelper;
import com.gridnine.xtrip.common.model.profile.Branch;
import com.gridnine.xtrip.common.model.profile.CashRegister;
import com.gridnine.xtrip.common.model.profile.CashRegisterWorkplace;
import com.gridnine.xtrip.common.model.profile.Contract;
import com.gridnine.xtrip.common.model.profile.Holding;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.PersonIndex;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.model.system.Worklog;
import com.gridnine.xtrip.common.restriction.helper.RestrictionRulesHelper;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.util.DateInterval;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestrictionModelRulesHelper {
    private static final Logger log = LoggerFactory.getLogger(RestrictionModelRulesHelper.class);

    public static boolean isMyCurrentWorklogPeriod(Date data, String userId, RestrictionRulesHelper.DateIntervalCondition condition) {
        DateInterval interval = RestrictionRulesHelper.VOID_DATE_INTERVAL;
        try {
            EntityContainer worklogContainer;
            EntityContainer person = ((EntityStorage)Environment.getPublished(EntityStorage.class)).find(PersonIndex.class, PersonIndex.Property.loginName.name(), (Object)userId);
            if (person != null && (worklogContainer = EntityStorage.get().resolve(WorklogHelper.getWorklog((EntityReference<Person>)person.toReference(), new Date()))) != null) {
                Worklog worklog = (Worklog)worklogContainer.getEntity();
                interval = new DateInterval(worklog.getStartDate(), worklog.getEndDate());
            }
        }
        catch (Exception e) {
            log.error("unable to collect period", (Throwable)e);
        }
        return RestrictionRulesHelper.isDateInterval((Date)data, (DateInterval)interval, (RestrictionRulesHelper.DateIntervalCondition)condition);
    }

    public static boolean isMyOrganizationsContracts(Object data, String userId, boolean collection, EntityCondition condition) {
        ArrayList<EntityReference<Contract>> contracts = new ArrayList<EntityReference<Contract>>();
        try {
            EntityContainer person = ((EntityStorage)Environment.getPublished(EntityStorage.class)).find(PersonIndex.class, PersonIndex.Property.loginName.name(), (Object)userId);
            if (person != null) {
                contracts.addAll(ProfileHelper.getOrganizationContracts(ProfileHelper.getPersonOrganizations(Arrays.asList(person.toReference()), null, new Date()), null));
            }
        }
        catch (Exception e) {
            log.error("unable to collect entities", (Throwable)e);
        }
        if (collection) {
            if (condition == EntityCondition.CONTAINS) {
                return RestrictionRulesHelper.isContainsCollection((Collection)((Collection)data), contracts);
            }
            if (condition == EntityCondition.NOT_CONTAINS) {
                return !RestrictionRulesHelper.isContainsCollection((Collection)((Collection)data), contracts);
            }
            return true;
        }
        if (condition == EntityCondition.EQUALS) {
            return RestrictionRulesHelper.isEquals((Object)((EntityReference)data), contracts);
        }
        if (condition == EntityCondition.NOT_EQUALS) {
            return !RestrictionRulesHelper.isEquals((Object)((EntityReference)data), contracts);
        }
        return true;
    }

    public static boolean isMyOrganizationsHoldings(Object data, String userId, boolean collection, EntityCondition condition) {
        ArrayList<EntityReference<Holding>> holdings = new ArrayList<EntityReference<Holding>>();
        try {
            EntityContainer person = ((EntityStorage)Environment.getPublished(EntityStorage.class)).find(PersonIndex.class, PersonIndex.Property.loginName.name(), (Object)userId);
            if (person != null) {
                holdings.addAll(ProfileHelper.getOrganizationHoldings(ProfileHelper.getPersonOrganizations(Arrays.asList(person.toReference()), null, new Date())));
            }
        }
        catch (Exception e) {
            log.error("unable to collect entities", (Throwable)e);
        }
        if (collection) {
            if (condition == EntityCondition.CONTAINS) {
                return RestrictionRulesHelper.isContainsCollection((Collection)((Collection)data), holdings);
            }
            if (condition == EntityCondition.NOT_CONTAINS) {
                return !RestrictionRulesHelper.isContainsCollection((Collection)((Collection)data), holdings);
            }
            return true;
        }
        if (condition == EntityCondition.EQUALS) {
            return RestrictionRulesHelper.isEquals((Object)((EntityReference)data), holdings);
        }
        if (condition == EntityCondition.NOT_EQUALS) {
            return !RestrictionRulesHelper.isEquals((Object)((EntityReference)data), holdings);
        }
        return true;
    }

    public static boolean isMyOrganizationsHoldingsOrganizations(Object data, String userId, boolean collection, EntityCondition condition) {
        ArrayList<EntityReference<Organization>> organizations = new ArrayList<EntityReference<Organization>>();
        try {
            EntityContainer person = ((EntityStorage)Environment.getPublished(EntityStorage.class)).find(PersonIndex.class, PersonIndex.Property.loginName.name(), (Object)userId);
            if (person != null) {
                organizations.addAll(ProfileHelper.getHoldingOrganizations(ProfileHelper.getOrganizationHoldings(ProfileHelper.getPersonOrganizations(Arrays.asList(person.toReference()), null, new Date()))));
            }
        }
        catch (Exception e) {
            log.error("unable to collect entities", (Throwable)e);
        }
        if (collection) {
            if (condition == EntityCondition.CONTAINS) {
                return RestrictionRulesHelper.isContainsCollection((Collection)((Collection)data), organizations);
            }
            if (condition == EntityCondition.NOT_CONTAINS) {
                return !RestrictionRulesHelper.isContainsCollection((Collection)((Collection)data), organizations);
            }
            return true;
        }
        if (condition == EntityCondition.EQUALS) {
            return RestrictionRulesHelper.isEquals((Object)((EntityReference)data), organizations);
        }
        if (condition == EntityCondition.NOT_EQUALS) {
            return !RestrictionRulesHelper.isEquals((Object)((EntityReference)data), organizations);
        }
        return true;
    }

    public static boolean isMyOrganizationsHoldingsOrganizationsPersons(Object data, String userId, boolean collection, EntityCondition condition) {
        ArrayList<EntityReference<Organization>> organizations = new ArrayList<EntityReference<Organization>>();
        try {
            EntityContainer person = ((EntityStorage)Environment.getPublished(EntityStorage.class)).find(PersonIndex.class, PersonIndex.Property.loginName.name(), (Object)userId);
            if (person != null) {
                organizations.addAll(ProfileHelper.getHoldingOrganizations(ProfileHelper.getOrganizationHoldings(ProfileHelper.getPersonOrganizations(Arrays.asList(person.toReference()), null, new Date()))));
            }
        }
        catch (Exception e) {
            log.error("unable to collect entities", (Throwable)e);
        }
        List<EntityReference<Organization>> personOrganizations = ProfileHelper.getPersonOrganizations(collection ? (List<EntityReference<Person>>)data : Collections.singletonList((EntityReference)data), Collections.emptyList(), new Date());
        if (collection) {
            if (condition == EntityCondition.CONTAINS) {
                return RestrictionRulesHelper.isContainsCollection(personOrganizations, organizations);
            }
            if (condition == EntityCondition.NOT_CONTAINS) {
                return !RestrictionRulesHelper.isContainsCollection(personOrganizations, organizations);
            }
            return true;
        }
        if (condition == EntityCondition.EQUALS) {
            return RestrictionRulesHelper.isContainsCollection(personOrganizations, organizations);
        }
        if (condition == EntityCondition.NOT_EQUALS) {
            return !RestrictionRulesHelper.isContainsCollection(personOrganizations, organizations);
        }
        return true;
    }

    public static boolean isMyOrganizationsCustomers(Object data, String userId, boolean collection, EntityCondition condition) {
        ArrayList<EntityReference<Organization>> customers = new ArrayList<EntityReference<Organization>>();
        try {
            EntityContainer person = EntityStorage.get().find(PersonIndex.class, PersonIndex.Property.loginName.name(), (Object)userId);
            if (person != null) {
                customers.addAll(ProfileHelper.getPersonsOrganizationsCustomers((EntityContainer<Person>)person));
            }
        }
        catch (Exception e) {
            log.error("unable to collect entities", (Throwable)e);
        }
        if (collection) {
            if (condition == EntityCondition.CONTAINS) {
                return RestrictionRulesHelper.isContainsCollection((Collection)((Collection)data), customers);
            }
            if (condition == EntityCondition.NOT_CONTAINS) {
                return !RestrictionRulesHelper.isContainsCollection((Collection)((Collection)data), customers);
            }
            return true;
        }
        if (condition == EntityCondition.EQUALS) {
            return RestrictionRulesHelper.isEquals((Object)((EntityReference)data), customers);
        }
        if (condition == EntityCondition.NOT_EQUALS) {
            return !RestrictionRulesHelper.isEquals((Object)((EntityReference)data), customers);
        }
        return true;
    }

    public static boolean isMyOrganizationsCustomersPersons(Object data, String userId, boolean collection, EntityCondition condition) {
        ArrayList<EntityReference<Person>> persons = new ArrayList<EntityReference<Person>>();
        try {
            EntityContainer person = EntityStorage.get().find(PersonIndex.class, PersonIndex.Property.loginName.name(), (Object)userId);
            if (person != null) {
                persons.addAll(ProfileHelper.getPersonsOrganizationsCustomersPersons((EntityContainer<Person>)person));
            }
        }
        catch (Exception e) {
            log.error("unable to collect entities", (Throwable)e);
        }
        if (collection) {
            if (condition == EntityCondition.CONTAINS) {
                return RestrictionRulesHelper.isContainsCollection((Collection)((Collection)data), persons);
            }
            if (condition == EntityCondition.NOT_CONTAINS) {
                return !RestrictionRulesHelper.isContainsCollection((Collection)((Collection)data), persons);
            }
            return true;
        }
        if (condition == EntityCondition.EQUALS) {
            return RestrictionRulesHelper.isEquals((Object)((EntityReference)data), persons);
        }
        if (condition == EntityCondition.NOT_EQUALS) {
            return !RestrictionRulesHelper.isEquals((Object)((EntityReference)data), persons);
        }
        return true;
    }

    public static boolean isMyOrganizationsChildren(Object data, String userId) {
        Date currentDate = new Date();
        EntityContainer<Person> userCtr = ProfileHelper.getPersonCtr(userId);
        List<EntityReference<Organization>> userOrganizationRefs = ProfileHelper.getPersonOrganizationByContainers(Collections.singletonList(userCtr), Collections.emptyList(), currentDate);
        List<EntityReference<Organization>> organizationRefs = EntityReference.class.isInstance(data) ? Collections.singletonList((EntityReference)data) : (List<EntityReference<Organization>>)data;
        Collection<EntityReference<Organization>> parentOrganizationRefs = ProfileHelper.getOrganizationParents(organizationRefs);
        return RestrictionRulesHelper.isContainsCollection(parentOrganizationRefs, userOrganizationRefs);
    }

    public static boolean isMyOrganizationsChildrenPersons(Object data, String userId) {
        Date currentDate = new Date();
        EntityContainer<Person> userCtr = ProfileHelper.getPersonCtr(userId);
        List<EntityReference<Organization>> userOrganizationRefs = ProfileHelper.getPersonOrganizationByContainers(Collections.singletonList(userCtr), Collections.emptyList(), currentDate);
        Collection<EntityReference<Organization>> userOrganizationParentRefs = ProfileHelper.getOrganizationParents(userOrganizationRefs);
        List<EntityReference<Person>> peronRefs = EntityReference.class.isInstance(data) ? Collections.singletonList((EntityReference)data) : (List<EntityReference<Person>>)data;
        List<EntityReference<Organization>> personOrganizationRefs = ProfileHelper.getPersonOrganizations(peronRefs, Collections.emptyList(), currentDate);
        Collection<EntityReference<Organization>> personOrganizationParentRefs = ProfileHelper.getOrganizationParents(personOrganizationRefs);
        return RestrictionRulesHelper.isContainsCollection(personOrganizationParentRefs, userOrganizationParentRefs);
    }

    public static boolean isMyOrganizationsBranches(Object data, String userId, boolean collection, EntityCondition condition) {
        ArrayList<EntityReference<Branch>> branches = new ArrayList<EntityReference<Branch>>();
        try {
            EntityContainer person = ((EntityStorage)Environment.getPublished(EntityStorage.class)).find(PersonIndex.class, PersonIndex.Property.loginName.name(), (Object)userId);
            if (person != null) {
                branches.addAll(ProfileHelper.getOrganizationBranches(ProfileHelper.getPersonOrganizations(Arrays.asList(person.toReference()), null, new Date())));
            }
        }
        catch (Exception e) {
            log.error("unable to collect entities", (Throwable)e);
        }
        if (collection) {
            if (condition == EntityCondition.CONTAINS) {
                return RestrictionRulesHelper.isContainsCollection((Collection)((Collection)data), branches);
            }
            if (condition == EntityCondition.NOT_CONTAINS) {
                return !RestrictionRulesHelper.isContainsCollection((Collection)((Collection)data), branches);
            }
            return true;
        }
        if (condition == EntityCondition.EQUALS) {
            return RestrictionRulesHelper.isEquals((Object)((EntityReference)data), branches);
        }
        if (condition == EntityCondition.NOT_EQUALS) {
            return !RestrictionRulesHelper.isEquals((Object)((EntityReference)data), branches);
        }
        return true;
    }

    public static boolean isMyOrganizationsSalesPoints(Object data, String userId, boolean collection, EntityCondition condition) {
        ArrayList<EntityReference<SalesPoint>> salesPoints = new ArrayList<EntityReference<SalesPoint>>();
        try {
            EntityContainer person = ((EntityStorage)Environment.getPublished(EntityStorage.class)).find(PersonIndex.class, PersonIndex.Property.loginName.name(), (Object)userId);
            if (person != null) {
                salesPoints.addAll(ProfileHelper.getOrganizationSalesPoints(ProfileHelper.getPersonOrganizations(Arrays.asList(person.toReference()), null, new Date())));
            }
        }
        catch (Exception e) {
            log.error("unable to collect entities", (Throwable)e);
        }
        if (collection) {
            if (condition == EntityCondition.CONTAINS) {
                return RestrictionRulesHelper.isContainsCollection((Collection)((Collection)data), salesPoints);
            }
            if (condition == EntityCondition.NOT_CONTAINS) {
                return !RestrictionRulesHelper.isContainsCollection((Collection)((Collection)data), salesPoints);
            }
            return true;
        }
        if (condition == EntityCondition.EQUALS) {
            return RestrictionRulesHelper.isEquals((Object)((EntityReference)data), salesPoints);
        }
        if (condition == EntityCondition.NOT_EQUALS) {
            return !RestrictionRulesHelper.isEquals((Object)((EntityReference)data), salesPoints);
        }
        return true;
    }

    public static boolean isMyOrganizationsPersons(Object data, String userId) {
        Date currentDate = new Date();
        EntityContainer<Person> userCtr = ProfileHelper.getPersonCtr(userId);
        List<EntityReference<Organization>> userOrganizationRefs = ProfileHelper.getPersonOrganizationByContainers(Collections.singletonList(userCtr), Collections.emptyList(), currentDate);
        List<EntityReference<Person>> peronRefs = EntityReference.class.isInstance(data) ? Collections.singletonList((EntityReference)data) : (List<EntityReference<Person>>)data;
        List<EntityReference<Organization>> personOrganizationRefs = ProfileHelper.getPersonOrganizations(peronRefs, Collections.emptyList(), currentDate);
        return RestrictionRulesHelper.isContainsCollection(personOrganizationRefs, userOrganizationRefs);
    }

    public static boolean isMyOrganizationsProfileGroups(Object data, String userId, boolean collection, EntityCondition condition) {
        ArrayList<DictionaryReference<ProfileGroup>> profileGroups = new ArrayList<DictionaryReference<ProfileGroup>>();
        try {
            EntityContainer person = ((EntityStorage)Environment.getPublished(EntityStorage.class)).find(PersonIndex.class, PersonIndex.Property.loginName.name(), (Object)userId);
            if (person != null) {
                profileGroups.addAll(ProfileHelper.getOrganizationProfileGroups(ProfileHelper.getPersonOrganizations(Arrays.asList(person.toReference()), null, new Date())));
            }
        }
        catch (Exception e) {
            log.error("unable to collect entities", (Throwable)e);
        }
        if (collection) {
            if (condition == EntityCondition.CONTAINS) {
                return RestrictionRulesHelper.isContainsCollection((Collection)((Collection)data), profileGroups);
            }
            if (condition == EntityCondition.NOT_CONTAINS) {
                return !RestrictionRulesHelper.isContainsCollection((Collection)((Collection)data), profileGroups);
            }
            return true;
        }
        if (condition == EntityCondition.EQUALS) {
            return RestrictionRulesHelper.isEquals((Object)((DictionaryReference)data), profileGroups);
        }
        if (condition == EntityCondition.NOT_EQUALS) {
            return !RestrictionRulesHelper.isEquals((Object)((DictionaryReference)data), profileGroups);
        }
        return true;
    }

    public static boolean isMyOrganizations(Object data, String userId, boolean collection, EntityCondition condition) {
        ArrayList<EntityReference<Organization>> organizations = new ArrayList<EntityReference<Organization>>();
        try {
            EntityContainer person = ((EntityStorage)Environment.getPublished(EntityStorage.class)).find(PersonIndex.class, PersonIndex.Property.loginName.name(), (Object)userId);
            if (person != null) {
                organizations.addAll(ProfileHelper.getPersonOrganizations(Arrays.asList(person.toReference()), null, new Date()));
            }
        }
        catch (Exception e) {
            log.error("unable to collect entities", (Throwable)e);
        }
        if (collection) {
            if (condition == EntityCondition.CONTAINS) {
                return RestrictionRulesHelper.isContainsCollection((Collection)((Collection)data), organizations);
            }
            if (condition == EntityCondition.NOT_CONTAINS) {
                return !RestrictionRulesHelper.isContainsCollection((Collection)((Collection)data), organizations);
            }
            return true;
        }
        if (condition == EntityCondition.EQUALS) {
            return RestrictionRulesHelper.isEquals((Object)((EntityReference)data), organizations);
        }
        if (condition == EntityCondition.NOT_EQUALS) {
            return !RestrictionRulesHelper.isEquals((Object)((EntityReference)data), organizations);
        }
        return true;
    }

    public static boolean isMySalesPointsBranches(Object data, String userId, boolean collection, EntityCondition condition) {
        ArrayList<EntityReference<Branch>> branches = new ArrayList<EntityReference<Branch>>();
        try {
            EntityContainer person = ((EntityStorage)Environment.getPublished(EntityStorage.class)).find(PersonIndex.class, PersonIndex.Property.loginName.name(), (Object)userId);
            if (person != null) {
                branches.addAll(ProfileHelper.getSalesPointBranches(ProfileHelper.getPersonSalesPoints(Arrays.asList(person.toReference()), new Date())));
            }
        }
        catch (Exception e) {
            log.error("unable to collect entities", (Throwable)e);
        }
        if (collection) {
            if (condition == EntityCondition.CONTAINS) {
                return RestrictionRulesHelper.isContainsCollection((Collection)((Collection)data), branches);
            }
            if (condition == EntityCondition.NOT_CONTAINS) {
                return !RestrictionRulesHelper.isContainsCollection((Collection)((Collection)data), branches);
            }
            return true;
        }
        if (condition == EntityCondition.EQUALS) {
            return RestrictionRulesHelper.isEquals((Object)((EntityReference)data), branches);
        }
        if (condition == EntityCondition.NOT_EQUALS) {
            return !RestrictionRulesHelper.isEquals((Object)((EntityReference)data), branches);
        }
        return true;
    }

    public static boolean isMySalesPointsCashRegisters(Object data, String userId, boolean collection, EntityCondition condition) {
        ArrayList<EntityReference<CashRegister>> cashRegisters = new ArrayList<EntityReference<CashRegister>>();
        try {
            EntityContainer person = ((EntityStorage)Environment.getPublished(EntityStorage.class)).find(PersonIndex.class, PersonIndex.Property.loginName.name(), (Object)userId);
            if (person != null) {
                cashRegisters.addAll(ProfileHelper.getSalesPointCashRegisters(ProfileHelper.getPersonSalesPoints(Arrays.asList(person.toReference()), new Date())));
            }
        }
        catch (Exception e) {
            log.error("unable to collect entities", (Throwable)e);
        }
        if (collection) {
            if (condition == EntityCondition.CONTAINS) {
                return RestrictionRulesHelper.isContainsCollection((Collection)((Collection)data), cashRegisters);
            }
            if (condition == EntityCondition.NOT_CONTAINS) {
                return !RestrictionRulesHelper.isContainsCollection((Collection)((Collection)data), cashRegisters);
            }
            return true;
        }
        if (condition == EntityCondition.EQUALS) {
            return RestrictionRulesHelper.isEquals((Object)((EntityReference)data), cashRegisters);
        }
        if (condition == EntityCondition.NOT_EQUALS) {
            return !RestrictionRulesHelper.isEquals((Object)((EntityReference)data), cashRegisters);
        }
        return true;
    }

    public static boolean isMySalesPointsCashRegisterWorkplaces(Object data, String userId, boolean collection, EntityCondition condition) {
        ArrayList<EntityReference<CashRegisterWorkplace>> cashRegisterWorkplaces = new ArrayList<EntityReference<CashRegisterWorkplace>>();
        try {
            EntityContainer person = ((EntityStorage)Environment.getPublished(EntityStorage.class)).find(PersonIndex.class, PersonIndex.Property.loginName.name(), (Object)userId);
            if (person != null) {
                cashRegisterWorkplaces.addAll(ProfileHelper.getSalesPointCashRegisterWorkplaces(ProfileHelper.getPersonSalesPoints(Arrays.asList(person.toReference()), new Date())));
            }
        }
        catch (Exception e) {
            log.error("unable to collect entities", (Throwable)e);
        }
        if (collection) {
            if (condition == EntityCondition.CONTAINS) {
                return RestrictionRulesHelper.isContainsCollection((Collection)((Collection)data), cashRegisterWorkplaces);
            }
            if (condition == EntityCondition.NOT_CONTAINS) {
                return !RestrictionRulesHelper.isContainsCollection((Collection)((Collection)data), cashRegisterWorkplaces);
            }
            return true;
        }
        if (condition == EntityCondition.EQUALS) {
            return RestrictionRulesHelper.isEquals((Object)((EntityReference)data), cashRegisterWorkplaces);
        }
        if (condition == EntityCondition.NOT_EQUALS) {
            return !RestrictionRulesHelper.isEquals((Object)((EntityReference)data), cashRegisterWorkplaces);
        }
        return true;
    }

    public static boolean isMySalesPoints(Object data, String userId, boolean collection, EntityCondition condition) {
        ArrayList<EntityReference<SalesPoint>> salesPoints = new ArrayList<EntityReference<SalesPoint>>();
        try {
            EntityContainer person = ((EntityStorage)Environment.getPublished(EntityStorage.class)).find(PersonIndex.class, PersonIndex.Property.loginName.name(), (Object)userId);
            if (person != null) {
                salesPoints.addAll(ProfileHelper.getPersonSalesPoints(Arrays.asList(person.toReference()), new Date()));
            }
        }
        catch (Exception e) {
            log.error("unable to collect entities", (Throwable)e);
        }
        if (collection) {
            if (condition == EntityCondition.CONTAINS) {
                return RestrictionRulesHelper.isContainsCollection((Collection)((Collection)data), salesPoints);
            }
            if (condition == EntityCondition.NOT_CONTAINS) {
                return !RestrictionRulesHelper.isContainsCollection((Collection)((Collection)data), salesPoints);
            }
            return true;
        }
        if (condition == EntityCondition.EQUALS) {
            return RestrictionRulesHelper.isEquals((Object)((EntityReference)data), salesPoints);
        }
        if (condition == EntityCondition.NOT_EQUALS) {
            return !RestrictionRulesHelper.isEquals((Object)((EntityReference)data), salesPoints);
        }
        return true;
    }

    public static boolean isMyProfileGroups(Object data, String userId, boolean collection, EntityCondition condition) {
        ArrayList<DictionaryReference<ProfileGroup>> profileGroups = new ArrayList<DictionaryReference<ProfileGroup>>();
        try {
            EntityContainer person = ((EntityStorage)Environment.getPublished(EntityStorage.class)).find(PersonIndex.class, PersonIndex.Property.loginName.name(), (Object)userId);
            if (person != null) {
                profileGroups.addAll(ProfileHelper.getPersonProfileGroups(Arrays.asList(person.toReference())));
            }
        }
        catch (Exception e) {
            log.error("unable to collect entities", (Throwable)e);
        }
        if (collection) {
            if (condition == EntityCondition.CONTAINS) {
                return RestrictionRulesHelper.isContainsCollection((Collection)((Collection)data), profileGroups);
            }
            if (condition == EntityCondition.NOT_CONTAINS) {
                return !RestrictionRulesHelper.isContainsCollection((Collection)((Collection)data), profileGroups);
            }
            return true;
        }
        if (condition == EntityCondition.EQUALS) {
            return RestrictionRulesHelper.isEquals((Object)((DictionaryReference)data), profileGroups);
        }
        if (condition == EntityCondition.NOT_EQUALS) {
            return !RestrictionRulesHelper.isEquals((Object)((DictionaryReference)data), profileGroups);
        }
        return true;
    }

    public static boolean isMyPersons(Object data, String userId, boolean collection, EntityCondition condition) {
        ArrayList<EntityReference> persons = new ArrayList<EntityReference>();
        try {
            EntityContainer person = ((EntityStorage)Environment.getPublished(EntityStorage.class)).find(PersonIndex.class, PersonIndex.Property.loginName.name(), (Object)userId);
            if (person != null) {
                persons.add(person.toReference());
            }
        }
        catch (Exception e) {
            log.error("unable to collect entities", (Throwable)e);
        }
        if (collection) {
            if (condition == EntityCondition.CONTAINS) {
                return RestrictionRulesHelper.isContainsCollection((Collection)((Collection)data), persons);
            }
            if (condition == EntityCondition.NOT_CONTAINS) {
                return !RestrictionRulesHelper.isContainsCollection((Collection)((Collection)data), persons);
            }
            return true;
        }
        if (condition == EntityCondition.EQUALS) {
            return RestrictionRulesHelper.isEquals((Object)((EntityReference)data), persons);
        }
        if (condition == EntityCondition.NOT_EQUALS) {
            return !RestrictionRulesHelper.isEquals((Object)((EntityReference)data), persons);
        }
        return true;
    }

    public static SearchCriterion createMyCurrentWorklogPeriodCriterion(String propertyId, String userId, RestrictionRulesHelper.DateIntervalCondition condition) {
        DateInterval interval = RestrictionRulesHelper.VOID_DATE_INTERVAL;
        try {
            EntityContainer worklogContainer;
            EntityContainer person = ((EntityStorage)Environment.getPublished(EntityStorage.class)).find(PersonIndex.class, PersonIndex.Property.loginName.name(), (Object)userId);
            if (person != null && (worklogContainer = EntityStorage.get().resolve(WorklogHelper.getWorklog((EntityReference<Person>)person.toReference(), new Date()))) != null) {
                Worklog worklog = (Worklog)worklogContainer.getEntity();
                interval = new DateInterval(worklog.getStartDate(), worklog.getEndDate());
            }
        }
        catch (Exception e) {
            log.error("unable to collect period", (Throwable)e);
        }
        return RestrictionRulesHelper.createDateIntervalCriterion((String)propertyId, (DateInterval)interval, (RestrictionRulesHelper.DateIntervalCondition)condition);
    }

    public static SearchCriterion createMyOrganizationsContractsCriterion(String propertyId, String userId, boolean collection, EntityCondition condition) {
        ArrayList<EntityReference<Contract>> contracts = new ArrayList<EntityReference<Contract>>();
        try {
            EntityContainer person = ((EntityStorage)Environment.getPublished(EntityStorage.class)).find(PersonIndex.class, PersonIndex.Property.loginName.name(), (Object)userId);
            if (person != null) {
                contracts.addAll(ProfileHelper.getOrganizationContracts(ProfileHelper.getPersonOrganizations(Arrays.asList(person.toReference()), null, new Date()), null));
            }
        }
        catch (Exception e) {
            log.error("unable to collect entities", (Throwable)e);
        }
        if (collection) {
            if (condition == EntityCondition.CONTAINS) {
                return RestrictionRulesHelper.createContainsCriterion((String)propertyId, contracts, (boolean)collection);
            }
            if (condition == EntityCondition.NOT_CONTAINS) {
                return RestrictionRulesHelper.createNotContainsCriterion((String)propertyId, contracts, (boolean)collection);
            }
            return null;
        }
        if (condition == EntityCondition.EQUALS) {
            return RestrictionRulesHelper.createEqualsCriterion((String)propertyId, contracts);
        }
        if (condition == EntityCondition.NOT_EQUALS) {
            return RestrictionRulesHelper.createNotEqualsCriterion((String)propertyId, contracts);
        }
        return null;
    }

    private static SearchCriterion createOrganizationsHoldingsCriterion(String propertyId, String userId, boolean collection, EntityCondition condition, Function<? super Collection<EntityReference<Organization>>, ? extends Collection<EntityReference<Organization>>> personOrganizationsMapper) {
        Collection holdingRefs = Optional.ofNullable(ProfileHelper.getPersonCtr(userId)).map(Collections::singleton).map(personCtrs -> ProfileHelper.getPersonOrganizationByContainers(personCtrs, null, new Date())).map(personOrganizationsMapper).map(ProfileHelper::getOrganizationHoldings).orElse(Collections.emptyList());
        if (collection) {
            if (condition == EntityCondition.CONTAINS) {
                return RestrictionRulesHelper.createContainsCriterion((String)propertyId, (Collection)holdingRefs, (boolean)collection);
            }
            if (condition == EntityCondition.NOT_CONTAINS) {
                return RestrictionRulesHelper.createNotContainsCriterion((String)propertyId, (Collection)holdingRefs, (boolean)collection);
            }
            return null;
        }
        if (condition == EntityCondition.EQUALS) {
            return RestrictionRulesHelper.createEqualsCriterion((String)propertyId, (Collection)holdingRefs);
        }
        if (condition == EntityCondition.NOT_EQUALS) {
            return RestrictionRulesHelper.createNotEqualsCriterion((String)propertyId, (Collection)holdingRefs);
        }
        return null;
    }

    public static SearchCriterion createMyOrganizationsHoldingsCriterion(String propertyId, String userId, boolean collection, EntityCondition condition) {
        return RestrictionModelRulesHelper.createOrganizationsHoldingsCriterion(propertyId, userId, collection, condition, Function.identity());
    }

    public static SearchCriterion createMyChildrenOrganizationsHoldingsCriterion(String propertyId, String userId, boolean collection, EntityCondition condition) {
        return RestrictionModelRulesHelper.createOrganizationsHoldingsCriterion(propertyId, userId, collection, condition, ProfileHelper::getOrganizationChildren);
    }

    public static SearchCriterion createMyOrganizationsHoldingsOrganizationsCriterion(String propertyId, String userId, boolean collection, EntityCondition condition) {
        ArrayList<EntityReference<Organization>> organizations = new ArrayList<EntityReference<Organization>>();
        try {
            EntityContainer person = EntityStorage.get().find(PersonIndex.class, PersonIndex.Property.loginName.name(), (Object)userId);
            if (person != null) {
                organizations.addAll(ProfileHelper.getHoldingOrganizations(ProfileHelper.getOrganizationHoldings(ProfileHelper.getPersonOrganizations(Arrays.asList(person.toReference()), null, new Date()))));
            }
        }
        catch (Exception e) {
            log.error("unable to collect entities", (Throwable)e);
        }
        if (collection) {
            if (condition == EntityCondition.CONTAINS) {
                return RestrictionRulesHelper.createContainsCriterion((String)propertyId, organizations, (boolean)collection);
            }
            if (condition == EntityCondition.NOT_CONTAINS) {
                return RestrictionRulesHelper.createNotContainsCriterion((String)propertyId, organizations, (boolean)collection);
            }
            return null;
        }
        if (condition == EntityCondition.EQUALS) {
            return RestrictionRulesHelper.createEqualsCriterion((String)propertyId, organizations);
        }
        if (condition == EntityCondition.NOT_EQUALS) {
            return RestrictionRulesHelper.createNotEqualsCriterion((String)propertyId, organizations);
        }
        return null;
    }

    public static SearchCriterion createMyOrganizationsHoldingsOrganizationsPersonsCriterion(String propertyId, String userId, boolean collection, EntityCondition condition) {
        ArrayList<EntityReference<Organization>> organizations = new ArrayList<EntityReference<Organization>>();
        try {
            EntityContainer person = EntityStorage.get().find(PersonIndex.class, PersonIndex.Property.loginName.name(), (Object)userId);
            if (person != null) {
                organizations.addAll(ProfileHelper.getHoldingOrganizations(ProfileHelper.getOrganizationHoldings(ProfileHelper.getPersonOrganizations(Arrays.asList(person.toReference()), null, new Date()))));
            }
        }
        catch (Exception e) {
            log.error("unable to collect entities", (Throwable)e);
        }
        if (collection) {
            if (condition == EntityCondition.CONTAINS) {
                return RestrictionRulesHelper.createContainsCriterion((String)propertyId, organizations, (boolean)collection);
            }
            if (condition == EntityCondition.NOT_CONTAINS) {
                return RestrictionRulesHelper.createNotContainsCriterion((String)propertyId, organizations, (boolean)collection);
            }
            return null;
        }
        if (condition == EntityCondition.EQUALS) {
            return RestrictionRulesHelper.createEqualsCriterion((String)propertyId, organizations);
        }
        if (condition == EntityCondition.NOT_EQUALS) {
            return RestrictionRulesHelper.createNotEqualsCriterion((String)propertyId, organizations);
        }
        return null;
    }

    public static SearchCriterion createMyOrganizationsCustomersCriterion(String propertyId, String userId, boolean collection, EntityCondition condition) {
        ArrayList<EntityReference<Organization>> organizations = new ArrayList<EntityReference<Organization>>();
        try {
            EntityContainer person = EntityStorage.get().find(PersonIndex.class, PersonIndex.Property.loginName.name(), (Object)userId);
            if (person != null) {
                organizations.addAll(ProfileHelper.getPersonsOrganizationsCustomers((EntityContainer<Person>)person));
            }
        }
        catch (Exception e) {
            log.error("unable to collect entities", (Throwable)e);
        }
        if (collection) {
            if (condition == EntityCondition.CONTAINS) {
                return RestrictionRulesHelper.createContainsCriterion((String)propertyId, organizations, (boolean)collection);
            }
            if (condition == EntityCondition.NOT_CONTAINS) {
                return RestrictionRulesHelper.createNotContainsCriterion((String)propertyId, organizations, (boolean)collection);
            }
            return null;
        }
        if (condition == EntityCondition.EQUALS) {
            return RestrictionRulesHelper.createEqualsCriterion((String)propertyId, organizations);
        }
        if (condition == EntityCondition.NOT_EQUALS) {
            return RestrictionRulesHelper.createNotEqualsCriterion((String)propertyId, organizations);
        }
        return null;
    }

    public static SearchCriterion createMyOrganizationsCustomersPersonsCriterion(String propertyId, String userId, boolean collection, EntityCondition condition) {
        ArrayList<EntityReference<Person>> persons = new ArrayList<EntityReference<Person>>();
        try {
            EntityContainer person = EntityStorage.get().find(PersonIndex.class, PersonIndex.Property.loginName.name(), (Object)userId);
            if (person != null) {
                persons.addAll(ProfileHelper.getPersonsOrganizationsCustomersPersons((EntityContainer<Person>)person));
            }
        }
        catch (Exception e) {
            log.error("unable to collect entities", (Throwable)e);
        }
        if (collection) {
            if (condition == EntityCondition.CONTAINS) {
                return RestrictionRulesHelper.createContainsCriterion((String)propertyId, persons, (boolean)collection);
            }
            if (condition == EntityCondition.NOT_CONTAINS) {
                return RestrictionRulesHelper.createNotContainsCriterion((String)propertyId, persons, (boolean)collection);
            }
            return null;
        }
        if (condition == EntityCondition.EQUALS) {
            return RestrictionRulesHelper.createEqualsCriterion((String)propertyId, persons);
        }
        if (condition == EntityCondition.NOT_EQUALS) {
            return RestrictionRulesHelper.createNotEqualsCriterion((String)propertyId, persons);
        }
        return null;
    }

    public static SearchCriterion createMyOrganizationsChildrenCriterion(String propertyId, String userId) {
        EntityContainer<Person> userCtr = ProfileHelper.getPersonCtr(userId);
        List<EntityReference<Organization>> userOrganizationRefs = ProfileHelper.getPersonOrganizationByContainers(Collections.singletonList(userCtr), Collections.emptyList(), new Date());
        return RestrictionRulesHelper.createContainsCriterion((String)propertyId, userOrganizationRefs, (boolean)true);
    }

    public static SearchCriterion createMyOrganizationsChildrenPersonsCriterion(String propertyId, String userId) {
        EntityContainer<Person> userCtr = ProfileHelper.getPersonCtr(userId);
        List<EntityReference<Organization>> userOrganizationRefs = ProfileHelper.getPersonOrganizationByContainers(Collections.singletonList(userCtr), Collections.emptyList(), new Date());
        return RestrictionRulesHelper.createContainsCriterion((String)propertyId, userOrganizationRefs, (boolean)true);
    }

    public static SearchCriterion createMyOrganizationsBranchesCriterion(String propertyId, String userId, boolean collection, EntityCondition condition) {
        ArrayList<EntityReference<Branch>> branches = new ArrayList<EntityReference<Branch>>();
        try {
            EntityContainer person = ((EntityStorage)Environment.getPublished(EntityStorage.class)).find(PersonIndex.class, PersonIndex.Property.loginName.name(), (Object)userId);
            if (person != null) {
                branches.addAll(ProfileHelper.getOrganizationBranches(ProfileHelper.getPersonOrganizations(Arrays.asList(person.toReference()), null, new Date())));
            }
        }
        catch (Exception e) {
            log.error("unable to collect entities", (Throwable)e);
        }
        if (collection) {
            if (condition == EntityCondition.CONTAINS) {
                return RestrictionRulesHelper.createContainsCriterion((String)propertyId, branches, (boolean)collection);
            }
            if (condition == EntityCondition.NOT_CONTAINS) {
                return RestrictionRulesHelper.createNotContainsCriterion((String)propertyId, branches, (boolean)collection);
            }
            return null;
        }
        if (condition == EntityCondition.EQUALS) {
            return RestrictionRulesHelper.createEqualsCriterion((String)propertyId, branches);
        }
        if (condition == EntityCondition.NOT_EQUALS) {
            return RestrictionRulesHelper.createNotEqualsCriterion((String)propertyId, branches);
        }
        return null;
    }

    public static SearchCriterion createMyOrganizationsSalesPointsCriterion(String propertyId, String userId, boolean collection, EntityCondition condition) {
        ArrayList<EntityReference<SalesPoint>> salesPoints = new ArrayList<EntityReference<SalesPoint>>();
        try {
            EntityContainer person = ((EntityStorage)Environment.getPublished(EntityStorage.class)).find(PersonIndex.class, PersonIndex.Property.loginName.name(), (Object)userId);
            if (person != null) {
                salesPoints.addAll(ProfileHelper.getOrganizationSalesPoints(ProfileHelper.getPersonOrganizations(Arrays.asList(person.toReference()), null, new Date())));
            }
        }
        catch (Exception e) {
            log.error("unable to collect entities", (Throwable)e);
        }
        if (collection) {
            if (condition == EntityCondition.CONTAINS) {
                return RestrictionRulesHelper.createContainsCriterion((String)propertyId, salesPoints, (boolean)collection);
            }
            if (condition == EntityCondition.NOT_CONTAINS) {
                return RestrictionRulesHelper.createNotContainsCriterion((String)propertyId, salesPoints, (boolean)collection);
            }
            return null;
        }
        if (condition == EntityCondition.EQUALS) {
            return RestrictionRulesHelper.createEqualsCriterion((String)propertyId, salesPoints);
        }
        if (condition == EntityCondition.NOT_EQUALS) {
            return RestrictionRulesHelper.createNotEqualsCriterion((String)propertyId, salesPoints);
        }
        return null;
    }

    public static SearchCriterion createParentInMyOrganizationsCriterion(String userId) {
        EntityContainer<Person> userCtr = ProfileHelper.getPersonCtr(userId);
        List<EntityContainer<Organization>> employments = ProfileHelper.getEmployments((Person)userCtr.getEntity(), false);
        if (employments.size() > 1) {
            employments = ProfileHelper.getEmployments((Person)userCtr.getEntity(), true);
        }
        if (employments.isEmpty()) {
            return SearchCriterion.eq((String)"containerUid", (Object)"fake");
        }
        List myEmployments = employments.stream().map(EntityContainer::toReference).distinct().collect(Collectors.toList());
        if (myEmployments.size() == 1) {
            return SearchCriterion.eq((String)PersonIndex.Property.parentMainEmployment.name(), myEmployments.get(0));
        }
        List myEmploymentsUids = myEmployments.stream().map(EntityReference::getUid).collect(Collectors.toList());
        return SearchCriterion.in((String)PersonIndex.Property.parentMainEmployment.name(), (Object[])new Object[]{myEmploymentsUids});
    }

    public static SearchCriterion createMyOrganizationsPersonsCriterion(String propertyId, String userId) {
        EntityContainer<Person> userCtr = ProfileHelper.getPersonCtr(userId);
        List<EntityReference<Organization>> userOrganizationRefs = ProfileHelper.getPersonOrganizationByContainers(Collections.singletonList(userCtr), Collections.emptyList(), new Date());
        return RestrictionRulesHelper.createContainsCriterion((String)propertyId, userOrganizationRefs, (boolean)true);
    }

    public static SearchCriterion createMyOrganizationsProfileGroupsCriterion(String propertyId, String userId, boolean collection, EntityCondition condition) {
        ArrayList<DictionaryReference<ProfileGroup>> profileGroups = new ArrayList<DictionaryReference<ProfileGroup>>();
        try {
            EntityContainer person = ((EntityStorage)Environment.getPublished(EntityStorage.class)).find(PersonIndex.class, PersonIndex.Property.loginName.name(), (Object)userId);
            if (person != null) {
                profileGroups.addAll(ProfileHelper.getOrganizationProfileGroups(ProfileHelper.getPersonOrganizations(Arrays.asList(person.toReference()), null, new Date())));
            }
        }
        catch (Exception e) {
            log.error("unable to collect entities", (Throwable)e);
        }
        if (collection) {
            if (condition == EntityCondition.CONTAINS) {
                return RestrictionRulesHelper.createContainsCriterion((String)propertyId, profileGroups, (boolean)collection);
            }
            if (condition == EntityCondition.NOT_CONTAINS) {
                return RestrictionRulesHelper.createNotContainsCriterion((String)propertyId, profileGroups, (boolean)collection);
            }
            return null;
        }
        if (condition == EntityCondition.EQUALS) {
            return RestrictionRulesHelper.createEqualsCriterion((String)propertyId, profileGroups);
        }
        if (condition == EntityCondition.NOT_EQUALS) {
            return RestrictionRulesHelper.createNotEqualsCriterion((String)propertyId, profileGroups);
        }
        return null;
    }

    public static SearchCriterion createMyOrganizationsCriterion(String propertyId, String userId, boolean collection, EntityCondition condition) {
        ArrayList<EntityReference<Organization>> organizations = new ArrayList<EntityReference<Organization>>();
        try {
            EntityContainer person = EntityStorage.get().find(PersonIndex.class, PersonIndex.Property.loginName.name(), (Object)userId);
            if (person != null) {
                organizations.addAll(ProfileHelper.getPersonOrganizations(Arrays.asList(person.toReference()), null, new Date()));
            }
        }
        catch (Exception e) {
            log.error("unable to collect entities", (Throwable)e);
        }
        if (collection) {
            if (condition == EntityCondition.CONTAINS) {
                return RestrictionRulesHelper.createContainsCriterion((String)propertyId, organizations, (boolean)collection);
            }
            if (condition == EntityCondition.NOT_CONTAINS) {
                return RestrictionRulesHelper.createNotContainsCriterion((String)propertyId, organizations, (boolean)collection);
            }
            return null;
        }
        if (condition == EntityCondition.EQUALS) {
            return RestrictionRulesHelper.createEqualsCriterion((String)propertyId, organizations);
        }
        if (condition == EntityCondition.NOT_EQUALS) {
            return RestrictionRulesHelper.createNotEqualsCriterion((String)propertyId, organizations);
        }
        return null;
    }

    public static SearchCriterion createMySalesPointsBranchesCriterion(String propertyId, String userId, boolean collection, EntityCondition condition) {
        ArrayList<EntityReference<Branch>> branches = new ArrayList<EntityReference<Branch>>();
        try {
            EntityContainer person = ((EntityStorage)Environment.getPublished(EntityStorage.class)).find(PersonIndex.class, PersonIndex.Property.loginName.name(), (Object)userId);
            if (person != null) {
                branches.addAll(ProfileHelper.getSalesPointBranches(ProfileHelper.getPersonSalesPoints(Arrays.asList(person.toReference()), new Date())));
            }
        }
        catch (Exception e) {
            log.error("unable to collect entities", (Throwable)e);
        }
        if (collection) {
            if (condition == EntityCondition.CONTAINS) {
                return RestrictionRulesHelper.createContainsCriterion((String)propertyId, branches, (boolean)collection);
            }
            if (condition == EntityCondition.NOT_CONTAINS) {
                return RestrictionRulesHelper.createNotContainsCriterion((String)propertyId, branches, (boolean)collection);
            }
            return null;
        }
        if (condition == EntityCondition.EQUALS) {
            return RestrictionRulesHelper.createEqualsCriterion((String)propertyId, branches);
        }
        if (condition == EntityCondition.NOT_EQUALS) {
            return RestrictionRulesHelper.createNotEqualsCriterion((String)propertyId, branches);
        }
        return null;
    }

    public static SearchCriterion createMySalesPointsCashRegistersCriterion(String propertyId, String userId, boolean collection, EntityCondition condition) {
        ArrayList<EntityReference<CashRegister>> cashRegisters = new ArrayList<EntityReference<CashRegister>>();
        try {
            EntityContainer person = ((EntityStorage)Environment.getPublished(EntityStorage.class)).find(PersonIndex.class, PersonIndex.Property.loginName.name(), (Object)userId);
            if (person != null) {
                cashRegisters.addAll(ProfileHelper.getSalesPointCashRegisters(ProfileHelper.getPersonSalesPoints(Arrays.asList(person.toReference()), new Date())));
            }
        }
        catch (Exception e) {
            log.error("unable to collect entities", (Throwable)e);
        }
        if (collection) {
            if (condition == EntityCondition.CONTAINS) {
                return RestrictionRulesHelper.createContainsCriterion((String)propertyId, cashRegisters, (boolean)collection);
            }
            if (condition == EntityCondition.NOT_CONTAINS) {
                return RestrictionRulesHelper.createNotContainsCriterion((String)propertyId, cashRegisters, (boolean)collection);
            }
            return null;
        }
        if (condition == EntityCondition.EQUALS) {
            return RestrictionRulesHelper.createEqualsCriterion((String)propertyId, cashRegisters);
        }
        if (condition == EntityCondition.NOT_EQUALS) {
            return RestrictionRulesHelper.createNotEqualsCriterion((String)propertyId, cashRegisters);
        }
        return null;
    }

    public static SearchCriterion createMySalesPointsCashRegisterWorkplacesCriterion(String propertyId, String userId, boolean collection, EntityCondition condition) {
        ArrayList<EntityReference<CashRegisterWorkplace>> cashRegisterWorkplaces = new ArrayList<EntityReference<CashRegisterWorkplace>>();
        try {
            EntityContainer person = ((EntityStorage)Environment.getPublished(EntityStorage.class)).find(PersonIndex.class, PersonIndex.Property.loginName.name(), (Object)userId);
            if (person != null) {
                cashRegisterWorkplaces.addAll(ProfileHelper.getSalesPointCashRegisterWorkplaces(ProfileHelper.getPersonSalesPoints(Arrays.asList(person.toReference()), new Date())));
            }
        }
        catch (Exception e) {
            log.error("unable to collect entities", (Throwable)e);
        }
        if (collection) {
            if (condition == EntityCondition.CONTAINS) {
                return RestrictionRulesHelper.createContainsCriterion((String)propertyId, cashRegisterWorkplaces, (boolean)collection);
            }
            if (condition == EntityCondition.NOT_CONTAINS) {
                return RestrictionRulesHelper.createNotContainsCriterion((String)propertyId, cashRegisterWorkplaces, (boolean)collection);
            }
            return null;
        }
        if (condition == EntityCondition.EQUALS) {
            return RestrictionRulesHelper.createEqualsCriterion((String)propertyId, cashRegisterWorkplaces);
        }
        if (condition == EntityCondition.NOT_EQUALS) {
            return RestrictionRulesHelper.createNotEqualsCriterion((String)propertyId, cashRegisterWorkplaces);
        }
        return null;
    }

    public static SearchCriterion createMySalesPointsCriterion(String propertyId, String userId, boolean collection, EntityCondition condition) {
        ArrayList<EntityReference<SalesPoint>> salesPoints = new ArrayList<EntityReference<SalesPoint>>();
        try {
            EntityContainer person = ((EntityStorage)Environment.getPublished(EntityStorage.class)).find(PersonIndex.class, PersonIndex.Property.loginName.name(), (Object)userId);
            if (person != null) {
                salesPoints.addAll(ProfileHelper.getPersonSalesPoints(Arrays.asList(person.toReference()), new Date()));
            }
        }
        catch (Exception e) {
            log.error("unable to collect entities", (Throwable)e);
        }
        if (collection) {
            if (condition == EntityCondition.CONTAINS) {
                return RestrictionRulesHelper.createContainsCriterion((String)propertyId, salesPoints, (boolean)collection);
            }
            if (condition == EntityCondition.NOT_CONTAINS) {
                return RestrictionRulesHelper.createNotContainsCriterion((String)propertyId, salesPoints, (boolean)collection);
            }
            return null;
        }
        if (condition == EntityCondition.EQUALS) {
            return RestrictionRulesHelper.createEqualsCriterion((String)propertyId, salesPoints);
        }
        if (condition == EntityCondition.NOT_EQUALS) {
            return RestrictionRulesHelper.createNotEqualsCriterion((String)propertyId, salesPoints);
        }
        return null;
    }

    public static SearchCriterion createMyProfileGroupsCriterion(String propertyId, String userId, boolean collection, EntityCondition condition) {
        ArrayList<DictionaryReference<ProfileGroup>> profileGroups = new ArrayList<DictionaryReference<ProfileGroup>>();
        try {
            EntityContainer person = ((EntityStorage)Environment.getPublished(EntityStorage.class)).find(PersonIndex.class, PersonIndex.Property.loginName.name(), (Object)userId);
            if (person != null) {
                profileGroups.addAll(ProfileHelper.getPersonProfileGroups(Arrays.asList(person.toReference())));
            }
        }
        catch (Exception e) {
            log.error("unable to collect entities", (Throwable)e);
        }
        if (collection) {
            if (condition == EntityCondition.CONTAINS) {
                return RestrictionRulesHelper.createContainsCriterion((String)propertyId, profileGroups, (boolean)collection);
            }
            if (condition == EntityCondition.NOT_CONTAINS) {
                return RestrictionRulesHelper.createNotContainsCriterion((String)propertyId, profileGroups, (boolean)collection);
            }
            return null;
        }
        if (condition == EntityCondition.EQUALS) {
            return RestrictionRulesHelper.createEqualsCriterion((String)propertyId, profileGroups);
        }
        if (condition == EntityCondition.NOT_EQUALS) {
            return RestrictionRulesHelper.createNotEqualsCriterion((String)propertyId, profileGroups);
        }
        return null;
    }

    public static SearchCriterion createMyPersonsCriterion(String propertyId, String userId, boolean collection, EntityCondition condition) {
        ArrayList<EntityReference> persons = new ArrayList<EntityReference>();
        try {
            EntityContainer person = ((EntityStorage)Environment.getPublished(EntityStorage.class)).find(PersonIndex.class, PersonIndex.Property.loginName.name(), (Object)userId);
            if (person != null) {
                persons.add(person.toReference());
            }
        }
        catch (Exception e) {
            log.error("unable to collect entities", (Throwable)e);
        }
        if (collection) {
            if (condition == EntityCondition.CONTAINS) {
                return RestrictionRulesHelper.createContainsCriterion((String)propertyId, persons, (boolean)collection);
            }
            if (condition == EntityCondition.NOT_CONTAINS) {
                return RestrictionRulesHelper.createNotContainsCriterion((String)propertyId, persons, (boolean)collection);
            }
            return null;
        }
        if (condition == EntityCondition.EQUALS) {
            return RestrictionRulesHelper.createEqualsCriterion((String)propertyId, persons);
        }
        if (condition == EntityCondition.NOT_EQUALS) {
            return RestrictionRulesHelper.createNotEqualsCriterion((String)propertyId, persons);
        }
        return null;
    }

    public static enum EntityCondition {
        EQUALS,
        NOT_EQUALS,
        CONTAINS,
        NOT_CONTAINS;

    }
}

