/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.rules.finance;

import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.ExtendedProductType;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.ServiceType;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.Nomenclature;
import com.gridnine.xtrip.common.model.finance.BillingItemHolder;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.rules.elements.RuleLogTracer;
import com.gridnine.xtrip.common.rules.elements.RuleProxy;
import com.gridnine.xtrip.common.util.MiscUtil;

public class BillingItemPropertySet {
    private final RuleProxy<? extends BillingItemPropertySet, ?> proxy;
    private ExtendedProductType productType;
    private ProductStatus productStatus;
    private boolean issuedInExchange;
    private boolean refunded;
    private ServiceType serviceType;
    private PaymentType paymentType;
    private DictionaryReference<Nomenclature> nomenclature;
    private EntityReference<Organization> supplier;
    private EntityReference<Organization> client;
    private int travellersCount;
    private boolean hasAdditionalServices;

    public BillingItemPropertySet(RuleProxy<? extends BillingItemPropertySet, ?> proxy) {
        this.proxy = proxy;
    }

    public void init(BillingItemHolder holder) {
        RuleLogTracer tracer = this.proxy.getTracer();
        tracer.traceEnteringMethod(BillingItemPropertySet.class, "init()", new String[0]);
        try {
            this.productType = holder.getProductType();
            this.productStatus = holder.getProductStatus();
            this.issuedInExchange = holder.isIssuedInExchange();
            this.refunded = holder.isRefunded();
            this.serviceType = holder.getServiceType();
            this.paymentType = holder.getPaymentType();
            this.nomenclature = holder.getNomenclature();
            this.supplier = holder.getSupplier();
            this.client = holder.getClient();
            this.travellersCount = holder.getTravellersCount();
            this.hasAdditionalServices = holder.isHasAdditionalServices();
        }
        finally {
            tracer.traceObject(MiscUtil.getSimpleClassName(this.getClass()), (Object)this);
            tracer.traceExitingMethod(BillingItemPropertySet.class, "init()", new String[0]);
        }
    }

    public ExtendedProductType getProductType() {
        return this.productType;
    }

    public void setProductType(ExtendedProductType productType) {
        this.productType = productType;
    }

    public ProductStatus getProductStatus() {
        return this.productStatus;
    }

    public void setProductStatus(ProductStatus productStatus) {
        this.productStatus = productStatus;
    }

    public ServiceType getServiceType() {
        return this.serviceType;
    }

    public boolean isIssuedInExchange() {
        return this.issuedInExchange;
    }

    public void setIssuedInExchange(boolean issuedInExchange) {
        this.issuedInExchange = issuedInExchange;
    }

    public boolean isRefunded() {
        return this.refunded;
    }

    public void setRefunded(boolean refunded) {
        this.refunded = refunded;
    }

    public void setServiceType(ServiceType serviceType) {
        this.serviceType = serviceType;
    }

    public PaymentType getPaymentType() {
        return this.paymentType;
    }

    public void setPaymentType(PaymentType paymentType) {
        this.paymentType = paymentType;
    }

    public DictionaryReference<Nomenclature> getNomenclature() {
        return this.nomenclature;
    }

    public void setNomenclature(DictionaryReference<Nomenclature> nomenclature) {
        this.nomenclature = nomenclature;
    }

    public EntityReference<Organization> getSupplier() {
        return this.supplier;
    }

    public void setSupplier(EntityReference<Organization> supplier) {
        this.supplier = supplier;
    }

    public EntityReference<Organization> getClient() {
        return this.client;
    }

    public void setClient(EntityReference<Organization> client) {
        this.client = client;
    }

    public int getTravellersCount() {
        return this.travellersCount;
    }

    public void setTravellersCount(int travellersCount) {
        this.travellersCount = travellersCount;
    }

    public boolean isHasAdditionalServices() {
        return this.hasAdditionalServices;
    }

    public void setHasAdditionalServices(boolean hasAdditionalServices) {
        this.hasAdditionalServices = hasAdditionalServices;
    }
}

