/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.rules.finance;

import com.gridnine.xtrip.common.l10n.messages.L10n;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.booking.ExtendedProductType;
import com.gridnine.xtrip.common.model.booking.FinanceDocumentType;
import com.gridnine.xtrip.common.model.booking.FinanceDocumentTypeData;
import com.gridnine.xtrip.common.model.rules.finance.BillingItemPropertySet;
import com.gridnine.xtrip.common.model.rules.finance.BillingItemsCreationPropertySet;
import com.gridnine.xtrip.common.model.rules.finance.HasSupplierPropertySet;
import com.gridnine.xtrip.common.model.rules.finance.HasVendorAgreementTypePropertySet;
import com.gridnine.xtrip.common.model.rules.finance.ShipmentPropertySet;
import com.gridnine.xtrip.common.model.rules.finance.ShipmentsDatePropertySet;
import com.gridnine.xtrip.common.model.rules.finance.Targets;
import com.gridnine.xtrip.common.model.rules.l10n.Messages;
import com.gridnine.xtrip.common.model.rules.standard.Conditions;
import com.gridnine.xtrip.common.model.rules.standard.RulesHelper;
import com.gridnine.xtrip.common.model.rules.standard.ValueTypes;
import com.gridnine.xtrip.common.rules.elements.RuleCondition;
import com.gridnine.xtrip.common.rules.elements.RuleProperty;
import com.gridnine.xtrip.common.util.MiscUtil;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public enum Properties implements RuleProperty
{
    SHIPMENTS_DATE_PRODUCT_TYPE{

        public String getDisplayName() {
            return L10n.get((String)Messages.FinanceProperties_shipmentsDateProductType);
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.SHIPMENTS_DATE.getId()};
        }

        @Override
        String[] getConditionIds() {
            return new String[]{Conditions.EQUALS.getId(), Conditions.NOT_EQUALS.getId()};
        }

        public String getRendererId() {
            return ValueTypes.EXTENDED_PRODUCT_TYPE.name();
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(L10nResourcesManager.getStr((String)Messages.FinanceProperties_shipmentsDateProductTypeInfo, (Object[])new Object[]{cond.getDisplayName(), ((List)value).stream().map(x$0 -> Properties.productTypeToString(x$0)).collect(Collectors.joining(", "))}));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            ShipmentsDatePropertySet ps = (ShipmentsDatePropertySet)propertySet;
            MiscUtil.Pair productType = Optional.ofNullable(ps.getProductType()).map(item -> new MiscUtil.Pair((Object)item.getProductType(), (Object)item.getProductDescription())).orElse(null);
            List productTypes = Optional.ofNullable((List)value).map(items -> items.stream().map(item -> new MiscUtil.Pair((Object)item.getProductType(), (Object)item.getProductDescription())).collect(Collectors.toList())).orElse(Collections.emptyList());
            if (Conditions.EQUALS.equals(condition)) {
                return productTypes.stream().anyMatch(item -> MiscUtil.equals((Object)item, (Object)productType));
            }
            if (Conditions.NOT_EQUALS.equals(condition)) {
                return !productTypes.stream().anyMatch(item -> MiscUtil.equals((Object)item, (Object)productType));
            }
            return true;
        }
    }
    ,
    SHIPMENTS_DATE_SUPPLIER{

        public String getDisplayName() {
            return L10n.get((String)Messages.FinanceProperties_shipmentsDateSupplier);
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.SHIPMENTS_DATE.getId()};
        }

        @Override
        String[] getConditionIds() {
            return new String[]{Conditions.EQUALS.getId(), Conditions.NOT_EQUALS.getId()};
        }

        public String getRendererId() {
            return ValueTypes.SUPPLIERS.name();
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(L10nResourcesManager.getStr((String)Messages.FinanceProperties_shipmentsDateSupplierInfo, (Object[])new Object[]{cond.getDisplayName(), RulesHelper.toString(value)}));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            ShipmentsDatePropertySet ps = (ShipmentsDatePropertySet)propertySet;
            List suppliers = (List)value;
            if (Conditions.EQUALS.equals(condition)) {
                return suppliers.contains(ps.getSupplier());
            }
            if (Conditions.NOT_EQUALS.equals(condition)) {
                return !suppliers.contains(ps.getSupplier());
            }
            return true;
        }
    }
    ,
    SHIPMENTS_DATE_VENDOR_FINANCE_DOCUMENT{

        public String getDisplayName() {
            return L10n.get((String)Messages.FinanceProperties_shipmentsDateVendorFinanceDocument);
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.SHIPMENTS_DATE.getId()};
        }

        @Override
        String[] getConditionIds() {
            return new String[]{Conditions.EQUALS.getId(), Conditions.NOT_EQUALS.getId()};
        }

        public String getRendererId() {
            return ValueTypes.FINANCE_DOCUMENT_TYPE.name();
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            FinanceDocumentTypeData data = (FinanceDocumentTypeData)value;
            StringBuilder builder = new StringBuilder();
            if (data.getFinanceDocumentType() != null) {
                builder.append(data.getFinanceDocumentType());
            }
            if (builder.length() != 0 && data.isIncludeVat()) {
                builder.append(" (");
                builder.append(L10n.get((String)Messages.FinanceProperties_containsFopComponentsWithVat));
                builder.append(")");
            }
            buf.append(L10nResourcesManager.getStr((String)Messages.FinanceProperties_shipmentsDateVendorFinanceDocumentInfo, (Object[])new Object[]{cond.getDisplayName(), builder.toString()}));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            ShipmentsDatePropertySet ps = (ShipmentsDatePropertySet)propertySet;
            Set<FinanceDocumentType> vendorFinanceDocumentTypes = ps.getVendorFinanceDocumentTypes();
            FinanceDocumentTypeData data = (FinanceDocumentTypeData)value;
            if (Conditions.EQUALS.equals(condition)) {
                if (data.isIncludeVat() && !ps.isIncludeVat()) {
                    return true;
                }
                return vendorFinanceDocumentTypes.contains(data.getFinanceDocumentType());
            }
            if (Conditions.NOT_EQUALS.equals(condition)) {
                return !vendorFinanceDocumentTypes.contains(data.getFinanceDocumentType());
            }
            return true;
        }
    }
    ,
    SHIPMENTS_DATE_CREATED_AFTER_ISSUED{

        public String getDisplayName() {
            return L10n.get((String)Messages.FinanceProperties_shipmentsDateCreatedAfterIssued);
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.SHIPMENTS_DATE.getId()};
        }

        @Override
        String[] getConditionIds() {
            return new String[0];
        }

        public String getRendererId() {
            return ValueTypes.YES_NO.name();
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append((Boolean)value != false ? L10n.get((String)Messages.FinanceProperties_shipmentsDateCreatedAfterIssuedYes) : L10n.get((String)Messages.FinanceProperties_shipmentsDateCreatedAfterIssuedNo));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            ShipmentsDatePropertySet ps = (ShipmentsDatePropertySet)propertySet;
            if (((Boolean)value).booleanValue()) {
                return MiscUtil.compare((Date)ps.getBookingFileCreateDate(), (Date)ps.getIssueDate()) > 0;
            }
            return MiscUtil.compare((Date)ps.getBookingFileCreateDate(), (Date)ps.getIssueDate()) <= 0;
        }
    }
    ,
    BILLING_ITEM_CREATION_SUPPLIER{

        public String getDisplayName() {
            return L10n.get((String)Messages.FinanceProperties_billingItemCreationSupplier);
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.BILLING_ITEMS_CREATION.getId()};
        }

        @Override
        String[] getConditionIds() {
            return new String[]{Conditions.EQUALS.getId(), Conditions.NOT_EQUALS.getId()};
        }

        public String getRendererId() {
            return ValueTypes.SUPPLIERS.name();
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(L10nResourcesManager.getStr((String)Messages.FinanceProperties_billingItemCreationSupplierInfo, (Object[])new Object[]{cond.getDisplayName(), RulesHelper.toString(value)}));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            BillingItemsCreationPropertySet ps = (BillingItemsCreationPropertySet)propertySet;
            List suppliers = (List)value;
            if (Conditions.EQUALS.equals(condition)) {
                return suppliers.contains(ps.getSupplier());
            }
            if (Conditions.NOT_EQUALS.equals(condition)) {
                return !suppliers.contains(ps.getSupplier());
            }
            return true;
        }
    }
    ,
    BILLING_ITEM_PRODUCT_TYPE{

        public String getDisplayName() {
            return L10n.get((String)Messages.FinanceProperties_billingItemProductType);
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.BILLING_ITEM.getId()};
        }

        @Override
        String[] getConditionIds() {
            return new String[]{Conditions.EQUALS.getId(), Conditions.NOT_EQUALS.getId()};
        }

        public String getRendererId() {
            return ValueTypes.EXTENDED_PRODUCT_TYPE.name();
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(L10nResourcesManager.getStr((String)Messages.FinanceProperties_billingItemProductTypeInfo, (Object[])new Object[]{cond.getDisplayName(), ((List)value).stream().map(x$0 -> Properties.productTypeToString(x$0)).collect(Collectors.joining(", "))}));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            BillingItemPropertySet ps = (BillingItemPropertySet)propertySet;
            MiscUtil.Pair productType = Optional.ofNullable(ps.getProductType()).map(item -> new MiscUtil.Pair((Object)item.getProductType(), (Object)item.getProductDescription())).orElse(null);
            List productTypes = Optional.ofNullable((List)value).map(items -> items.stream().map(item -> new MiscUtil.Pair((Object)item.getProductType(), (Object)item.getProductDescription())).collect(Collectors.toList())).orElse(Collections.emptyList());
            if (Conditions.EQUALS.equals(condition)) {
                return productTypes.stream().anyMatch(item -> MiscUtil.equals((Object)item, (Object)productType));
            }
            if (Conditions.NOT_EQUALS.equals(condition)) {
                return !productTypes.stream().anyMatch(item -> MiscUtil.equals((Object)item, (Object)productType));
            }
            return true;
        }
    }
    ,
    BILLING_ITEM_PRODUCT_STATUS{

        public String getDisplayName() {
            return L10n.get((String)Messages.FinanceProperties_billingItemProductStatus);
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.BILLING_ITEM.getId()};
        }

        @Override
        String[] getConditionIds() {
            return new String[]{Conditions.EQUALS.getId(), Conditions.NOT_EQUALS.getId()};
        }

        public String getRendererId() {
            return ValueTypes.PRODUCT_STATUS.name();
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(L10nResourcesManager.getStr((String)Messages.FinanceProperties_billingItemProductStatusInfo, (Object[])new Object[]{cond.getDisplayName(), RulesHelper.toString(value)}));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            BillingItemPropertySet ps = (BillingItemPropertySet)propertySet;
            List productStatuses = (List)value;
            if (Conditions.EQUALS.equals(condition)) {
                return productStatuses.contains(ps.getProductStatus());
            }
            if (Conditions.NOT_EQUALS.equals(condition)) {
                return !productStatuses.contains(ps.getProductStatus());
            }
            return true;
        }
    }
    ,
    BILLING_ITEM_PRODUCT_IS_ISSUED_IN_EXCHANGE{

        public String getDisplayName() {
            return L10n.get((String)Messages.FinanceProperties_billingItemProductIsIssuedInExchange);
        }

        public String getRendererId() {
            return ValueTypes.YES_NO.name();
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(Boolean.TRUE.equals(value) ? L10n.get((String)Messages.FinanceProperties_billingItemProductIsIssuedInExchange_info1) : L10n.get((String)Messages.FinanceProperties_billingItemProductIsIssuedInExchange_info2));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            BillingItemPropertySet ps = (BillingItemPropertySet)propertySet;
            return Boolean.valueOf(ps.isIssuedInExchange()).equals(value);
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.BILLING_ITEM.getId()};
        }

        @Override
        String[] getConditionIds() {
            return new String[]{Conditions.EQUALS.getId()};
        }
    }
    ,
    BILLING_ITEM_PRODUCT_HAS_REFUND{

        public String getDisplayName() {
            return L10n.get((String)Messages.FinanceProperties_billingItemProductRefunded);
        }

        public String getRendererId() {
            return ValueTypes.YES_NO.name();
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(Boolean.TRUE.equals(value) ? L10n.get((String)Messages.FinanceProperties_billingItemProductRefundedInfo1) : L10n.get((String)Messages.FinanceProperties_billingItemProductRefundedInfo2));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            BillingItemPropertySet ps = (BillingItemPropertySet)propertySet;
            return Boolean.valueOf(ps.isRefunded()).equals(value);
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.BILLING_ITEM.getId()};
        }

        @Override
        String[] getConditionIds() {
            return new String[]{Conditions.EQUALS.getId()};
        }
    }
    ,
    BILLING_ITEM_SERVICE_TYPE{

        public String getDisplayName() {
            return L10n.get((String)Messages.FinanceProperties_billingItemServiceType);
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.BILLING_ITEM.getId()};
        }

        @Override
        String[] getConditionIds() {
            return new String[]{Conditions.EQUALS.getId(), Conditions.NOT_EQUALS.getId()};
        }

        public String getRendererId() {
            return ValueTypes.BILLING_ITEM_SERVICE_TYPE.name();
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(L10nResourcesManager.getStr((String)Messages.FinanceProperties_billingItemServiceTypeInfo, (Object[])new Object[]{cond.getDisplayName(), RulesHelper.toString(value)}));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            BillingItemPropertySet ps = (BillingItemPropertySet)propertySet;
            List serviceTypes = (List)value;
            if (Conditions.EQUALS.equals(condition)) {
                return serviceTypes.contains(ps.getServiceType());
            }
            if (Conditions.NOT_EQUALS.equals(condition)) {
                return !serviceTypes.contains(ps.getServiceType());
            }
            return true;
        }
    }
    ,
    BILLING_ITEM_PAYMENT_TYPE{

        public String getDisplayName() {
            return L10n.get((String)Messages.FinanceProperties_billingItemPaymentType);
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.BILLING_ITEM.getId()};
        }

        @Override
        String[] getConditionIds() {
            return new String[]{Conditions.EQUALS.getId(), Conditions.NOT_EQUALS.getId()};
        }

        public String getRendererId() {
            return ValueTypes.PAYMENT_TYPE.name();
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(L10nResourcesManager.getStr((String)Messages.FinanceProperties_billingItemPaymentTypeInfo, (Object[])new Object[]{cond.getDisplayName(), RulesHelper.toString(value)}));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            BillingItemPropertySet ps = (BillingItemPropertySet)propertySet;
            List paymentTypes = (List)value;
            if (Conditions.EQUALS.equals(condition)) {
                return paymentTypes.contains(ps.getPaymentType());
            }
            if (Conditions.NOT_EQUALS.equals(condition)) {
                return !paymentTypes.contains(ps.getPaymentType());
            }
            return true;
        }
    }
    ,
    BILLING_ITEM_NOMENCLATURE{

        public String getDisplayName() {
            return L10n.get((String)Messages.FinanceProperties_billingItemNomenclature);
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.BILLING_ITEM.getId()};
        }

        @Override
        String[] getConditionIds() {
            return new String[]{Conditions.EQUALS.getId(), Conditions.NOT_EQUALS.getId()};
        }

        public String getRendererId() {
            return ValueTypes.NOMENCLATURE.name();
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(L10nResourcesManager.getStr((String)Messages.FinanceProperties_billingItemNomenclatureInfo, (Object[])new Object[]{cond.getDisplayName(), RulesHelper.toString(value)}));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            BillingItemPropertySet ps = (BillingItemPropertySet)propertySet;
            List nomenclatures = (List)value;
            if (Conditions.EQUALS.equals(condition)) {
                return nomenclatures.contains(ps.getNomenclature());
            }
            if (Conditions.NOT_EQUALS.equals(condition)) {
                return !nomenclatures.contains(ps.getNomenclature());
            }
            return true;
        }
    }
    ,
    BILLING_ITEM_SUPPLIER{

        public String getDisplayName() {
            return L10n.get((String)Messages.FinanceProperties_billingItemSupplier);
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.BILLING_ITEM.getId()};
        }

        @Override
        String[] getConditionIds() {
            return new String[]{Conditions.EQUALS.getId(), Conditions.NOT_EQUALS.getId()};
        }

        public String getRendererId() {
            return ValueTypes.SUPPLIERS.name();
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(L10nResourcesManager.getStr((String)Messages.FinanceProperties_billingItemSupplierInfo, (Object[])new Object[]{cond.getDisplayName(), RulesHelper.toString(value)}));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            BillingItemPropertySet ps = (BillingItemPropertySet)propertySet;
            List suppliers = (List)value;
            if (Conditions.EQUALS.equals(condition)) {
                return suppliers.contains(ps.getSupplier());
            }
            if (Conditions.NOT_EQUALS.equals(condition)) {
                return !suppliers.contains(ps.getSupplier());
            }
            return true;
        }
    }
    ,
    BILLING_ITEM_COUNTERPARTY{

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.BILLING_ITEM.getId()};
        }

        @Override
        String[] getConditionIds() {
            return new String[]{Conditions.INCLUDE.getId(), Conditions.EXCLUDE.getId()};
        }

        public String getDisplayName() {
            return L10n.get((String)Messages.FinanceProperties_billingItemCounterparty);
        }

        public String getRendererId() {
            return ValueTypes.CLIENTS.name();
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(L10nResourcesManager.getStr((String)Messages.FinanceProperties_billingItemCounterpartyInfo, (Object[])new Object[]{cond.getDisplayName(), RulesHelper.toString(value)}));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            BillingItemPropertySet ps = (BillingItemPropertySet)propertySet;
            List organizations = (List)value;
            if (Conditions.INCLUDE.equals(condition)) {
                return organizations.contains(ps.getClient());
            }
            if (Conditions.EXCLUDE.equals(condition)) {
                return !organizations.contains(ps.getClient());
            }
            return false;
        }
    }
    ,
    BILLING_ITEM_PRODUCT_TRAVELLERS_COUNT{

        public String getDisplayName() {
            return L10n.get((String)Messages.FinanceProperties_billingItemProductTravellersCount);
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.BILLING_ITEM.getId()};
        }

        @Override
        String[] getConditionIds() {
            return new String[]{Conditions.EQUALS.getId(), Conditions.LESS_THAN_OR_EQUALS.getId(), Conditions.GREATER_THAN_OR_EQUALS.getId()};
        }

        public String getRendererId() {
            return ValueTypes.INTEGER.name();
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(L10nResourcesManager.getStr((String)Messages.FinanceProperties_billingItemProductTravellersCountInfo, (Object[])new Object[]{cond.getDisplayName(), RulesHelper.toString(value)}));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            BillingItemPropertySet ps = (BillingItemPropertySet)propertySet;
            Number travellersCount = (Number)value;
            if (condition == Conditions.EQUALS) {
                return ps.getTravellersCount() == travellersCount.intValue();
            }
            if (condition == Conditions.LESS_THAN_OR_EQUALS) {
                return ps.getTravellersCount() <= travellersCount.intValue();
            }
            if (condition == Conditions.GREATER_THAN_OR_EQUALS) {
                return ps.getTravellersCount() >= travellersCount.intValue();
            }
            return false;
        }
    }
    ,
    BILLING_ITEM_PRODUCT_HAS_ADDITIONAL_SERVICES{

        public String getDisplayName() {
            return L10n.get((String)Messages.FinanceProperties_billingItemProductHasAdditionalServices);
        }

        public String getRendererId() {
            return ValueTypes.YES_NO.name();
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(Boolean.TRUE.equals(value) ? L10n.get((String)Messages.FinanceProperties_billingItemProductHasAdditionalServicesInfo1) : L10n.get((String)Messages.FinanceProperties_billingItemProductHasAdditionalServicesInfo2));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            BillingItemPropertySet ps = (BillingItemPropertySet)propertySet;
            return Boolean.valueOf(ps.isHasAdditionalServices()).equals(value);
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.BILLING_ITEM.getId()};
        }

        @Override
        String[] getConditionIds() {
            return new String[]{Conditions.EQUALS.getId()};
        }
    }
    ,
    SHIPMENT_CATEGORY{

        public String getDisplayName() {
            return L10n.get((String)Messages.FinanceProperties_shipmentCategory);
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.SHIPMENT.getId()};
        }

        @Override
        String[] getConditionIds() {
            return new String[]{Conditions.INCLUDE.getId(), Conditions.EXCLUDE.getId()};
        }

        public String getRendererId() {
            return ValueTypes.SHIPMENT_CATEGORY.name();
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(L10nResourcesManager.getStr((String)Messages.FinanceProperties_shipmentCategoryInfo, (Object[])new Object[]{cond.getDisplayName(), RulesHelper.toString(value)}));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            ShipmentPropertySet ps = (ShipmentPropertySet)propertySet;
            List categories = (List)value;
            if (Conditions.INCLUDE.equals(condition)) {
                return categories.stream().anyMatch(item -> ps.getCategories().contains(item));
            }
            if (Conditions.EXCLUDE.equals(condition)) {
                return !categories.stream().anyMatch(item -> ps.getCategories().contains(item));
            }
            return true;
        }
    }
    ,
    SHIPMENT_CORRECTION{

        public String getDisplayName() {
            return L10n.get((String)Messages.FinanceProperties_shipmentCorrection);
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.SHIPMENT.getId()};
        }

        @Override
        String[] getConditionIds() {
            return new String[]{Conditions.EQUALS.getId()};
        }

        public String getRendererId() {
            return ValueTypes.YES_NO.name();
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(Boolean.TRUE.equals(value) ? L10n.get((String)Messages.FinanceProperties_shipmentCorrection) : L10n.get((String)Messages.FinanceProperties_shipmentNotCorrection));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            ShipmentPropertySet ps = (ShipmentPropertySet)propertySet;
            boolean correction = Boolean.TRUE.equals(value);
            return ps.isCorrectionShipment() == correction;
        }
    }
    ,
    SHIPMENT_NOMENCLATURE{

        public String getDisplayName() {
            return L10n.get((String)Messages.FinanceProperties_billingItemNomenclature);
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.SHIPMENT.getId()};
        }

        @Override
        String[] getConditionIds() {
            return new String[]{Conditions.INCLUDE.getId(), Conditions.EXCLUDE.getId()};
        }

        public String getRendererId() {
            return ValueTypes.NOMENCLATURE.name();
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(L10nResourcesManager.getStr((String)Messages.FinanceProperties_billingItemNomenclatureInfo, (Object[])new Object[]{cond.getDisplayName(), RulesHelper.toString(value)}));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            ShipmentPropertySet ps = (ShipmentPropertySet)propertySet;
            List nomenclatures = (List)value;
            if (Conditions.INCLUDE.equals(condition)) {
                return nomenclatures.contains(ps.getNomenclature());
            }
            if (Conditions.EXCLUDE.equals(condition)) {
                return !nomenclatures.contains(ps.getNomenclature());
            }
            return true;
        }
    }
    ,
    SHIPMENT_VENDOR_AGREEMENT_TYPE{

        public String getDisplayName() {
            return L10n.get((String)Messages.FinanceProperties_shipmentVendorAgreementType);
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.SHIPMENT.getId(), Targets.INVOICE_PREPAYMENT.getId()};
        }

        @Override
        String[] getConditionIds() {
            return new String[]{Conditions.INCLUDE.getId(), Conditions.EXCLUDE.getId()};
        }

        public String getRendererId() {
            return ValueTypes.AGREEMENT_TYPES.name();
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(L10nResourcesManager.getStr((String)Messages.FinanceProperties_shipmentVendorAgreementTypeInfo, (Object[])new Object[]{cond.getDisplayName(), RulesHelper.toString(value)}));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            HasVendorAgreementTypePropertySet ps = (HasVendorAgreementTypePropertySet)propertySet;
            List types = (List)value;
            if (Conditions.INCLUDE.equals(condition)) {
                return types.contains(ps.getVendorAgreementType());
            }
            if (Conditions.EXCLUDE.equals(condition)) {
                return !types.contains(ps.getVendorAgreementType());
            }
            return true;
        }
    }
    ,
    SHIPMENT_SUPPLIER{

        public String getDisplayName() {
            return L10n.get((String)Messages.FinanceProperties_shipmentSupplier);
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.SHIPMENT.getId(), Targets.INVOICE_PREPAYMENT.getId()};
        }

        @Override
        String[] getConditionIds() {
            return new String[]{Conditions.INCLUDE.getId(), Conditions.EXCLUDE.getId()};
        }

        public String getRendererId() {
            return ValueTypes.SUPPLIERS.name();
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(L10nResourcesManager.getStr((String)Messages.FinanceProperties_shipmentSupplierInfo, (Object[])new Object[]{cond.getDisplayName(), RulesHelper.toString(value)}));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            HasSupplierPropertySet ps = (HasSupplierPropertySet)propertySet;
            List suppliers = (List)value;
            if (Conditions.INCLUDE.equals(condition)) {
                return suppliers.contains(ps.getSupplier());
            }
            if (Conditions.EXCLUDE.equals(condition)) {
                return !suppliers.contains(ps.getSupplier());
            }
            return true;
        }
    }
    ,
    SHIPMENT_HOTEL_PROVIDER{

        public String getDisplayName() {
            return L10n.get((String)Messages.FinanceProperties_shipmentHotelProvider);
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.SHIPMENT.getId()};
        }

        @Override
        String[] getConditionIds() {
            return new String[]{Conditions.INCLUDE.getId(), Conditions.EXCLUDE.getId()};
        }

        public String getRendererId() {
            return ValueTypes.HOTEL_PROVIDER.name();
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(L10nResourcesManager.getStr((String)Messages.FinanceProperties_shipmentHotelProviderInfo, (Object[])new Object[]{cond.getDisplayName(), RulesHelper.toString(value)}));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            ShipmentPropertySet ps = (ShipmentPropertySet)propertySet;
            List providers = (List)value;
            if (Conditions.INCLUDE.equals(condition)) {
                return providers.contains(ps.getHotelProvider());
            }
            if (Conditions.EXCLUDE.equals(condition)) {
                return !providers.contains(ps.getHotelProvider());
            }
            return true;
        }
    }
    ,
    SHIPMENT_HOTEL_VAT_RATE{

        public String getDisplayName() {
            return L10n.get((String)Messages.FinanceProperties_shipmentHotelVatRate);
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.SHIPMENT.getId()};
        }

        @Override
        String[] getConditionIds() {
            return new String[]{Conditions.INCLUDE.getId(), Conditions.EXCLUDE.getId()};
        }

        public String getRendererId() {
            return ValueTypes.HOTEL_VAT_RATE.name();
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            List vatRates = (List)value;
            buf.append(L10nResourcesManager.getStr((String)Messages.FinanceProperties_shipmentHotelVatRateInfo, (Object[])new Object[]{cond.getDisplayName(), vatRates.stream().map(vatRate -> vatRate == -1.0 ? L10n.get((String)Messages.withoutVat) : vatRate + "%").collect(Collectors.joining(", "))}));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            ShipmentPropertySet ps = (ShipmentPropertySet)propertySet;
            List vatRates = (List)value;
            if (Conditions.INCLUDE.equals(condition)) {
                return vatRates.contains(ps.getHotelVatRate());
            }
            if (Conditions.EXCLUDE.equals(condition)) {
                return !vatRates.contains(ps.getHotelVatRate());
            }
            return true;
        }
    }
    ,
    SHIPMENT_CUSTOMER{

        public String getDisplayName() {
            return L10n.get((String)Messages.FinanceProperties_shipmentCustomer);
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.SHIPMENT.getId()};
        }

        @Override
        String[] getConditionIds() {
            return new String[]{Conditions.INCLUDE.getId(), Conditions.EXCLUDE.getId()};
        }

        public String getRendererId() {
            return ValueTypes.CLIENTS.name();
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(L10nResourcesManager.getStr((String)Messages.FinanceProperties_shipmentCustomerInfo, (Object[])new Object[]{cond.getDisplayName(), RulesHelper.toString(value)}));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            ShipmentPropertySet ps = (ShipmentPropertySet)propertySet;
            List organizations = (List)value;
            if (Conditions.INCLUDE.equals(condition)) {
                return organizations.contains(ps.getCustomer());
            }
            if (Conditions.EXCLUDE.equals(condition)) {
                return !organizations.contains(ps.getCustomer());
            }
            return false;
        }
    };


    public String getId() {
        return this.name();
    }

    abstract String[] getTargetIds();

    abstract String[] getConditionIds();

    private static String productTypeToString(ExtendedProductType value) {
        if (value == null) {
            return null;
        }
        if (value.getProductDescription() != null) {
            return value.getProductDescription().getCaption();
        }
        return value.getProductType() == null ? null : value.getProductType().toString();
    }
}

