/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.rules.fiscal;

import com.gridnine.xtrip.common.l10n.messages.L10n;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.FiscalCategory;
import com.gridnine.xtrip.common.model.fiscal.ReceiptLineSellType;
import com.gridnine.xtrip.common.model.rules.fiscal.FiscalReceiptItemActionSet;
import com.gridnine.xtrip.common.model.rules.fiscal.FiscalTargets;
import com.gridnine.xtrip.common.model.rules.l10n.Messages;
import com.gridnine.xtrip.common.model.rules.standard.ValueTypes;
import com.gridnine.xtrip.common.rules.elements.RuleAction;
import com.gridnine.xtrip.common.rules.elements.RuleProxy;

public enum FiscalActions implements RuleAction
{
    FISCAL_RECEIPT_ITEM_NAME_PATTERN{

        public String getDisplayName() {
            return L10n.get((String)Messages.FiscalActions_fiscalReceiptItemNamePattern);
        }

        @Override
        String[] getTargetIds() {
            return new String[]{FiscalTargets.FISCAL_RECEIPT_ITEM.getId()};
        }

        public String getRendererId() {
            return ValueTypes.STRING.name();
        }

        public void buildInfo(StringBuilder buf, Object value) {
            if (value != null) {
                buf.append(value);
            }
        }

        public boolean hasValue() {
            return true;
        }

        public void apply(RuleProxy<?, ?> proxy, Object value) {
            FiscalReceiptItemActionSet actionSet = (FiscalReceiptItemActionSet)proxy.getActionSet();
            String pattern = (String)value;
            if (pattern != null) {
                actionSet.setPattern(pattern);
                proxy.getAppliedRuleCategories().add("rule_category_fiscal_receipt_item_name_pattern");
            }
        }

        public String getRuleCategoryValue(Object actionSet, Object value) {
            return "rule_category_fiscal_receipt_item_name_pattern";
        }
    }
    ,
    FISCAL_RECEIPT_ITEM_SELL_TYPE{

        public String getDisplayName() {
            return L10n.get((String)Messages.FiscalActions_fiscalReceiptItemSellType);
        }

        @Override
        String[] getTargetIds() {
            return new String[]{FiscalTargets.FISCAL_RECEIPT_ITEM.getId()};
        }

        public String getRendererId() {
            return ValueTypes.FISCAL_SELL_TYPE.name();
        }

        public void buildInfo(StringBuilder buf, Object value) {
            if (value != null) {
                buf.append(value.toString());
            }
        }

        public boolean hasValue() {
            return true;
        }

        public void apply(RuleProxy<?, ?> proxy, Object value) {
            FiscalReceiptItemActionSet actionSet = (FiscalReceiptItemActionSet)proxy.getActionSet();
            ReceiptLineSellType sellType = (ReceiptLineSellType)value;
            if (sellType != null) {
                actionSet.setSellType(sellType);
                proxy.getAppliedRuleCategories().add("rule_category_fiscal_receipt_item_sell_type");
            }
        }

        public String getRuleCategoryValue(Object actionSet, Object value) {
            return "rule_category_fiscal_receipt_item_sell_type";
        }
    }
    ,
    FISCAL_RECEIPT_ITEM_SHOW_VAT{

        public String getDisplayName() {
            return L10n.get((String)Messages.FiscalActions_fiscalReceiptItemShowVat);
        }

        @Override
        String[] getTargetIds() {
            return new String[]{FiscalTargets.FISCAL_RECEIPT_ITEM.getId()};
        }

        public String getRendererId() {
            return ValueTypes.YES_NO.name();
        }

        public void buildInfo(StringBuilder buf, Object value) {
            if (value != null) {
                buf.append(value.toString());
            }
        }

        public boolean hasValue() {
            return true;
        }

        public void apply(RuleProxy<?, ?> proxy, Object value) {
            FiscalReceiptItemActionSet actionSet = (FiscalReceiptItemActionSet)proxy.getActionSet();
            Boolean showVat = (Boolean)value;
            if (showVat != null) {
                actionSet.setShowVat(showVat);
                proxy.getAppliedRuleCategories().add("rule_category_fiscal_receipt_item_show_vat");
            }
        }

        public String getRuleCategoryValue(Object actionSet, Object value) {
            return "rule_category_fiscal_receipt_item_show_vat";
        }
    }
    ,
    FISCAL_RECEIPT_ITEM_CATEGORY{

        public String getDisplayName() {
            return L10n.get((String)Messages.FiscalActions_fiscalReceiptItemCategory);
        }

        @Override
        String[] getTargetIds() {
            return new String[]{FiscalTargets.FISCAL_RECEIPT_ITEM.getId()};
        }

        public String getRendererId() {
            return ValueTypes.FISCAL_RECEIPT_CATEGORY.name();
        }

        public void buildInfo(StringBuilder buf, Object value) {
            if (value != null) {
                buf.append(value.toString());
            }
        }

        public boolean hasValue() {
            return true;
        }

        public void apply(RuleProxy<?, ?> proxy, Object value) {
            FiscalReceiptItemActionSet actionSet = (FiscalReceiptItemActionSet)proxy.getActionSet();
            DictionaryReference category = (DictionaryReference)value;
            if (category != null) {
                actionSet.getFiscalCategories().add((DictionaryReference<FiscalCategory>)category);
                proxy.getAppliedRuleCategories().add(category.getCode());
            }
        }

        public String getRuleCategoryValue(Object actionSet, Object value) {
            return ((DictionaryReference)value).getCode();
        }
    };


    public String getId() {
        return this.name();
    }

    abstract String[] getTargetIds();
}

