/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.rules.migration;

import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.meta.EnumType;
import com.gridnine.xtrip.common.meta.MetaRegistry;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.commission.ProductType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.rules.l10n.Messages;
import com.gridnine.xtrip.common.model.rules.migration.RulesMigrationConditions;
import com.gridnine.xtrip.common.model.rules.migration.RulesMigrationPropertySet;
import com.gridnine.xtrip.common.model.rules.standard.Conditions;
import com.gridnine.xtrip.common.model.rules.standard.RulesHelper;
import com.gridnine.xtrip.common.model.rules.standard.ValueTypes;
import com.gridnine.xtrip.common.rules.elements.RuleCondition;
import com.gridnine.xtrip.common.rules.elements.RuleProperty;
import com.gridnine.xtrip.common.util.MiscUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public enum RulesMigrationProperties implements RuleProperty
{
    RULE_NAME{

        @Override
        String[] getConditionIds() {
            return new String[]{Conditions.EQUALS.getId(), Conditions.NOT_EQUALS.getId(), Conditions.INCLUDE.getId(), Conditions.EXCLUDE.getId()};
        }

        public String getDisplayName() {
            return L10nResourcesManager.getStr((String)"RulesMigrationProperties_RuleName", (Object[])new Object[0]);
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(L10nResourcesManager.getStr((String)"RulesMigrationProperties_RuleName_Info", (Object[])new Object[]{cond.getDisplayName(), value}));
        }

        public String getRendererId() {
            return ValueTypes.STRING_LIST.name();
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            RulesMigrationPropertySet ps = (RulesMigrationPropertySet)propertySet;
            if (Conditions.EQUALS.equals(condition)) {
                return RulesHelper.matchesStringRestriction(ps.getRuleName(), value, true);
            }
            if (Conditions.NOT_EQUALS.equals(condition)) {
                return ps.getRuleName() != null && RulesHelper.matchesStringRestriction(ps.getRuleName(), value, false);
            }
            if (Conditions.INCLUDE.equals(condition)) {
                return ps.getRuleName() != null && RulesHelper.matchesStringContainsRestriction(ps.getRuleName(), value, true);
            }
            if (Conditions.EXCLUDE.equals(condition)) {
                return ps.getRuleName() != null && RulesHelper.matchesStringContainsRestriction(ps.getRuleName(), value, false);
            }
            return true;
        }
    }
    ,
    CALCULATION_TYPE{

        @Override
        String[] getConditionIds() {
            return new String[]{RulesMigrationConditions.COMMISSION_FIXED.getId(), RulesMigrationConditions.COMMISSION_PERCENT.getId()};
        }

        public String getDisplayName() {
            return L10nResourcesManager.getStr((String)"RulesMigrationProperties_CalculationType", (Object[])new Object[0]);
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(L10nResourcesManager.getStr((String)"RulesMigrationProperties_CalculationType_Info", (Object[])new Object[]{cond.getDisplayName()}));
        }

        public String getRendererId() {
            return ValueTypes.NULL.name();
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            RulesMigrationPropertySet ps = (RulesMigrationPropertySet)propertySet;
            if (RulesMigrationConditions.COMMISSION_FIXED.equals(condition)) {
                return !ps.isPercentCommission();
            }
            if (RulesMigrationConditions.COMMISSION_PERCENT.equals(condition)) {
                return ps.isPercentCommission();
            }
            return false;
        }
    }
    ,
    COMMISSION_AMOUNT{

        @Override
        String[] getConditionIds() {
            return new String[]{Conditions.EQUALS.getId(), Conditions.NOT_EQUALS.getId(), Conditions.GREATER_THAN.getId(), Conditions.GREATER_THAN_OR_EQUALS.getId(), Conditions.LESS_THAN.getId(), Conditions.LESS_THAN_OR_EQUALS.getId()};
        }

        public String getDisplayName() {
            return L10nResourcesManager.getStr((String)"RulesMigrationProperties_CommissionAmount", (Object[])new Object[0]);
        }

        public String getRendererId() {
            return ValueTypes.NUMBER.name();
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(L10nResourcesManager.getStr((String)"RulesMigrationProperties_CommissionAmount_Info", (Object[])new Object[]{cond.getDisplayName(), value}));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            RulesMigrationPropertySet ps = (RulesMigrationPropertySet)propertySet;
            double dv = value == null ? 0.0 : (Double)value;
            double percent = ps.getCommissionValue();
            if (Conditions.EQUALS.equals(condition)) {
                return Math.abs(percent - dv) < 0.01;
            }
            if (Conditions.NOT_EQUALS.equals(condition)) {
                return Math.abs(percent - dv) >= 0.01;
            }
            if (Conditions.GREATER_THAN.equals(condition)) {
                return percent - dv >= 0.01;
            }
            if (Conditions.GREATER_THAN_OR_EQUALS.equals(condition)) {
                return Math.abs(percent - dv) < 0.01 || percent - dv >= 0.01;
            }
            if (Conditions.LESS_THAN.equals(condition)) {
                return dv - percent >= 0.01;
            }
            if (Conditions.LESS_THAN_OR_EQUALS.equals(condition)) {
                return Math.abs(percent - dv) < 0.01 || dv - percent >= 0.01;
            }
            return false;
        }
    }
    ,
    COMMISSION_CURRENCY{

        @Override
        String[] getConditionIds() {
            return new String[]{Conditions.EQUALS.getId(), Conditions.NOT_EQUALS.getId()};
        }

        public String getDisplayName() {
            return L10nResourcesManager.getStr((String)"RulesMigrationProperties_CommissionCurrency", (Object[])new Object[0]);
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(L10nResourcesManager.getStr((String)"RulesMigrationProperties_CommissionCurrency_Info", (Object[])new Object[]{cond.getDisplayName(), value}));
        }

        public String getRendererId() {
            return ValueTypes.STRING_LIST.name();
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            RulesMigrationPropertySet ps = (RulesMigrationPropertySet)propertySet;
            if (Conditions.EQUALS.equals(condition)) {
                return RulesHelper.matchesStringRestriction(ps.getCurrencyCode(), value, true);
            }
            if (Conditions.NOT_EQUALS.equals(condition)) {
                return ps.getCurrencyCode() != null && RulesHelper.matchesStringRestriction(ps.getCurrencyCode(), value, false);
            }
            return false;
        }
    }
    ,
    COMMISSION_PROPERTIES{

        @Override
        String[] getConditionIds() {
            return new String[]{Conditions.EQUALS.getId(), Conditions.NOT_EQUALS.getId()};
        }

        public String getDisplayName() {
            return L10nResourcesManager.getStr((String)"RulesMigrationProperties_CommissionProperties", (Object[])new Object[0]);
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(L10nResourcesManager.getStr((String)"RulesMigrationProperties_CommissionProperties_Info", (Object[])new Object[]{cond.getDisplayName(), value}));
        }

        public String getRendererId() {
            return ValueTypes.COMMISSION_PROPERTIES.name();
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            List<EntityReference> ruleValues;
            RulesMigrationPropertySet ps = (RulesMigrationPropertySet)propertySet;
            if (value == null || ps.getCommissionProperties() == null) {
                return false;
            }
            List<EntityReference> list = ruleValues = value instanceof Collection ? (List<EntityReference>)value : Collections.singletonList((EntityReference)value);
            if (Conditions.EQUALS.equals(condition)) {
                return ruleValues.contains(ps.getCommissionProperties());
            }
            if (Conditions.NOT_EQUALS.equals(condition)) {
                return !ruleValues.contains(ps.getCommissionProperties());
            }
            return false;
        }
    }
    ,
    PRODUCT_TYPE{

        @Override
        String[] getConditionIds() {
            return new String[]{Conditions.EQUALS.getId(), Conditions.NOT_EQUALS.getId()};
        }

        public String getDisplayName() {
            return ((EnumType)MetaRegistry.get().getEnums().get(ProductType.class.getName())).getDisplayName();
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(String.format("%s %s %s", this.getDisplayName(), cond.getDisplayName(), value));
        }

        public String getRendererId() {
            return ValueTypes.AIR_PRODUCT_TYPE.name();
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            RulesMigrationPropertySet ps = (RulesMigrationPropertySet)propertySet;
            if (Conditions.EQUALS == condition) {
                return ps.getProductType() == null || ps.getProductType() == value;
            }
            if (Conditions.NOT_EQUALS == condition) {
                return ps.getProductType() != null && ps.getProductType() != value;
            }
            return false;
        }
    }
    ,
    CONTRACT_BLANK_OWNER{

        @Override
        String[] getConditionIds() {
            return new String[]{Conditions.EQUALS.getId(), Conditions.NOT_EQUALS.getId()};
        }

        public String getDisplayName() {
            return L10nResourcesManager.getStr((String)"RulesMigrationProperties_ContractBlankOwner", (Object[])new Object[0]);
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(L10nResourcesManager.getStr((String)"RulesMigrationProperties_ContractBlankOwner_Info", (Object[])new Object[]{cond.getDisplayName(), this.toString((List)value)}));
        }

        private String toString(List<Object> value) {
            if (value == null || value.isEmpty()) {
                return "";
            }
            StringBuilder sb = new StringBuilder();
            for (Object blankOwner : value) {
                String title = "???";
                if (blankOwner instanceof EntityReference) {
                    title = ((EntityReference)blankOwner).getCaption();
                } else {
                    EntityContainer ctr = EntityStorage.get().load(Organization.class, (String)blankOwner);
                    if (ctr != null) {
                        title = ctr.toReference().toString();
                    }
                }
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                sb.append(title);
            }
            return sb.toString();
        }

        public String getRendererId() {
            return ValueTypes.BLANK_OWNERS.name();
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            RulesMigrationPropertySet ps = (RulesMigrationPropertySet)propertySet;
            List values = (List)value;
            if (Conditions.EQUALS.equals(condition)) {
                return RulesHelper.matchesEntityRestriction(ps.getContractBlankOwner(), values, true);
            }
            return RulesHelper.matchesEntityRestriction(ps.getContractBlankOwner(), values, false);
        }
    }
    ,
    BLANK_OWNER_FROM_RULE{

        @Override
        String[] getConditionIds() {
            return new String[]{Conditions.INCLUDE.getId(), Conditions.EXCLUDE.getId()};
        }

        public String getDisplayName() {
            return L10nResourcesManager.getStr((String)"RulesMigrationProperties_BlankOwnerFromRule", (Object[])new Object[0]);
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(L10nResourcesManager.getStr((String)"RulesMigrationProperties_BlankOwnerFromRule_info", (Object[])new Object[]{cond.getDisplayName(), RulesHelper.toString(value)}));
        }

        public String getRendererId() {
            return ValueTypes.STRING_LIST.name();
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            RulesMigrationPropertySet ps = (RulesMigrationPropertySet)propertySet;
            List codes = (List)value;
            if (Conditions.INCLUDE.equals(condition)) {
                return ps.getBlankOwnerCondition() == Conditions.INCLUDE && RulesHelper.matchesStringRestriction(ps.getBlankOwnerRestrictionCodes(), (Object)codes, true);
            }
            if (Conditions.EXCLUDE.equals(condition)) {
                return ps.getBlankOwnerCondition() == Conditions.EXCLUDE && RulesHelper.matchesStringRestriction(ps.getBlankOwnerRestrictionCodes(), (Object)codes, true);
            }
            return false;
        }
    }
    ,
    VALIDATING_CARRIER_NUMBER_FROM_RULE{

        @Override
        String[] getConditionIds() {
            return new String[]{Conditions.INCLUDE.getId(), Conditions.EXCLUDE.getId()};
        }

        public String getDisplayName() {
            return L10nResourcesManager.getStr((String)"RulesMigrationProperties_ValidatingCarrierNumberFromRule", (Object[])new Object[0]);
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(L10nResourcesManager.getStr((String)"RulesMigrationProperties_ValidatingCarrierNumberFromRule_info", (Object[])new Object[]{cond.getDisplayName(), RulesHelper.toString(value)}));
        }

        public String getRendererId() {
            return ValueTypes.STRING_LIST.name();
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            RulesMigrationPropertySet ps = (RulesMigrationPropertySet)propertySet;
            List codes = (List)value;
            if (Conditions.INCLUDE.equals(condition)) {
                return ps.getValidatingCarrierNumberCondition() == Conditions.EQUALS && RulesHelper.matchesStringRestriction(ps.getValidatingCarrierNumberRestrictionCodes(), (Object)codes, true);
            }
            if (Conditions.EXCLUDE.equals(condition)) {
                return ps.getValidatingCarrierNumberCondition() == Conditions.NOT_EQUALS && RulesHelper.matchesStringRestriction(ps.getValidatingCarrierNumberRestrictionCodes(), (Object)codes, true);
            }
            return false;
        }
    }
    ,
    CONTRACT_SUPPLIER{

        @Override
        String[] getConditionIds() {
            return new String[]{Conditions.EQUALS.getId(), Conditions.NOT_EQUALS.getId()};
        }

        public String getDisplayName() {
            return L10nResourcesManager.getStr((String)"RulesMigrationProperties_ContractSupplier", (Object[])new Object[0]);
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(L10nResourcesManager.getStr((String)"RulesMigrationProperties_ContractSupplier_Info", (Object[])new Object[]{cond.getDisplayName(), value != null ? ((List)value).stream().map(EntityReference::getCaption).map(MiscUtil::guarded).collect(Collectors.joining(", ")) : ""}));
        }

        public String getRendererId() {
            return ValueTypes.SUPPLIERS.name();
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            RulesMigrationPropertySet ps = (RulesMigrationPropertySet)propertySet;
            List values = (List)value;
            if (Conditions.EQUALS.equals(condition)) {
                return RulesHelper.matchesEntityRestriction(values, ps.getContractSupplier(), true);
            }
            return RulesHelper.matchesEntityRestriction(values, ps.getContractSupplier(), false);
        }
    }
    ,
    SUPPLIER_FROM_RULE{

        @Override
        String[] getConditionIds() {
            return new String[]{Conditions.INCLUDE.getId(), Conditions.EXCLUDE.getId()};
        }

        public String getDisplayName() {
            return L10nResourcesManager.getStr((String)"RulesMigrationProperties_SupplierFromRule", (Object[])new Object[0]);
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(L10nResourcesManager.getStr((String)"RulesMigrationProperties_SupplierFromRule_Info", (Object[])new Object[]{cond.getDisplayName(), RulesHelper.toString(value)}));
        }

        public String getRendererId() {
            return ValueTypes.SUPPLIERS.name();
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            RulesMigrationPropertySet ps = (RulesMigrationPropertySet)propertySet;
            List values = (List)value;
            if (Conditions.INCLUDE.equals(condition)) {
                return ps.getSupplierCondition() == Conditions.INCLUDE && RulesHelper.matchesEntityRestriction(ps.getSupplierRestrictions(), values, true);
            }
            if (Conditions.EXCLUDE.equals(condition)) {
                return ps.getSupplierCondition() == Conditions.EXCLUDE && RulesHelper.matchesEntityRestriction(ps.getSupplierRestrictions(), values, true);
            }
            return false;
        }
    }
    ,
    RULE_PAYMENT_TYPE{

        @Override
        String[] getConditionIds() {
            return new String[]{Conditions.INCLUDE.getId(), Conditions.EXCLUDE.getId()};
        }

        public String getDisplayName() {
            return L10nResourcesManager.getStr((String)"RulesMigrationProperties_PaymentType", (Object[])new Object[0]);
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(L10nResourcesManager.getStr((String)Messages.RuleProperty_PAYMENT_TYPES_info, (Object[])new Object[]{cond.getDisplayName(), RulesHelper.toString(value)}));
        }

        public String getRendererId() {
            return ValueTypes.PAYMENT_TYPES_LIST.name();
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            RulesMigrationPropertySet ps = (RulesMigrationPropertySet)propertySet;
            if (Conditions.INCLUDE.equals(condition)) {
                return RulesHelper.matchesEnumRestriction(ps.getPaymentTypes(), (List)value, true);
            }
            if (Conditions.EXCLUDE.equals(condition)) {
                return RulesHelper.matchesEnumRestriction(ps.getPaymentTypes(), (List)value, false);
            }
            return false;
        }
    };


    public String getId() {
        return this.name();
    }

    abstract String[] getConditionIds();
}

