/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.rules.passport;

import com.gridnine.xtrip.common.l10n.messages.L10n;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.rules.l10n.Messages;
import com.gridnine.xtrip.common.model.rules.passport.PassportPropertiesProvider;
import com.gridnine.xtrip.common.model.rules.standard.AirTicketPropertiesProvider;
import com.gridnine.xtrip.common.model.rules.standard.Conditions;
import com.gridnine.xtrip.common.model.rules.standard.RulePropertyConditions;
import com.gridnine.xtrip.common.model.rules.standard.RulesHelper;
import com.gridnine.xtrip.common.model.rules.standard.ValueTypes;
import com.gridnine.xtrip.common.rules.elements.RuleCondition;
import com.gridnine.xtrip.common.rules.elements.RuleProperty;
import java.util.ArrayList;
import java.util.List;

public enum PassportProperties implements RuleProperty,
RulePropertyConditions
{
    PASSPORT_TYPE{

        public double getRank() {
            return 0.001;
        }

        @Override
        public String[] getConditionIds() {
            return new String[]{Conditions.EQUALS.getId(), Conditions.NOT_EQUALS.getId()};
        }

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleProperty_PASSPORT_TYPE);
        }

        public String getRendererId() {
            return ValueTypes.PASSPORT_TYPE.name();
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(L10nResourcesManager.getStr((String)Messages.RuleProperty_PASSPORT_TYPE_info, (Object[])new Object[]{cond.getDisplayName(), RulesHelper.values2text((List)value)}));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            PassportPropertiesProvider ps = (PassportPropertiesProvider)propertySet;
            if (Conditions.EQUALS.equals(condition)) {
                return RulesHelper.matchesEnumsRestriction(ps.getPassportTypes(), (List)value, true);
            }
            if (Conditions.NOT_EQUALS.equals(condition)) {
                return RulesHelper.matchesEnumsRestriction(ps.getPassportTypes(), (List)value, false);
            }
            return true;
        }
    }
    ,
    PASSPORT_CITIZENSHIP{

        public double getRank() {
            return 0.001;
        }

        @Override
        public String[] getConditionIds() {
            return new String[]{Conditions.INCLUDE.getId(), Conditions.EXCLUDE.getId()};
        }

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleProperty_PASSPORT_CITIZENSHIP);
        }

        public String getRendererId() {
            return ValueTypes.STRING.name();
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(L10nResourcesManager.getStr((String)Messages.RuleProperty_PASSPORT_CITIZENSHIP_info, (Object[])new Object[]{cond.getDisplayName(), RulesHelper.toString(value)}));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            PassportPropertiesProvider ps = (PassportPropertiesProvider)propertySet;
            List<String> strings = RulesHelper.toStringCollection(((String)value).toUpperCase());
            ArrayList citizenship = new ArrayList(ps.getCitizenship());
            if (Conditions.INCLUDE.equals(condition)) {
                return RulesHelper.matchesDictRestriction(strings, citizenship, true);
            }
            if (Conditions.EXCLUDE.equals(condition)) {
                return RulesHelper.matchesDictRestriction(strings, citizenship, false);
            }
            return true;
        }
    }
    ,
    LATIN_REGISTRATION{

        @Override
        public String[] getConditionIds() {
            return new String[]{Conditions.EQUALS.getId()};
        }

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleProperty_LATIN_REGISTRATION);
        }

        public String getRendererId() {
            return ValueTypes.YES_NO.name();
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(Boolean.TRUE.equals(value) ? L10n.get((String)Messages.RuleProperty_LATIN_REGISTRATION) : L10n.get((String)Messages.RuleProperty_LATIN_REGISTRATION_NOT));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            AirTicketPropertiesProvider ps = (AirTicketPropertiesProvider)propertySet;
            return Boolean.valueOf(ps.isLatinRegistration()).equals(value);
        }
    };


    public String getId() {
        return this.name();
    }
}

