/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.rules.standard;

import com.gridnine.xtrip.common.l10n.messages.L10n;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.l10n.model.L10nString;
import com.gridnine.xtrip.common.model.rules.l10n.Messages;
import com.gridnine.xtrip.common.model.rules.standard.BasicCommissionActionsProvider;
import com.gridnine.xtrip.common.model.rules.standard.CachedRulesCategoriesProvider;
import com.gridnine.xtrip.common.model.rules.standard.CommissionMigrationActionsProvider;
import com.gridnine.xtrip.common.model.rules.standard.DisplayMessageActionProvider;
import com.gridnine.xtrip.common.model.rules.standard.RuleResultValue;
import com.gridnine.xtrip.common.model.rules.standard.RulesHelper;
import com.gridnine.xtrip.common.model.rules.standard.ServiceClassCommissionsRuleResultValue;
import com.gridnine.xtrip.common.model.rules.standard.Targets;
import com.gridnine.xtrip.common.model.rules.standard.TechnicalFeeActionsProvider;
import com.gridnine.xtrip.common.model.rules.standard.ValueTypes;
import com.gridnine.xtrip.common.model.rules.standard.formOfPayment.FOPTargets;
import com.gridnine.xtrip.common.model.rules.standard.qualityCheck.QualityCheckTargets;
import com.gridnine.xtrip.common.rules.elements.RuleAction;
import com.gridnine.xtrip.common.rules.elements.RuleProxy;

public enum Actions implements RuleAction
{
    SIMPLE_COMMISSION{

        @Override
        public void buildInfo(StringBuilder buf, Object value) {
            RulesHelper.buildCommissionInfo(buf, (RuleResultValue)value);
        }

        @Override
        public String getDisplayName() {
            return L10n.get((String)Messages.RuleAction_SimpleCommission);
        }

        @Override
        public String getRendererId() {
            return ValueTypes.SIMPLE_COMMISSION.name();
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.PRODUCT_COMMISSION.getId()};
        }

        @Override
        public boolean hasValue() {
            return true;
        }

        public void apply(RuleProxy<?, ?> proxy, Object value) throws Exception {
            RulesHelper.apply(proxy, (RuleResultValue)value);
        }

        public String getRuleCategoryValue(Object actionSet, Object value) {
            return RulesHelper.getRuleCategoryValue((CachedRulesCategoriesProvider)((BasicCommissionActionsProvider)actionSet), (RuleResultValue)value);
        }
    }
    ,
    FOP_COMMISSION{

        @Override
        public void buildInfo(StringBuilder buf, Object value) {
            RulesHelper.buildCommissionInfo(buf, (RuleResultValue)value);
        }

        @Override
        public String getDisplayName() {
            return L10n.get((String)Messages.RuleAction_FopCommission);
        }

        @Override
        public String getRendererId() {
            return ValueTypes.FOP_COMMISSION.name();
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.PRODUCT_COMMISSION.getId()};
        }

        @Override
        public boolean hasValue() {
            return true;
        }

        public void apply(RuleProxy<?, ?> proxy, Object value) throws Exception {
            RulesHelper.apply(proxy, (RuleResultValue)value);
        }

        public String getRuleCategoryValue(Object actionSet, Object value) {
            return RulesHelper.getRuleCategoryValue((CachedRulesCategoriesProvider)((BasicCommissionActionsProvider)actionSet), (RuleResultValue)value);
        }
    }
    ,
    SIMPLE_DISCOUNT{

        @Override
        public void buildInfo(StringBuilder buf, Object value) {
            RulesHelper.buildCommissionInfo(buf, (RuleResultValue)value);
        }

        @Override
        public String getDisplayName() {
            return L10n.get((String)Messages.RuleAction_SimpleDiscount);
        }

        @Override
        public String getRendererId() {
            return ValueTypes.SIMPLE_DISCOUNT.name();
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.PRODUCT_COMMISSION.getId(), Targets.HOTELS_COMMISSION.getId()};
        }

        @Override
        public boolean hasValue() {
            return true;
        }

        public void apply(RuleProxy<?, ?> proxy, Object value) throws Exception {
            RulesHelper.apply(proxy, (RuleResultValue)value);
        }

        public String getRuleCategoryValue(Object actionSet, Object value) {
            return RulesHelper.getRuleCategoryValue((CachedRulesCategoriesProvider)((BasicCommissionActionsProvider)actionSet), (RuleResultValue)value);
        }
    }
    ,
    FOP_DISCOUNT{

        @Override
        public void buildInfo(StringBuilder buf, Object value) {
            RulesHelper.buildCommissionInfo(buf, (RuleResultValue)value);
        }

        @Override
        public String getDisplayName() {
            return L10n.get((String)Messages.RuleAction_FopDiscount);
        }

        @Override
        public String getRendererId() {
            return ValueTypes.FOP_DISCOUNT.name();
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.PRODUCT_COMMISSION.getId()};
        }

        @Override
        public boolean hasValue() {
            return true;
        }

        public void apply(RuleProxy<?, ?> proxy, Object value) throws Exception {
            RulesHelper.apply(proxy, (RuleResultValue)value);
        }

        public String getRuleCategoryValue(Object actionSet, Object value) {
            return RulesHelper.getRuleCategoryValue((CachedRulesCategoriesProvider)((BasicCommissionActionsProvider)actionSet), (RuleResultValue)value);
        }
    }
    ,
    SIMPLE_FEE{

        @Override
        public void buildInfo(StringBuilder buf, Object value) {
            RulesHelper.buildCommissionInfo(buf, (RuleResultValue)value);
        }

        @Override
        public String getDisplayName() {
            return L10n.get((String)Messages.RuleAction_SimpleFee);
        }

        @Override
        public String getRendererId() {
            return ValueTypes.SIMPLE_FEE.name();
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.PRODUCT_COMMISSION.getId()};
        }

        @Override
        public boolean hasValue() {
            return true;
        }

        public void apply(RuleProxy<?, ?> proxy, Object value) throws Exception {
            RulesHelper.apply(proxy, (RuleResultValue)value);
        }

        public String getRuleCategoryValue(Object actionSet, Object value) {
            return RulesHelper.getRuleCategoryValue((CachedRulesCategoriesProvider)((BasicCommissionActionsProvider)actionSet), (RuleResultValue)value);
        }
    }
    ,
    FOP_FEE{

        @Override
        public void buildInfo(StringBuilder buf, Object value) {
            RulesHelper.buildCommissionInfo(buf, (RuleResultValue)value);
        }

        @Override
        public String getDisplayName() {
            return L10n.get((String)Messages.RuleAction_FopFee);
        }

        @Override
        public String getRendererId() {
            return ValueTypes.FOP_FEE.name();
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.PRODUCT_COMMISSION.getId()};
        }

        @Override
        public boolean hasValue() {
            return true;
        }

        public void apply(RuleProxy<?, ?> proxy, Object value) throws Exception {
            RulesHelper.apply(proxy, (RuleResultValue)value);
        }

        public String getRuleCategoryValue(Object actionSet, Object value) {
            return RulesHelper.getRuleCategoryValue((CachedRulesCategoriesProvider)((BasicCommissionActionsProvider)actionSet), (RuleResultValue)value);
        }
    }
    ,
    PAYMENT_FEE{

        @Override
        public void buildInfo(StringBuilder buf, Object value) {
            RulesHelper.buildCommissionInfo(buf, (RuleResultValue)value);
        }

        @Override
        public String getDisplayName() {
            return L10n.get((String)Messages.RuleAction_PaymentFee);
        }

        @Override
        public String getRendererId() {
            return ValueTypes.PAYMENT_FEE.name();
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.PRODUCT_COMMISSION.getId()};
        }

        @Override
        public boolean hasValue() {
            return true;
        }

        public void apply(RuleProxy<?, ?> proxy, Object value) throws Exception {
            RulesHelper.apply(proxy, (RuleResultValue)value);
        }

        public String getRuleCategoryValue(Object actionSet, Object value) {
            return RulesHelper.getRuleCategoryValue((CachedRulesCategoriesProvider)((BasicCommissionActionsProvider)actionSet), (RuleResultValue)value);
        }
    }
    ,
    INCLUDE_AGENCY_BONUS_IN_TECHNICAL_FEE{

        @Override
        public String getDisplayName() {
            return L10n.get((String)Messages.RuleAction_IncludeAgencyBonusInTechnicalFee);
        }

        @Override
        public String getRendererId() {
            return ValueTypes.YES_NO.name();
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.TECHNICAL_FEE.getId()};
        }

        @Override
        public boolean hasValue() {
            return true;
        }

        public String getRuleCategoryValue(Object actionSet, Object value) throws Exception {
            return this.name().toLowerCase();
        }

        public void apply(RuleProxy<?, ?> proxy, Object value) throws Exception {
            TechnicalFeeActionsProvider as = (TechnicalFeeActionsProvider)proxy.getActionSet();
            as.getProdUid2IncludeBonus().put(as.getProdUid(), (Boolean)value);
            proxy.getAppliedRuleCategories().add(this.getRuleCategoryValue(as, value));
        }

        @Override
        public void buildInfo(StringBuilder buf, Object value) {
            buf.append(String.format("%s: %s", L10n.get((String)Messages.RuleAction_IncludeAgencyBonusInTechnicalFee), (Boolean)value != false ? Messages.YES : Messages.NO));
        }
    }
    ,
    TRANSLATE_TECHNICAL_PROVIDER_FEE{

        @Override
        public String getDisplayName() {
            return L10n.get((String)Messages.RuleAction_TranslateTechnicalProviderFee);
        }

        @Override
        public String getRendererId() {
            return ValueTypes.YES_NO.name();
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.TECHNICAL_FEE.getId()};
        }

        @Override
        public boolean hasValue() {
            return true;
        }

        public String getRuleCategoryValue(Object actionSet, Object value) throws Exception {
            return this.name().toLowerCase();
        }

        public void apply(RuleProxy<?, ?> proxy, Object value) throws Exception {
            TechnicalFeeActionsProvider as = (TechnicalFeeActionsProvider)proxy.getActionSet();
            as.getProdUid2TransferTechFee().put(as.getProdUid(), (Boolean)value);
            proxy.getAppliedRuleCategories().add(this.getRuleCategoryValue(as, value));
        }

        @Override
        public void buildInfo(StringBuilder buf, Object value) {
            buf.append(String.format("%s: %s", L10n.get((String)Messages.RuleAction_TranslateTechnicalProviderFee), (Boolean)value != false ? Messages.YES : Messages.NO));
        }
    }
    ,
    REDUCED_COMMISSION{

        @Override
        public String getDisplayName() {
            return L10n.get((String)Messages.RuleAction_ReducedRate);
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.COMMISSIONS_MIGRATION.getId()};
        }

        @Override
        public String getRendererId() {
            return ValueTypes.NUMBER.name();
        }

        @Override
        public boolean hasValue() {
            return true;
        }

        @Override
        public void buildInfo(StringBuilder buf, Object value) {
            buf.append(L10nResourcesManager.getStr((String)Messages.RuleAction_ReducedRate_info, (Object[])new Object[]{value}));
        }

        public String getRuleCategoryValue(Object actionSet, Object value) {
            return this.name().toLowerCase();
        }

        public void apply(RuleProxy<?, ?> proxy, Object value) {
            CommissionMigrationActionsProvider as = (CommissionMigrationActionsProvider)proxy.getActionSet();
            as.setReducedPercent(value != null ? (Double)value : 0.0);
            proxy.getAppliedRuleCategories().add(this.getRuleCategoryValue(as, value));
        }
    }
    ,
    SERVICE_CLASS_COMMISSION{

        @Override
        public String getDisplayName() {
            return L10n.get((String)Messages.RuleAction_ServiceClassCommission);
        }

        @Override
        public String getRendererId() {
            return ValueTypes.SERVICE_CLASS_COMMISSION.name();
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.PRODUCT_COMMISSION.getId()};
        }

        @Override
        public void buildInfo(StringBuilder info, Object object) {
            RulesHelper.buildCommissionInfo(info, (ServiceClassCommissionsRuleResultValue)((Object)object));
        }

        @Override
        public boolean hasValue() {
            return true;
        }

        public void apply(RuleProxy<?, ?> proxy, Object value) {
            RulesHelper.apply(proxy, (ServiceClassCommissionsRuleResultValue)((Object)value));
        }

        public String getRuleCategoryValue(Object actionSet, Object value) {
            return RulesHelper.getRuleCategoryValue((CachedRulesCategoriesProvider)((BasicCommissionActionsProvider)actionSet), (ServiceClassCommissionsRuleResultValue)((Object)value));
        }
    }
    ,
    EXCLUDE_SABRE_COMMISSION_QUALIFIER{

        @Override
        public String getDisplayName() {
            return L10n.get((String)Messages.RuleAction_SabreExcludeCommissionQualifier);
        }

        @Override
        public String getRendererId() {
            return ValueTypes.YES_NO.name();
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.PRODUCT_COMMISSION.getId()};
        }

        @Override
        public void buildInfo(StringBuilder buf, Object value) {
            buf.append(String.format("%s: %s", L10n.get((String)Messages.RuleAction_SabreExcludeCommissionQualifier), (Boolean)value != false ? Messages.YES : Messages.NO));
        }

        @Override
        public boolean hasValue() {
            return true;
        }

        public void apply(RuleProxy<?, ?> proxy, Object value) throws Exception {
            BasicCommissionActionsProvider action = (BasicCommissionActionsProvider)proxy.getActionSet();
            action.setSabreExcludeCommissionQualifier((Boolean)value);
            proxy.getAppliedRuleCategories().add(this.getRuleCategoryValue(action, value));
        }

        public String getRuleCategoryValue(Object actionSet, Object value) throws Exception {
            return "exclude-sabre-commission-qualifier";
        }
    }
    ,
    DISPLAY_MESSAGE{

        @Override
        public String getDisplayName() {
            return L10nResourcesManager.getStr((String)"RuleAction_DisplayMessage", (Object[])new Object[0]);
        }

        @Override
        public String getRendererId() {
            return ValueTypes.L10N_TEXT.name();
        }

        @Override
        String[] getTargetIds() {
            return new String[]{FOPTargets.FOP_CHECK_RESERVATION.getId(), QualityCheckTargets.QUALITY_CHECK_RESERVATION.getId()};
        }

        @Override
        public boolean hasValue() {
            return true;
        }

        @Override
        public void buildInfo(StringBuilder buf, Object value) {
            buf.append(L10nResourcesManager.getStr((String)"RuleAction_DisplayMessage", (Object[])new Object[0]));
        }

        public String getRuleCategoryValue(Object actionSet, Object value) {
            return "check-display-message";
        }

        public void apply(RuleProxy<?, ?> proxy, Object value) {
            DisplayMessageActionProvider as = (DisplayMessageActionProvider)proxy.getActionSet();
            L10nString l10nString = (L10nString)value;
            as.setMessage(l10nString);
            proxy.getAppliedRuleCategories().add(this.getRuleCategoryValue(as, l10nString));
        }
    };


    public String getId() {
        return this.name();
    }

    public abstract String getRendererId();

    abstract String[] getTargetIds();

    public abstract String getDisplayName();

    public abstract boolean hasValue();

    public abstract void buildInfo(StringBuilder var1, Object var2);
}

