/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.rules.standard;

import com.gridnine.xtrip.common.l10n.messages.L10n;
import com.gridnine.xtrip.common.model.rules.l10n.Messages;
import com.gridnine.xtrip.common.model.rules.standard.AgentTouchProductPropertiesProvider;
import com.gridnine.xtrip.common.model.rules.standard.Conditions;
import com.gridnine.xtrip.common.model.rules.standard.RulePropertyConditions;
import com.gridnine.xtrip.common.model.rules.standard.RulesHelper;
import com.gridnine.xtrip.common.model.rules.standard.Targets;
import com.gridnine.xtrip.common.model.rules.standard.ValueTypes;
import com.gridnine.xtrip.common.rules.elements.RuleCondition;
import com.gridnine.xtrip.common.rules.elements.RuleProperty;
import java.util.ArrayList;

public enum AgentTouchProductProperties implements RuleProperty,
RulePropertyConditions
{
    AGENT_TOUCH_TYPE{

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleTarget_AgentTouchTypes);
        }

        public String getRendererId() {
            return ValueTypes.AGENT_TOUCH_TYPES.name();
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(this.getDisplayName()).append(" ").append(cond.getDisplayName()).append(" \"").append(RulesHelper.toString(value)).append("\"");
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            AgentTouchProductPropertiesProvider propertiesProvider = (AgentTouchProductPropertiesProvider)propertySet;
            ArrayList agentTouchTypes = (ArrayList)value;
            if (Conditions.INCLUDE.equals(condition)) {
                return RulesHelper.matchesEnumRestriction(propertiesProvider.getTypeName(), agentTouchTypes, true);
            }
            if (Conditions.EXCLUDE.equals(condition)) {
                return RulesHelper.matchesEnumRestriction(propertiesProvider.getTypeName(), agentTouchTypes, false);
            }
            return false;
        }

        @Override
        public String[] getTargetIds() {
            return new String[]{Targets.AGENT_TOUCH_COMMISSION.getId()};
        }

        @Override
        public String[] getConditionIds() {
            return new String[]{Conditions.INCLUDE.getId(), Conditions.EXCLUDE.getId()};
        }
    };


    public String getId() {
        return this.name();
    }

    abstract String[] getTargetIds();

    @Override
    public abstract String[] getConditionIds();
}

