/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.rules.standard;

import com.gridnine.xtrip.common.l10n.messages.L10n;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.rules.l10n.Messages;
import com.gridnine.xtrip.common.model.rules.standard.Conditions;
import com.gridnine.xtrip.common.model.rules.standard.DeliveryPropertiesProvider;
import com.gridnine.xtrip.common.model.rules.standard.RulePropertyConditions;
import com.gridnine.xtrip.common.model.rules.standard.Targets;
import com.gridnine.xtrip.common.model.rules.standard.ValueTypes;
import com.gridnine.xtrip.common.rules.elements.RuleCondition;
import com.gridnine.xtrip.common.rules.elements.RuleProperty;
import com.gridnine.xtrip.common.util.MiscUtil;

public enum DeliveryProperties implements RuleProperty,
RulePropertyConditions
{
    DELIVERY_URGENT{

        @Override
        public String[] getConditionIds() {
            return new String[]{Conditions.EQUALS.getId()};
        }

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleProperty_DeliveryUrgent);
        }

        public String getRendererId() {
            return ValueTypes.YES_NO.name();
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.DELIVERY.getId()};
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(L10nResourcesManager.getStr((String)Messages.RuleProperty_DeliveryUrgent_info, (Object[])new Object[]{Boolean.TRUE.equals(value) ? L10n.get((String)Messages.URGENT) : L10n.get((String)Messages.NOT_URGENT)}));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            DeliveryPropertiesProvider ps = (DeliveryPropertiesProvider)propertySet;
            return ps.isUrgent() == Boolean.TRUE.equals(value);
        }
    }
    ,
    DELIVERY_TOTAL_COST{

        @Override
        public String[] getConditionIds() {
            return new String[]{Conditions.EQUALS.getId(), Conditions.NOT_EQUALS.getId(), Conditions.GREATER_THAN.getId(), Conditions.GREATER_THAN_OR_EQUALS.getId(), Conditions.LESS_THAN.getId(), Conditions.LESS_THAN_OR_EQUALS.getId()};
        }

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleProperty_DeliveryCost);
        }

        public String getRendererId() {
            return ValueTypes.NUMBER.name();
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.DELIVERY.getId()};
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(L10nResourcesManager.getStr((String)Messages.RuleProperty_DeliveryCost_info, (Object[])new Object[]{cond.getDisplayName(), value}));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            double fare;
            DeliveryPropertiesProvider ps = (DeliveryPropertiesProvider)propertySet;
            double dv = value == null ? 0.0 : (Double)value;
            double d = fare = ps.getTotalCost() != null ? ps.getTotalCost().doubleValue() : 0.0;
            if (Conditions.EQUALS.equals(condition)) {
                return Math.abs(fare - dv) < 0.01;
            }
            if (Conditions.NOT_EQUALS.equals(condition)) {
                return Math.abs(fare - dv) >= 0.01;
            }
            if (Conditions.GREATER_THAN.equals(condition)) {
                return fare - dv >= 0.01;
            }
            if (Conditions.GREATER_THAN_OR_EQUALS.equals(condition)) {
                return Math.abs(fare - dv) < 0.01 || fare - dv >= 0.01;
            }
            if (Conditions.LESS_THAN.equals(condition)) {
                return dv - fare >= 0.01;
            }
            if (Conditions.LESS_THAN_OR_EQUALS.equals(condition)) {
                return Math.abs(fare - dv) < 0.01 || dv - fare >= 0.01;
            }
            return true;
        }
    }
    ,
    DELIVERY_REGION{

        @Override
        public String[] getConditionIds() {
            return new String[]{Conditions.EQUALS.getId(), Conditions.NOT_EQUALS.getId()};
        }

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleProperty_DeliveryRegion);
        }

        public String getRendererId() {
            return ValueTypes.DELIVERY_REGION.name();
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.DELIVERY.getId()};
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(L10nResourcesManager.getStr((String)Messages.RuleProperty_DeliveryRegion_info, (Object[])new Object[]{cond.getDisplayName(), value}));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            DeliveryPropertiesProvider ps = (DeliveryPropertiesProvider)propertySet;
            return Conditions.EQUALS == condition == MiscUtil.equals(ps.getDeliveryRegion(), (Object)value);
        }
    };


    public String getId() {
        return this.name();
    }

    abstract String[] getTargetIds();

    @Override
    public abstract String[] getConditionIds();
}

