/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.rules.standard;

import com.gridnine.xtrip.common.gds.model.BaseGdsAccount;
import com.gridnine.xtrip.common.l10n.messages.L10n;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.commission.ProductType;
import com.gridnine.xtrip.common.model.dict.Country;
import com.gridnine.xtrip.common.model.dict.CountryReference;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GeoLocationReference;
import com.gridnine.xtrip.common.model.dict.GeoRegionReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.HotelProductHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.model.rules.l10n.Messages;
import com.gridnine.xtrip.common.model.rules.standard.ClientCreditCardVendorProvider;
import com.gridnine.xtrip.common.model.rules.standard.Conditions;
import com.gridnine.xtrip.common.model.rules.standard.HotelPropertiesProvider;
import com.gridnine.xtrip.common.model.rules.standard.LocationCodesPropertiesProvider;
import com.gridnine.xtrip.common.model.rules.standard.RulePropertyConditions;
import com.gridnine.xtrip.common.model.rules.standard.RulesHelper;
import com.gridnine.xtrip.common.model.rules.standard.Targets;
import com.gridnine.xtrip.common.model.rules.standard.ValueTypes;
import com.gridnine.xtrip.common.model.util.DictionaryReference2CodeTransformer;
import com.gridnine.xtrip.common.rules.elements.RuleCondition;
import com.gridnine.xtrip.common.rules.elements.RuleProperty;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.DateInterval;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public enum HotelProperties implements RuleProperty,
RulePropertyConditions
{
    HOTEL_STARS{

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleProperty_HotelStars);
        }

        public String getRendererId() {
            return ValueTypes.STRING_LIST.name();
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(L10nResourcesManager.getStr((String)Messages.RuleProperty_HotelStars_info, (Object[])new Object[]{cond.getDisplayName(), RulesHelper.toString(value)}));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            HotelPropertiesProvider ps = (HotelPropertiesProvider)propertySet;
            if (ps.getHotelStars() == null) {
                return Conditions.NOT_EQUALS.equals(condition);
            }
            if (Conditions.EQUALS.equals(condition)) {
                return RulesHelper.matchesStringRestriction(String.valueOf(ps.getHotelStars()), value, true);
            }
            if (Conditions.NOT_EQUALS.equals(condition)) {
                return ps.getHotelName() != null && RulesHelper.matchesStringRestriction(String.valueOf(ps.getHotelStars()), value, false);
            }
            return false;
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.HOTELS_COMMISSION.getId()};
        }

        @Override
        public String[] getConditionIds() {
            return new String[]{Conditions.EQUALS.getId(), Conditions.NOT_EQUALS.getId()};
        }
    }
    ,
    HOTEL_TYPE{

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleProperty_HotelType);
        }

        public String getRendererId() {
            return ValueTypes.HOTEL_TYPE.name();
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(L10nResourcesManager.getStr((String)Messages.RuleProperty_HotelType_info, (Object[])new Object[]{cond.getDisplayName(), RulesHelper.values2text((List)value)}));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            HotelPropertiesProvider ps = (HotelPropertiesProvider)propertySet;
            if (Conditions.EQUALS.equals(condition)) {
                return RulesHelper.matchesEnumRestriction(ps.getHotelType(), (List)value, true);
            }
            return ps.getProviderName() != null && RulesHelper.matchesEnumRestriction(ps.getHotelType(), (List)value, false);
        }

        @Override
        String[] getTargetIds() {
            return new String[0];
        }

        @Override
        public String[] getConditionIds() {
            return new String[]{Conditions.EQUALS.getId(), Conditions.NOT_EQUALS.getId()};
        }
    }
    ,
    HOTEL_PROVIDER{

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleProperty_HotelProvider);
        }

        public String getRendererId() {
            return ValueTypes.HOTEL_PROVIDER.name();
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(L10nResourcesManager.getStr((String)Messages.RuleProperty_HotelProviderArgs, (Object[])new Object[]{cond.getDisplayName(), RulesHelper.values2text((List)value)}));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            HotelPropertiesProvider ps = (HotelPropertiesProvider)propertySet;
            if (Conditions.EQUALS.equals(condition)) {
                return RulesHelper.matchesEnumRestriction(ps.getProviderName(), (List)value, true);
            }
            return ps.getProviderName() != null && RulesHelper.matchesEnumRestriction(ps.getProviderName(), (List)value, false);
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.HOTELS_COMMISSION.getId()};
        }

        @Override
        public String[] getConditionIds() {
            return new String[]{Conditions.EQUALS.getId(), Conditions.NOT_EQUALS.getId()};
        }
    }
    ,
    HOTEL_SUBPROVIDER{

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleProperty_HotelSubProvider);
        }

        public String getRendererId() {
            return ValueTypes.HOTEL_SUBPROVIDER.name();
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(L10n.replace((String)(this.getDisplayName() + " {0} {1}"), (Object[])new Object[]{cond.getDisplayName(), value}));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            HotelPropertiesProvider ps = (HotelPropertiesProvider)propertySet;
            DictionaryReference subProvider = (DictionaryReference)value;
            if (Conditions.EQUALS.equals(condition)) {
                return subProvider.getCode().equals(ps.getSubProviderCode());
            }
            if (Conditions.NOT_EQUALS.equals(condition)) {
                return !subProvider.getCode().equals(ps.getSubProviderCode());
            }
            return true;
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.HOTELS_COMMISSION.getId()};
        }

        @Override
        public String[] getConditionIds() {
            return new String[]{Conditions.EQUALS.getId(), Conditions.NOT_EQUALS.getId()};
        }
    }
    ,
    HOTEL_OFFER_VAT{

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleProperty_HotelVat);
        }

        public String getRendererId() {
            return ValueTypes.YES_NO.name();
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            if (value == null) {
                buf.append(L10n.get((String)Messages.RuleProperty_HotelVatUnknown));
            } else if (value instanceof Boolean) {
                boolean b = (Boolean)value;
                buf.append(b ? L10n.get((String)Messages.RuleProperty_HotelWithVat) : L10n.get((String)Messages.RuleProperty_HotelWithoutVat));
            }
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            HotelPropertiesProvider pp = (HotelPropertiesProvider)propertySet;
            Boolean isVat = (Boolean)value;
            return MiscUtil.equals((Object)isVat, (Object)pp.getVat());
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.HOTELS_COMMISSION.getId()};
        }

        @Override
        public String[] getConditionIds() {
            return new String[]{Conditions.EQUALS.getId()};
        }
    }
    ,
    HOTEL_VAT_RATE{

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleProperty_HotelVatRate);
        }

        public String getRendererId() {
            return ValueTypes.HOTEL_VAT_RATE.name();
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            List vatRates = (List)value;
            buf.append(L10nResourcesManager.getStr((String)Messages.RuleProperty_HotelVatRate_info, (Object[])new Object[]{vatRates.stream().map(vatRate -> vatRate == -1.0 ? L10n.get((String)Messages.withoutVat) + "%" : vatRate + "%").collect(Collectors.joining(", "))}));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            HotelPropertiesProvider pp = (HotelPropertiesProvider)propertySet;
            List vatRates = (List)value;
            return vatRates.contains(pp.getVatRate());
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.HOTELS_COMMISSION.getId()};
        }

        @Override
        public String[] getConditionIds() {
            return new String[]{Conditions.EQUALS.getId(), Conditions.NOT_EQUALS.getId()};
        }
    }
    ,
    HOTEL_CITY{

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleProperty_HotelCity);
        }

        public String getRendererId() {
            return ValueTypes.CITY.name();
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(L10nResourcesManager.getStr((String)Messages.RuleProperty_HotelCityArgs, (Object[])new Object[]{cond.getDisplayName(), value}));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            LocationCodesPropertiesProvider pp = (LocationCodesPropertiesProvider)propertySet;
            GeoLocationReference city = (GeoLocationReference)value;
            if (Conditions.EQUALS.equals(condition)) {
                String hotelCityCode = pp.getCityCode();
                return hotelCityCode != null && hotelCityCode.equals(city.getCode());
            }
            if (Conditions.NOT_EQUALS.equals(condition)) {
                String hotelCityCode = pp.getCityCode();
                return hotelCityCode == null || !hotelCityCode.equals(city.getCode());
            }
            return true;
        }

        @Override
        String[] getTargetIds() {
            return new String[0];
        }

        @Override
        public String[] getConditionIds() {
            return new String[]{Conditions.EQUALS.getId(), Conditions.NOT_EQUALS.getId()};
        }
    }
    ,
    HOTEL_COUNTRY{

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleProperty_HotelCountry);
        }

        public String getRendererId() {
            return ValueTypes.COUNTRY.name();
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(L10n.replace((String)(this.getDisplayName() + " {0} {1}"), (Object[])new Object[]{cond.getDisplayName(), value}));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            LocationCodesPropertiesProvider pp = (LocationCodesPropertiesProvider)propertySet;
            CountryReference country = (CountryReference)value;
            if (Conditions.EQUALS.equals(condition)) {
                return country.getCode().equals(pp.getCountryCode());
            }
            if (Conditions.NOT_EQUALS.equals(condition)) {
                return !country.getCode().equals(pp.getCountryCode());
            }
            return true;
        }

        @Override
        String[] getTargetIds() {
            return new String[0];
        }

        @Override
        public String[] getConditionIds() {
            return new String[]{Conditions.EQUALS.getId(), Conditions.NOT_EQUALS.getId()};
        }
    }
    ,
    HOTEL_RESERVATION_TYPE{

        @Override
        public String[] getConditionIds() {
            return new String[]{Conditions.EQUALS.getId(), Conditions.NOT_EQUALS.getId()};
        }

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleProperty_ReservationType);
        }

        public String getRendererId() {
            return ValueTypes.RESERVATION_TYPE.name();
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.HOTELS_COMMISSION.getId()};
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(L10nResourcesManager.getStr((String)Messages.RuleProperty_ReservationType_info, (Object[])new Object[]{cond.getDisplayName(), RulesHelper.values2text((List)value)}));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            HotelPropertiesProvider ps = (HotelPropertiesProvider)propertySet;
            if (Conditions.EQUALS.equals(condition)) {
                return RulesHelper.matchesEnumRestriction(ps.getReservationType(), (List)value, true);
            }
            if (Conditions.NOT_EQUALS.equals(condition)) {
                return RulesHelper.matchesEnumRestriction(ps.getReservationType(), (List)value, false);
            }
            return true;
        }
    }
    ,
    HOTEL_REGION{

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleProperty_HotelRegion);
        }

        public String getRendererId() {
            return ValueTypes.GEO_REGION.name();
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(L10n.replace((String)(this.getDisplayName() + " {0} {1}"), (Object[])new Object[]{cond.getDisplayName(), value}));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            Country country;
            boolean result = true;
            LocationCodesPropertiesProvider pp = (LocationCodesPropertiesProvider)propertySet;
            GeoRegionReference region = (GeoRegionReference)value;
            if (Conditions.EQUALS.equals(condition)) {
                Country country2 = (Country)DictionaryCache.get().resolveReference((DictionaryReference)new CountryReference(pp.getCountryCode()));
                if (country2 != null) {
                    Set<String> countryRegions = RulesHelper.codes(country2.getRegions());
                    result = countryRegions.contains(region.getCode());
                } else {
                    result = false;
                }
            } else if (Conditions.NOT_EQUALS.equals(condition) && (country = (Country)DictionaryCache.get().resolveReference((DictionaryReference)new CountryReference(pp.getCountryCode()))) != null) {
                Set<String> countryRegions = RulesHelper.codes(country.getRegions());
                result = !countryRegions.contains(region.getCode());
            }
            return result;
        }

        @Override
        String[] getTargetIds() {
            return new String[0];
        }

        @Override
        public String[] getConditionIds() {
            return new String[]{Conditions.EQUALS.getId(), Conditions.NOT_EQUALS.getId()};
        }
    }
    ,
    HOTEL_FARE{

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleProperty_HotelFare);
        }

        public String getRendererId() {
            return ValueTypes.NUMBER.name();
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(L10nResourcesManager.getStr((String)Messages.RuleProperty_HotelFareArgs, (Object[])new Object[]{cond.getDisplayName(), value}));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            HotelPropertiesProvider ps = (HotelPropertiesProvider)propertySet;
            double dv = value == null ? 0.0 : ((Number)value).doubleValue();
            double fare = ps.getFare();
            if (Conditions.EQUALS.equals(condition)) {
                return Math.abs(fare - dv) < 0.01;
            }
            if (Conditions.NOT_EQUALS.equals(condition)) {
                return Math.abs(fare - dv) >= 0.01;
            }
            if (Conditions.GREATER_THAN.equals(condition)) {
                return fare - dv >= 0.01;
            }
            if (Conditions.GREATER_THAN_OR_EQUALS.equals(condition)) {
                return Math.abs(fare - dv) < 0.01 || fare - dv >= 0.01;
            }
            if (Conditions.LESS_THAN.equals(condition)) {
                return dv - fare >= 0.01;
            }
            if (Conditions.LESS_THAN_OR_EQUALS.equals(condition)) {
                return Math.abs(fare - dv) < 0.01 || dv - fare >= 0.01;
            }
            return false;
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.HOTELS_COMMISSION.getId()};
        }

        @Override
        public String[] getConditionIds() {
            return new String[]{Conditions.EQUALS.getId(), Conditions.NOT_EQUALS.getId(), Conditions.GREATER_THAN.getId(), Conditions.GREATER_THAN_OR_EQUALS.getId(), Conditions.LESS_THAN.getId(), Conditions.LESS_THAN_OR_EQUALS.getId()};
        }
    }
    ,
    HOTEL_LOCATION{

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleProperty_HotelLocation);
        }

        public String getRendererId() {
            return ValueTypes.STRING_LIST.name();
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(L10nResourcesManager.getStr((String)Messages.RuleProperty_HotelLocationArgs, (Object[])new Object[]{cond.getDisplayName(), RulesHelper.toString(value)}));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            LocationCodesPropertiesProvider ps = (LocationCodesPropertiesProvider)propertySet;
            if (Conditions.INCLUDE.equals(condition)) {
                return RulesHelper.matchesStringRestriction(ps.getLocationCodes(), value, true);
            }
            if (Conditions.EXCLUDE.equals(condition)) {
                return RulesHelper.matchesStringRestriction(ps.getLocationCodes(), value, false);
            }
            return false;
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.HOTELS_COMMISSION.getId()};
        }

        @Override
        public String[] getConditionIds() {
            return new String[]{Conditions.INCLUDE.getId(), Conditions.EXCLUDE.getId()};
        }
    }
    ,
    HOTEL_NAME{

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleProperty_HotelName);
        }

        public String getRendererId() {
            return ValueTypes.STRING_LIST.name();
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(L10nResourcesManager.getStr((String)Messages.RuleProperty_HotelNameArgs, (Object[])new Object[]{cond.getDisplayName(), RulesHelper.toString(value)}));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            HotelPropertiesProvider ps = (HotelPropertiesProvider)propertySet;
            if (Conditions.EQUALS.equals(condition)) {
                return RulesHelper.matchesStringRestriction(ps.getHotelName(), value, true);
            }
            if (Conditions.NOT_EQUALS.equals(condition)) {
                return ps.getHotelName() != null && RulesHelper.matchesStringRestriction(ps.getHotelName(), value, false);
            }
            return false;
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.HOTELS_COMMISSION.getId()};
        }

        @Override
        public String[] getConditionIds() {
            return new String[]{Conditions.EQUALS.getId(), Conditions.NOT_EQUALS.getId()};
        }
    }
    ,
    ROOMS_COUNT{

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleProperty_HotelRoomsCount);
        }

        public String getRendererId() {
            return ValueTypes.NUMBER.name();
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(L10nResourcesManager.getStr((String)Messages.RuleProperty_HotelRoomsCountArgs, (Object[])new Object[]{cond.getDisplayName(), value}));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            HotelPropertiesProvider ps = (HotelPropertiesProvider)propertySet;
            int iv = value == null ? 0 : ((Number)value).intValue();
            int roomsCount = ps.getRoomsCount();
            if (Conditions.EQUALS.equals(condition)) {
                return roomsCount == iv;
            }
            if (Conditions.NOT_EQUALS.equals(condition)) {
                return roomsCount != iv;
            }
            if (Conditions.GREATER_THAN.equals(condition)) {
                return roomsCount > iv;
            }
            if (Conditions.GREATER_THAN_OR_EQUALS.equals(condition)) {
                return roomsCount >= iv;
            }
            if (Conditions.LESS_THAN.equals(condition)) {
                return roomsCount < iv;
            }
            if (Conditions.LESS_THAN_OR_EQUALS.equals(condition)) {
                return roomsCount <= iv;
            }
            return false;
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.HOTELS_COMMISSION.getId()};
        }

        @Override
        public String[] getConditionIds() {
            return new String[]{Conditions.EQUALS.getId(), Conditions.NOT_EQUALS.getId(), Conditions.GREATER_THAN.getId(), Conditions.GREATER_THAN_OR_EQUALS.getId(), Conditions.LESS_THAN.getId(), Conditions.LESS_THAN_OR_EQUALS.getId()};
        }
    }
    ,
    ROOM_NAME{

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleProperty_HotelRoomName);
        }

        public String getRendererId() {
            return ValueTypes.STRING.name();
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(L10nResourcesManager.getStr((String)Messages.RuleProperty_HotelRoomNameArgs, (Object[])new Object[]{cond.getDisplayName(), RulesHelper.toString(value)}));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            HotelPropertiesProvider ps = (HotelPropertiesProvider)propertySet;
            String roomNames = (String)value;
            if (TextUtil.nonBlank((String)roomNames)) {
                roomNames = roomNames.toLowerCase();
            }
            if (Conditions.EQUALS.equals(condition)) {
                return RulesHelper.matchesStringRestriction(ps.getRoomNames(), (Object)roomNames, true);
            }
            if (Conditions.NOT_EQUALS.equals(condition)) {
                return RulesHelper.matchesStringRestriction(ps.getRoomNames(), (Object)roomNames, false);
            }
            if (Conditions.INCLUDE.equals(condition)) {
                return RulesHelper.matchesStringContainsRestriction(ps.getRoomNames(), (Object)roomNames, true);
            }
            if (Conditions.EXCLUDE.equals(condition)) {
                return RulesHelper.matchesStringContainsRestriction(ps.getRoomNames(), (Object)roomNames, false);
            }
            return false;
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.HOTELS_COMMISSION.getId()};
        }

        @Override
        public String[] getConditionIds() {
            return new String[]{Conditions.EQUALS.getId(), Conditions.NOT_EQUALS.getId(), Conditions.INCLUDE.getId(), Conditions.EXCLUDE.getId()};
        }
    }
    ,
    CHECK_IN_DATE{

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleProperty_HotelCheckInDate);
        }

        public String getRendererId() {
            return ValueTypes.DATE_INTERVAL.name();
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(L10nResourcesManager.getStr((String)Messages.RuleProperty_HotelCheckInDateArgs, (Object[])new Object[]{cond.getDisplayName(), RulesHelper.toString(value)}));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            HotelPropertiesProvider ps = (HotelPropertiesProvider)propertySet;
            DateInterval di = (DateInterval)value;
            if (di == null || di.getBeginDate() == null && di.getEndDate() == null) {
                return true;
            }
            if (Conditions.PERIOD_WITHIN.equals(condition)) {
                if (di.getBeginDate() == null) {
                    return ps.getCheckInDate() != null && ps.getCheckInDate().getTime() <= di.getEndDate().getTime();
                }
                if (di.getEndDate() == null) {
                    return ps.getCheckInDate() != null && ps.getCheckInDate().getTime() >= di.getBeginDate().getTime();
                }
                return ps.getCheckInDate() != null && ps.getCheckInDate().getTime() >= di.getBeginDate().getTime() && ps.getCheckInDate().getTime() <= di.getEndDate().getTime();
            }
            if (Conditions.PERIOD_BEYOND.equals(condition)) {
                if (di.getBeginDate() == null) {
                    return ps.getCheckInDate() != null && ps.getCheckInDate().getTime() > di.getEndDate().getTime();
                }
                if (di.getEndDate() == null) {
                    return ps.getCheckInDate() != null && ps.getCheckInDate().getTime() < di.getBeginDate().getTime();
                }
                return ps.getCheckInDate() != null && (ps.getCheckInDate().getTime() < di.getBeginDate().getTime() || ps.getCheckInDate().getTime() > di.getEndDate().getTime());
            }
            return false;
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.HOTELS_COMMISSION.getId()};
        }

        @Override
        public String[] getConditionIds() {
            return new String[]{Conditions.PERIOD_WITHIN.getId(), Conditions.PERIOD_BEYOND.getId()};
        }
    }
    ,
    STAY_DURATION{

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleProperty_HotelStayDuration);
        }

        public String getRendererId() {
            return ValueTypes.NUMBER.name();
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(L10nResourcesManager.getStr((String)Messages.RuleProperty_HotelStayDurationArgs, (Object[])new Object[]{cond.getDisplayName(), value}));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            HotelPropertiesProvider ps = (HotelPropertiesProvider)propertySet;
            int iv = value == null ? 0 : ((Number)value).intValue();
            int stayDuration = ps.getStayDuration();
            if (Conditions.EQUALS.equals(condition)) {
                return stayDuration == iv;
            }
            if (Conditions.NOT_EQUALS.equals(condition)) {
                return stayDuration != iv;
            }
            if (Conditions.GREATER_THAN.equals(condition)) {
                return stayDuration > iv;
            }
            if (Conditions.GREATER_THAN_OR_EQUALS.equals(condition)) {
                return stayDuration >= iv;
            }
            if (Conditions.LESS_THAN.equals(condition)) {
                return stayDuration < iv;
            }
            if (Conditions.LESS_THAN_OR_EQUALS.equals(condition)) {
                return stayDuration <= iv;
            }
            return false;
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.HOTELS_COMMISSION.getId()};
        }

        @Override
        public String[] getConditionIds() {
            return new String[]{Conditions.EQUALS.getId(), Conditions.NOT_EQUALS.getId(), Conditions.GREATER_THAN.getId(), Conditions.GREATER_THAN_OR_EQUALS.getId(), Conditions.LESS_THAN.getId(), Conditions.LESS_THAN_OR_EQUALS.getId()};
        }
    }
    ,
    BOOKING_DEPTH_DAYS{
        private static final long DAY_MS = 86400000L;

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleProperty_BookingDepthDays);
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.HOTELS_COMMISSION.getId()};
        }

        @Override
        public String[] getConditionIds() {
            return new String[]{Conditions.EQUALS.getId(), Conditions.NOT_EQUALS.getId(), Conditions.GREATER_THAN.getId(), Conditions.GREATER_THAN_OR_EQUALS.getId(), Conditions.LESS_THAN.getId(), Conditions.LESS_THAN_OR_EQUALS.getId()};
        }

        public String getRendererId() {
            return ValueTypes.NUMBER.name();
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(L10nResourcesManager.getStr((String)Messages.RuleProperty_BookingDepthDays_info, (Object[])new Object[]{cond.getDisplayName(), value}));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            HotelPropertiesProvider ps = (HotelPropertiesProvider)propertySet;
            int days = value == null ? 0 : ((Number)value).intValue();
            Date bookingDate = ps.getBookingDate();
            Date departureDate = ps.getCheckInDate();
            if (bookingDate == null || departureDate == null) {
                return false;
            }
            int depthDays = (int)(MiscUtil.getDuration((Date)MiscUtil.clearTime((Date)bookingDate), (Date)MiscUtil.clearTime((Date)departureDate)) / 86400000L);
            if (Conditions.EQUALS.equals(condition)) {
                return depthDays == days;
            }
            if (Conditions.NOT_EQUALS.equals(condition)) {
                return depthDays != days;
            }
            if (Conditions.GREATER_THAN.equals(condition)) {
                return depthDays > days;
            }
            if (Conditions.GREATER_THAN_OR_EQUALS.equals(condition)) {
                return depthDays >= days;
            }
            if (Conditions.LESS_THAN.equals(condition)) {
                return depthDays < days;
            }
            if (Conditions.LESS_THAN_OR_EQUALS.equals(condition)) {
                return depthDays <= days;
            }
            return true;
        }
    }
    ,
    HOTEL_CHAIN_CODE{

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleProperty_HotelChainCode);
        }

        public String getRendererId() {
            return ValueTypes.STRING.name();
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(L10nResourcesManager.getStr((String)Messages.RuleProperty_HotelChainCodeArgs, (Object[])new Object[]{cond.getDisplayName(), RulesHelper.toString(value)}));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            HotelPropertiesProvider ps = (HotelPropertiesProvider)propertySet;
            if (Conditions.EQUALS.equals(condition)) {
                return RulesHelper.matchesStringRestriction(ps.getHotelChainCode(), value, true);
            }
            if (Conditions.NOT_EQUALS.equals(condition)) {
                return ps.getHotelName() != null && RulesHelper.matchesStringRestriction(ps.getHotelChainCode(), value, false);
            }
            return false;
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.HOTELS_COMMISSION.getId()};
        }

        @Override
        public String[] getConditionIds() {
            return new String[]{Conditions.EQUALS.getId(), Conditions.NOT_EQUALS.getId()};
        }
    }
    ,
    HOTEL_CLIENT_TARIFF_CODE{

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleProperty_HotelClientTariffCode);
        }

        public String getRendererId() {
            return ValueTypes.STRING.name();
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(L10nResourcesManager.getStr((String)Messages.RuleProperty_HotelClientTariffCodeArgs, (Object[])new Object[]{cond.getDisplayName(), RulesHelper.toString(value)}));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            HotelPropertiesProvider ps = (HotelPropertiesProvider)propertySet;
            String clientTariffCode = ps.getClientTariffCode();
            if (Conditions.EQUALS.equals(condition)) {
                return RulesHelper.matchesStringRestriction(clientTariffCode, value, true);
            }
            if (Conditions.NOT_EQUALS.equals(condition)) {
                return RulesHelper.matchesStringRestriction(clientTariffCode, value, false);
            }
            if (Conditions.NOT_SET.equals(condition)) {
                return TextUtil.isBlank((String)clientTariffCode);
            }
            if (Conditions.NOT_EMPTY.equals(condition)) {
                return !TextUtil.isBlank((String)clientTariffCode);
            }
            return false;
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.HOTELS_COMMISSION.getId()};
        }

        @Override
        public String[] getConditionIds() {
            return new String[]{Conditions.EQUALS.getId(), Conditions.NOT_EQUALS.getId(), Conditions.NOT_EMPTY.getId(), Conditions.NOT_SET.getId()};
        }
    }
    ,
    ADDITIONAL_SERVICE_TYPE{

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleProperty_HotelAdditionalServices);
        }

        public String getRendererId() {
            return ValueTypes.ADDITIONAL_SERVICE_TYPE.name();
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(L10nResourcesManager.getStr((String)Messages.RuleProperty_HotelAdditionalServicesArgs, (Object[])new Object[]{cond.getDisplayName(), RulesHelper.values2text((List)value)}));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            HotelPropertiesProvider ps = (HotelPropertiesProvider)propertySet;
            if (Conditions.INCLUDE.equals(condition)) {
                return RulesHelper.matchesEnumRestriction(ps.getAdditionalServiceTypes(), (List)value, true);
            }
            if (Conditions.EXCLUDE.equals(condition)) {
                return RulesHelper.matchesEnumRestriction(ps.getAdditionalServiceTypes(), (List)value, false);
            }
            return false;
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.HOTELS_COMMISSION.getId()};
        }

        @Override
        public String[] getConditionIds() {
            return new String[]{Conditions.INCLUDE.getId(), Conditions.EXCLUDE.getId()};
        }
    }
    ,
    HOTEL_MEAL_INCLUDED_IN_TARIFF{

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleProperty_HotelMealIncludedInTariff);
        }

        public String getRendererId() {
            return ValueTypes.YES_NO.name();
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            boolean b = (Boolean)value;
            buf.append(b ? L10n.get((String)Messages.RuleProperty_HotelMealIncludedInTariff) : L10n.get((String)Messages.RuleProperty_HotelMealNotIncludedInTariff));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            HotelPropertiesProvider pp = (HotelPropertiesProvider)propertySet;
            Boolean mealIncludeInTariff = (Boolean)value;
            return MiscUtil.equals((Object)mealIncludeInTariff, (Object)HotelProductHelper.isMealIncludedInTariff(pp.getProduct()));
        }

        @Override
        String[] getTargetIds() {
            return new String[0];
        }

        @Override
        public String[] getConditionIds() {
            return new String[]{Conditions.EQUALS.getId()};
        }
    }
    ,
    HOTEL_BOOKING_CONTENT{

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleProperty_HotelBookingContent);
        }

        public String getRendererId() {
            return ValueTypes.BOOKING_CONTENT.name();
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(L10nResourcesManager.getStr((String)Messages.RuleProperty_HotelBookingContentArgs, (Object[])new Object[]{cond.getDisplayName(), RulesHelper.values2text((List)value)}));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            HotelPropertiesProvider ps = (HotelPropertiesProvider)propertySet;
            if (Conditions.INCLUDE.equals(condition)) {
                return RulesHelper.matchesEnumRestriction(ps.getBookingContent(), (List)value, true);
            }
            if (Conditions.EXCLUDE.equals(condition)) {
                return RulesHelper.matchesEnumRestriction(ps.getBookingContent(), (List)value, false);
            }
            if (Conditions.CONTAINS_ONLY.equals(condition)) {
                List items = (List)value;
                StringBuilder buf = new StringBuilder();
                for (int n = 0; n < items.size(); ++n) {
                    if (n != 0) {
                        buf.append("-");
                    }
                    buf.append(((ProductType)items.get(n)).name());
                }
                return RulesHelper.includesOnly(ps.getBookingContent(), Collections.singletonList(buf.toString()));
            }
            if (Conditions.CONFINED_TO.equals(condition)) {
                List items = (List)value;
                StringBuilder buf = new StringBuilder();
                for (int n = 0; n < items.size(); ++n) {
                    if (n != 0) {
                        buf.append("-");
                    }
                    buf.append(((ProductType)items.get(n)).name());
                }
                return RulesHelper.confinedTo(RulesHelper.to2DList(ps.getBookingContent()), Collections.singletonList(buf.toString()));
            }
            return true;
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.HOTELS_COMMISSION.getId()};
        }

        @Override
        public String[] getConditionIds() {
            return new String[]{Conditions.INCLUDE.getId(), Conditions.EXCLUDE.getId(), Conditions.CONTAINS_ONLY.getId(), Conditions.CONFINED_TO.getId()};
        }
    }
    ,
    HOTEL_SALES_POINT{

        @Override
        public String[] getConditionIds() {
            return new String[]{Conditions.EQUALS.getId(), Conditions.NOT_EQUALS.getId()};
        }

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleProperty_HotelSalesPoint);
        }

        public String getRendererId() {
            return ValueTypes.SALES_POINTS.name();
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.HOTELS_COMMISSION.getId()};
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(String.format(L10n.get((String)Messages.RuleProperty_HotelSalesPointArgs), cond.getDisplayName(), this.toString((List)value)));
        }

        private String toString(List<String> value) {
            if (value == null || value.isEmpty()) {
                return "";
            }
            StringBuilder sb = new StringBuilder();
            for (String uid : value) {
                String title = "???";
                EntityContainer ctr = EntityStorage.get().resolve(new EntityReference(uid, SalesPoint.class, null));
                if (ctr != null) {
                    title = ctr.toReference().toString();
                }
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                sb.append(title);
            }
            return sb.toString();
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            HotelPropertiesProvider ps = (HotelPropertiesProvider)propertySet;
            List uids = (List)value;
            if (Conditions.EQUALS.equals(condition)) {
                return RulesHelper.matchesStringRestriction(ps.getSalesPointUid(), (Object)uids, true);
            }
            return RulesHelper.matchesStringRestriction(ps.getSalesPointUid(), (Object)uids, false);
        }
    }
    ,
    HOTEL_SUPPLIER{

        @Override
        public String[] getConditionIds() {
            return new String[]{Conditions.EQUALS.getId(), Conditions.NOT_EQUALS.getId()};
        }

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleProperty_HotelSupplier);
        }

        public String getRendererId() {
            return ValueTypes.BLANK_OWNERS.name();
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.HOTELS_COMMISSION.getId()};
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(String.format(L10n.get((String)Messages.RuleProperty_HotelSupplierArgs), cond.getDisplayName(), this.toString((List)value)));
        }

        private String toString(List<String> value) {
            if (value == null || value.isEmpty()) {
                return "";
            }
            StringBuilder sb = new StringBuilder();
            for (String supplier : value) {
                String title = "???";
                if (supplier instanceof EntityReference) {
                    title = ((EntityReference)supplier).getCaption();
                } else {
                    EntityContainer ctr = EntityStorage.get().load(Organization.class, supplier);
                    if (ctr != null) {
                        title = ctr.toReference().toString();
                    }
                }
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                sb.append(title);
            }
            return sb.toString();
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            HotelPropertiesProvider ps = (HotelPropertiesProvider)propertySet;
            List values = (List)value;
            if (Conditions.EQUALS.equals(condition)) {
                return RulesHelper.matchesEntityRestriction(ps.getSupplierUid(), values, true);
            }
            return RulesHelper.matchesEntityRestriction(ps.getSupplierUid(), values, false);
        }
    }
    ,
    HOTEL_PASSENGER_TYPES{

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleProperty_HotelPassengerTypes);
        }

        public String getRendererId() {
            return ValueTypes.PASSENGER_TYPE.name();
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(L10nResourcesManager.getStr((String)Messages.RuleProperty_HotelPassengerTypesArgs, (Object[])new Object[]{cond.getDisplayName(), RulesHelper.toString(value)}));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            HotelPropertiesProvider ps = (HotelPropertiesProvider)propertySet;
            if (Conditions.INCLUDE.equals(condition)) {
                return RulesHelper.matchesDictRestriction(ps.getPassengerTypes(), (List)value, true);
            }
            if (Conditions.EXCLUDE.equals(condition)) {
                return RulesHelper.matchesDictRestriction(ps.getPassengerTypes(), (List)value, false);
            }
            if (Conditions.CONTAINS_ONLY.equals(condition)) {
                List items = CollectionUtil.transform((CollectionUtil.ItemTransformer)new DictionaryReference2CodeTransformer(), (Collection)((List)value));
                StringBuilder buf = new StringBuilder();
                for (int n = 0; n < items.size(); ++n) {
                    if (n != 0) {
                        buf.append("-");
                    }
                    buf.append((String)items.get(n));
                }
                return RulesHelper.includesOnly(ps.getPassengerTypes(), Collections.singletonList(buf.toString()));
            }
            if (Conditions.CONFINED_TO.equals(condition)) {
                List items = CollectionUtil.transform((CollectionUtil.ItemTransformer)new DictionaryReference2CodeTransformer(), (Collection)((List)value));
                StringBuilder buf = new StringBuilder();
                for (int n = 0; n < items.size(); ++n) {
                    if (n != 0) {
                        buf.append("-");
                    }
                    buf.append((String)items.get(n));
                }
                return RulesHelper.confinedTo(RulesHelper.to2DList(ps.getPassengerTypes()), Collections.singletonList(buf.toString()));
            }
            return true;
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.HOTELS_COMMISSION.getId()};
        }

        @Override
        public String[] getConditionIds() {
            return new String[]{Conditions.INCLUDE.getId(), Conditions.EXCLUDE.getId(), Conditions.CONTAINS_ONLY.getId(), Conditions.CONFINED_TO.getId()};
        }
    }
    ,
    HOTEL_PASSENGER_TYPE_CATEGORIES{

        @Override
        public String[] getConditionIds() {
            return new String[]{Conditions.INCLUDE.getId(), Conditions.EXCLUDE.getId()};
        }

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleProperty_PassengerTypeCategory);
        }

        public String getRendererId() {
            return ValueTypes.PASSENGER_TYPE_CATEGORY.name();
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.HOTELS_COMMISSION.getId()};
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(String.format(L10n.get((String)Messages.RuleProperty_PassengerTypeCategory_info), cond.getDisplayName(), RulesHelper.toString(value)));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            HotelPropertiesProvider ps = (HotelPropertiesProvider)propertySet;
            if (Conditions.INCLUDE.equals(condition)) {
                return RulesHelper.matchesDictRestriction(ps.getPassengerTypeCategories(), (List)value, true);
            }
            return RulesHelper.matchesDictRestriction(ps.getPassengerTypeCategories(), (List)value, false);
        }
    }
    ,
    HOTEL_CREDIT_CARD_TYPE{

        @Override
        public String[] getConditionIds() {
            return new String[]{Conditions.EQUALS.getId(), Conditions.NOT_EQUALS.getId()};
        }

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleProperty_CreditCardType);
        }

        public String getRendererId() {
            return ValueTypes.CREDIT_CARD_TYPE.name();
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.HOTELS_COMMISSION.getId()};
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(String.format(L10n.get((String)Messages.RuleProperty_CreditCardType_info), cond.getDisplayName(), RulesHelper.values2text((List)value)));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            if (propertySet instanceof ClientCreditCardVendorProvider) {
                ClientCreditCardVendorProvider prov = (ClientCreditCardVendorProvider)propertySet;
                if (Conditions.EQUALS.equals(condition)) {
                    return RulesHelper.matchesEnumRestriction(prov.getClientCreditCardVendor(), (List)value, true);
                }
                return RulesHelper.matchesEnumRestriction(prov.getClientCreditCardVendor(), (List)value, false);
            }
            return false;
        }
    }
    ,
    HOTEL_ROOM_TYPES{

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleProperty_HotelRoomTypes);
        }

        public String getRendererId() {
            return ValueTypes.STRING_LIST.name();
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(L10nResourcesManager.getStr((String)Messages.RuleProperty_HotelRoomTypesArgs, (Object[])new Object[]{cond.getDisplayName(), RulesHelper.toString(value)}));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            HotelPropertiesProvider ps = (HotelPropertiesProvider)propertySet;
            List values = (List)value;
            if (Conditions.INCLUDE.equals(condition)) {
                return RulesHelper.collectionIncludes(ps.getRoomTypes(), values);
            }
            if (Conditions.EXCLUDE.equals(condition)) {
                return !RulesHelper.collectionIncludes(ps.getRoomTypes(), values);
            }
            return false;
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.HOTELS_COMMISSION.getId()};
        }

        @Override
        public String[] getConditionIds() {
            return new String[]{Conditions.INCLUDE.getId(), Conditions.EXCLUDE.getId()};
        }
    }
    ,
    PERSONS_COUNT{

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleProperty_PersonsCount);
        }

        public String getRendererId() {
            return ValueTypes.NUMBER.name();
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(L10nResourcesManager.getStr((String)Messages.RuleProperty_PersonsCount_info, (Object[])new Object[]{cond.getDisplayName(), value}));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            HotelPropertiesProvider ps = (HotelPropertiesProvider)propertySet;
            int iv = value == null ? 0 : ((Number)value).intValue();
            int personsCount = ps.getPersonsCount();
            if (Conditions.EQUALS.equals(condition)) {
                return personsCount == iv;
            }
            if (Conditions.NOT_EQUALS.equals(condition)) {
                return personsCount != iv;
            }
            if (Conditions.GREATER_THAN.equals(condition)) {
                return personsCount > iv;
            }
            if (Conditions.GREATER_THAN_OR_EQUALS.equals(condition)) {
                return personsCount >= iv;
            }
            if (Conditions.LESS_THAN.equals(condition)) {
                return personsCount < iv;
            }
            if (Conditions.LESS_THAN_OR_EQUALS.equals(condition)) {
                return personsCount <= iv;
            }
            return false;
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.HOTELS_COMMISSION.getId()};
        }

        @Override
        public String[] getConditionIds() {
            return new String[]{Conditions.EQUALS.getId(), Conditions.NOT_EQUALS.getId(), Conditions.GREATER_THAN.getId(), Conditions.GREATER_THAN_OR_EQUALS.getId(), Conditions.LESS_THAN.getId(), Conditions.LESS_THAN_OR_EQUALS.getId()};
        }
    }
    ,
    STAY_WEEK_DAYS{

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleProperty_StayWeekDays);
        }

        public String getRendererId() {
            return ValueTypes.WEEK_DAY.name();
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(L10nResourcesManager.getStr((String)Messages.RuleProperty_StayWeekDays_info, (Object[])new Object[]{cond.getDisplayName(), RulesHelper.values2text((List)value)}));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            HotelPropertiesProvider ps = (HotelPropertiesProvider)propertySet;
            if (Conditions.INCLUDE.equals(condition)) {
                return this.stayDatesStream(ps).anyMatch(date -> RulesHelper.matchesEnumRestriction(DictHelper.getWeekDay(date.getDay()), (List)value, true));
            }
            if (Conditions.EXCLUDE.equals(condition)) {
                return this.stayDatesStream(ps).anyMatch(date -> RulesHelper.matchesEnumRestriction(DictHelper.getWeekDay(date.getDay()), (List)value, false));
            }
            return true;
        }

        private Stream<Date> stayDatesStream(HotelPropertiesProvider ps) {
            return IntStream.range(0, ps.getStayDuration() + 1).mapToObj(d -> MiscUtil.addDaysToDate((Date)ps.getCheckInDate(), (int)d));
        }

        @Override
        String[] getTargetIds() {
            return new String[0];
        }

        @Override
        public String[] getConditionIds() {
            return new String[]{Conditions.INCLUDE.getId(), Conditions.EXCLUDE.getId()};
        }
    }
    ,
    HOTEL_GDS_ACCOUNT{

        @Override
        public String[] getConditionIds() {
            return new String[]{Conditions.EQUALS.getId(), Conditions.NOT_EQUALS.getId()};
        }

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleProperty_GDS_ACCOUNT);
        }

        public String getRendererId() {
            return ValueTypes.HOTEL_GDS_ACCOUNT.name();
        }

        @Override
        String[] getTargetIds() {
            return new String[0];
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(L10nResourcesManager.getStr((String)Messages.RuleProperty_GDS_ACCOUNT_info, (Object[])new Object[]{cond.getDisplayName(), RulesHelper.toString(value)}));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            List values = (List)value;
            HotelPropertiesProvider ps = (HotelPropertiesProvider)propertySet;
            EntityReference<? extends BaseGdsAccount> accountRef = ps.getGdsAccount();
            if (Conditions.EQUALS.equals(condition)) {
                return values.contains(accountRef);
            }
            if (Conditions.NOT_EQUALS.equals(condition)) {
                return !values.contains(accountRef);
            }
            return false;
        }
    };


    public String getId() {
        return this.name();
    }

    abstract String[] getTargetIds();

    @Override
    public abstract String[] getConditionIds();
}

