/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.rules.standard;

import com.gridnine.xtrip.common.model.rules.standard.ContractsFilteringCategories;
import com.gridnine.xtrip.common.model.rules.standard.RulePropertyConditions;
import com.gridnine.xtrip.common.rules.RuleFilteringCategory;
import com.gridnine.xtrip.common.rules.RulesEnvironment;
import com.gridnine.xtrip.common.rules.elements.RuleAction;
import com.gridnine.xtrip.common.rules.elements.RuleProperty;
import com.gridnine.xtrip.common.rules.elements.RuleTarget;

public class RuleEnvironmentHelper {
    public static void registerTargetToContracts(RulesEnvironment env, String targetId) {
        for (ContractsFilteringCategories category : ContractsFilteringCategories.values()) {
            env.registerFilteringCategory2targetAssociation(category.getId(), targetId);
        }
    }

    public static <P extends RuleProperty & RulePropertyConditions> void registerPropertiesToContracts(RulesEnvironment env, P property) {
        for (String string : ((RulePropertyConditions)property).getConditionIds()) {
            env.registerProperty2conditionAssociation(property.getId(), string);
        }
        for (ContractsFilteringCategories contractsFilteringCategories : ContractsFilteringCategories.values()) {
            env.registerFilteringCategory2propertyAssociation(contractsFilteringCategories.getId(), property.getId());
        }
    }

    public static <P extends RuleProperty & RulePropertyConditions> void registerProperty2conditionAssociation(RulesEnvironment env, P ... properties) {
        for (P property : properties) {
            for (String conditionId : ((RulePropertyConditions)property).getConditionIds()) {
                env.registerProperty2conditionAssociation(property.getId(), conditionId);
            }
        }
    }

    public static void registerPropertyAssociation(RulesEnvironment env, String filteringCategoryId, String targetId, String ... properties) {
        for (String property : properties) {
            if (filteringCategoryId != null) {
                env.registerFilteringCategory2propertyAssociation(filteringCategoryId, property);
            }
            if (targetId == null) continue;
            env.registerTarget2propertyAssociation(targetId, property);
        }
    }

    public static void registerActionAssociation(RulesEnvironment env, String filteringCategoryId, String targetId, String ... actions) {
        for (String action : actions) {
            if (filteringCategoryId != null) {
                env.registerFilteringCategory2actionAssociation(filteringCategoryId, action);
            }
            if (targetId == null) continue;
            env.registerTarget2actionAssociation(targetId, action);
        }
    }

    public static void registerFilteringCategoryAndTargets(RulesEnvironment env, RuleFilteringCategory filteringCategory, RuleTarget ... targets) {
        env.registerFilteringCategories(new RuleFilteringCategory[]{filteringCategory});
        env.registerTargets(targets);
        for (RuleTarget target : targets) {
            RuleEnvironmentHelper.registerFilteringCategory2targetAssociation(env, filteringCategory, target);
        }
    }

    public static void registerFilteringCategory2targetAssociation(RulesEnvironment env, RuleFilteringCategory filteringCategory, RuleTarget target) {
        env.registerFilteringCategory2targetAssociation(filteringCategory.getId(), target.getId());
    }

    public static <P extends RuleProperty & RulePropertyConditions> void registerProperties(RulesEnvironment env, P ... properties) {
        env.registerProperties(properties);
        RuleEnvironmentHelper.registerProperty2conditionAssociation((RulesEnvironment)env, properties);
    }

    public static void registerPropertyAssociation(RulesEnvironment env, RuleFilteringCategory filteringCategory, RuleTarget target, RuleProperty ... properties) {
        for (RuleProperty property : properties) {
            if (filteringCategory != null) {
                env.registerFilteringCategory2propertyAssociation(filteringCategory.getId(), property.getId());
            }
            if (target == null) continue;
            env.registerTarget2propertyAssociation(target.getId(), property.getId());
        }
    }

    public static void registerActionAssociation(RulesEnvironment env, RuleFilteringCategory filteringCategory, RuleTarget target, RuleAction ... actions) {
        for (RuleAction action : actions) {
            if (filteringCategory != null) {
                env.registerFilteringCategory2actionAssociation(filteringCategory.getId(), action.getId());
            }
            if (target == null) continue;
            env.registerTarget2actionAssociation(target.getId(), action.getId());
        }
    }
}

