/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.rules.standard;

import com.google.common.collect.Sets;
import com.gridnine.xtrip.common.model.rules.standard.RulesHelper;
import java.util.Arrays;
import java.util.HashSet;
import org.junit.Assert;
import org.junit.Test;

public class RulesHelperTest {
    @Test
    public void testconfinedTo1() {
        HashSet operatingAirlines = Sets.newHashSet((Object[])new String[]{"SU", "S7"});
        Assert.assertTrue((boolean)RulesHelper.containsOnly(operatingAirlines, Arrays.asList("SU", "S7", "LH")));
    }

    @Test
    public void testconfinedTo2() {
        HashSet operatingAirlines = Sets.newHashSet((Object[])new String[]{"SU", "S7"});
        Assert.assertFalse((boolean)RulesHelper.containsOnly(operatingAirlines, Arrays.asList("SU", "LH")));
    }

    @Test
    public void testconfinedTo3() {
        HashSet operatingAirlines = Sets.newHashSet((Object[])new String[]{"SU", "S7"});
        Assert.assertTrue((boolean)RulesHelper.containsOnly(operatingAirlines, Arrays.asList("SU-LH", "S7-OS")));
    }

    @Test
    public void testconfinedTo4() {
        HashSet operatingAirlines = Sets.newHashSet((Object[])new String[]{"LH", "OS"});
        Assert.assertTrue((boolean)RulesHelper.containsOnly(operatingAirlines, Arrays.asList("SU-LH", "S7-OS")));
    }

    @Test
    public void testconfinedTo5() {
        HashSet operatingAirlines = Sets.newHashSet((Object[])new String[]{"UN", "S7"});
        Assert.assertFalse((boolean)RulesHelper.containsOnly(operatingAirlines, Arrays.asList("SU-LH", "S7-OS")));
    }

    @Test
    public void testconfinedTo6() {
        HashSet operatingAirlines = Sets.newHashSet((Object[])new String[]{"SU", "UN"});
        Assert.assertFalse((boolean)RulesHelper.containsOnly(operatingAirlines, Arrays.asList("SU-LH", "S7-OS")));
    }

    @Test
    public void testToRegexPattern() {
        Assert.assertEquals((Object)"..BS.*", (Object)RulesHelper.toRegexPattern("??BS*"));
        Assert.assertEquals((Object)"B.*", (Object)RulesHelper.toRegexPattern("B*"));
        Assert.assertEquals((Object)".FOR", (Object)RulesHelper.toRegexPattern("?FOR"));
        Assert.assertEquals((Object)"QFLEX", (Object)RulesHelper.toRegexPattern("QFLEX"));
    }

    @Test
    public void testMatchesPattern() {
        Assert.assertTrue((boolean)RulesHelper.matchesPattern("MECOW", "?EC*"));
        Assert.assertFalse((boolean)RulesHelper.matchesPattern("ECOW", "?EC*"));
        Assert.assertFalse((boolean)RulesHelper.matchesPattern("MECOW", "*EC?"));
        Assert.assertTrue((boolean)RulesHelper.matchesPattern("MECO", "*EC?"));
    }
}

