/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.rules.standard;

import com.gridnine.xtrip.common.l10n.messages.L10n;
import com.gridnine.xtrip.common.model.booking.PassengerTypeCategory;
import com.gridnine.xtrip.common.model.booking.TravelSubject;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.helpers.MoneyHelper;
import com.gridnine.xtrip.common.model.helpers.MulticurrencyHelper;
import com.gridnine.xtrip.common.model.profile.ExchangeRateData;
import com.gridnine.xtrip.common.model.rules.l10n.Messages;
import com.gridnine.xtrip.common.model.rules.standard.Conditions;
import com.gridnine.xtrip.common.model.rules.standard.RulesHelper;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.XCloneable;
import com.gridnine.xtrip.common.util.XSSerializable;
import com.gridnine.xtrip.common.util.XSerializable;
import com.gridnine.xtrip.common.xml.XHelper;
import com.gridnine.xtrip.common.xml.XSHelper;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.w3c.dom.Element;

public class TravelSubjectTotalPriceRestrictions
implements Serializable,
XSerializable,
XSSerializable,
XCloneable {
    private static final long serialVersionUID = -4374110589330137058L;
    private Conditions totalPriceCondition;
    private Money totalPriceValue;
    private Conditions travelSubjectCondition;
    private TravelSubject travelSubjectValue;
    private Conditions passengerTypeCategoryCondition;
    private DictionaryReference<PassengerTypeCategory> passengerTypeCategoryValue;

    public TravelSubjectTotalPriceRestrictions() {
    }

    public TravelSubjectTotalPriceRestrictions(Conditions totalPriceCondition, Money totalPriceValue, Conditions travelSubjectCondition, TravelSubject travelSubjectValue, Conditions passengerTypeCategoryCondition, DictionaryReference<PassengerTypeCategory> passengerTypeCategoryValue) {
        this.totalPriceCondition = totalPriceCondition;
        this.totalPriceValue = totalPriceValue;
        this.travelSubjectCondition = travelSubjectCondition;
        this.travelSubjectValue = travelSubjectValue;
        this.passengerTypeCategoryCondition = passengerTypeCategoryCondition;
        this.passengerTypeCategoryValue = passengerTypeCategoryValue;
    }

    public boolean matches(TravelSubject travelSubject, Set<String> passengerTypeCategoryCodes, Money totalPrice) {
        boolean matches = this.checkTravelSubject(travelSubject);
        matches &= this.checkPassengerTypeCategory(passengerTypeCategoryCodes);
        return matches &= this.checkTotalPrice(totalPrice);
    }

    private boolean checkTravelSubject(TravelSubject travelSubject) {
        if (this.travelSubjectCondition == null || this.travelSubjectValue == null) {
            return true;
        }
        if (this.travelSubjectCondition == Conditions.EQUALS && this.travelSubjectValue == travelSubject) {
            return true;
        }
        return this.travelSubjectCondition == Conditions.NOT_EQUALS && this.travelSubjectValue != travelSubject;
    }

    private boolean checkPassengerTypeCategory(Set<String> passengerTypeCategoryCodes) {
        if (this.passengerTypeCategoryCondition == null || this.passengerTypeCategoryValue == null) {
            return true;
        }
        if (this.travelSubjectCondition == Conditions.EQUALS) {
            return RulesHelper.matchesDictRestriction(passengerTypeCategoryCodes, Collections.singletonList(this.passengerTypeCategoryValue), true);
        }
        if (this.travelSubjectCondition == Conditions.NOT_EQUALS) {
            return RulesHelper.matchesDictRestriction(passengerTypeCategoryCodes, Collections.singletonList(this.passengerTypeCategoryValue), false);
        }
        return false;
    }

    private boolean checkTotalPrice(Money totalPrice) {
        if (this.totalPriceCondition == null || this.totalPriceValue == null) {
            return true;
        }
        if (totalPrice != null) {
            BigDecimal totalPriceAmount = totalPrice.getValue();
            if (!MoneyHelper.sameCurrency(this.totalPriceValue, totalPrice)) {
                ExchangeRateData rateData = MulticurrencyHelper.buildExchangeRateData(totalPrice.getCurrency(), this.totalPriceValue.getCurrency(), null, null, null, true);
                totalPriceAmount = MulticurrencyHelper.convert(totalPrice.getValue(), rateData);
            }
            switch (this.totalPriceCondition) {
                case EQUALS: {
                    if (MiscUtil.compare((Comparable)totalPriceAmount, (Comparable)this.totalPriceValue.getValue()) != 0) break;
                    return true;
                }
                case NOT_EQUALS: {
                    if (MiscUtil.compare((Comparable)totalPriceAmount, (Comparable)this.totalPriceValue.getValue()) == 0) break;
                    return true;
                }
                case GREATER_THAN: {
                    if (MiscUtil.compare((Comparable)totalPriceAmount, (Comparable)this.totalPriceValue.getValue()) <= 0) break;
                    return true;
                }
                case GREATER_THAN_OR_EQUALS: {
                    if (MiscUtil.compare((Comparable)totalPriceAmount, (Comparable)this.totalPriceValue.getValue()) < 0) break;
                    return true;
                }
                case LESS_THAN: {
                    if (MiscUtil.compare((Comparable)totalPriceAmount, (Comparable)this.totalPriceValue.getValue()) >= 0) break;
                    return true;
                }
                case LESS_THAN_OR_EQUALS: {
                    if (MiscUtil.compare((Comparable)totalPriceAmount, (Comparable)this.totalPriceValue.getValue()) > 0) break;
                    return true;
                }
            }
        }
        return false;
    }

    public void buildInfo(StringBuilder buf) {
        if (this.getTotalPriceCondition() != null && this.totalPriceValue != null) {
            buf.append(L10n.get((String)Messages.RuleProperty_TotalPrice)).append(" ");
            buf.append(this.getTotalPriceCondition().getDisplayName()).append(" ");
            buf.append(this.totalPriceValue);
        }
        if (this.getTravelSubjectCondition() != null && this.travelSubjectValue != null) {
            buf.append("<br>").append(L10n.get((String)Messages.WHERE)).append(" ");
            buf.append(L10n.get((String)Messages.RuleProperty_TravelSubject)).append(" ");
            buf.append(this.getTravelSubjectCondition().getDisplayName()).append(" ");
            buf.append(this.travelSubjectValue);
        }
        if (this.getPassengerTypeCategoryCondition() != null && this.passengerTypeCategoryValue != null) {
            buf.append("<br>").append(L10n.get((String)Messages.WHERE)).append(" ");
            buf.append(L10n.get((String)Messages.RuleProperty_PassengerTypeCategory)).append(" ");
            buf.append(this.getPassengerTypeCategoryCondition().getDisplayName()).append(" ");
            buf.append(this.passengerTypeCategoryValue);
        }
    }

    public Object clone(boolean newUids, Map<String, String> uids) throws Exception {
        return new TravelSubjectTotalPriceRestrictions(this.totalPriceCondition, this.totalPriceValue, this.travelSubjectCondition, this.travelSubjectValue, this.passengerTypeCategoryCondition, this.passengerTypeCategoryValue);
    }

    public void toXML(XMLStreamWriter writer) throws Exception {
        XSHelper.writeEnum((XMLStreamWriter)writer, (String)"totalPriceCondition", (Enum)this.totalPriceCondition);
        XSHelper.writeObject((XMLStreamWriter)writer, (String)"totalPriceValue", (Object)this.totalPriceValue);
        XSHelper.writeEnum((XMLStreamWriter)writer, (String)"travelSubjectCondition", (Enum)this.travelSubjectCondition);
        XSHelper.writeEnum((XMLStreamWriter)writer, (String)"travelSubjectValue", (Enum)this.travelSubjectValue);
        XSHelper.writeEnum((XMLStreamWriter)writer, (String)"passengerTypeCategoryCondition", (Enum)this.passengerTypeCategoryCondition);
        XSHelper.writeObject((XMLStreamWriter)writer, (String)"passengerTypeCategoryValue", this.passengerTypeCategoryValue);
    }

    public void fromXML(XMLStreamReader reader) throws Exception {
        while (reader.nextTag() != 2) {
            String tag;
            switch (tag = reader.getName().getLocalPart()) {
                case "totalPriceCondition": {
                    this.totalPriceCondition = (Conditions)XSHelper.readEnum((XMLStreamReader)reader, Conditions.class);
                    break;
                }
                case "totalPriceValue": {
                    this.totalPriceValue = (Money)XSHelper.readObject((XMLStreamReader)reader);
                    break;
                }
                case "travelSubjectCondition": {
                    this.travelSubjectCondition = (Conditions)XSHelper.readEnum((XMLStreamReader)reader, Conditions.class);
                    break;
                }
                case "travelSubjectValue": {
                    this.travelSubjectValue = (TravelSubject)XSHelper.readEnum((XMLStreamReader)reader, TravelSubject.class);
                    break;
                }
                case "passengerTypeCategoryCondition": {
                    this.passengerTypeCategoryCondition = (Conditions)XSHelper.readEnum((XMLStreamReader)reader, Conditions.class);
                    break;
                }
                case "passengerTypeCategoryValue": {
                    this.passengerTypeCategoryValue = (DictionaryReference)XSHelper.readObject((XMLStreamReader)reader);
                }
            }
        }
    }

    public void toXML(Element elm) throws Exception {
        XHelper.writeEnum((Element)elm, (String)"totalPriceCondition", (Enum)this.totalPriceCondition);
        XHelper.writeObject((Element)elm, (String)"totalPriceValue", (Object)this.totalPriceValue);
        XHelper.writeEnum((Element)elm, (String)"travelSubjectCondition", (Enum)this.travelSubjectCondition);
        XHelper.writeEnum((Element)elm, (String)"travelSubjectValue", (Enum)this.travelSubjectValue);
        XHelper.writeEnum((Element)elm, (String)"passengerTypeCategoryCondition", (Enum)this.passengerTypeCategoryCondition);
        XHelper.writeObject((Element)elm, (String)"passengerTypeCategoryValue", this.passengerTypeCategoryValue);
    }

    public void fromXML(Element elm) throws Exception {
        this.totalPriceCondition = (Conditions)XHelper.readEnum((Element)elm, (String)"totalPriceCondition", Conditions.class);
        this.totalPriceValue = (Money)XHelper.readObject((Element)elm, (String)"totalPriceValue");
        this.travelSubjectCondition = (Conditions)XHelper.readEnum((Element)elm, (String)"travelSubjectCondition", Conditions.class);
        this.travelSubjectValue = (TravelSubject)XHelper.readEnum((Element)elm, (String)"travelSubjectValue", TravelSubject.class);
        this.passengerTypeCategoryCondition = (Conditions)XHelper.readEnum((Element)elm, (String)"passengerTypeCategoryCondition", Conditions.class);
        this.passengerTypeCategoryValue = (DictionaryReference)XHelper.readObject((Element)elm, (String)"passengerTypeCategoryValue");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TravelSubjectTotalPriceRestrictions that = (TravelSubjectTotalPriceRestrictions)o;
        return this.totalPriceCondition == that.totalPriceCondition && MiscUtil.equals((Object)this.totalPriceValue, (Object)that.totalPriceValue) && this.travelSubjectCondition == that.travelSubjectCondition && this.travelSubjectValue == that.travelSubjectValue && this.passengerTypeCategoryCondition == that.passengerTypeCategoryCondition && MiscUtil.equals(this.passengerTypeCategoryValue, that.passengerTypeCategoryValue);
    }

    public int hashCode() {
        return MiscUtil.hash((Object[])new Object[]{this.totalPriceCondition, this.totalPriceValue, this.travelSubjectCondition, this.travelSubjectValue, this.passengerTypeCategoryCondition, this.passengerTypeCategoryValue});
    }

    public Conditions getTotalPriceCondition() {
        return this.totalPriceCondition;
    }

    public void setTotalPriceCondition(Conditions totalPriceCondition) {
        this.totalPriceCondition = totalPriceCondition;
    }

    public Money getTotalPriceValue() {
        return this.totalPriceValue;
    }

    public void setTotalPriceValue(Money totalPriceValue) {
        this.totalPriceValue = totalPriceValue;
    }

    public Conditions getTravelSubjectCondition() {
        return this.travelSubjectCondition;
    }

    public void setTravelSubjectCondition(Conditions travelSubjectCondition) {
        this.travelSubjectCondition = travelSubjectCondition;
    }

    public TravelSubject getTravelSubjectValue() {
        return this.travelSubjectValue;
    }

    public void setTravelSubjectValue(TravelSubject travelSubjectValue) {
        this.travelSubjectValue = travelSubjectValue;
    }

    public Conditions getPassengerTypeCategoryCondition() {
        return this.passengerTypeCategoryCondition;
    }

    public void setPassengerTypeCategoryCondition(Conditions passengerTypeCategoryCondition) {
        this.passengerTypeCategoryCondition = passengerTypeCategoryCondition;
    }

    public DictionaryReference<PassengerTypeCategory> getPassengerTypeCategoryValue() {
        return this.passengerTypeCategoryValue;
    }

    public void setPassengerTypeCategoryValue(DictionaryReference<PassengerTypeCategory> passengerTypeCategoryValue) {
        this.passengerTypeCategoryValue = passengerTypeCategoryValue;
    }
}

