/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.rules.standard;

import com.gridnine.xtrip.common.l10n.messages.L10n;
import com.gridnine.xtrip.common.model.dict.CostCodeCategory;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.profile.CostCode;
import com.gridnine.xtrip.common.model.rules.l10n.Messages;
import com.gridnine.xtrip.common.model.rules.standard.Conditions;
import com.gridnine.xtrip.common.model.rules.standard.RulePropertyConditions;
import com.gridnine.xtrip.common.model.rules.standard.UDIDRestriction;
import com.gridnine.xtrip.common.model.rules.standard.UDIDsPropertyProvider;
import com.gridnine.xtrip.common.rules.elements.RuleCondition;
import com.gridnine.xtrip.common.rules.elements.RuleProperty;
import java.util.Optional;

public class UDIDProperty
implements RuleProperty,
RulePropertyConditions {
    public static final String ID = "UDID_PROPERTY";
    private static final String[] CONDITIONS_IDs = new String[]{Conditions.EQUALS.getId(), Conditions.NOT_EQUALS.getId()};

    public String getId() {
        return ID;
    }

    public String getDisplayName() {
        return L10n.get((String)Messages.UDIDProperty_displayName);
    }

    public String getRendererId() {
        return "UDID_VALUE_RENDERER";
    }

    public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
        UDIDRestriction udidRestriction = (UDIDRestriction)value;
        buf.append(L10n.get((String)Messages.UDIDProperty_info)).append(" \"").append((String)Optional.ofNullable(udidRestriction.getUdid()).map(DictionaryReference::getCaption).orElse(null)).append("\" ").append(cond.getDisplayName()).append(" \"").append(udidRestriction.getUdidValue()).append("\"");
    }

    public boolean match(Object proxyValue, RuleCondition condition, Object ruleValue) {
        UDIDsPropertyProvider provider = (UDIDsPropertyProvider)proxyValue;
        UDIDRestriction udidRestriction = (UDIDRestriction)ruleValue;
        boolean anyMatch = provider.getCostCodes().stream().anyMatch(costCode -> this.costCodeWithSameCostCodeCategory((CostCode)costCode, (DictionaryReference<CostCodeCategory>)udidRestriction.getUdid()) && this.valueEqual(udidRestriction, (CostCode)costCode));
        return Conditions.EQUALS.getId().equals(condition.getId()) == anyMatch;
    }

    @Override
    public String[] getConditionIds() {
        return CONDITIONS_IDs;
    }

    private boolean valueEqual(UDIDRestriction udidRestriction, CostCode costCode) {
        return udidRestriction.getUdidValue().equals(costCode.getValue()) || udidRestriction.getUdidValue().equals(costCode.getLocalValue()) || udidRestriction.getUdidValue().equals(costCode.getEnglishValue());
    }

    private boolean costCodeWithSameCostCodeCategory(CostCode costCode, DictionaryReference<CostCodeCategory> category) {
        return costCode.getCostCodeProperties() != null && costCode.getCostCodeProperties().getCategory() != null && costCode.getCostCodeProperties().getCategory().equals(category);
    }
}

