/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.rules.standard.qualityCheck;

import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.rules.standard.Conditions;
import com.gridnine.xtrip.common.model.rules.standard.RulePropertyConditions;
import com.gridnine.xtrip.common.model.rules.standard.RulesHelper;
import com.gridnine.xtrip.common.model.rules.standard.ValueTypes;
import com.gridnine.xtrip.common.model.rules.standard.qualityCheck.QualityCheckPropertiesProvider;
import com.gridnine.xtrip.common.rules.elements.RuleCondition;
import com.gridnine.xtrip.common.rules.elements.RuleProperty;
import com.gridnine.xtrip.common.util.BooleanUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public enum QualityCheckProperties implements RuleProperty,
RulePropertyConditions
{
    NO_OSI{

        @Override
        public String[] getConditionIds() {
            return new String[0];
        }

        public String getDisplayName() {
            return L10nResourcesManager.getStr((String)"RuleProperty_qualityCheckNoOSI", (Object[])new Object[0]);
        }

        public String getRendererId() {
            return ValueTypes.YES_NO.name();
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append((Boolean)value != false ? L10nResourcesManager.getStr((String)"RuleProperty_qualityCheckNoOSIYes", (Object[])new Object[0]) : L10nResourcesManager.getStr((String)"RuleProperty_qualityCheckNoOSINo", (Object[])new Object[0]));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            QualityCheckPropertiesProvider ps = (QualityCheckPropertiesProvider)propertySet;
            return (Boolean)value ^ BooleanUtil.nullAsFalse((Boolean)ps.hasOsi());
        }
    }
    ,
    NO_OSI_AIRLINE{

        @Override
        public String[] getConditionIds() {
            return new String[]{Conditions.INCLUDE.getId()};
        }

        public String getDisplayName() {
            return L10nResourcesManager.getStr((String)"RuleProperty_qualityCheckNoOSIForAirline", (Object[])new Object[0]);
        }

        public String getRendererId() {
            return ValueTypes.STRING_LIST.name();
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(L10nResourcesManager.getStr((String)"RuleProperty_qualityCheckNoOSIForAirlineInfo", (Object[])new Object[]{RulesHelper.toString(value)}));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            QualityCheckPropertiesProvider ps = (QualityCheckPropertiesProvider)propertySet;
            List<String> ruleCarriers = RulesHelper.toStringCollection(value);
            ruleCarriers.remove("YY");
            Set carriersToCheck = ruleCarriers.stream().filter(s -> ps.getMarketingCarriers().contains(s)).collect(Collectors.toSet());
            if (carriersToCheck.isEmpty()) {
                return false;
            }
            if (ps.getOsiCarriers().isEmpty()) {
                return true;
            }
            if (ps.getOsiCarriers().contains("YY")) {
                return false;
            }
            carriersToCheck.removeIf(s -> ps.getOsiCarriers().contains(s));
            return !carriersToCheck.isEmpty();
        }
    }
    ,
    NO_SSR_DOCS{

        @Override
        public String[] getConditionIds() {
            return new String[0];
        }

        public String getDisplayName() {
            return L10nResourcesManager.getStr((String)"RuleProperty_qualityCheckNoSsrDocs", (Object[])new Object[0]);
        }

        public String getRendererId() {
            return ValueTypes.YES_NO.name();
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append((Boolean)value != false ? L10nResourcesManager.getStr((String)"RuleProperty_qualityCheckNoSsrDocsYes", (Object[])new Object[0]) : L10nResourcesManager.getStr((String)"RuleProperty_qualityCheckNoSsrDocsNo", (Object[])new Object[0]));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            QualityCheckPropertiesProvider ps = (QualityCheckPropertiesProvider)propertySet;
            return (Boolean)value ^ BooleanUtil.nullAsFalse((Boolean)ps.hasSsrDocs());
        }
    }
    ,
    NO_SSR_DOCS_DB{

        @Override
        public String[] getConditionIds() {
            return new String[0];
        }

        public String getDisplayName() {
            return L10nResourcesManager.getStr((String)"RuleProperty_qualityCheckNoSsrDocsDb", (Object[])new Object[0]);
        }

        public String getRendererId() {
            return ValueTypes.YES_NO.name();
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append((Boolean)value != false ? L10nResourcesManager.getStr((String)"RuleProperty_qualityCheckNoSsrDocsDbYes", (Object[])new Object[0]) : L10nResourcesManager.getStr((String)"RuleProperty_qualityCheckNoSsrDocsDbNo", (Object[])new Object[0]));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            QualityCheckPropertiesProvider ps = (QualityCheckPropertiesProvider)propertySet;
            return (Boolean)value ^ BooleanUtil.nullAsFalse((Boolean)ps.hasSsrDocsDb());
        }
    }
    ,
    NO_PROFILES{

        @Override
        public String[] getConditionIds() {
            return new String[]{Conditions.ANY_OF.getId(), Conditions.ALL_OF.getId()};
        }

        public String getDisplayName() {
            return L10nResourcesManager.getStr((String)"RuleProperty_qualityCheckNoProfiles", (Object[])new Object[0]);
        }

        public String getRendererId() {
            return ValueTypes.PROFILE_TYPE.name();
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            if (Conditions.ANY_OF.equals(cond)) {
                buf.append(L10nResourcesManager.getStr((String)"RuleProperty_qualityCheckNoProfilesAnyOfInfo", (Object[])new Object[]{RulesHelper.toString(value)}));
            } else if (Conditions.ALL_OF.equals(cond)) {
                buf.append(L10nResourcesManager.getStr((String)"RuleProperty_qualityCheckNoProfilesAllOfInfo", (Object[])new Object[]{RulesHelper.toString(value)}));
            }
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            QualityCheckPropertiesProvider ps = (QualityCheckPropertiesProvider)propertySet;
            if (Conditions.ANY_OF.equals(condition)) {
                return !ps.getProfileTypes().containsAll((List)value);
            }
            if (Conditions.ALL_OF.equals(condition)) {
                return !((List)value).isEmpty() && ps.getProfileTypes().stream().noneMatch(p -> ((List)value).contains(p));
            }
            return false;
        }
    }
    ,
    NO_PASSENGER_CONTACT_DATA{

        @Override
        public String[] getConditionIds() {
            return new String[0];
        }

        public String getDisplayName() {
            return L10nResourcesManager.getStr((String)"RuleProperty_qualityCheckNoPassengerContactData", (Object[])new Object[0]);
        }

        public String getRendererId() {
            return ValueTypes.YES_NO.name();
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append((Boolean)value != false ? L10nResourcesManager.getStr((String)"RuleProperty_qualityCheckNoPassengerContactDataYes", (Object[])new Object[0]) : L10nResourcesManager.getStr((String)"RuleProperty_qualityCheckNoPassengerContactDataNo", (Object[])new Object[0]));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            QualityCheckPropertiesProvider ps = (QualityCheckPropertiesProvider)propertySet;
            return (Boolean)value ^ BooleanUtil.nullAsFalse((Boolean)ps.hasPassengerContact());
        }
    }
    ,
    NO_AGENT_CODE_REMARK{

        @Override
        public String[] getConditionIds() {
            return new String[0];
        }

        public String getDisplayName() {
            return L10nResourcesManager.getStr((String)"RuleProperty_qualityCheckNoAgentCodeRemark", (Object[])new Object[0]);
        }

        public String getRendererId() {
            return ValueTypes.YES_NO.name();
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append((Boolean)value != false ? L10nResourcesManager.getStr((String)"RuleProperty_qualityCheckNoAgentCodeRemarkYes", (Object[])new Object[0]) : L10nResourcesManager.getStr((String)"RuleProperty_qualityCheckNoAgentCodeRemarkNo", (Object[])new Object[0]));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            QualityCheckPropertiesProvider ps = (QualityCheckPropertiesProvider)propertySet;
            return (Boolean)value ^ BooleanUtil.nullAsFalse((Boolean)ps.hasAgentCodeRemarks());
        }
    }
    ,
    NO_DATE_OF_BIRTH{

        @Override
        public String[] getConditionIds() {
            return new String[0];
        }

        public String getDisplayName() {
            return L10nResourcesManager.getStr((String)"RuleProperty_qualityCheckNoDateOfBirth", (Object[])new Object[0]);
        }

        public String getRendererId() {
            return ValueTypes.YES_NO.name();
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append((Boolean)value != false ? L10nResourcesManager.getStr((String)"RuleProperty_qualityCheckNoDateOfBirthYes", (Object[])new Object[0]) : L10nResourcesManager.getStr((String)"RuleProperty_qualityCheckNoDateOfBirthNo", (Object[])new Object[0]));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            QualityCheckPropertiesProvider ps = (QualityCheckPropertiesProvider)propertySet;
            return (Boolean)value ^ BooleanUtil.nullAsFalse((Boolean)ps.hasBirthDate());
        }
    }
    ,
    BOOKING_PCC{

        @Override
        public String[] getConditionIds() {
            return new String[]{Conditions.INCLUDE.getId(), Conditions.EXCLUDE.getId()};
        }

        public String getDisplayName() {
            return L10nResourcesManager.getStr((String)"RuleProperty_qualityCheckBookingPcc", (Object[])new Object[0]);
        }

        public String getRendererId() {
            return ValueTypes.STRING_LIST.name();
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(L10nResourcesManager.getStr((String)"RuleProperty_qualityCheckBookingPccInfo", (Object[])new Object[]{cond.getDisplayName(), RulesHelper.toString(value)}));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            QualityCheckPropertiesProvider ps = (QualityCheckPropertiesProvider)propertySet;
            if (Conditions.INCLUDE.equals(condition)) {
                return RulesHelper.matchesStringRestriction(ps.getCurrentPcc(), value, true);
            }
            if (Conditions.EXCLUDE.equals(condition)) {
                return RulesHelper.matchesStringRestriction(ps.getCurrentPcc(), value, false);
            }
            return false;
        }
    }
    ,
    TICKETING_PCC{

        @Override
        public String[] getConditionIds() {
            return new String[]{Conditions.INCLUDE.getId(), Conditions.EXCLUDE.getId()};
        }

        public String getDisplayName() {
            return L10nResourcesManager.getStr((String)"RuleProperty_qualityCheckTicketingPcc", (Object[])new Object[0]);
        }

        public String getRendererId() {
            return ValueTypes.STRING_LIST.name();
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(L10nResourcesManager.getStr((String)"RuleProperty_qualityCheckTicketingPccInfo", (Object[])new Object[]{cond.getDisplayName(), RulesHelper.toString(value)}));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            QualityCheckPropertiesProvider ps = (QualityCheckPropertiesProvider)propertySet;
            if (Conditions.INCLUDE.equals(condition)) {
                return RulesHelper.matchesStringRestriction(ps.getCurrentPcc(), value, true);
            }
            if (Conditions.EXCLUDE.equals(condition)) {
                return RulesHelper.matchesStringRestriction(ps.getCurrentPcc(), value, false);
            }
            return false;
        }
    }
    ,
    EXCHANGE_PCC_MATCHES_TICKETING_PCC{

        @Override
        public String[] getConditionIds() {
            return new String[0];
        }

        public String getDisplayName() {
            return L10nResourcesManager.getStr((String)"RuleProperty_qualityCheckExchangePccMatchesTicketingPcc", (Object[])new Object[0]);
        }

        public String getRendererId() {
            return ValueTypes.YES_NO.name();
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append((Boolean)value != false ? L10nResourcesManager.getStr((String)"RuleProperty_qualityCheckExchangePccMatchesTicketingPccYes", (Object[])new Object[0]) : L10nResourcesManager.getStr((String)"RuleProperty_qualityCheckExchangePccMatchesTicketingPccNo", (Object[])new Object[0]));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            QualityCheckPropertiesProvider ps = (QualityCheckPropertiesProvider)propertySet;
            return (Boolean)value ^ !MiscUtil.equals((Object)ps.getCurrentPcc(), (Object)ps.getTicketingPcc(), (boolean)false);
        }
    };


    public String getId() {
        return this.name();
    }
}

