/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.rules.standard.rate;

import com.gridnine.xtrip.common.l10n.model.LocaleManager;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.CurrencyRate;
import com.gridnine.xtrip.common.model.booking.CurrencyRateType;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.ValidationMessage;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.dict.PreferenceKey;
import com.gridnine.xtrip.common.model.handlers.HandlersRegistry;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.FinanceHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.model.validation.StandartValidationMessageType;
import com.gridnine.xtrip.common.model.validation.ValidationMessageHelper;
import com.gridnine.xtrip.common.model.validation.ValidationMessageType;
import com.gridnine.xtrip.common.util.TextUtil;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Collection;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RateHelper {
    private static final Logger log = LoggerFactory.getLogger(RateHelper.class);

    public static BigDecimal getCurrencyRate(String currencyCode, Date issueDate, Collection<ValidationMessage> messages) {
        String equivalentCurrencyCode;
        if (issueDate == null) {
            messages.add(ValidationMessageHelper.createValidationMessage(StandartValidationMessageType.GPCAS_ISSUE_DATE_IS_CURRENT));
            issueDate = new Date();
        }
        if (TextUtil.isSame((String)currencyCode, (String)(equivalentCurrencyCode = DictHelper.getPreferenceValue(PreferenceKey.EQUIVE_CURRENCY, null)))) {
            return BigDecimal.ONE;
        }
        CurrencyRate currencyRate = BookingHelper.findCurrencyRate(currencyCode, issueDate, CurrencyRateType.IATA, null, null);
        if (currencyRate != null) {
            return BigDecimal.valueOf(currencyRate.getRate());
        }
        String equivCurrency = DictHelper.getEquivCurrency();
        if (equivCurrency != null && (currencyRate = BookingHelper.findCurrencyRate(currencyCode, equivCurrency, issueDate, CurrencyRateType.IATA, null, null, null)) != null) {
            return BigDecimal.ONE.divide(BigDecimal.valueOf(currencyRate.getRate()), 10, RoundingMode.HALF_UP);
        }
        messages.add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.GPCAS_CURRENCY_RATE_IS_1, currencyCode));
        return BigDecimal.ONE;
    }

    public static BigDecimal getCurrencyRate(String baseCurrencyCode, String currencyCode, Product product, boolean feeForRefund, Collection<ValidationMessage> messages) {
        BigDecimal rate;
        String equivalentCurrencyCode;
        Date issueDate = product.getIssueDate();
        ProductStatus status = product.getStatus();
        if (status == ProductStatus.REFUND && !feeForRefund || status == ProductStatus.EXCHANGE) {
            Product rp = RateHelper.findRelatedSell(product);
            if (rp != null) {
                issueDate = rp.getIssueDate();
            } else {
                messages.add(ValidationMessageHelper.createValidationMessage(StandartValidationMessageType.PCAS_CANT_DEFINE_ISSUE_DATE));
            }
        }
        if (issueDate == null) {
            messages.add(ValidationMessageHelper.createValidationMessage(StandartValidationMessageType.PCAS_ISSUE_DATE_IS_CURRENT));
            issueDate = new Date();
        }
        String string = equivalentCurrencyCode = baseCurrencyCode == null ? DictHelper.getPreferenceValue(PreferenceKey.EQUIVE_CURRENCY, null) : baseCurrencyCode;
        if (TextUtil.isSame((String)currencyCode, (String)equivalentCurrencyCode)) {
            return BigDecimal.ONE;
        }
        CurrencyRateType currencyRateType = FinanceHelper.getCurrencyRateType(equivalentCurrencyCode);
        CurrencyRate currencyRate = BookingHelper.findCurrencyRate(equivalentCurrencyCode, currencyCode, issueDate, currencyRateType, product.getTariffType(), (EntityReference<Organization>)product.getBlankOwnerRef(), GeneralProductHelper.getSupplier((BaseProduct)product));
        if (currencyRate != null) {
            return BigDecimal.valueOf(currencyRate.getRate());
        }
        currencyRate = BookingHelper.findCurrencyRate(currencyCode, equivalentCurrencyCode, issueDate, currencyRateType, product.getTariffType(), (EntityReference<Organization>)product.getBlankOwnerRef(), GeneralProductHelper.getSupplier((BaseProduct)product));
        if (currencyRate != null) {
            return BigDecimal.ONE.divide(BigDecimal.valueOf(currencyRate.getRate()), 10, RoundingMode.HALF_UP);
        }
        Money baseFare = AirProductHelper.getBaseFare(product);
        if (baseFare != null && baseFare.getCurrency() != null && baseFare.getCurrency().equals(currencyCode) && (rate = AirProductHelper.calculateS7Rate(product)) != null) {
            messages.add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.PCAS_USING_CALCULATED_CURRENCY_RATE, currencyCode, LocaleManager.get().getCurrentLocaleData().getPriceFormat().format(rate)));
            return BigDecimal.valueOf(rate.doubleValue());
        }
        messages.add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.PCAS_CURRENCY_RATE_IS_1, currencyCode));
        return BigDecimal.ONE;
    }

    private static Product findRelatedSell(Product product) {
        if (product == null) {
            return null;
        }
        if (product.getStatus() == ProductStatus.SELL) {
            return product;
        }
        if (product.getPreviousProduct() == null) {
            return null;
        }
        return RateHelper.findRelatedSell(product.getPreviousProduct());
    }

    public static BigDecimal getCurrencyRate(String baseCurrencyCode, String currencyCode, BaseProduct baseProduct, boolean feeForRefund, Collection<ValidationMessage> messages) {
        CurrencyRateType currencyRateType;
        String equivalentCurrencyCode;
        CurrencyRate currencyRate;
        ProductHandler<BaseProduct> handler = HandlersRegistry.get().findProductHandler(baseProduct.getClass());
        Date issueDate = handler.findIssueDate(baseProduct);
        ProductStatus status = handler.getStatus(baseProduct);
        if (status == ProductStatus.REFUND && !feeForRefund || status == ProductStatus.EXCHANGE) {
            BaseProduct rp = RateHelper.findRelatedSell(handler, baseProduct);
            if (rp != null) {
                issueDate = handler.findIssueDate(rp);
            } else {
                messages.add(ValidationMessageHelper.createValidationMessage(StandartValidationMessageType.PCAS_CANT_DEFINE_ISSUE_DATE));
            }
        }
        if (issueDate == null) {
            messages.add(ValidationMessageHelper.createValidationMessage(StandartValidationMessageType.PCAS_ISSUE_DATE_IS_CURRENT));
            issueDate = new Date();
        }
        if ((currencyRate = BookingHelper.findCurrencyRate(equivalentCurrencyCode = baseCurrencyCode == null ? DictHelper.getPreferenceValue(PreferenceKey.EQUIVE_CURRENCY, null) : baseCurrencyCode, currencyCode, issueDate, currencyRateType = FinanceHelper.getCurrencyRateType(equivalentCurrencyCode), null, null, GeneralProductHelper.getSupplier(baseProduct))) != null) {
            return BigDecimal.valueOf(currencyRate.getRate());
        }
        currencyRate = BookingHelper.findCurrencyRate(currencyCode, equivalentCurrencyCode, issueDate, currencyRateType, null, null, GeneralProductHelper.getSupplier(baseProduct));
        if (currencyRate != null) {
            return BigDecimal.ONE.divide(BigDecimal.valueOf(currencyRate.getRate()), 10, RoundingMode.HALF_UP);
        }
        messages.add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.PCAS_CURRENCY_RATE_IS_1, currencyCode));
        return BigDecimal.ONE;
    }

    private static BaseProduct findRelatedSell(ProductHandler<BaseProduct> handler, BaseProduct bp) {
        if (bp == null) {
            return null;
        }
        if (handler.getStatus(bp) == ProductStatus.SELL) {
            return bp;
        }
        BaseProduct prev = handler.getPreviousProduct(bp);
        if (prev == null) {
            return null;
        }
        return RateHelper.findRelatedSell(handler, prev);
    }
}

