/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.rules.standard.tchexport;

import com.gridnine.xtrip.common.model.rules.standard.tchexport.TchConditionParam;
import com.gridnine.xtrip.common.model.rules.standard.tchexport.TchConditionType;
import com.gridnine.xtrip.common.model.rules.standard.tchexport.TchConditionValue;
import com.gridnine.xtrip.common.util.XmlUtil;
import com.gridnine.xtrip.common.xml.XHelper;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.w3c.dom.Element;

public class TchCondition {
    private int id;
    private int num;
    private String name;
    private Date dateCondition;
    private Long carrierId;
    private int priority;
    private Date dateStart;
    private Date dateEnd;
    private String outNumAvs;
    private Date dateAct;
    private boolean useTp;
    private boolean useTb;
    private boolean useCn;
    private String carrierCode;
    private String treatyCode;
    private TchConditionType type;
    private final List<TchConditionValue> values = new ArrayList<TchConditionValue>();
    private final List<TchConditionParam> params = new ArrayList<TchConditionParam>();

    public int getId() {
        return this.id;
    }

    public void setId(int value) {
        this.id = value;
    }

    public int getNum() {
        return this.num;
    }

    public void setNum(int value) {
        this.num = value;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String value) {
        this.name = value;
    }

    public Date getDateCondition() {
        return this.dateCondition;
    }

    public void setDateCondition(Date value) {
        this.dateCondition = value;
    }

    public Long getCarrierId() {
        return this.carrierId;
    }

    public void setCarrierId(Long value) {
        this.carrierId = value;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int value) {
        this.priority = value;
    }

    public Date getDateStart() {
        return this.dateStart;
    }

    public void setDateStart(Date value) {
        this.dateStart = value;
    }

    public Date getDateEnd() {
        return this.dateEnd;
    }

    public void setDateEnd(Date value) {
        this.dateEnd = value;
    }

    public String getOutNumAvs() {
        return this.outNumAvs;
    }

    public void setOutNumAvs(String value) {
        this.outNumAvs = value;
    }

    public Date getDateAct() {
        return this.dateAct;
    }

    public void setDateAct(Date value) {
        this.dateAct = value;
    }

    public boolean isUseTp() {
        return this.useTp;
    }

    public void setUseTp(boolean value) {
        this.useTp = value;
    }

    public boolean isUseTb() {
        return this.useTb;
    }

    public void setUseTb(boolean value) {
        this.useTb = value;
    }

    public boolean isUseCn() {
        return this.useCn;
    }

    public void setUseCn(boolean value) {
        this.useCn = value;
    }

    public String getCarrierCode() {
        return this.carrierCode;
    }

    public void setCarrierCode(String value) {
        this.carrierCode = value;
    }

    public String getTreatyCode() {
        return this.treatyCode;
    }

    public void setTreatyCode(String value) {
        this.treatyCode = value;
    }

    public TchConditionType getType() {
        return this.type;
    }

    public void setType(TchConditionType value) {
        this.type = value;
    }

    public List<TchConditionValue> getValues() {
        return this.values;
    }

    public List<TchConditionParam> getParams() {
        return this.params;
    }

    public void toXml(Element elm, String namespace) {
        Element subElement = XmlUtil.addElement((Element)elm, (String)"condition", (boolean)false, (String)namespace);
        XHelper.writeInt((Element)subElement, (String)"condition_id", (int)this.getId(), (String)namespace);
        XHelper.writeInt((Element)subElement, (String)"condition_num", (int)this.getNum(), (String)namespace);
        XHelper.writeString((Element)subElement, (String)"name", (String)this.getName(), (String)namespace);
        this.writeTchDate(subElement, "condition_date", this.getDateCondition(), namespace);
        XHelper.writeString((Element)subElement, (String)"carrier_id", (String)(this.getCarrierId() != null ? this.getCarrierId().toString() : null), (String)namespace);
        XHelper.writeInt((Element)subElement, (String)"priority", (int)this.getPriority(), (String)namespace);
        this.writeTchDate(subElement, "date_from", this.getDateStart(), namespace);
        this.writeTchDate(subElement, "date_to", this.getDateEnd(), namespace);
        XHelper.writeString((Element)subElement, (String)"out_num_avs", (String)this.getOutNumAvs(), (String)namespace);
        this.writeTchBoolean(subElement, "use_tp", this.isUseTp(), namespace);
        this.writeTchBoolean(subElement, "use_tb", this.isUseTb(), namespace);
        this.writeTchBoolean(subElement, "use_cn", this.isUseCn(), namespace);
        XHelper.writeString((Element)subElement, (String)"carrier_code", (String)this.getCarrierCode(), (String)namespace);
        this.writeTchDate(subElement, "act_date", this.getDateAct(), namespace);
        XHelper.writeString((Element)subElement, (String)"treaty_code", (String)this.getTreatyCode(), (String)namespace);
        XHelper.writeString((Element)subElement, (String)"condition_type", (String)this.getType().getCode(), (String)namespace);
        for (TchConditionValue tchValue : this.values) {
            tchValue.toXml(subElement, this.getId(), namespace);
        }
        for (TchConditionParam tchParam : this.params) {
            tchParam.toXml(subElement, this.getId(), namespace);
        }
    }

    private Element writeTchBoolean(Element elm, String path, boolean value, String namespace) {
        return XHelper.writeString((Element)elm, (String)path, (String)(value ? "1" : "0"), (String)namespace);
    }

    private Element writeTchDate(Element elm, String path, Date value, String namespace) {
        if (value == null) {
            return null;
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
        String s = df.format(value);
        s = s.substring(0, 22).concat(":").concat(s.substring(22));
        Element result = XmlUtil.addElement((Element)elm, (String)path, (boolean)false, (String)namespace);
        XmlUtil.setValue((Element)result, (String)s);
        return result;
    }
}

