/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.rules.travelPolicy;

import com.gridnine.xtrip.common.l10n.messages.L10n;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.rules.l10n.Messages;
import com.gridnine.xtrip.common.model.rules.standard.ValueTypes;
import com.gridnine.xtrip.common.model.rules.travelPolicy.TravelPolicyActionsProvider;
import com.gridnine.xtrip.common.model.rules.travelPolicy.TravelPolicyTargets;
import com.gridnine.xtrip.common.model.travelPolicy.TravelPolicyAuthorizationParameters;
import com.gridnine.xtrip.common.model.travelPolicy.TravelPolicyAuthorizationStepParameters;
import com.gridnine.xtrip.common.model.travelPolicy.TravelPolicyAuthorizationUnitParameters;
import com.gridnine.xtrip.common.rules.elements.RuleAction;
import com.gridnine.xtrip.common.rules.elements.RuleProxy;
import java.util.List;

public enum TravelPolicyActions implements RuleAction
{
    TRAVEL_POLICY_MATCH_TYPE{

        public String getDisplayName() {
            return L10n.get((String)Messages.TravelPolicyActions_MATCH_TYPE);
        }

        @Override
        public String[] getTargets() {
            return new String[]{TravelPolicyTargets.TRAVEL_POLICY_AVIA.getId(), TravelPolicyTargets.TRAVEL_POLICY_RAILWAY.getId(), TravelPolicyTargets.TRAVEL_POLICY_HOTELS.getId(), TravelPolicyTargets.TRAVEL_POLICY_TRANSFER.getId()};
        }

        public String getRendererId() {
            return ValueTypes.TRAVEL_POLICY_MATCH_TYPE.name();
        }

        public boolean hasValue() {
            return true;
        }

        public void buildInfo(StringBuilder buf, Object value) {
            buf.append(L10nResourcesManager.getStr((String)Messages.TravelPolicyActions_MATCH_TYPE_X, (Object[])new Object[]{value}));
        }

        public String getRuleCategoryValue(Object actionSet, Object value) {
            return "travel-policy-match-type";
        }

        public void apply(RuleProxy<?, ?> proxy, Object value) {
        }
    }
    ,
    TRAVEL_POLICY_RECOMMENDED{

        public String getDisplayName() {
            return L10n.get((String)Messages.TravelPolicyActions_RECOMMENDED);
        }

        @Override
        public String[] getTargets() {
            return new String[]{TravelPolicyTargets.TRAVEL_POLICY_AVIA.getId(), TravelPolicyTargets.TRAVEL_POLICY_RAILWAY.getId(), TravelPolicyTargets.TRAVEL_POLICY_HOTELS.getId(), TravelPolicyTargets.TRAVEL_POLICY_TRANSFER.getId()};
        }

        public String getRendererId() {
            return ValueTypes.YES_NO.name();
        }

        public boolean hasValue() {
            return true;
        }

        public void buildInfo(StringBuilder buf, Object value) {
            Boolean v = (Boolean)value;
            buf.append(L10nResourcesManager.getStr((String)Messages.TravelPolicyActions_RECOMMENDED_X, (Object[])new Object[]{Boolean.TRUE.equals(v) ? L10nResourcesManager.getStr((String)Messages.YES, (Object[])new Object[0]) : L10nResourcesManager.getStr((String)Messages.NO, (Object[])new Object[0])}));
        }

        public String getRuleCategoryValue(Object actionSet, Object value) {
            return "travel-policy-recommended";
        }

        public void apply(RuleProxy<?, ?> proxy, Object value) {
            TravelPolicyActionsProvider actions = (TravelPolicyActionsProvider)proxy.getActionSet();
            Boolean v = (Boolean)value;
            actions.setRecommended(Boolean.TRUE.equals(v));
            proxy.getAppliedRuleCategories().add(this.getRuleCategoryValue(proxy.getActionSet(), value));
        }
    }
    ,
    TRAVEL_POLICY_AUTHORIZATION_REQUIRED{

        public String getDisplayName() {
            return L10n.get((String)Messages.TravelPolicyActions_AUTHORIZATION_REQUIRED_OLD);
        }

        @Override
        public String[] getTargets() {
            return new String[]{TravelPolicyTargets.TRAVEL_POLICY_AVIA.getId(), TravelPolicyTargets.TRAVEL_POLICY_RAILWAY.getId(), TravelPolicyTargets.TRAVEL_POLICY_HOTELS.getId(), TravelPolicyTargets.TRAVEL_POLICY_TRANSFER.getId(), TravelPolicyTargets.TRAVEL_POLICY_AUTHORIZATION.getId()};
        }

        public void buildInfo(StringBuilder buf, Object value) {
            buf.append(value != null ? L10n.get((String)Messages.TravelPolicyActions_AUTHORIZATION_REQUIRED_OLD) : L10n.get((String)Messages.TravelPolicyActions_NO_AUTHORIZATION_REQUIRED_OLD));
        }

        public String getRendererId() {
            return ValueTypes.TRAVEL_POLICY_AUTHORIZATION_PARAMETERS.name();
        }

        public boolean hasValue() {
            return true;
        }

        public String getRuleCategoryValue(Object actionSet, Object value) {
            return "travel-policy-authorization-required";
        }

        public void apply(RuleProxy<?, ?> proxy, Object value) {
            TravelPolicyActionsProvider as = (TravelPolicyActionsProvider)proxy.getActionSet();
            TravelPolicyAuthorizationParameters authorizationParameters = (TravelPolicyAuthorizationParameters)value;
            this.updateAuthorizationParameters(authorizationParameters);
            as.setAuthorizationParameters(authorizationParameters);
            proxy.getAppliedRuleCategories().add(this.getRuleCategoryValue(as, value));
        }

        private void updateAuthorizationParameters(TravelPolicyAuthorizationParameters authorizationParameters) {
            if (authorizationParameters.getSteps().isEmpty()) {
                return;
            }
            TravelPolicyAuthorizationStepParameters step = (TravelPolicyAuthorizationStepParameters)authorizationParameters.getSteps().get(0);
            List units = step.getUnits();
            units.clear();
            TravelPolicyAuthorizationUnitParameters unit = new TravelPolicyAuthorizationUnitParameters();
            unit.getPersons().clear();
            unit.getPersons().addAll(step.getPersons());
            unit.setTimeLimit(authorizationParameters.getTimeLimit());
            unit.setPriceLimitPercent(authorizationParameters.getPriceLimitPercent());
            units.add(unit);
        }
    }
    ,
    TRAVEL_POLICY_AUTHORIZATION_UNIT_REQUIRED{

        public String getDisplayName() {
            return L10n.get((String)Messages.TravelPolicyActions_AUTHORIZATION_REQUIRED);
        }

        @Override
        public String[] getTargets() {
            return new String[]{TravelPolicyTargets.TRAVEL_POLICY_AVIA.getId(), TravelPolicyTargets.TRAVEL_POLICY_RAILWAY.getId(), TravelPolicyTargets.TRAVEL_POLICY_HOTELS.getId(), TravelPolicyTargets.TRAVEL_POLICY_TRANSFER.getId(), TravelPolicyTargets.TRAVEL_POLICY_AUTHORIZATION.getId()};
        }

        public void buildInfo(StringBuilder buf, Object value) {
            buf.append(value != null ? L10n.get((String)Messages.TravelPolicyActions_AUTHORIZATION_REQUIRED) : L10n.get((String)Messages.TravelPolicyActions_NO_AUTHORIZATION_REQUIRED));
        }

        public String getRendererId() {
            return ValueTypes.TRAVEL_POLICY_AUTHORIZATION_UNIT_PARAMETERS.name();
        }

        public boolean hasValue() {
            return true;
        }

        public String getRuleCategoryValue(Object actionSet, Object value) {
            return null;
        }

        public void apply(RuleProxy<?, ?> proxy, Object value) {
        }
    }
    ,
    TRAVEL_POLICY_REASON_CODE_REQUIRED{

        public String getDisplayName() {
            return L10n.get((String)Messages.TravelPolicyActions_REASON_CODE_REQUIRED);
        }

        @Override
        public String[] getTargets() {
            return new String[]{TravelPolicyTargets.TRAVEL_POLICY_AVIA.getId(), TravelPolicyTargets.TRAVEL_POLICY_RAILWAY.getId(), TravelPolicyTargets.TRAVEL_POLICY_HOTELS.getId(), TravelPolicyTargets.TRAVEL_POLICY_TRANSFER.getId()};
        }

        public String getRendererId() {
            return ValueTypes.TRUE.name();
        }

        public boolean hasValue() {
            return true;
        }

        public void buildInfo(StringBuilder buf, Object value) {
            buf.append(Boolean.TRUE.equals(value) ? L10n.get((String)Messages.TravelPolicyActions_REASON_CODE_REQUIRED) : L10n.get((String)Messages.TravelPolicyActions_NO_REASON_CODE_REQUIRED));
        }

        public String getRuleCategoryValue(Object actionSet, Object value) {
            return "travel-policy-reason-code-required";
        }

        public void apply(RuleProxy<?, ?> proxy, Object value) {
            TravelPolicyActionsProvider as = (TravelPolicyActionsProvider)proxy.getActionSet();
            as.setReasonCodeRequired(Boolean.TRUE.equals(value));
            proxy.getAppliedRuleCategories().add(this.getRuleCategoryValue(as, value));
        }
    }
    ,
    TRAVEL_POLICY_KEY_CONTACTS{

        @Override
        public String[] getTargets() {
            return new String[]{TravelPolicyTargets.TRAVEL_POLICY_AVIA.getId(), TravelPolicyTargets.TRAVEL_POLICY_RAILWAY.getId(), TravelPolicyTargets.TRAVEL_POLICY_HOTELS.getId(), TravelPolicyTargets.TRAVEL_POLICY_TRANSFER.getId()};
        }

        public String getDisplayName() {
            return L10n.get((String)Messages.TravelPolicyActions_KEY_CONTACTS_REQUIRED);
        }

        public String getRendererId() {
            return ValueTypes.YES_NO.name();
        }

        public boolean hasValue() {
            return true;
        }

        public void buildInfo(StringBuilder buf, Object value) {
            buf.append(Boolean.TRUE.equals(value) ? L10n.get((String)Messages.TravelPolicyActions_KEY_CONTACTS_REQUIRED) : L10n.get((String)Messages.TravelPolicyActions_NO_KEY_CONTACTS_REQUIRED));
        }

        public String getRuleCategoryValue(Object actionSet, Object value) throws Exception {
            return "travel-policy-key-contacts-required";
        }

        public void apply(RuleProxy<?, ?> proxy, Object value) throws Exception {
            TravelPolicyActionsProvider as = (TravelPolicyActionsProvider)proxy.getActionSet();
            as.setKeyContactsRequired(Boolean.TRUE.equals(value));
            proxy.getAppliedRuleCategories().add(this.getRuleCategoryValue(as, value));
        }
    }
    ,
    DISPLAY_WARNING_TRAVEL_POLICY_VIOLATION{

        @Override
        public String[] getTargets() {
            return new String[]{TravelPolicyTargets.TRAVEL_POLICY_AVIA.getId(), TravelPolicyTargets.TRAVEL_POLICY_CAR_RENTAL.getId()};
        }

        public String getDisplayName() {
            return L10n.get((String)Messages.TravelPolicyActions_DISPLAY_WARNING_TRAVEL_POLICY_VIOLATION);
        }

        public String getRendererId() {
            return ValueTypes.NULL.name();
        }

        public boolean hasValue() {
            return false;
        }

        public void buildInfo(StringBuilder buf, Object value) {
            buf.append(L10n.get((String)Messages.TravelPolicyActions_DISPLAY_WARNING_TRAVEL_POLICY_VIOLATION));
        }

        public String getRuleCategoryValue(Object actionSet, Object value) throws Exception {
            return "travel-policy-violation-display-warning";
        }

        public void apply(RuleProxy<?, ?> proxy, Object value) throws Exception {
            TravelPolicyActionsProvider as = (TravelPolicyActionsProvider)proxy.getActionSet();
            as.setDisplayWarning(true);
            proxy.getAppliedRuleCategories().add(this.getRuleCategoryValue(as, value));
        }
    }
    ,
    TRAVEL_POLICY_VIOLATION_PROHIBIT_END_PNR{

        @Override
        public String[] getTargets() {
            return new String[]{TravelPolicyTargets.TRAVEL_POLICY_AVIA.getId(), TravelPolicyTargets.TRAVEL_POLICY_CAR_RENTAL.getId()};
        }

        public String getDisplayName() {
            return L10n.get((String)Messages.TravelPolicyActions_TRAVEL_POLICY_VIOLATION_PROHIBIT_END_PNR);
        }

        public String getRendererId() {
            return ValueTypes.NULL.name();
        }

        public boolean hasValue() {
            return false;
        }

        public void buildInfo(StringBuilder buf, Object value) {
            buf.append(L10n.get((String)Messages.TravelPolicyActions_TRAVEL_POLICY_VIOLATION_PROHIBIT_END_PNR));
        }

        public String getRuleCategoryValue(Object actionSet, Object value) throws Exception {
            return "travel-policy-violation-prohibit-end-pnr";
        }

        public void apply(RuleProxy<?, ?> proxy, Object value) throws Exception {
            TravelPolicyActionsProvider as = (TravelPolicyActionsProvider)proxy.getActionSet();
            as.setProhibitEndPnr(true);
            proxy.getAppliedRuleCategories().add(this.getRuleCategoryValue(as, value));
        }
    };


    public String getId() {
        return this.name();
    }

    public abstract String[] getTargets();
}

