/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.rules.tripartite;

import com.gridnine.xtrip.common.l10n.messages.L10n;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.booking.TripartitePublicFareDiscount;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.profile.TripartiteContractCalculationIndicatorType;
import com.gridnine.xtrip.common.model.rules.l10n.Messages;
import com.gridnine.xtrip.common.model.rules.standard.CommissionActionsProvider;
import com.gridnine.xtrip.common.model.rules.standard.RulesHelper;
import com.gridnine.xtrip.common.model.rules.standard.SabreRemarkResult;
import com.gridnine.xtrip.common.model.rules.standard.Targets;
import com.gridnine.xtrip.common.model.rules.standard.ValueTypes;
import com.gridnine.xtrip.common.model.rules.tripartite.AviaTripartiteContractActionsProvider;
import com.gridnine.xtrip.common.rules.elements.RuleAction;
import com.gridnine.xtrip.common.rules.elements.RuleProxy;
import com.gridnine.xtrip.common.util.UUIDGenerator;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public enum AviaTripartiteContractActions implements RuleAction
{
    AVIA_CORPORATE_ID{

        public String getDisplayName() {
            return "Corporate ID";
        }

        public String getRendererId() {
            return ValueTypes.STRING_LIST.name();
        }

        public boolean hasValue() {
            return true;
        }

        public void buildInfo(StringBuilder buf, Object value) {
            buf.append(String.format("\u0443\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c Corporate ID %s", value));
        }

        public String getRuleCategoryValue(Object actionSet, Object value) throws Exception {
            return String.format("%s-%s", this.name(), value);
        }

        public void apply(RuleProxy<?, ?> proxy, Object value) throws Exception {
            AviaTripartiteContractActionsProvider as = (AviaTripartiteContractActionsProvider)proxy.getActionSet();
            as.setCorporateIds(RulesHelper.toStringCollection(value));
            proxy.getAppliedRuleCategories().add(this.getRuleCategoryValue(proxy.getActionSet(), value));
        }

        @Override
        protected String[] getTargetIds() {
            return new String[]{Targets.PRODUCT_COMMISSION.getId(), Targets.AVIA_SUBSIDIZED.getId()};
        }
    }
    ,
    AVIA_PUBLIC_FARE_DISCOUNT{

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleAction_AviaPublicFareDiscount_displayName);
        }

        public String getRendererId() {
            return ValueTypes.TRIPARTITE_PUBLIC_FARE_DISCOUNT.name();
        }

        @Override
        protected String[] getTargetIds() {
            return new String[]{Targets.PRODUCT_COMMISSION.getId(), Targets.AVIA_SUBSIDIZED.getId()};
        }

        public boolean hasValue() {
            return true;
        }

        public void buildInfo(StringBuilder buf, Object value) {
            TripartitePublicFareDiscount discount = (TripartitePublicFareDiscount)value;
            buf.append(L10n.get((String)Messages.RuleAction_AviaPublicFareDiscount_info1));
            buf.append(" ");
            buf.append(discount.getValue());
            buf.append(discount.isRate() ? "%" : discount.getCurrency());
            if (discount.getTicketDesignator() != null && !discount.getTicketDesignator().isEmpty()) {
                buf.append(" ");
                buf.append(L10n.get((String)Messages.RuleAction_AviaPublicFareDiscount_info2));
                buf.append(" ");
                buf.append(discount.getTicketDesignator());
            }
        }

        public String getRuleCategoryValue(Object actionSet, Object value) throws Exception {
            return this.name();
        }

        public void apply(RuleProxy<?, ?> proxy, Object value) throws Exception {
            AviaTripartiteContractActionsProvider as = (AviaTripartiteContractActionsProvider)proxy.getActionSet();
            as.setPublicFareDiscount((TripartitePublicFareDiscount)value);
            proxy.getAppliedRuleCategories().add(this.getRuleCategoryValue(proxy.getActionSet(), value));
        }
    }
    ,
    AVIA_ACCOUNTING_CODE{

        public String getDisplayName() {
            return "Account code";
        }

        public String getRendererId() {
            return ValueTypes.STRING_LIST.name();
        }

        @Override
        protected String[] getTargetIds() {
            return new String[]{Targets.PRODUCT_COMMISSION.getId(), Targets.AVIA_SUBSIDIZED.getId()};
        }

        public boolean hasValue() {
            return true;
        }

        public void buildInfo(StringBuilder buf, Object value) {
            buf.append(String.format("\u0443\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c Account code %s", value));
        }

        public String getRuleCategoryValue(Object actionSet, Object value) throws Exception {
            return this.name();
        }

        public void apply(RuleProxy<?, ?> proxy, Object value) throws Exception {
            AviaTripartiteContractActionsProvider as = (AviaTripartiteContractActionsProvider)proxy.getActionSet();
            as.setAccountingCodes(RulesHelper.toStringCollection(value));
            proxy.getAppliedRuleCategories().add(this.getRuleCategoryValue(proxy.getActionSet(), value));
        }
    }
    ,
    AVIA_TEMPLATE_REMARK{

        public String getDisplayName() {
            return "\u0420\u0435\u043c\u0430\u0440\u043a\u0430 \u0432 Sabre (\u0448\u0430\u0431\u043b\u043e\u043d)";
        }

        public String getRendererId() {
            return ValueTypes.SABRE_REMARK_NO_ARGS.name();
        }

        @Override
        protected String[] getTargetIds() {
            return new String[]{Targets.PRODUCT_COMMISSION.getId()};
        }

        public boolean hasValue() {
            return true;
        }

        public void buildInfo(StringBuilder buf, Object value) {
            RulesHelper.buildRemarkInfo(buf, (SabreRemarkResult)value);
        }

        public String getRuleCategoryValue(Object actionSet, Object value) throws Exception {
            SabreRemarkResult res = (SabreRemarkResult)value;
            StringBuilder buf = new StringBuilder();
            buf.append("remark" + res.getTemplate());
            return buf.toString();
        }

        public void apply(RuleProxy<?, ?> proxy, Object value) throws Exception {
            proxy.getAppliedRuleCategories().add(UUIDGenerator.generate((boolean)false).toString());
        }
    }
    ,
    AVIA_FREE_REMARK{

        public String getDisplayName() {
            return "\u0420\u0435\u043c\u0430\u0440\u043a\u0430 \u0432 Sabre (\u0442\u0435\u043a\u0441\u0442)";
        }

        public String getRendererId() {
            return ValueTypes.STRING_LIST.name();
        }

        @Override
        protected String[] getTargetIds() {
            return new String[]{Targets.PRODUCT_COMMISSION.getId()};
        }

        public boolean hasValue() {
            return true;
        }

        public void buildInfo(StringBuilder buf, Object value) {
            buf.append(String.format("\u0434\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u0440\u0435\u043c\u0430\u0440\u043a\u0443 \u0432 Sabre: %s", value));
        }

        public String getRuleCategoryValue(Object actionSet, Object value) throws Exception {
            return this.name();
        }

        public void apply(RuleProxy<?, ?> proxy, Object value) throws Exception {
            proxy.getAppliedRuleCategories().add(UUIDGenerator.generate((boolean)false).toString());
        }
    }
    ,
    AVIA_TOUR_CODE{

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleAction_AviaTourCode_displayName);
        }

        public String getRendererId() {
            return ValueTypes.STRING_LIST.name();
        }

        @Override
        protected String[] getTargetIds() {
            return new String[]{Targets.PRODUCT_COMMISSION.getId(), Targets.AVIA_SUBSIDIZED.getId()};
        }

        public boolean hasValue() {
            return true;
        }

        public void buildInfo(StringBuilder buf, Object value) {
            buf.append(L10nResourcesManager.getStr((String)Messages.RuleAction_AviaTourCode_info, (Object[])new Object[]{value}));
        }

        public String getRuleCategoryValue(Object actionSet, Object value) throws Exception {
            return this.name();
        }

        public void apply(RuleProxy<?, ?> proxy, Object value) throws Exception {
            CommissionActionsProvider as = (CommissionActionsProvider)proxy.getActionSet();
            as.setTourCodes(RulesHelper.toStringCollection(value));
            proxy.getAppliedRuleCategories().add(this.getRuleCategoryValue(proxy.getActionSet(), value));
        }
    }
    ,
    AVIA_CALCULATION_INDICATOR{

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleAction_AviaCalculationIndicator_displayName);
        }

        public String getRendererId() {
            return ValueTypes.CALCULATION_INDICATOR.name();
        }

        @Override
        protected String[] getTargetIds() {
            return new String[]{Targets.PRODUCT_COMMISSION.getId(), Targets.AVIA_SUBSIDIZED.getId()};
        }

        public boolean hasValue() {
            return true;
        }

        public void buildInfo(StringBuilder buf, Object value) {
            buf.append(L10nResourcesManager.getStr((String)Messages.RuleAction_AviaCalculationIndicator_info, (Object[])new Object[]{value}));
        }

        public String getRuleCategoryValue(Object actionSet, Object value) throws Exception {
            return this.name();
        }

        public void apply(RuleProxy<?, ?> proxy, Object value) throws Exception {
            AviaTripartiteContractActionsProvider as = (AviaTripartiteContractActionsProvider)proxy.getActionSet();
            as.setCalculationIndicator((TripartiteContractCalculationIndicatorType)value);
            proxy.getAppliedRuleCategories().add(this.getRuleCategoryValue(proxy.getActionSet(), value));
        }
    }
    ,
    SUBSTITUTE_PASSENGER_TYPE{

        public String getDisplayName() {
            return "\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u044c \u0442\u0438\u043f \u043f\u0430\u0441\u0441\u0430\u0436\u0438\u0440\u0430";
        }

        public String getRendererId() {
            return ValueTypes.SINGLE_PASSENGER_TYPE.name();
        }

        @Override
        protected String[] getTargetIds() {
            return new String[]{Targets.PRODUCT_COMMISSION.getId()};
        }

        public boolean hasValue() {
            return true;
        }

        public void buildInfo(StringBuilder buf, Object value) {
            buf.append(String.format("\u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u044c \u0442\u0438\u043f \u043f\u0430\u0441\u0441\u0430\u0436\u0438\u0440\u0430 %s", value));
        }

        public String getRuleCategoryValue(Object actionSet, Object value) throws Exception {
            return this.name();
        }

        public void apply(RuleProxy<?, ?> proxy, Object value) throws Exception {
            AviaTripartiteContractActionsProvider as = (AviaTripartiteContractActionsProvider)proxy.getActionSet();
            as.setSubstitutePassengerType((DictionaryReference<PassengerType>)((DictionaryReference)value));
            proxy.getAppliedRuleCategories().add(this.getRuleCategoryValue(proxy.getActionSet(), value));
        }
    }
    ,
    SUBSTITUTE_BRAND_IDS{

        public String getDisplayName() {
            return "\u041f\u0440\u043e\u0438\u0437\u0432\u043e\u0434\u0438\u0442\u044c \u0437\u0430\u043c\u0435\u043d\u0443 Brand ID";
        }

        public String getRendererId() {
            return ValueTypes.STRING_MAP.name();
        }

        @Override
        protected String[] getTargetIds() {
            return new String[]{Targets.PRODUCT_COMMISSION.getId()};
        }

        public boolean hasValue() {
            return true;
        }

        public void buildInfo(StringBuilder buf, Object value) {
            Map map = Optional.ofNullable(value).map(obj -> (Map)obj).orElse(Collections.emptyMap());
            buf.append(String.format("\u043f\u0440\u043e\u0438\u0437\u0432\u043e\u0434\u0438\u0442\u044c \u0437\u0430\u043c\u0435\u043d\u0443 Brand ID %s", map.entrySet().stream().map(e -> String.join((CharSequence)"->", (CharSequence)e.getKey(), (CharSequence)e.getValue())).collect(Collectors.joining(", "))));
        }

        public String getRuleCategoryValue(Object actionSet, Object value) throws Exception {
            return this.name();
        }

        public void apply(RuleProxy<?, ?> proxy, Object value) throws Exception {
            Map<String, String> map = Optional.ofNullable(value).map(obj -> (Map)obj).orElse(Collections.emptyMap());
            AviaTripartiteContractActionsProvider as = (AviaTripartiteContractActionsProvider)proxy.getActionSet();
            as.setSubstituteBrandIds(map);
            proxy.getAppliedRuleCategories().add(this.getRuleCategoryValue(proxy.getActionSet(), value));
        }
    }
    ,
    USE_PERSON_DISCOUNT_CARD{

        public String getDisplayName() {
            return "\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u044c \u043a\u0430\u0440\u0442\u0443 \u0444\u0438\u0437\u0438\u0447\u0435\u0441\u043a\u043e\u0433\u043e \u043b\u0438\u0446\u0430";
        }

        public String getRendererId() {
            return ValueTypes.YES_NO.name();
        }

        @Override
        protected String[] getTargetIds() {
            return new String[]{Targets.PRODUCT_COMMISSION.getId()};
        }

        public boolean hasValue() {
            return true;
        }

        public void buildInfo(StringBuilder buf, Object value) {
            buf.append(String.format("\u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u044c \u043a\u0430\u0440\u0442\u0443 \u0444\u0438\u0437\u0438\u0447\u0435\u0441\u043a\u043e\u0433\u043e \u043b\u0438\u0446\u0430 %s", value));
        }

        public String getRuleCategoryValue(Object actionSet, Object value) throws Exception {
            return this.name();
        }

        public void apply(RuleProxy<?, ?> proxy, Object value) throws Exception {
            AviaTripartiteContractActionsProvider as = (AviaTripartiteContractActionsProvider)proxy.getActionSet();
            as.setUsePersonDiscountCard(Boolean.TRUE.equals(value));
            proxy.getAppliedRuleCategories().add(this.getRuleCategoryValue(proxy.getActionSet(), value));
        }
    }
    ,
    TRIPARTITE_CONTRACT_REMARK{

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleAction_TripartiteContractRemark_displayName);
        }

        public String getRendererId() {
            return ValueTypes.STRING.name();
        }

        @Override
        protected String[] getTargetIds() {
            return new String[]{Targets.PRODUCT_COMMISSION.getId(), Targets.AVIA_SUBSIDIZED.getId()};
        }

        public boolean hasValue() {
            return true;
        }

        public void buildInfo(StringBuilder buf, Object value) {
            buf.append(L10nResourcesManager.getStr((String)Messages.RuleAction_TripartiteContractRemark_info, (Object[])new Object[]{value}));
        }

        public String getRuleCategoryValue(Object actionSet, Object value) throws Exception {
            return this.name();
        }

        public void apply(RuleProxy<?, ?> proxy, Object value) throws Exception {
            AviaTripartiteContractActionsProvider as = (AviaTripartiteContractActionsProvider)proxy.getActionSet();
            as.setTripartiteContractRemark((String)value);
            proxy.getAppliedRuleCategories().add(this.getRuleCategoryValue(proxy.getActionSet(), value));
        }
    }
    ,
    CONTRACT_CODE{

        public String getDisplayName() {
            return "\u0423\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c \u043a\u043e\u0434 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430";
        }

        public String getRendererId() {
            return ValueTypes.STRING.name();
        }

        @Override
        protected String[] getTargetIds() {
            return new String[]{Targets.PRODUCT_COMMISSION.getId()};
        }

        public boolean hasValue() {
            return true;
        }

        public void buildInfo(StringBuilder buf, Object value) {
            buf.append(String.format("\u0443\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c \u043a\u043e\u0434 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430 %s", value));
        }

        public String getRuleCategoryValue(Object actionSet, Object value) throws Exception {
            return this.name();
        }

        public void apply(RuleProxy<?, ?> proxy, Object value) throws Exception {
            AviaTripartiteContractActionsProvider as = (AviaTripartiteContractActionsProvider)proxy.getActionSet();
            as.setContractCode((String)value);
            proxy.getAppliedRuleCategories().add(this.getRuleCategoryValue(proxy.getActionSet(), value));
        }
    }
    ,
    ISSUED_UNDER_3D{

        public String getDisplayName() {
            return "\u041e\u0444\u043e\u0440\u043c\u043b\u0435\u043d \u043f\u043e 3d \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0443";
        }

        public String getRendererId() {
            return ValueTypes.YES_NO.name();
        }

        @Override
        protected String[] getTargetIds() {
            return null;
        }

        public boolean hasValue() {
            return true;
        }

        public void buildInfo(StringBuilder buf, Object value) {
            if (Boolean.TRUE.equals(value)) {
                buf.append("\u041e\u0444\u043e\u0440\u043c\u043b\u0435\u043d \u043f\u043e 3d \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0443");
            } else {
                buf.append("\u041e\u0444\u043e\u0440\u043c\u043b\u0435\u043d \u043d\u0435 \u043f\u043e 3d \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0443");
            }
        }

        public String getRuleCategoryValue(Object actionSet, Object value) throws Exception {
            return this.name();
        }

        public void apply(RuleProxy<?, ?> proxy, Object value) throws Exception {
            AviaTripartiteContractActionsProvider as = (AviaTripartiteContractActionsProvider)proxy.getActionSet();
            as.setIssuedUnder3d(Boolean.TRUE.equals(value));
            proxy.getAppliedRuleCategories().add(this.getRuleCategoryValue(proxy.getActionSet(), value));
        }
    };


    public String getId() {
        return this.name();
    }

    protected abstract String[] getTargetIds();
}

