/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.rules.vat;

import com.gridnine.xtrip.common.l10n.messages.L10n;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.booking.ExtendedProductType;
import com.gridnine.xtrip.common.model.rules.l10n.Messages;
import com.gridnine.xtrip.common.model.rules.standard.Conditions;
import com.gridnine.xtrip.common.model.rules.standard.RulesHelper;
import com.gridnine.xtrip.common.model.rules.standard.ValueTypes;
import com.gridnine.xtrip.common.model.rules.vat.Targets;
import com.gridnine.xtrip.common.model.rules.vat.VatPropertySet;
import com.gridnine.xtrip.common.rules.elements.RuleCondition;
import com.gridnine.xtrip.common.rules.elements.RuleProperty;
import com.gridnine.xtrip.common.util.MiscUtil;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public enum Properties implements RuleProperty
{
    VAT_PRODUCT_TYPE{

        public String getDisplayName() {
            return L10n.get((String)Messages.VatProperties_productType);
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.VAT_CALCULATION.name()};
        }

        @Override
        String[] getConditionIds() {
            return new String[]{Conditions.EQUALS.getId(), Conditions.NOT_EQUALS.getId()};
        }

        public String getRendererId() {
            return ValueTypes.EXTENDED_PRODUCT_TYPE.name();
        }

        public void buildInfo(StringBuilder info, RuleCondition condition, Object value) {
            info.append(L10nResourcesManager.getStr((String)Messages.VatProperties_productTypeInfo, (Object[])new Object[]{condition.getDisplayName(), ((List)value).stream().map(this::productTypeToString).collect(Collectors.joining(", "))}));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            VatPropertySet ps = (VatPropertySet)propertySet;
            MiscUtil.Pair productType = Optional.ofNullable(ps.getProductType()).map(item -> new MiscUtil.Pair((Object)item.getProductType(), (Object)item.getProductDescription())).orElse(null);
            List productTypes = Optional.ofNullable((List)value).map(items -> items.stream().map(item -> new MiscUtil.Pair((Object)item.getProductType(), (Object)item.getProductDescription())).collect(Collectors.toList())).orElse(Collections.emptyList());
            if (Conditions.EQUALS.equals(condition)) {
                return productTypes.stream().anyMatch(item -> MiscUtil.equals((Object)item, (Object)productType));
            }
            if (Conditions.NOT_EQUALS.equals(condition)) {
                return !productTypes.stream().anyMatch(item -> MiscUtil.equals((Object)item, (Object)productType));
            }
            return true;
        }

        private String productTypeToString(ExtendedProductType value) {
            if (value == null) {
                return null;
            }
            if (value.getProductDescription() != null) {
                return value.getProductDescription().getCaption();
            }
            return value.getProductType() == null ? null : value.getProductType().toString();
        }
    }
    ,
    VAT_SUPPLIER{

        public String getDisplayName() {
            return L10n.get((String)Messages.VatProperties_supplier);
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.VAT_CALCULATION.name()};
        }

        @Override
        String[] getConditionIds() {
            return new String[]{Conditions.EQUALS.getId(), Conditions.NOT_EQUALS.getId()};
        }

        public String getRendererId() {
            return ValueTypes.SUPPLIERS.name();
        }

        public void buildInfo(StringBuilder info, RuleCondition condition, Object value) {
            info.append(L10nResourcesManager.getStr((String)Messages.VatProperties_supplierInfo, (Object[])new Object[]{condition.getDisplayName(), RulesHelper.toString(value)}));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            VatPropertySet ps = (VatPropertySet)propertySet;
            List suppliers = (List)value;
            if (Conditions.EQUALS.equals(condition)) {
                return suppliers.contains(ps.getSupplier());
            }
            if (Conditions.NOT_EQUALS.equals(condition)) {
                return !suppliers.contains(ps.getSupplier());
            }
            return true;
        }
    }
    ,
    VAT_VENDOR_AGREEMENT_TYPE{

        public String getDisplayName() {
            return L10n.get((String)Messages.VatProperties_vendorAgreementType);
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.VAT_CALCULATION.name()};
        }

        @Override
        String[] getConditionIds() {
            return new String[]{Conditions.INCLUDE.getId(), Conditions.EXCLUDE.getId()};
        }

        public String getRendererId() {
            return ValueTypes.AGREEMENT_TYPES.name();
        }

        public void buildInfo(StringBuilder info, RuleCondition condition, Object value) {
            info.append(L10nResourcesManager.getStr((String)Messages.VatProperties_vendorAgreementTypeInfo, (Object[])new Object[]{condition.getDisplayName(), RulesHelper.toString(value)}));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            VatPropertySet ps = (VatPropertySet)propertySet;
            List types = (List)value;
            if (Conditions.INCLUDE.equals(condition)) {
                return types.contains(ps.getVendorAgreementType());
            }
            if (Conditions.EXCLUDE.equals(condition)) {
                return !types.contains(ps.getVendorAgreementType());
            }
            return true;
        }
    }
    ,
    VAT_CLIENT_AGREEMENT_TYPE{

        public String getDisplayName() {
            return L10n.get((String)Messages.VatProperties_clientAgreementType);
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.VAT_CALCULATION.name()};
        }

        @Override
        String[] getConditionIds() {
            return new String[]{Conditions.INCLUDE.getId(), Conditions.EXCLUDE.getId()};
        }

        public String getRendererId() {
            return ValueTypes.AGREEMENT_TYPES.name();
        }

        public void buildInfo(StringBuilder info, RuleCondition condition, Object value) {
            info.append(L10nResourcesManager.getStr((String)Messages.VatProperties_clientAgreementTypeInfo, (Object[])new Object[]{condition.getDisplayName(), RulesHelper.toString(value)}));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            VatPropertySet ps = (VatPropertySet)propertySet;
            List types = (List)value;
            if (Conditions.INCLUDE.equals(condition)) {
                return types.contains(ps.getClientAgreementType());
            }
            if (Conditions.EXCLUDE.equals(condition)) {
                return !types.contains(ps.getClientAgreementType());
            }
            return true;
        }
    };


    public String getId() {
        return this.name();
    }

    abstract String[] getTargetIds();

    abstract String[] getConditionIds();
}

