/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.security.acl.resource;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.profile.Branch;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.security.acl.helper.AclModelRulesHelper;
import com.gridnine.xtrip.common.model.security.acl.resource.ModelAclEntityResources;
import com.gridnine.xtrip.common.model.security.acl.resource.ModelAclResourcePropertyConditions;
import com.gridnine.xtrip.common.security.acl.helper.AclRulesHelper;
import com.gridnine.xtrip.common.security.acl.resource.AclMatchable;
import com.gridnine.xtrip.common.security.acl.resource.AclResourceProperty;
import com.gridnine.xtrip.common.security.acl.resource.AclResourcePropertyCondition;
import com.gridnine.xtrip.common.security.acl.resource.AclResourcePropertyType;
import com.gridnine.xtrip.common.security.acl.resource.AclResourceProxy;
import com.gridnine.xtrip.common.security.acl.resource.AclResourcesEnvironment;
import com.gridnine.xtrip.common.security.acl.resource.StandardAclResourcePropertyConditions;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public enum ModelAclBranchResourceProperties implements AclResourceProperty,
AclMatchable
{
    AGENCY{

        @Override
        public String getIdSuffix() {
            return "agency";
        }

        public String getName() {
            return "\u0410\u0433\u0435\u043d\u0442\u0441\u0442\u0432\u043e";
        }

        public Class<?> getType() {
            return Organization.class;
        }

        public Set<String> getConditionIds() {
            return new HashSet<String>(Arrays.asList(StandardAclResourcePropertyConditions.EQUALS.getId(), StandardAclResourcePropertyConditions.NOT_EQUALS.getId(), StandardAclResourcePropertyConditions.INCLUDES.getId(), StandardAclResourcePropertyConditions.NOT_INCLUDES.getId(), ModelAclResourcePropertyConditions.MY_ORGANIZATIONS.getId()));
        }

        public String getRendererId(String conditionId) {
            if (StandardAclResourcePropertyConditions.EQUALS.getId().equals(conditionId) || StandardAclResourcePropertyConditions.NOT_EQUALS.getId().equals(conditionId)) {
                return AclResourcePropertyType.ENTITY.name();
            }
            if (StandardAclResourcePropertyConditions.INCLUDES.getId().equals(conditionId) || StandardAclResourcePropertyConditions.NOT_INCLUDES.getId().equals(conditionId)) {
                return AclResourcePropertyType.ENTITY_LIST.name();
            }
            return AclResourcePropertyType.NULL.name();
        }

        public void init(AclResourceProxy proxy, Object object) {
            proxy.getProperties().put(this.getId(), ((Branch)object).getAgency());
        }

        public boolean match(AclResourceProxy proxy, AclResourcePropertyCondition condition, Object value, String userId) {
            if (proxy.getProperties().containsKey(this.getId())) {
                EntityReference agency = (EntityReference)proxy.getProperties().get(this.getId());
                if (StandardAclResourcePropertyConditions.EQUALS.getId().equals(condition.getId())) {
                    return AclRulesHelper.isEquals((Object)agency, (Object)((EntityReference)value));
                }
                if (StandardAclResourcePropertyConditions.NOT_EQUALS.getId().equals(condition.getId())) {
                    return !AclRulesHelper.isEquals((Object)agency, (Object)((EntityReference)value));
                }
                if (StandardAclResourcePropertyConditions.INCLUDES.getId().equals(condition.getId())) {
                    return AclRulesHelper.isIncludes((Object)agency, (Collection)((List)value));
                }
                if (StandardAclResourcePropertyConditions.NOT_INCLUDES.getId().equals(condition.getId())) {
                    return !AclRulesHelper.isIncludes((Object)agency, (Collection)((List)value));
                }
                if (ModelAclResourcePropertyConditions.MY_ORGANIZATIONS.getId().equals(condition.getId())) {
                    return AclModelRulesHelper.isMyOrganizations((EntityReference<Organization>)agency, userId);
                }
            }
            return true;
        }
    }
    ,
    DISABLED{

        @Override
        public String getIdSuffix() {
            return "disabled";
        }

        public String getName() {
            return "\u041d\u0435 \u043e\u0442\u043e\u0431\u0440\u0430\u0436\u0430\u0442\u044c \u0432 \u0441\u043f\u0438\u0441\u043a\u0430\u0445";
        }

        public Class<?> getType() {
            return Boolean.class;
        }

        public Set<String> getConditionIds() {
            return new HashSet<String>(Arrays.asList(StandardAclResourcePropertyConditions.YES.getId(), StandardAclResourcePropertyConditions.NO.getId()));
        }

        public String getRendererId(String conditionId) {
            return AclResourcePropertyType.NULL.name();
        }

        public void init(AclResourceProxy proxy, Object object) {
            proxy.getProperties().put(this.getId(), ((Branch)object).isDisabled());
        }

        public boolean match(AclResourceProxy proxy, AclResourcePropertyCondition condition, Object value, String userId) {
            if (proxy.getProperties().containsKey(this.getId())) {
                Boolean disabled = (Boolean)proxy.getProperties().get(this.getId());
                if (StandardAclResourcePropertyConditions.YES.getId().equals(condition.getId())) {
                    return AclRulesHelper.isEquals((Object)disabled, (Object)Boolean.TRUE);
                }
                if (StandardAclResourcePropertyConditions.NO.getId().equals(condition.getId())) {
                    return AclRulesHelper.isEquals((Object)disabled, (Object)Boolean.FALSE);
                }
            }
            return true;
        }
    };


    public abstract String getIdSuffix();

    public String getId() {
        return String.format("%s.%s", this.getResourceId(), this.getIdSuffix());
    }

    public String getResourceId() {
        return ModelAclEntityResources.ENTITY_BRANCH.getId();
    }

    public String getInfo(AclResourcePropertyCondition condition, Object value) {
        AclResourcesEnvironment environment = (AclResourcesEnvironment)Environment.getPublished(AclResourcesEnvironment.class);
        String propertyName = this.getName();
        String resourceName = environment.getResource(this.getResourceId()).getName();
        return AclRulesHelper.getInfo((String)String.format("%s (%s)", propertyName, resourceName), (AclResourcePropertyCondition)condition, (Object)value);
    }
}

