/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.security.acl.resource;

import com.gridnine.xtrip.common.meta.IndexType;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.security.acl.helper.AclRulesHelper;
import com.gridnine.xtrip.common.security.acl.resource.AclQueryable;
import com.gridnine.xtrip.common.security.acl.resource.AclResourceProperty;
import com.gridnine.xtrip.common.security.acl.resource.AclResourcePropertyCondition;
import com.gridnine.xtrip.common.xml.XHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ModelAclIndexResourceOwnershipProperty
implements AclResourceProperty,
AclQueryable {
    private static final Logger log = LoggerFactory.getLogger(ModelAclIndexResourceOwnershipProperty.class);
    protected final IndexType index;
    protected final String propertyId;
    protected final String propertyName;
    protected final String propertyType;

    public ModelAclIndexResourceOwnershipProperty(IndexType index, String propertyId, String propertyName, String propertyType) {
        this.index = index;
        this.propertyId = propertyId;
        this.propertyName = propertyName;
        this.propertyType = propertyType;
    }

    public String getId() {
        return String.format("%s.%s", this.index.getId(), this.propertyId);
    }

    public String getName() {
        return this.propertyName;
    }

    public Class<?> getType() {
        try {
            return XHelper.getClass((String)this.propertyType);
        }
        catch (ClassNotFoundException e) {
            log.error(String.format("failed loading property %s class of index %s", this.propertyId, this.index.getId()), (Throwable)e);
            throw new Error(String.format("failed loading property %s class of index %s", this.propertyId, this.index.getId()), e);
        }
    }

    public String getResourceId() {
        return this.index.getId();
    }

    public String getInfo(AclResourcePropertyCondition condition, Object value) {
        return AclRulesHelper.getInfo((String)String.format("%s", this.getName()), (AclResourcePropertyCondition)condition, (Object)value);
    }

    protected SearchCriterion createContainerUidEqualsCriterion(EntityReference<? extends BaseEntity> value) {
        return AclRulesHelper.createEqualsCriterion((String)"containerUid", (Object)value.getUid());
    }

    protected SearchCriterion createContainerUidNotEqualsCriterion(EntityReference<? extends BaseEntity> value) {
        return AclRulesHelper.createNotEqualsCriterion((String)"containerUid", (Object)value.getUid());
    }

    protected SearchCriterion createContainerUidIncludesCriterion(Iterable<EntityReference<? extends BaseEntity>> iterable) {
        return AclRulesHelper.createIncludesCriterion((String)"containerUid", iterable, (boolean)false);
    }

    protected SearchCriterion createContainerUidNotIncludesCriterion(Iterable<EntityReference<? extends BaseEntity>> iterable) {
        return AclRulesHelper.createNotIncludesCriterion((String)"containerUid", iterable, (boolean)false);
    }
}

