/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.security.acl.resource;

import com.gridnine.xtrip.common.meta.IndexType;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.PersonIndex;
import com.gridnine.xtrip.common.model.security.acl.resource.ModelAclIndexResourceOwnershipProperty;
import com.gridnine.xtrip.common.model.security.acl.resource.ModelAclResourcePropertyConditions;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.security.acl.resource.AclResourcePropertyCondition;
import com.gridnine.xtrip.common.security.acl.resource.AclResourcePropertyType;
import com.gridnine.xtrip.common.security.acl.resource.StandardAclResourcePropertyConditions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelAclPersonIndexResourceOwnershipProperty
extends ModelAclIndexResourceOwnershipProperty {
    private static final Logger log = LoggerFactory.getLogger(ModelAclPersonIndexResourceOwnershipProperty.class);

    public ModelAclPersonIndexResourceOwnershipProperty(IndexType index, String propertyId, String propertyName, String propertyType) {
        super(index, propertyId, propertyName, propertyType);
    }

    public Set<String> getConditionIds() {
        return new HashSet<String>(Arrays.asList(StandardAclResourcePropertyConditions.INCLUDES.getId(), StandardAclResourcePropertyConditions.NOT_INCLUDES.getId(), ModelAclResourcePropertyConditions.MY_ORGANIZATIONS_HOLDINGS_ORGANIZATIONS_PERSONS.getId(), ModelAclResourcePropertyConditions.MY_ORGANIZATIONS_CHILDREN_PERSONS.getId(), ModelAclResourcePropertyConditions.MY_ORGANIZATIONS_PERSONS.getId(), ModelAclResourcePropertyConditions.MY_PERSONS.getId(), ModelAclResourcePropertyConditions.MY_ORGANIZATIONS_CUSTOMERS_PERSONS.getId()));
    }

    public String getRendererId(String conditionId) {
        if (StandardAclResourcePropertyConditions.INCLUDES.getId().equals(conditionId) || StandardAclResourcePropertyConditions.NOT_INCLUDES.getId().equals(conditionId)) {
            return AclResourcePropertyType.ENTITY_LIST.name();
        }
        return AclResourcePropertyType.NULL.name();
    }

    public SearchCriterion getQuery(AclResourcePropertyCondition condition, Object value, String userId) {
        if (StandardAclResourcePropertyConditions.INCLUDES.getId().equals(condition.getId())) {
            return this.createContainerUidIncludesCriterion((Iterable)value);
        }
        if (StandardAclResourcePropertyConditions.NOT_INCLUDES.getId().equals(condition.getId())) {
            return this.createContainerUidNotIncludesCriterion((Iterable)value);
        }
        if (ModelAclResourcePropertyConditions.MY_ORGANIZATIONS_HOLDINGS_ORGANIZATIONS_PERSONS.getId().equals(condition.getId()) || ModelAclResourcePropertyConditions.MY_ORGANIZATIONS_CHILDREN_PERSONS.getId().equals(condition.getId()) || ModelAclResourcePropertyConditions.MY_ORGANIZATIONS_PERSONS.getId().equals(condition.getId()) || ModelAclResourcePropertyConditions.MY_ORGANIZATIONS_CUSTOMERS_PERSONS.getId().equals(condition.getId()) || ModelAclResourcePropertyConditions.MY_PERSONS.getId().equals(condition.getId())) {
            ArrayList<EntityReference<? extends BaseEntity>> persons = new ArrayList<EntityReference<? extends BaseEntity>>();
            try {
                EntityContainer person = EntityStorage.get().find(PersonIndex.class, PersonIndex.Property.loginName.name(), (Object)userId);
                if (person != null) {
                    if (ModelAclResourcePropertyConditions.MY_ORGANIZATIONS_HOLDINGS_ORGANIZATIONS_PERSONS.getId().equals(condition.getId())) {
                        List<EntityReference<Organization>> organizations = ProfileHelper.getHoldingOrganizations(ProfileHelper.getOrganizationHoldings(ProfileHelper.getPersonOrganizations(Arrays.asList(person.toReference()), null, new Date())));
                        ArrayList<SearchCriterion> criterions = new ArrayList<SearchCriterion>();
                        for (EntityReference<Organization> organization : organizations) {
                            criterions.add(SearchCriterion.contains((String)PersonIndex.Property.employmentsUids.name(), (Object)organization.getUid()));
                        }
                        return SearchCriterion.or((SearchCriterion[])criterions.toArray(new SearchCriterion[criterions.size()]));
                    }
                    if (ModelAclResourcePropertyConditions.MY_ORGANIZATIONS_CHILDREN_PERSONS.getId().equals(condition.getId())) {
                        List<EntityReference<Organization>> organizations = ProfileHelper.getPersonOrganizations(Arrays.asList(person.toReference()), null, new Date());
                        ArrayList<SearchCriterion> criterions = new ArrayList<SearchCriterion>();
                        for (EntityReference<Organization> organization : organizations) {
                            criterions.add(SearchCriterion.contains((String)PersonIndex.Property.parentOrganizationUids.name(), (Object)organization.getUid()));
                        }
                        return SearchCriterion.or((SearchCriterion[])criterions.toArray(new SearchCriterion[criterions.size()]));
                    }
                    if (ModelAclResourcePropertyConditions.MY_ORGANIZATIONS_PERSONS.getId().equals(condition.getId())) {
                        List<EntityReference<Organization>> organizations = ProfileHelper.getPersonOrganizations(Arrays.asList(person.toReference()), null, new Date());
                        ArrayList<SearchCriterion> criterions = new ArrayList<SearchCriterion>();
                        for (EntityReference<Organization> organization : organizations) {
                            criterions.add(SearchCriterion.contains((String)PersonIndex.Property.employmentsUids.name(), (Object)organization.getUid()));
                        }
                        return SearchCriterion.or((SearchCriterion[])criterions.toArray(new SearchCriterion[criterions.size()]));
                    }
                    if (ModelAclResourcePropertyConditions.MY_PERSONS.getId().equals(condition.getId())) {
                        persons.add((EntityReference<? extends BaseEntity>)person.toReference());
                    } else if (ModelAclResourcePropertyConditions.MY_ORGANIZATIONS_CUSTOMERS_PERSONS.getId().equals(condition.getId())) {
                        persons.addAll(ProfileHelper.getPersonsOrganizationsCustomersPersons((EntityContainer<Person>)person));
                    }
                }
            }
            catch (Exception e) {
                log.error("unable to collect entities", (Throwable)e);
            }
            return this.createContainerUidIncludesCriterion(persons);
        }
        return null;
    }
}

