/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.security.acl.resource;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.commission.ProductType;
import com.gridnine.xtrip.common.model.booking.misc.UniversalProductDescription;
import com.gridnine.xtrip.common.model.handlers.HandlersRegistry;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.model.security.acl.helper.AclModelRulesHelper;
import com.gridnine.xtrip.common.model.security.acl.resource.ModelAclEntityResources;
import com.gridnine.xtrip.common.model.security.acl.resource.ModelAclResourcePropertyConditions;
import com.gridnine.xtrip.common.security.acl.helper.AclRulesHelper;
import com.gridnine.xtrip.common.security.acl.resource.AclMatchable;
import com.gridnine.xtrip.common.security.acl.resource.AclResourceProperty;
import com.gridnine.xtrip.common.security.acl.resource.AclResourcePropertyCondition;
import com.gridnine.xtrip.common.security.acl.resource.AclResourcePropertyType;
import com.gridnine.xtrip.common.security.acl.resource.AclResourceProxy;
import com.gridnine.xtrip.common.security.acl.resource.AclResourcesEnvironment;
import com.gridnine.xtrip.common.security.acl.resource.StandardAclResourcePropertyConditions;
import com.gridnine.xtrip.common.util.DateInterval;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public enum ModelAclProductResourceProperties implements AclResourceProperty,
AclMatchable
{
    TYPE{

        @Override
        public String getIdSuffix() {
            return "type";
        }

        public String getName() {
            return "\u0422\u0438\u043f";
        }

        public Class<?> getType() {
            return ProductType.class;
        }

        public Set<String> getConditionIds() {
            return new HashSet<String>(Arrays.asList(StandardAclResourcePropertyConditions.EQUALS.getId(), StandardAclResourcePropertyConditions.NOT_EQUALS.getId(), StandardAclResourcePropertyConditions.INCLUDES.getId(), StandardAclResourcePropertyConditions.NOT_INCLUDES.getId()));
        }

        public String getRendererId(String conditionId) {
            if (StandardAclResourcePropertyConditions.EQUALS.getId().equals(conditionId) || StandardAclResourcePropertyConditions.NOT_EQUALS.getId().equals(conditionId)) {
                return AclResourcePropertyType.ENUM.name();
            }
            if (StandardAclResourcePropertyConditions.INCLUDES.getId().equals(conditionId) || StandardAclResourcePropertyConditions.NOT_INCLUDES.getId().equals(conditionId)) {
                return AclResourcePropertyType.ENUM_LIST.name();
            }
            return AclResourcePropertyType.NULL.name();
        }

        public void init(AclResourceProxy proxy, Object object) {
            BaseProduct baseProduct = (BaseProduct)object;
            ProductHandler<?> handler = HandlersRegistry.get().findProductHandler(baseProduct.getClass());
            if (handler != null) {
                proxy.getProperties().put(this.getId(), handler.getProductType(baseProduct));
            }
        }

        public boolean match(AclResourceProxy proxy, AclResourcePropertyCondition condition, Object value, String userId) {
            if (proxy.getProperties().containsKey(this.getId())) {
                ProductType productType = (ProductType)proxy.getProperties().get(this.getId());
                if (StandardAclResourcePropertyConditions.EQUALS.getId().equals(condition.getId())) {
                    return AclRulesHelper.isEquals((Object)productType, (Object)((ProductType)value));
                }
                if (StandardAclResourcePropertyConditions.NOT_EQUALS.getId().equals(condition.getId())) {
                    return !AclRulesHelper.isEquals((Object)productType, (Object)((ProductType)value));
                }
                if (StandardAclResourcePropertyConditions.INCLUDES.getId().equals(condition.getId())) {
                    return AclRulesHelper.isIncludes((Object)productType, (Collection)((List)value));
                }
                if (StandardAclResourcePropertyConditions.NOT_INCLUDES.getId().equals(condition.getId())) {
                    return !AclRulesHelper.isIncludes((Object)productType, (Collection)((List)value));
                }
            }
            return true;
        }
    }
    ,
    STATUS{

        @Override
        public String getIdSuffix() {
            return "status";
        }

        public String getName() {
            return "\u0421\u0442\u0430\u0442\u0443\u0441";
        }

        public Class<?> getType() {
            return ProductStatus.class;
        }

        public Set<String> getConditionIds() {
            return new HashSet<String>(Arrays.asList(StandardAclResourcePropertyConditions.EQUALS.getId(), StandardAclResourcePropertyConditions.NOT_EQUALS.getId(), StandardAclResourcePropertyConditions.INCLUDES.getId(), StandardAclResourcePropertyConditions.NOT_INCLUDES.getId()));
        }

        public String getRendererId(String conditionId) {
            if (StandardAclResourcePropertyConditions.EQUALS.getId().equals(conditionId) || StandardAclResourcePropertyConditions.NOT_EQUALS.getId().equals(conditionId)) {
                return AclResourcePropertyType.ENUM.name();
            }
            if (StandardAclResourcePropertyConditions.INCLUDES.getId().equals(conditionId) || StandardAclResourcePropertyConditions.NOT_INCLUDES.getId().equals(conditionId)) {
                return AclResourcePropertyType.ENUM_LIST.name();
            }
            return AclResourcePropertyType.NULL.name();
        }

        public void init(AclResourceProxy proxy, Object object) {
            BaseProduct baseProduct = (BaseProduct)object;
            ProductHandler<?> handler = HandlersRegistry.get().findProductHandler(baseProduct.getClass());
            if (handler != null) {
                proxy.getProperties().put(this.getId(), handler.getStatus(baseProduct));
            }
        }

        public boolean match(AclResourceProxy proxy, AclResourcePropertyCondition condition, Object value, String userId) {
            if (proxy.getProperties().containsKey(this.getId())) {
                ProductStatus productStatus = (ProductStatus)proxy.getProperties().get(this.getId());
                if (StandardAclResourcePropertyConditions.EQUALS.getId().equals(condition.getId())) {
                    return AclRulesHelper.isEquals((Object)productStatus, (Object)((ProductStatus)value));
                }
                if (StandardAclResourcePropertyConditions.NOT_EQUALS.getId().equals(condition.getId())) {
                    return !AclRulesHelper.isEquals((Object)productStatus, (Object)((ProductStatus)value));
                }
                if (StandardAclResourcePropertyConditions.INCLUDES.getId().equals(condition.getId())) {
                    return AclRulesHelper.isIncludes((Object)productStatus, (Collection)((List)value));
                }
                if (StandardAclResourcePropertyConditions.NOT_INCLUDES.getId().equals(condition.getId())) {
                    return !AclRulesHelper.isIncludes((Object)productStatus, (Collection)((List)value));
                }
            }
            return true;
        }
    }
    ,
    BLANK_OWNER{

        @Override
        public String getIdSuffix() {
            return "blankOwner";
        }

        public String getName() {
            return "\u0412\u043b\u0430\u0434\u0435\u043b\u0435\u0446 \u0431\u043b\u0430\u043d\u043a\u043e\u0432";
        }

        public Class<?> getType() {
            return Organization.class;
        }

        public Set<String> getConditionIds() {
            return new HashSet<String>(Arrays.asList(StandardAclResourcePropertyConditions.EQUALS.getId(), StandardAclResourcePropertyConditions.NOT_EQUALS.getId(), StandardAclResourcePropertyConditions.INCLUDES.getId(), StandardAclResourcePropertyConditions.NOT_INCLUDES.getId(), ModelAclResourcePropertyConditions.MY_ORGANIZATIONS.getId()));
        }

        public String getRendererId(String conditionId) {
            if (StandardAclResourcePropertyConditions.EQUALS.getId().equals(conditionId) || StandardAclResourcePropertyConditions.NOT_EQUALS.getId().equals(conditionId)) {
                return AclResourcePropertyType.ENTITY.name();
            }
            if (StandardAclResourcePropertyConditions.INCLUDES.getId().equals(conditionId) || StandardAclResourcePropertyConditions.NOT_INCLUDES.getId().equals(conditionId)) {
                return AclResourcePropertyType.ENTITY_LIST.name();
            }
            return AclResourcePropertyType.NULL.name();
        }

        public void init(AclResourceProxy proxy, Object object) {
            BaseProduct baseProduct = (BaseProduct)object;
            ProductHandler<?> handler = HandlersRegistry.get().findProductHandler(baseProduct.getClass());
            if (handler != null) {
                proxy.getProperties().put(this.getId(), handler.getBlankOwner(baseProduct));
            }
        }

        public boolean match(AclResourceProxy proxy, AclResourcePropertyCondition condition, Object value, String userId) {
            if (proxy.getProperties().containsKey(this.getId())) {
                EntityReference blankOwner = (EntityReference)proxy.getProperties().get(this.getId());
                if (StandardAclResourcePropertyConditions.EQUALS.getId().equals(condition.getId())) {
                    return AclRulesHelper.isEquals((Object)blankOwner, (Object)((EntityReference)value));
                }
                if (StandardAclResourcePropertyConditions.NOT_EQUALS.getId().equals(condition.getId())) {
                    return !AclRulesHelper.isEquals((Object)blankOwner, (Object)((EntityReference)value));
                }
                if (StandardAclResourcePropertyConditions.INCLUDES.getId().equals(condition.getId())) {
                    return AclRulesHelper.isIncludes((Object)blankOwner, (Collection)((List)value));
                }
                if (StandardAclResourcePropertyConditions.NOT_INCLUDES.getId().equals(condition.getId())) {
                    return !AclRulesHelper.isIncludes((Object)blankOwner, (Collection)((List)value));
                }
                if (ModelAclResourcePropertyConditions.MY_ORGANIZATIONS.getId().equals(condition.getId())) {
                    return AclModelRulesHelper.isMyOrganizations((EntityReference<Organization>)blankOwner, userId);
                }
            }
            return true;
        }
    }
    ,
    PROVIDER{

        @Override
        public String getIdSuffix() {
            return "provider";
        }

        public String getName() {
            return "\u041f\u0440\u043e\u0432\u0430\u0439\u0434\u0435\u0440";
        }

        public Class<?> getType() {
            return Organization.class;
        }

        public Set<String> getConditionIds() {
            return new HashSet<String>(Arrays.asList(StandardAclResourcePropertyConditions.EQUALS.getId(), StandardAclResourcePropertyConditions.NOT_EQUALS.getId(), StandardAclResourcePropertyConditions.INCLUDES.getId(), StandardAclResourcePropertyConditions.NOT_INCLUDES.getId(), ModelAclResourcePropertyConditions.MY_ORGANIZATIONS.getId()));
        }

        public String getRendererId(String conditionId) {
            if (StandardAclResourcePropertyConditions.EQUALS.getId().equals(conditionId) || StandardAclResourcePropertyConditions.NOT_EQUALS.getId().equals(conditionId)) {
                return AclResourcePropertyType.ENTITY.name();
            }
            if (StandardAclResourcePropertyConditions.INCLUDES.getId().equals(conditionId) || StandardAclResourcePropertyConditions.NOT_INCLUDES.getId().equals(conditionId)) {
                return AclResourcePropertyType.ENTITY_LIST.name();
            }
            return AclResourcePropertyType.NULL.name();
        }

        public void init(AclResourceProxy proxy, Object object) {
            BaseProduct baseProduct = (BaseProduct)object;
            ProductHandler<?> handler = HandlersRegistry.get().findProductHandler(baseProduct.getClass());
            if (handler != null) {
                proxy.getProperties().put(this.getId(), handler.getProvider(baseProduct));
            }
        }

        public boolean match(AclResourceProxy proxy, AclResourcePropertyCondition condition, Object value, String userId) {
            if (proxy.getProperties().containsKey(this.getId())) {
                EntityReference provider = (EntityReference)proxy.getProperties().get(this.getId());
                if (StandardAclResourcePropertyConditions.EQUALS.getId().equals(condition.getId())) {
                    return AclRulesHelper.isEquals((Object)provider, (Object)((EntityReference)value));
                }
                if (StandardAclResourcePropertyConditions.NOT_EQUALS.getId().equals(condition.getId())) {
                    return !AclRulesHelper.isEquals((Object)provider, (Object)((EntityReference)value));
                }
                if (StandardAclResourcePropertyConditions.INCLUDES.getId().equals(condition.getId())) {
                    return AclRulesHelper.isIncludes((Object)provider, (Collection)((List)value));
                }
                if (StandardAclResourcePropertyConditions.NOT_INCLUDES.getId().equals(condition.getId())) {
                    return !AclRulesHelper.isIncludes((Object)provider, (Collection)((List)value));
                }
                if (ModelAclResourcePropertyConditions.MY_ORGANIZATIONS.getId().equals(condition.getId())) {
                    return AclModelRulesHelper.isMyOrganizations((EntityReference<Organization>)provider, userId);
                }
            }
            return true;
        }
    }
    ,
    SUPPLIER{

        @Override
        public String getIdSuffix() {
            return "supplier";
        }

        public String getName() {
            return "\u041f\u043e\u0441\u0442\u0430\u0432\u0449\u0438\u043a";
        }

        public Class<?> getType() {
            return Organization.class;
        }

        public Set<String> getConditionIds() {
            return new HashSet<String>(Arrays.asList(StandardAclResourcePropertyConditions.EQUALS.getId(), StandardAclResourcePropertyConditions.NOT_EQUALS.getId(), StandardAclResourcePropertyConditions.INCLUDES.getId(), StandardAclResourcePropertyConditions.NOT_INCLUDES.getId(), ModelAclResourcePropertyConditions.MY_ORGANIZATIONS.getId()));
        }

        public String getRendererId(String conditionId) {
            if (StandardAclResourcePropertyConditions.EQUALS.getId().equals(conditionId) || StandardAclResourcePropertyConditions.NOT_EQUALS.getId().equals(conditionId)) {
                return AclResourcePropertyType.ENTITY.name();
            }
            if (StandardAclResourcePropertyConditions.INCLUDES.getId().equals(conditionId) || StandardAclResourcePropertyConditions.NOT_INCLUDES.getId().equals(conditionId)) {
                return AclResourcePropertyType.ENTITY_LIST.name();
            }
            return AclResourcePropertyType.NULL.name();
        }

        public void init(AclResourceProxy proxy, Object object) {
            BaseProduct baseProduct = (BaseProduct)object;
            ProductHandler<?> handler = HandlersRegistry.get().findProductHandler(baseProduct.getClass());
            if (handler != null) {
                proxy.getProperties().put(this.getId(), GeneralProductHelper.getSupplier(baseProduct));
            }
        }

        public boolean match(AclResourceProxy proxy, AclResourcePropertyCondition condition, Object value, String userId) {
            if (proxy.getProperties().containsKey(this.getId())) {
                EntityReference supplier = (EntityReference)proxy.getProperties().get(this.getId());
                if (StandardAclResourcePropertyConditions.EQUALS.getId().equals(condition.getId())) {
                    return AclRulesHelper.isEquals((Object)supplier, (Object)((EntityReference)value));
                }
                if (StandardAclResourcePropertyConditions.NOT_EQUALS.getId().equals(condition.getId())) {
                    return !AclRulesHelper.isEquals((Object)supplier, (Object)((EntityReference)value));
                }
                if (StandardAclResourcePropertyConditions.INCLUDES.getId().equals(condition.getId())) {
                    return AclRulesHelper.isIncludes((Object)supplier, (Collection)((List)value));
                }
                if (StandardAclResourcePropertyConditions.NOT_INCLUDES.getId().equals(condition.getId())) {
                    return !AclRulesHelper.isIncludes((Object)supplier, (Collection)((List)value));
                }
                if (ModelAclResourcePropertyConditions.MY_ORGANIZATIONS.getId().equals(condition.getId())) {
                    return AclModelRulesHelper.isMyOrganizations((EntityReference<Organization>)supplier, userId);
                }
            }
            return true;
        }
    }
    ,
    ISSUE_DATE{

        @Override
        public String getIdSuffix() {
            return "issueDate";
        }

        public String getName() {
            return "\u0414\u0430\u0442\u0430 \u0432\u044b\u043f\u0438\u0441\u043a\u0438";
        }

        public Class<?> getType() {
            return Date.class;
        }

        public Set<String> getConditionIds() {
            return new HashSet<String>(Arrays.asList(StandardAclResourcePropertyConditions.EQUALS.getId(), StandardAclResourcePropertyConditions.NOT_EQUALS.getId(), StandardAclResourcePropertyConditions.PERIOD_WITHIN.getId(), StandardAclResourcePropertyConditions.PERIOD_BEYOND.getId(), StandardAclResourcePropertyConditions.TODAY.getId(), StandardAclResourcePropertyConditions.YESTERDAY.getId(), StandardAclResourcePropertyConditions.CURRENT_DECADE.getId(), StandardAclResourcePropertyConditions.LAST_DECADE.getId(), StandardAclResourcePropertyConditions.NULL.getId(), StandardAclResourcePropertyConditions.NOT_NULL.getId()));
        }

        public String getRendererId(String conditionId) {
            if (StandardAclResourcePropertyConditions.EQUALS.getId().equals(conditionId) || StandardAclResourcePropertyConditions.NOT_EQUALS.getId().equals(conditionId)) {
                return AclResourcePropertyType.DATE_TIME.name();
            }
            if (StandardAclResourcePropertyConditions.PERIOD_WITHIN.getId().equals(conditionId) || StandardAclResourcePropertyConditions.PERIOD_BEYOND.getId().equals(conditionId)) {
                return AclResourcePropertyType.DATE_TIME_INTERVAL.name();
            }
            return AclResourcePropertyType.NULL.name();
        }

        public void init(AclResourceProxy proxy, Object object) {
            BaseProduct baseProduct = (BaseProduct)object;
            ProductHandler<?> handler = HandlersRegistry.get().findProductHandler(baseProduct.getClass());
            if (handler != null) {
                proxy.getProperties().put(this.getId(), handler.findIssueDate(baseProduct));
            }
        }

        public boolean match(AclResourceProxy proxy, AclResourcePropertyCondition condition, Object value, String userId) {
            if (proxy.getProperties().containsKey(this.getId())) {
                Date issueDate = (Date)proxy.getProperties().get(this.getId());
                if (StandardAclResourcePropertyConditions.EQUALS.getId().equals(condition.getId())) {
                    return AclRulesHelper.isEquals((Object)issueDate, (Object)((Date)value));
                }
                if (StandardAclResourcePropertyConditions.NOT_EQUALS.getId().equals(condition.getId())) {
                    return !AclRulesHelper.isEquals((Object)issueDate, (Object)((Date)value));
                }
                if (StandardAclResourcePropertyConditions.PERIOD_WITHIN.getId().equals(condition.getId())) {
                    return AclRulesHelper.isWithin((Date)issueDate, (DateInterval)((DateInterval)value));
                }
                if (StandardAclResourcePropertyConditions.PERIOD_BEYOND.getId().equals(condition.getId())) {
                    return !AclRulesHelper.isWithin((Date)issueDate, (DateInterval)((DateInterval)value));
                }
                if (StandardAclResourcePropertyConditions.TODAY.getId().equals(condition.getId())) {
                    return AclRulesHelper.isToday((Date)issueDate);
                }
                if (StandardAclResourcePropertyConditions.YESTERDAY.getId().equals(condition.getId())) {
                    return AclRulesHelper.isYesterday((Date)issueDate);
                }
                if (StandardAclResourcePropertyConditions.CURRENT_DECADE.getId().equals(condition.getId())) {
                    return AclRulesHelper.isCurrentDecade((Date)issueDate);
                }
                if (StandardAclResourcePropertyConditions.LAST_DECADE.getId().equals(condition.getId())) {
                    return AclRulesHelper.isLastDecade((Date)issueDate);
                }
                if (StandardAclResourcePropertyConditions.NULL.getId().equals(condition.getId())) {
                    return AclRulesHelper.isNull((Object)issueDate);
                }
                if (StandardAclResourcePropertyConditions.NOT_NULL.getId().equals(condition.getId())) {
                    return !AclRulesHelper.isNull((Object)issueDate);
                }
            }
            return true;
        }
    }
    ,
    AGENCY{

        @Override
        public String getIdSuffix() {
            return "agency";
        }

        public String getName() {
            return "\u0410\u0433\u0435\u043d\u0442\u0441\u0442\u0432\u043e";
        }

        public Class<?> getType() {
            return Organization.class;
        }

        public Set<String> getConditionIds() {
            return new HashSet<String>(Arrays.asList(StandardAclResourcePropertyConditions.EQUALS.getId(), StandardAclResourcePropertyConditions.NOT_EQUALS.getId(), StandardAclResourcePropertyConditions.INCLUDES.getId(), StandardAclResourcePropertyConditions.NOT_INCLUDES.getId(), ModelAclResourcePropertyConditions.MY_ORGANIZATIONS.getId()));
        }

        public String getRendererId(String conditionId) {
            if (StandardAclResourcePropertyConditions.EQUALS.getId().equals(conditionId) || StandardAclResourcePropertyConditions.NOT_EQUALS.getId().equals(conditionId)) {
                return AclResourcePropertyType.ENTITY.name();
            }
            if (StandardAclResourcePropertyConditions.INCLUDES.getId().equals(conditionId) || StandardAclResourcePropertyConditions.NOT_INCLUDES.getId().equals(conditionId)) {
                return AclResourcePropertyType.ENTITY_LIST.name();
            }
            return AclResourcePropertyType.NULL.name();
        }

        public void init(AclResourceProxy proxy, Object object) {
            BaseProduct baseProduct = (BaseProduct)object;
            ProductHandler<?> handler = HandlersRegistry.get().findProductHandler(baseProduct.getClass());
            if (handler != null) {
                proxy.getProperties().put(this.getId(), GeneralProductHelper.getAgency(baseProduct));
            }
        }

        public boolean match(AclResourceProxy proxy, AclResourcePropertyCondition condition, Object value, String userId) {
            if (proxy.getProperties().containsKey(this.getId())) {
                EntityReference agency = (EntityReference)proxy.getProperties().get(this.getId());
                if (StandardAclResourcePropertyConditions.EQUALS.getId().equals(condition.getId())) {
                    return AclRulesHelper.isEquals((Object)agency, (Object)((EntityReference)value));
                }
                if (StandardAclResourcePropertyConditions.NOT_EQUALS.getId().equals(condition.getId())) {
                    return !AclRulesHelper.isEquals((Object)agency, (Object)((EntityReference)value));
                }
                if (StandardAclResourcePropertyConditions.INCLUDES.getId().equals(condition.getId())) {
                    return AclRulesHelper.isIncludes((Object)agency, (Collection)((List)value));
                }
                if (StandardAclResourcePropertyConditions.NOT_INCLUDES.getId().equals(condition.getId())) {
                    return !AclRulesHelper.isIncludes((Object)agency, (Collection)((List)value));
                }
                if (ModelAclResourcePropertyConditions.MY_ORGANIZATIONS.getId().equals(condition.getId())) {
                    return AclModelRulesHelper.isMyOrganizations((EntityReference<Organization>)agency, userId);
                }
            }
            return true;
        }
    }
    ,
    SUBAGENCY{

        @Override
        public String getIdSuffix() {
            return "subagency";
        }

        public String getName() {
            return "\u0421\u0443\u0431\u0430\u0433\u0435\u043d\u0442\u0441\u0442\u0432\u043e";
        }

        public Class<?> getType() {
            return Organization.class;
        }

        public Set<String> getConditionIds() {
            return new HashSet<String>(Arrays.asList(StandardAclResourcePropertyConditions.EQUALS.getId(), StandardAclResourcePropertyConditions.NOT_EQUALS.getId(), StandardAclResourcePropertyConditions.INCLUDES.getId(), StandardAclResourcePropertyConditions.NOT_INCLUDES.getId(), ModelAclResourcePropertyConditions.MY_ORGANIZATIONS.getId()));
        }

        public String getRendererId(String conditionId) {
            if (StandardAclResourcePropertyConditions.EQUALS.getId().equals(conditionId) || StandardAclResourcePropertyConditions.NOT_EQUALS.getId().equals(conditionId)) {
                return AclResourcePropertyType.ENTITY.name();
            }
            if (StandardAclResourcePropertyConditions.INCLUDES.getId().equals(conditionId) || StandardAclResourcePropertyConditions.NOT_INCLUDES.getId().equals(conditionId)) {
                return AclResourcePropertyType.ENTITY_LIST.name();
            }
            return AclResourcePropertyType.NULL.name();
        }

        public void init(AclResourceProxy proxy, Object object) {
            BaseProduct baseProduct = (BaseProduct)object;
            ProductHandler<?> handler = HandlersRegistry.get().findProductHandler(baseProduct.getClass());
            if (handler != null) {
                proxy.getProperties().put(this.getId(), GeneralProductHelper.getSubagency(baseProduct));
            }
        }

        public boolean match(AclResourceProxy proxy, AclResourcePropertyCondition condition, Object value, String userId) {
            if (proxy.getProperties().containsKey(this.getId())) {
                EntityReference subagency = (EntityReference)proxy.getProperties().get(this.getId());
                if (StandardAclResourcePropertyConditions.EQUALS.getId().equals(condition.getId())) {
                    return AclRulesHelper.isEquals((Object)subagency, (Object)((EntityReference)value));
                }
                if (StandardAclResourcePropertyConditions.NOT_EQUALS.getId().equals(condition.getId())) {
                    return !AclRulesHelper.isEquals((Object)subagency, (Object)((EntityReference)value));
                }
                if (StandardAclResourcePropertyConditions.INCLUDES.getId().equals(condition.getId())) {
                    return AclRulesHelper.isIncludes((Object)subagency, (Collection)((List)value));
                }
                if (StandardAclResourcePropertyConditions.NOT_INCLUDES.getId().equals(condition.getId())) {
                    return !AclRulesHelper.isIncludes((Object)subagency, (Collection)((List)value));
                }
                if (ModelAclResourcePropertyConditions.MY_ORGANIZATIONS.getId().equals(condition.getId())) {
                    return AclModelRulesHelper.isMyOrganizations((EntityReference<Organization>)subagency, userId);
                }
            }
            return true;
        }
    }
    ,
    SALES_POINT{

        @Override
        public String getIdSuffix() {
            return "salesPoint";
        }

        public String getName() {
            return "\u0422\u043e\u0447\u043a\u0430 \u043f\u0440\u043e\u0434\u0430\u0436";
        }

        public Class<?> getType() {
            return SalesPoint.class;
        }

        public Set<String> getConditionIds() {
            return new HashSet<String>(Arrays.asList(StandardAclResourcePropertyConditions.EQUALS.getId(), StandardAclResourcePropertyConditions.NOT_EQUALS.getId(), StandardAclResourcePropertyConditions.INCLUDES.getId(), StandardAclResourcePropertyConditions.NOT_INCLUDES.getId(), ModelAclResourcePropertyConditions.MY_SALES_POINTS.getId()));
        }

        public String getRendererId(String conditionId) {
            if (StandardAclResourcePropertyConditions.EQUALS.getId().equals(conditionId) || StandardAclResourcePropertyConditions.NOT_EQUALS.getId().equals(conditionId)) {
                return AclResourcePropertyType.ENTITY.name();
            }
            if (StandardAclResourcePropertyConditions.INCLUDES.getId().equals(conditionId) || StandardAclResourcePropertyConditions.NOT_INCLUDES.getId().equals(conditionId)) {
                return AclResourcePropertyType.ENTITY_LIST.name();
            }
            return AclResourcePropertyType.NULL.name();
        }

        public void init(AclResourceProxy proxy, Object object) {
            BaseProduct baseProduct = (BaseProduct)object;
            ProductHandler<?> handler = HandlersRegistry.get().findProductHandler(baseProduct.getClass());
            if (handler != null) {
                proxy.getProperties().put(this.getId(), handler.findSalesPoint(baseProduct));
            }
        }

        public boolean match(AclResourceProxy proxy, AclResourcePropertyCondition condition, Object value, String userId) {
            if (proxy.getProperties().containsKey(this.getId())) {
                EntityReference salesPoint = (EntityReference)proxy.getProperties().get(this.getId());
                if (StandardAclResourcePropertyConditions.EQUALS.getId().equals(condition.getId())) {
                    return AclRulesHelper.isEquals((Object)salesPoint, (Object)((EntityReference)value));
                }
                if (StandardAclResourcePropertyConditions.NOT_EQUALS.getId().equals(condition.getId())) {
                    return !AclRulesHelper.isEquals((Object)salesPoint, (Object)((EntityReference)value));
                }
                if (StandardAclResourcePropertyConditions.INCLUDES.getId().equals(condition.getId())) {
                    return AclRulesHelper.isIncludes((Object)salesPoint, (Collection)((List)value));
                }
                if (StandardAclResourcePropertyConditions.NOT_INCLUDES.getId().equals(condition.getId())) {
                    return !AclRulesHelper.isIncludes((Object)salesPoint, (Collection)((List)value));
                }
                if (ModelAclResourcePropertyConditions.MY_SALES_POINTS.getId().equals(condition.getId())) {
                    return AclModelRulesHelper.isMySalesPoints((EntityReference<SalesPoint>)salesPoint, userId);
                }
            }
            return true;
        }
    }
    ,
    AGENT{

        @Override
        public String getIdSuffix() {
            return "agent";
        }

        public String getName() {
            return "\u0410\u0433\u0435\u043d\u0442";
        }

        public Class<?> getType() {
            return Person.class;
        }

        public Set<String> getConditionIds() {
            return new HashSet<String>(Arrays.asList(StandardAclResourcePropertyConditions.EQUALS.getId(), StandardAclResourcePropertyConditions.NOT_EQUALS.getId(), StandardAclResourcePropertyConditions.INCLUDES.getId(), StandardAclResourcePropertyConditions.NOT_INCLUDES.getId(), ModelAclResourcePropertyConditions.MY_PERSONS.getId()));
        }

        public String getRendererId(String conditionId) {
            if (StandardAclResourcePropertyConditions.EQUALS.getId().equals(conditionId) || StandardAclResourcePropertyConditions.NOT_EQUALS.getId().equals(conditionId)) {
                return AclResourcePropertyType.ENTITY.name();
            }
            if (StandardAclResourcePropertyConditions.INCLUDES.getId().equals(conditionId) || StandardAclResourcePropertyConditions.NOT_INCLUDES.getId().equals(conditionId)) {
                return AclResourcePropertyType.ENTITY_LIST.name();
            }
            return AclResourcePropertyType.NULL.name();
        }

        public void init(AclResourceProxy proxy, Object object) {
            BaseProduct baseProduct = (BaseProduct)object;
            ProductHandler<?> handler = HandlersRegistry.get().findProductHandler(baseProduct.getClass());
            if (handler != null) {
                proxy.getProperties().put(this.getId(), handler.findIssuingAgent(baseProduct));
            }
        }

        public boolean match(AclResourceProxy proxy, AclResourcePropertyCondition condition, Object value, String userId) {
            if (proxy.getProperties().containsKey(this.getId())) {
                EntityReference agent = (EntityReference)proxy.getProperties().get(this.getId());
                if (StandardAclResourcePropertyConditions.EQUALS.getId().equals(condition.getId())) {
                    return AclRulesHelper.isEquals((Object)agent, (Object)((EntityReference)value));
                }
                if (StandardAclResourcePropertyConditions.NOT_EQUALS.getId().equals(condition.getId())) {
                    return !AclRulesHelper.isEquals((Object)agent, (Object)((EntityReference)value));
                }
                if (StandardAclResourcePropertyConditions.INCLUDES.getId().equals(condition.getId())) {
                    return AclRulesHelper.isIncludes((Object)agent, (Collection)((List)value));
                }
                if (StandardAclResourcePropertyConditions.NOT_INCLUDES.getId().equals(condition.getId())) {
                    return !AclRulesHelper.isIncludes((Object)agent, (Collection)((List)value));
                }
                if (ModelAclResourcePropertyConditions.MY_PERSONS.getId().equals(condition.getId())) {
                    return AclModelRulesHelper.isMyPersons((EntityReference<Person>)agent, userId);
                }
            }
            return true;
        }
    }
    ,
    CHECKED{

        @Override
        public String getIdSuffix() {
            return "checked";
        }

        public String getName() {
            return "\u041f\u0440\u043e\u0432\u0435\u0440\u0435\u043d";
        }

        public Class<?> getType() {
            return Boolean.class;
        }

        public Set<String> getConditionIds() {
            return new HashSet<String>(Arrays.asList(StandardAclResourcePropertyConditions.YES.getId(), StandardAclResourcePropertyConditions.NO.getId()));
        }

        public String getRendererId(String conditionId) {
            return AclResourcePropertyType.NULL.name();
        }

        public void init(AclResourceProxy proxy, Object object) {
            BaseProduct baseProduct = (BaseProduct)object;
            ProductHandler<?> handler = HandlersRegistry.get().findProductHandler(baseProduct.getClass());
            if (handler != null) {
                proxy.getProperties().put(this.getId(), handler.isChecked(baseProduct));
            }
        }

        public boolean match(AclResourceProxy proxy, AclResourcePropertyCondition condition, Object value, String userId) {
            if (proxy.getProperties().containsKey(this.getId())) {
                Boolean checked = (Boolean)proxy.getProperties().get(this.getId());
                if (StandardAclResourcePropertyConditions.YES.getId().equals(condition.getId())) {
                    return AclRulesHelper.isEquals((Object)checked, (Object)Boolean.TRUE);
                }
                if (StandardAclResourcePropertyConditions.NO.getId().equals(condition.getId())) {
                    return AclRulesHelper.isEquals((Object)checked, (Object)Boolean.FALSE);
                }
            }
            return true;
        }
    }
    ,
    COMPLETED{

        @Override
        public String getIdSuffix() {
            return "completed";
        }

        public String getName() {
            return "\u0417\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u043e";
        }

        public Class<?> getType() {
            return Boolean.class;
        }

        public Set<String> getConditionIds() {
            return new HashSet<String>(Arrays.asList(StandardAclResourcePropertyConditions.YES.getId(), StandardAclResourcePropertyConditions.NO.getId()));
        }

        public String getRendererId(String conditionId) {
            return AclResourcePropertyType.NULL.name();
        }

        public void init(AclResourceProxy proxy, Object object) {
            BaseProduct baseProduct = (BaseProduct)object;
            ProductHandler<?> handler = HandlersRegistry.get().findProductHandler(baseProduct.getClass());
            if (handler != null) {
                proxy.getProperties().put(this.getId(), handler.isCompleted(baseProduct));
            }
        }

        public boolean match(AclResourceProxy proxy, AclResourcePropertyCondition condition, Object value, String userId) {
            if (proxy.getProperties().containsKey(this.getId())) {
                Boolean completed = (Boolean)proxy.getProperties().get(this.getId());
                if (StandardAclResourcePropertyConditions.YES.getId().equals(condition.getId())) {
                    return AclRulesHelper.isEquals((Object)completed, (Object)Boolean.TRUE);
                }
                if (StandardAclResourcePropertyConditions.NO.getId().equals(condition.getId())) {
                    return AclRulesHelper.isEquals((Object)completed, (Object)Boolean.FALSE);
                }
            }
            return true;
        }
    }
    ,
    DESCRIPTION{

        @Override
        public String getIdSuffix() {
            return "description";
        }

        public String getName() {
            return "\u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u0443\u043d\u0438\u0432\u0435\u0440\u0441\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u0430";
        }

        public Class<?> getType() {
            return UniversalProductDescription.class;
        }

        public Set<String> getConditionIds() {
            return new HashSet<String>(Arrays.asList(StandardAclResourcePropertyConditions.EQUALS.getId(), StandardAclResourcePropertyConditions.NOT_EQUALS.getId(), StandardAclResourcePropertyConditions.INCLUDES.getId(), StandardAclResourcePropertyConditions.NOT_INCLUDES.getId()));
        }

        public String getRendererId(String conditionId) {
            if (StandardAclResourcePropertyConditions.EQUALS.getId().equals(conditionId) || StandardAclResourcePropertyConditions.NOT_EQUALS.getId().equals(conditionId)) {
                return AclResourcePropertyType.ENTITY.name();
            }
            if (StandardAclResourcePropertyConditions.INCLUDES.getId().equals(conditionId) || StandardAclResourcePropertyConditions.NOT_INCLUDES.getId().equals(conditionId)) {
                return AclResourcePropertyType.ENTITY_LIST.name();
            }
            return AclResourcePropertyType.NULL.name();
        }

        public void init(AclResourceProxy proxy, Object object) {
            BaseProduct baseProduct = (BaseProduct)object;
            ProductHandler<?> handler = HandlersRegistry.get().findProductHandler(baseProduct.getClass());
            if (handler != null) {
                proxy.getProperties().put(this.getId(), handler.getUniversalProductDescription(baseProduct));
            }
        }

        public boolean match(AclResourceProxy proxy, AclResourcePropertyCondition condition, Object value, String userId) {
            if (proxy.getProperties().containsKey(this.getId())) {
                EntityReference description = (EntityReference)proxy.getProperties().get(this.getId());
                if (StandardAclResourcePropertyConditions.EQUALS.getId().equals(condition.getId())) {
                    return AclRulesHelper.isEquals((Object)description, (Object)((EntityReference)value));
                }
                if (StandardAclResourcePropertyConditions.NOT_EQUALS.getId().equals(condition.getId())) {
                    return !AclRulesHelper.isEquals((Object)description, (Object)((EntityReference)value));
                }
                if (StandardAclResourcePropertyConditions.INCLUDES.getId().equals(condition.getId())) {
                    return AclRulesHelper.isIncludes((Object)description, (Collection)((List)value));
                }
                if (StandardAclResourcePropertyConditions.NOT_INCLUDES.getId().equals(condition.getId())) {
                    return !AclRulesHelper.isIncludes((Object)description, (Collection)((List)value));
                }
            }
            return true;
        }
    };


    public abstract String getIdSuffix();

    public String getId() {
        return String.format("%s.%s", this.getResourceId(), this.getIdSuffix());
    }

    public String getResourceId() {
        return ModelAclEntityResources.ENTITY_PRODUCT.getId();
    }

    public String getInfo(AclResourcePropertyCondition condition, Object value) {
        AclResourcesEnvironment environment = (AclResourcesEnvironment)Environment.getPublished(AclResourcesEnvironment.class);
        String propertyName = this.getName();
        String resourceName = environment.getResource(this.getResourceId()).getName();
        return AclRulesHelper.getInfo((String)String.format("%s (%s)", propertyName, resourceName), (AclResourcePropertyCondition)condition, (Object)value);
    }
}

