/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.templates.jr;

import com.gridnine.xtrip.common.jr.JasperUtil;
import com.gridnine.xtrip.common.l10n.model.LocaleHelper;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.RecordLocatorType;
import com.gridnine.xtrip.common.model.booking.VatBasisType;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProduct;
import com.gridnine.xtrip.common.model.booking.railway.RailwaySegment;
import com.gridnine.xtrip.common.model.dict.CodeSystem;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.dict.InformationNote;
import com.gridnine.xtrip.common.model.dict.railway.RailwayStation;
import com.gridnine.xtrip.common.model.handlers.HandlersRegistry;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.handlers.RailwayReceiptHandler;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.system.ContentType;
import com.gridnine.xtrip.common.model.system.DocumentType;
import com.gridnine.xtrip.common.model.system.FilledTemplateDocument;
import com.gridnine.xtrip.common.model.system.TemplateDocument;
import com.gridnine.xtrip.common.model.templates.jr.RailwayReceiptRenderHelper;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.data.JRMapCollectionDataSource;

public class RailwayItineraryReceiptRender {
    private static final String RESERVATION_NUMBER = "RESERVATION_NUMBER";
    private static final String TICKET_NUMBER = "TICKET_NUMBER";
    private static final String ISSUE_DATE = "ISSUE_DATE";
    private static final String DEPART_DATE = "DEPART_DATE";
    private static final String ARRIVE_DATE = "ARRIVE_DATE";
    private static final String TRAVELLERS_COUNT = "TRAVELLERS_COUNT";
    private static final String ADULTS_COUNT = "ADULTS_COUNT";
    private static final String TOTAL_EQUIVALENT_FARE = "TOTAL_EQUIVALENT_FARE";
    private static final String TOTAL_EQUIVALENT_FARE_WO_CLIENT_FEES = "TOTAL_EQUIVALENT_FARE_WO_CLIENT_FEES";
    private static final String VAT = "VAT";
    private static final String FARE_VAT_KZ = "FARE_VAT_KZ";
    private static final String SERVICE_VAT_KZ = "SERVICE_VAT_KZ";
    private static final String TIME_LIMIT = "TIME_LIMIT";
    private static final String IS_REFUND = "IS_REFUND";
    private static final String INN = "INN";
    private static final String CARRIER = "CARRIER";
    private static final String CARRIER_RU = "CARRIER_RU";
    private static final String CARRIER_KZ = "CARRIER_KZ";
    private static final String FARE = "FARE";
    private static final String EQUIVALENT_FARE = "EQUIVALENT_FARE";
    private static final String SEGMENT_FARE = "SEGMENT_FARE";
    private static final String RESERVED_SEATS_FARE = "RESERVED_SEATS_FARE";
    private static final String TRAVELLERS_IIN = "TRAVELLERS_IIN";
    private static final String TRAVELLERS_NAMES = "TRAVELLERS_NAMES";
    private static final String TRAVELLERS_NAMES_2 = "TRAVELLERS_NAMES_2";
    private static final String TRAVELLERS_PASSPORTS = "TRAVELLERS_PASSPORTS";
    private static final String TRAVELLERS_INFO_KZ = "TRAVELLERS_INFO_KZ";
    private static final String PAYMENT_TYPE = "PAYMENT_TYPE";
    private static final String PAYMENT_TYPE_LOCALIZED = "PAYMENT_TYPE_LOCALIZED";
    private static final String PAYMENT_TYPE_KZ = "PAYMENT_TYPE_KZ";
    private static final String SEAT = "SEAT";
    private static final String SERVICE_FARE = "SERVICE_FARE";
    private static final String AGENCY = "AGENCY";
    private static final String BONUS_CARD = "BONUS_CARD";
    private static final String TICKET_TYPE = "TICKET_TYPE";
    private static final String CARRIER_BIN = "CARRIER_BIN";
    private static final String CARRIER_VAT_SERIES_NUMBER = "CARRIER_VAT_SERIES_NUMBER";
    private static final String RESERVATION_TYPE = "RESERVATION_TYPE";
    private static final String CANCEL_DATE = "CANCEL_DATE";
    private static final String SUBAGENCY_PHONE_NUMBER = "SUBAGENCY_PHONE_NUMBER";
    private static final String FIELD_DEPARTURE_DATE = "DEPARTURE_DATE";
    private static final String FIELD_LOCAL_DEPARTURE_DATE = "LOCAL_DEPARTURE_DATE";
    private static final String FIELD_ARRIVE_DATE = "ARRIVE_DATE";
    private static final String FIELD_LOCAL_ARRIVE_DATE = "LOCAL_ARRIVE_DATE";
    private static final String FIELD_TRAIN_NUMBER = "TRAIN_NUMBER";
    private static final String FIELD_TRAIN_CATEGORY = "TRAIN_CATEGORY";
    private static final String FIELD_CARRIAGE = "CARRIAGE";
    private static final String FIELD_CARRIAGE_NUMBER = "CARRIAGE_NUMBER";
    private static final String FIELD_SERVISE_CLASS = "SERVISE_CLASS";
    private static final String FIELD_DEPARTURE_LOCATION = "DEPARTURE_LOCATION";
    private static final String FIELD_ARRIVE_LOCATION = "ARRIVE_LOCATION";
    private static final String FIELD_DEPARTURE_LOCATION_EN = "DEPARTURE_LOCATION_EN";
    private static final String FIELD_ARRIVE_LOCATION_EN = "ARRIVE_LOCATION_EN";
    private static final String FIELD_DEPARTURE_LOCATION_EXPRESS_CODE = "DEPARTURE_LOCATION_EXPRESS_CODE";
    private static final String FIELD_ARRIVE_LOCATION_EXPRESS_CODE = "ARRIVE_LOCATION_EXPRESS_CODE";
    private static final String FIELD_CURRENCY = "CURRENCY";
    private static final String FIELD_TIME_INFO = "TIME_INFO";
    private static final String FIELD_TRAVEL_TIME = "TRAVEL_TIME";

    public FilledTemplateDocument renderReport(EntityContainer<BookingFile> bookingFile, RailwayProduct product, EntityContainer<TemplateDocument> template, List<InformationNote> notes) throws Exception {
        Locale locale;
        LinkedHashSet messages = new LinkedHashSet();
        JasperReport jasperReport = JasperUtil.getReport((byte[])((TemplateDocument)template.getEntity()).getContent());
        byte[] content = JasperUtil.fillReport((JasperReport)jasperReport, this.getParameters(product, locale = RailwayReceiptRenderHelper.getLocale((TemplateDocument)template.getEntity())), (JRDataSource)this.getDataSource(product, locale), null);
        if (content == null) {
            return null;
        }
        Date date = new Date();
        FilledTemplateDocument file = new FilledTemplateDocument();
        file.setTitle(RailwayReceiptRenderHelper.getReportTitle(product, (TemplateDocument)template.getEntity()));
        file.setContentType(ContentType.JASPERPRINT);
        file.setContent(content);
        file.setName(RailwayReceiptRenderHelper.getFileName(product, (TemplateDocument)template.getEntity()));
        file.setType(DocumentType.RECEIPT);
        file.setCreated(date);
        file.setNavigationKey(product.getUid());
        file.setOwner(bookingFile.toReference());
        file.setCheckSum(MiscUtil.getCheckSum((byte[])file.getContent()));
        file.setTemplate(template.toReference());
        file.getMessages().clear();
        file.getMessages().addAll(messages);
        return file;
    }

    private Map<String, Object> getParameters(RailwayProduct product, Locale locale) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("REPORT_LOCALE", locale);
        if (product.getReservation() != null) {
            String expressCode = CommonReservationGdsNameInfoHelper.getRecordLocator(product.getReservation(), GdsName.EXPRESS, RecordLocatorType.DEFAULT);
            parameters.put(RESERVATION_NUMBER, expressCode);
        }
        parameters.put(TICKET_NUMBER, product.getSystemNumber());
        parameters.put(ISSUE_DATE, product.getIssueDate());
        parameters.put(DEPART_DATE, RailwayReceiptRenderHelper.getDepartureDate(product));
        parameters.put("ARRIVE_DATE", RailwayReceiptRenderHelper.getArriveDate(product));
        parameters.put(ADULTS_COUNT, RailwayReceiptRenderHelper.getAdultsCount(product));
        parameters.put(TRAVELLERS_COUNT, product.getPassengers().size());
        parameters.put(TOTAL_EQUIVALENT_FARE, product.getTotalEquivalentFare());
        parameters.put(TOTAL_EQUIVALENT_FARE_WO_CLIENT_FEES, ProductHandler.of(product).calculateProductPrice(product, ContractType.CLIENT).getTotal());
        parameters.put(VAT, RailwayReceiptRenderHelper.getVat(product));
        parameters.put(FARE_VAT_KZ, RailwayReceiptRenderHelper.getVatKZ(product, VatBasisType.FARE));
        parameters.put(SERVICE_VAT_KZ, RailwayReceiptRenderHelper.getVatKZ(product, VatBasisType.SERVICE));
        parameters.put(TIME_LIMIT, product.getReservation().getTimeLimit());
        parameters.put(IS_REFUND, product.getNextProduct() != null && product.getNextProduct().getStatus() == ProductStatus.REFUND);
        parameters.put(INN, RailwayReceiptRenderHelper.getINN(product));
        parameters.put(CARRIER, product.getCarrier() != null ? product.getCarrier().toString(locale) : null);
        parameters.put(CARRIER_RU, product.getCarrier() != null ? product.getCarrier().toString(LocaleHelper.RU_LOCALE) : null);
        parameters.put(CARRIER_KZ, product.getCarrier() != null ? product.getCarrier().toString(LocaleHelper.getLocale((String)"KZ")) : null);
        parameters.put(FARE, RailwayReceiptRenderHelper.getFare(product));
        parameters.put(EQUIVALENT_FARE, RailwayReceiptRenderHelper.getEquivalentFare(product));
        parameters.put(SEGMENT_FARE, RailwayReceiptRenderHelper.getSegmentFare(product));
        parameters.put(RESERVED_SEATS_FARE, RailwayReceiptRenderHelper.getReservedSeatsFare(product));
        parameters.put(TRAVELLERS_IIN, RailwayReceiptRenderHelper.getTravellersIIN(product));
        parameters.put(TRAVELLERS_NAMES, RailwayReceiptRenderHelper.getTravellersString(product, locale));
        parameters.put(TRAVELLERS_NAMES_2, RailwayReceiptRenderHelper.getTravellersNames(product, locale));
        parameters.put(TRAVELLERS_PASSPORTS, RailwayReceiptRenderHelper.getTravellersPassports(product));
        parameters.put(TRAVELLERS_INFO_KZ, RailwayReceiptRenderHelper.getTravellersInfoKZ(product, locale));
        parameters.put(PAYMENT_TYPE, RailwayReceiptRenderHelper.getPaymentType(product));
        parameters.put(PAYMENT_TYPE_LOCALIZED, RailwayReceiptRenderHelper.getPaymentTypeLocalized(product, locale));
        parameters.put(PAYMENT_TYPE_KZ, RailwayReceiptRenderHelper.getPaymentTypeKZ(product));
        parameters.put(SEAT, RailwayReceiptRenderHelper.getSeat(product));
        parameters.put(SERVICE_FARE, product.getServiceFare());
        parameters.put(AGENCY, RailwayReceiptRenderHelper.getAgency(product, locale));
        parameters.put(BONUS_CARD, RailwayReceiptRenderHelper.getBonusCard(product));
        parameters.put(TICKET_TYPE, RailwayReceiptRenderHelper.getTicketType(product));
        parameters.put(CARRIER_BIN, RailwayReceiptRenderHelper.getCarrierBIN(product));
        parameters.put(CARRIER_VAT_SERIES_NUMBER, RailwayReceiptRenderHelper.getVatSeriesNumber(product));
        parameters.put(RESERVATION_TYPE, product.getReservation() == null ? null : product.getReservation().getType());
        parameters.put(CANCEL_DATE, product.getERegExpireDate());
        parameters.put(SUBAGENCY_PHONE_NUMBER, RailwayReceiptRenderHelper.getSubagencyPhoneNumber(product));
        for (RailwayReceiptHandler handler : HandlersRegistry.get().getAllRailwayReceiptHandlers()) {
            handler.getParameters(parameters, product, locale);
        }
        return parameters;
    }

    private JRDataSource getDataSource(RailwayProduct product, Locale locale) {
        ArrayList data = new ArrayList();
        for (RailwaySegment segment : product.getSegments()) {
            HashMap<String, Object> record = new HashMap<String, Object>();
            record.put(FIELD_DEPARTURE_DATE, segment.getDepartureDate());
            record.put(FIELD_LOCAL_DEPARTURE_DATE, segment.getLocalDepartureDate());
            record.put("ARRIVE_DATE", segment.getArriveDate());
            record.put(FIELD_LOCAL_ARRIVE_DATE, segment.getLocalArriveDate());
            record.put(FIELD_TRAIN_NUMBER, segment.getTrainNumber() != null ? (segment.getSlot() != null ? segment.getTrainNumber() + segment.getSlot() : segment.getTrainNumber()) : null);
            record.put(FIELD_TRAIN_CATEGORY, segment.getTrainCategory());
            record.put(FIELD_CARRIAGE, segment.getCarriageNumber() != null ? (segment.getCarriageType() != null ? segment.getCarriageNumber() + " " + segment.getCarriageType() : segment.getCarriageNumber()) : null);
            record.put(FIELD_CARRIAGE_NUMBER, segment.getCarriageNumber());
            record.put(FIELD_SERVISE_CLASS, segment.getServiceClass() != null ? segment.getServiceClass().toString() : null);
            record.put(FIELD_DEPARTURE_LOCATION, RailwayReceiptRenderHelper.getCityName((DictionaryReference<RailwayStation>)segment.getDepartureStation(), locale));
            record.put(FIELD_ARRIVE_LOCATION, RailwayReceiptRenderHelper.getCityName((DictionaryReference<RailwayStation>)segment.getArriveStation(), locale));
            record.put(FIELD_DEPARTURE_LOCATION_EN, RailwayReceiptRenderHelper.getCityName((DictionaryReference<RailwayStation>)segment.getDepartureStation(), Locale.ENGLISH));
            record.put(FIELD_ARRIVE_LOCATION_EN, RailwayReceiptRenderHelper.getCityName((DictionaryReference<RailwayStation>)segment.getArriveStation(), Locale.ENGLISH));
            record.put(FIELD_DEPARTURE_LOCATION_EXPRESS_CODE, DictHelper.getCodeVariant(segment.getDepartureStation(), CodeSystem.EXPRESS));
            record.put(FIELD_ARRIVE_LOCATION_EXPRESS_CODE, DictHelper.getCodeVariant(segment.getArriveStation(), CodeSystem.EXPRESS));
            record.put(FIELD_CURRENCY, segment.getFare() != null ? segment.getFare().getCurrency() : null);
            record.put(FIELD_TIME_INFO, segment.getTimeInfo() != null ? TextUtil.trim((String)segment.getTimeInfo()) : null);
            record.put(FIELD_TRAVEL_TIME, RailwayReceiptRenderHelper.getTravelTime(segment));
            data.add(record);
        }
        if (data.isEmpty()) {
            data.add(new HashMap());
        }
        return new JRMapCollectionDataSource(data);
    }
}

