/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.validation;

import com.gridnine.xtrip.common.model.booking.ValidationMessageCategory;
import com.gridnine.xtrip.common.model.booking.ValidationMessageSeverity;
import com.gridnine.xtrip.common.model.l10n.Messages;
import com.gridnine.xtrip.common.model.validation.ValidationMessageType;

public enum UniversalProductMessageType implements ValidationMessageType
{
    UNIVERSAL_PRODUCT_DESCRIPTION_IS_NULL(ValidationMessageSeverity.ERROR, ValidationMessageCategory.OTHER, Messages.UniversalProductMessageType_0),
    UNIVERSAL_PRODUCT_UNABLE_TO_LOAD_DESCRIPTION(ValidationMessageSeverity.ERROR, ValidationMessageCategory.OTHER, Messages.UniversalProductMessageType_1);

    private static final String PREFIX = "MISC-PRODUCT-";
    private ValidationMessageSeverity defaultSeverety;
    private ValidationMessageCategory category;
    private String messageKey;

    private UniversalProductMessageType(ValidationMessageSeverity defaultSeverety, ValidationMessageCategory category, String messageKey) {
        this.defaultSeverety = defaultSeverety;
        this.category = category;
        this.messageKey = messageKey;
    }

    private UniversalProductMessageType(String messageKey) {
        this(ValidationMessageSeverity.ERROR, ValidationMessageCategory.OTHER, messageKey);
    }

    @Override
    public ValidationMessageCategory getCategory() {
        return this.category;
    }

    @Override
    public String getMessageKey() {
        return this.messageKey;
    }

    @Override
    public ValidationMessageSeverity getDefaultSeverity() {
        return this.defaultSeverety;
    }

    @Override
    public String getId() {
        return this.name();
    }

    @Override
    public String getErrorCode() {
        return PREFIX + this.getNumber();
    }

    @Override
    public String getPrefix() {
        return PREFIX;
    }

    @Override
    public Integer getNumber() {
        return this.ordinal() + 20000;
    }
}

