/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.validation;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.booking.ValidationMessage;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.ValidationMessageDict;
import com.gridnine.xtrip.common.model.validation.ValidationMessageType;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class ValidationMessagesResourcesEnvironment {
    private final Map<String, ValidationMessageType> messageTypes = new HashMap<String, ValidationMessageType>(400);
    private final Map<String, ValidationMessageType> errorCodes = new HashMap<String, ValidationMessageType>(400);

    public static ValidationMessagesResourcesEnvironment getFromEnvironment() {
        return (ValidationMessagesResourcesEnvironment)Environment.getPublished(ValidationMessagesResourcesEnvironment.class);
    }

    public void addMessageType(ValidationMessageType type) {
        this.messageTypes.put(type.getId(), type);
        this.errorCodes.put(type.getErrorCode(), type);
    }

    public Map<String, ValidationMessageType> getMessageTypes() {
        return Collections.unmodifiableMap(this.messageTypes);
    }

    public ValidationMessageType getTypeByErrorCode(String errorCode) {
        return this.errorCodes.get(errorCode);
    }

    public Set<String> getMessagesAsStrings() {
        TreeSet<String> result = new TreeSet<String>(new ValueComparator(this.messageTypes));
        for (ValidationMessageType type : this.getMessageTypes().values()) {
            result.add(type.getId());
        }
        return result;
    }

    public String getKeyString(String errorCode) {
        return this.messageTypes.get(errorCode) != null ? this.messageTypes.get(errorCode).getMessageKey() : "";
    }

    public ValidationMessage createValidationMessage(String details, ValidationMessageType messageType, Object ... messageParams) {
        ValidationMessage message = new ValidationMessage();
        message.setCategory(messageType.getCategory());
        message.setDetails(details);
        message.setMessage(L10nResourcesManager.createL10nMessage((String)messageType.getMessageKey(), (Object[])messageParams));
        Map all = DictionaryCache.get().getAll(ValidationMessageDict.class);
        ValidationMessageDict dict = (ValidationMessageDict)all.get(messageType.getId());
        if (dict == null) {
            for (ValidationMessageDict item : all.values()) {
                if (!messageType.getErrorCode().equals(item.getErrorCode())) continue;
                dict = item;
                break;
            }
        }
        message.setSeverity(dict != null ? dict.getSeverity() : messageType.getDefaultSeverity());
        message.setErrorCode(messageType.getErrorCode());
        return message;
    }

    class ValueComparator
    implements Comparator<String> {
        Map<String, ValidationMessageType> base;

        public ValueComparator(Map<String, ValidationMessageType> base) {
            this.base = base;
        }

        @Override
        public int compare(String a, String b) {
            ValidationMessageType aType = this.base.get(a);
            ValidationMessageType bType = this.base.get(b);
            if (aType.getPrefix().compareTo(bType.getPrefix()) == 0) {
                return aType.getNumber().compareTo(bType.getNumber());
            }
            return aType.getPrefix().compareTo(bType.getPrefix());
        }
    }
}

