/*
 * Decompiled with CFR 0.152.
 */
package org.java.plugin.registry.xml;

import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.java.plugin.registry.Documentation;
import org.java.plugin.registry.Extension;
import org.java.plugin.registry.ExtensionPoint;
import org.java.plugin.registry.Identity;
import org.java.plugin.registry.Library;
import org.java.plugin.registry.ManifestProcessingException;
import org.java.plugin.registry.PluginAttribute;
import org.java.plugin.registry.PluginDescriptor;
import org.java.plugin.registry.PluginFragment;
import org.java.plugin.registry.PluginPrerequisite;
import org.java.plugin.registry.PluginRegistry;
import org.java.plugin.registry.Version;
import org.java.plugin.registry.xml.DocumentationImpl;
import org.java.plugin.registry.xml.ExtensionImpl;
import org.java.plugin.registry.xml.ExtensionPointImpl;
import org.java.plugin.registry.xml.IdentityImpl;
import org.java.plugin.registry.xml.LibraryImpl;
import org.java.plugin.registry.xml.ModelAttribute;
import org.java.plugin.registry.xml.ModelExtension;
import org.java.plugin.registry.xml.ModelExtensionPoint;
import org.java.plugin.registry.xml.ModelLibrary;
import org.java.plugin.registry.xml.ModelPluginDescriptor;
import org.java.plugin.registry.xml.ModelPluginManifest;
import org.java.plugin.registry.xml.ModelPrerequisite;
import org.java.plugin.registry.xml.PluginAttributeImpl;
import org.java.plugin.registry.xml.PluginFragmentImpl;
import org.java.plugin.registry.xml.PluginPrerequisiteImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PluginDescriptorImpl
extends IdentityImpl
implements PluginDescriptor {
    private final PluginRegistry registry;
    private final ModelPluginDescriptor model;
    private Map<String, PluginPrerequisite> pluginPrerequisites;
    private Map<String, Library> libraries;
    private Map<String, ExtensionPoint> extensionPoints;
    private Map<String, Extension> extensions;
    private Documentation<PluginDescriptor> doc;
    private List<PluginFragment> fragments;
    private List<PluginAttribute> attributes;

    PluginDescriptorImpl(PluginRegistry aRegistry, ModelPluginDescriptor aModel) throws ManifestProcessingException {
        super(aModel.getId());
        this.registry = aRegistry;
        this.model = aModel;
        if (this.model.getVendor() == null) {
            this.model.setVendor("");
        }
        if (this.model.getClassName() != null && this.model.getClassName().trim().length() == 0) {
            this.model.setClassName(null);
        }
        if (this.model.getDocsPath() == null || this.model.getDocsPath().trim().length() == 0) {
            this.model.setDocsPath("docs");
        }
        if (this.model.getDocumentation() != null) {
            this.doc = new DocumentationImpl<PluginDescriptorImpl>(this, this.model.getDocumentation());
        }
        this.attributes = new LinkedList<PluginAttribute>();
        this.fragments = new LinkedList<PluginFragment>();
        this.pluginPrerequisites = new LinkedHashMap<String, PluginPrerequisite>();
        this.libraries = new LinkedHashMap<String, Library>();
        this.extensionPoints = new HashMap<String, ExtensionPoint>();
        this.extensions = new HashMap<String, Extension>();
        this.processAttributes(null, this.model);
        this.processPrerequisites(null, this.model);
        this.processLibraries(null, this.model);
        this.processExtensionPoints(null, this.model);
        this.processExtensions(null, this.model);
        if (this.log.isDebugEnabled()) {
            this.log.debug("object instantiated: " + this);
        }
    }

    void registerFragment(PluginFragmentImpl fragment) throws ManifestProcessingException {
        this.fragments.add(fragment);
        this.processAttributes(fragment, fragment.getModel());
        this.processPrerequisites(fragment, fragment.getModel());
        this.processLibraries(fragment, fragment.getModel());
        this.processExtensionPoints(fragment, fragment.getModel());
        this.processExtensions(fragment, fragment.getModel());
    }

    void unregisterFragment(PluginFragmentImpl fragment) {
        Map.Entry entry;
        Iterator<Object> it = this.attributes.iterator();
        while (it.hasNext()) {
            if (!fragment.equals(it.next().getDeclaringPluginFragment())) continue;
            it.remove();
        }
        it = this.pluginPrerequisites.entrySet().iterator();
        while (it.hasNext()) {
            entry = (Map.Entry)it.next();
            if (!fragment.equals(((PluginPrerequisite)entry.getValue()).getDeclaringPluginFragment())) continue;
            it.remove();
        }
        it = this.libraries.entrySet().iterator();
        while (it.hasNext()) {
            entry = (Map.Entry)it.next();
            if (!fragment.equals(((Library)entry.getValue()).getDeclaringPluginFragment())) continue;
            it.remove();
        }
        it = this.extensionPoints.entrySet().iterator();
        while (it.hasNext()) {
            entry = (Map.Entry)it.next();
            if (!fragment.equals(((ExtensionPoint)entry.getValue()).getDeclaringPluginFragment())) continue;
            it.remove();
        }
        it = this.extensions.entrySet().iterator();
        while (it.hasNext()) {
            entry = (Map.Entry)it.next();
            if (!fragment.equals(((Extension)entry.getValue()).getDeclaringPluginFragment())) continue;
            it.remove();
        }
        this.fragments.remove(fragment);
    }

    private void processAttributes(PluginFragmentImpl fragment, ModelPluginManifest modelManifest) throws ManifestProcessingException {
        for (ModelAttribute modelAttribute : modelManifest.getAttributes()) {
            this.attributes.add(new PluginAttributeImpl(this, fragment, modelAttribute, null));
        }
    }

    private void processPrerequisites(PluginFragmentImpl fragment, ModelPluginManifest modelManifest) throws ManifestProcessingException {
        for (ModelPrerequisite modelPrerequisite : modelManifest.getPrerequisites()) {
            PluginPrerequisiteImpl pluginPrerequisite = new PluginPrerequisiteImpl(this, fragment, modelPrerequisite);
            if (this.pluginPrerequisites.containsKey(pluginPrerequisite.getPluginId())) {
                throw new ManifestProcessingException("org.java.plugin.registry.xml", "duplicateImports", new Object[]{pluginPrerequisite.getPluginId(), this.getId()});
            }
            this.pluginPrerequisites.put(pluginPrerequisite.getPluginId(), pluginPrerequisite);
        }
    }

    private void processLibraries(PluginFragmentImpl fragment, ModelPluginManifest modelManifest) throws ManifestProcessingException {
        for (ModelLibrary modelLibrary : modelManifest.getLibraries()) {
            LibraryImpl lib = new LibraryImpl(this, fragment, modelLibrary);
            if (this.libraries.containsKey(lib.getId())) {
                throw new ManifestProcessingException("org.java.plugin.registry.xml", "duplicateLibraries", new Object[]{lib.getId(), this.getId()});
            }
            this.libraries.put(lib.getId(), lib);
        }
    }

    private void processExtensionPoints(PluginFragmentImpl fragment, ModelPluginManifest modelManifest) throws ManifestProcessingException {
        for (ModelExtensionPoint modelExtensionPoint : modelManifest.getExtensionPoints()) {
            ExtensionPointImpl extensionPoint = new ExtensionPointImpl(this, fragment, modelExtensionPoint);
            if (this.extensionPoints.containsKey(extensionPoint.getId())) {
                throw new ManifestProcessingException("org.java.plugin.registry.xml", "duplicateExtensionPoints", new Object[]{extensionPoint.getId(), this.getId()});
            }
            this.extensionPoints.put(extensionPoint.getId(), extensionPoint);
        }
    }

    private void processExtensions(PluginFragmentImpl fragment, ModelPluginManifest modelManifest) throws ManifestProcessingException {
        for (ModelExtension modelExtension : modelManifest.getExtensions()) {
            ExtensionImpl extension = new ExtensionImpl(this, fragment, modelExtension);
            if (this.extensions.containsKey(extension.getId())) {
                throw new ManifestProcessingException("org.java.plugin.registry.xml", "duplicateExtensions", new Object[]{extension.getId(), this.getId()});
            }
            if (!this.getId().equals(extension.getExtendedPluginId()) && !this.pluginPrerequisites.containsKey(extension.getExtendedPluginId())) {
                throw new ManifestProcessingException("org.java.plugin.registry.xml", "pluginNotDeclaredInPrerequisites", new Object[]{extension.getExtendedPluginId(), extension.getId(), this.getId()});
            }
            this.extensions.put(extension.getId(), extension);
        }
    }

    @Override
    public String getUniqueId() {
        return this.registry.makeUniqueId(this.getId(), this.model.getVersion());
    }

    @Override
    public String getVendor() {
        return this.model.getVendor();
    }

    @Override
    public Version getVersion() {
        return this.model.getVersion();
    }

    @Override
    public Collection<PluginPrerequisite> getPrerequisites() {
        return Collections.unmodifiableCollection(this.pluginPrerequisites.values());
    }

    @Override
    public PluginPrerequisite getPrerequisite(String id) {
        return this.pluginPrerequisites.get(id);
    }

    @Override
    public Collection<ExtensionPoint> getExtensionPoints() {
        return Collections.unmodifiableCollection(this.extensionPoints.values());
    }

    @Override
    public ExtensionPoint getExtensionPoint(String id) {
        return this.extensionPoints.get(id);
    }

    @Override
    public Collection<Extension> getExtensions() {
        return Collections.unmodifiableCollection(this.extensions.values());
    }

    @Override
    public Extension getExtension(String id) {
        return this.extensions.get(id);
    }

    @Override
    public Collection<Library> getLibraries() {
        return Collections.unmodifiableCollection(this.libraries.values());
    }

    @Override
    public Library getLibrary(String id) {
        return this.libraries.get(id);
    }

    @Override
    public PluginRegistry getRegistry() {
        return this.registry;
    }

    @Override
    public String getPluginClassName() {
        return this.model.getClassName();
    }

    public String toString() {
        return "{PluginDescriptor: uid=" + this.getUniqueId() + "}";
    }

    @Override
    public Documentation<PluginDescriptor> getDocumentation() {
        return this.doc;
    }

    @Override
    public Collection<PluginFragment> getFragments() {
        return Collections.unmodifiableCollection(this.fragments);
    }

    @Override
    public PluginAttribute getAttribute(String id) {
        PluginAttributeImpl result = null;
        for (PluginAttribute attribute : this.attributes) {
            PluginAttributeImpl attr = (PluginAttributeImpl)attribute;
            if (!attr.getId().equals(id)) continue;
            if (result == null) {
                result = attr;
                continue;
            }
            throw new IllegalArgumentException("more than one attribute with ID " + id + " defined in plug-in " + this.getUniqueId());
        }
        return result;
    }

    @Override
    public Collection<PluginAttribute> getAttributes() {
        return Collections.unmodifiableCollection(this.attributes);
    }

    @Override
    public Collection<PluginAttribute> getAttributes(String id) {
        LinkedList<PluginAttributeImpl> result = new LinkedList<PluginAttributeImpl>();
        for (PluginAttribute attribute : this.attributes) {
            PluginAttributeImpl param = (PluginAttributeImpl)attribute;
            if (!param.getId().equals(id)) continue;
            result.add(param);
        }
        return Collections.unmodifiableList(result);
    }

    @Override
    public String getDocsPath() {
        return this.model.getDocsPath();
    }

    @Override
    public URL getLocation() {
        return this.model.getLocation();
    }

    @Override
    protected boolean isEqualTo(Identity idt) {
        if (!(idt instanceof PluginDescriptorImpl)) {
            return false;
        }
        PluginDescriptorImpl other = (PluginDescriptorImpl)idt;
        return this.getUniqueId().equals(other.getUniqueId()) && this.getLocation().toExternalForm().equals(other.getLocation().toExternalForm());
    }
}

