/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.reports;

import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BlankType;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.profile.BaseProfile;
import com.gridnine.xtrip.common.model.stockcontrol.BlankOrderLogItem;
import com.gridnine.xtrip.common.model.stockcontrol.StockBlank;
import com.gridnine.xtrip.common.model.stockcontrol.StockBlankControlStatus;
import com.gridnine.xtrip.common.model.stockcontrol.StockBlankIndex;
import com.gridnine.xtrip.common.model.stockcontrol.UsageStatus;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StockBlankReportHelper {
    private static Pattern numberPattern = Pattern.compile("(\\d+\\s*)+");

    static long getNumber(String number) {
        Matcher matcher = numberPattern.matcher(number);
        matcher.find();
        return Long.parseLong(matcher.group());
    }

    static String getPrefix(String number) {
        Matcher matcher = numberPattern.matcher(number);
        matcher.find();
        return number.substring(0, matcher.start());
    }

    public static Map<BlankType, TreeMap<String, StockBlankBatch>> generateData(List<StockBlankIndex> source, Date beginWithTime, Date endWithTime) {
        Calendar c = Calendar.getInstance();
        c.setTime(beginWithTime);
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        Date begin = c.getTime();
        c.setTime(endWithTime);
        c.set(11, 23);
        c.set(12, 59);
        c.set(13, 59);
        c.set(14, 999);
        Date end = c.getTime();
        TreeMap<BlankType, TreeMap<String, StockBlankBatch>> map = new TreeMap<BlankType, TreeMap<String, StockBlankBatch>>(new Comparator<BlankType>(){

            @Override
            public int compare(BlankType o1, BlankType o2) {
                if (o1.getProductCategory().ordinal() == o2.getProductCategory().ordinal()) {
                    return o1.getCode().compareTo(o2.getCode());
                }
                return o1.getProductCategory().ordinal() - o2.getProductCategory().ordinal();
            }
        });
        for (StockBlankIndex blank : source) {
            if (blank.getControlStatus() == StockBlankControlStatus.ERROR || blank.getRegistrationDate().compareTo(end) > 0 || blank.getOperationDate() != null && blank.getOperationDate().compareTo(begin) < 0) continue;
            BlankType type = (BlankType)DictionaryCache.get().resolveReference(blank.getType());
            if (map.get(type) == null) {
                map.put(type, new TreeMap());
            }
            if (map.get(type).get(StockBlankReportHelper.getPrefix(blank.getNumber())) == null) {
                map.get(type).put(StockBlankReportHelper.getPrefix(blank.getNumber()), new StockBlankBatch(begin, end));
            }
            map.get(type).get(StockBlankReportHelper.getPrefix(blank.getNumber())).add(blank);
        }
        return map;
    }

    public static Map<BlankType, TreeMap<String, StockBlankBatch>> generateData(List<StockBlankIndex> source, Date beginWithTime, Date endWithTime, EntityReference<? extends BaseProfile> location) {
        TreeMap<BlankType, TreeMap<String, StockBlankBatch>> map = new TreeMap<BlankType, TreeMap<String, StockBlankBatch>>(new Comparator<BlankType>(){

            @Override
            public int compare(BlankType o1, BlankType o2) {
                if (o1.getProductCategory().ordinal() == o2.getProductCategory().ordinal()) {
                    return o1.getCode().compareTo(o2.getCode());
                }
                return o1.getProductCategory().ordinal() - o2.getProductCategory().ordinal();
            }
        });
        EntityStorage es = EntityStorage.get();
        for (StockBlankIndex blankIndex : source) {
            BlankType type;
            if (blankIndex.getControlStatus() == StockBlankControlStatus.ERROR) continue;
            StockBlank blank = (StockBlank)es.resolve(blankIndex.getSource()).getEntity();
            List logs = blank.getOrderLogItems();
            Collections.sort(logs, new Comparator<BlankOrderLogItem>(){

                @Override
                public int compare(BlankOrderLogItem o1, BlankOrderLogItem o2) {
                    return o1.getOperationDate().compareTo(o2.getOperationDate());
                }
            });
            Iterator logIter = logs.iterator();
            boolean before = false;
            boolean receipt = false;
            boolean moved = false;
            boolean spend = false;
            boolean after = false;
            while (logIter.hasNext()) {
                BlankOrderLogItem log = (BlankOrderLogItem)logIter.next();
                Date logDate = log.getOperationDate();
                EntityReference logLocation = log.getBlankLocation();
                before = logDate.before(beginWithTime) && logLocation.equals(location);
                if (logDate.after(beginWithTime) && logDate.before(endWithTime) && logLocation.equals(location)) {
                    receipt = true;
                }
                if (!logDate.after(beginWithTime) || !logDate.before(endWithTime) || logLocation.equals(location) || !receipt && !before) continue;
                moved = true;
            }
            if (!before && !receipt) continue;
            if (blank.getOperationDate() != null && blank.getOperationDate().before(endWithTime) && (before || receipt)) {
                spend = true;
            }
            if (blank.getOperationDate() == null && blank.getUsageStatus() == UsageStatus.NEW && !moved && !spend) {
                after = true;
            }
            ArrayList<StockBlankBatch.BatchTypes> batchTypes = new ArrayList<StockBlankBatch.BatchTypes>();
            if (before) {
                batchTypes.add(StockBlankBatch.BatchTypes.before);
            }
            if (receipt) {
                batchTypes.add(StockBlankBatch.BatchTypes.receipt);
            }
            if (moved) {
                batchTypes.add(StockBlankBatch.BatchTypes.move);
            }
            if (spend) {
                batchTypes.add(StockBlankBatch.BatchTypes.spend);
            }
            if (after) {
                batchTypes.add(StockBlankBatch.BatchTypes.after);
            }
            if (map.get(type = (BlankType)DictionaryCache.get().resolveReference(blankIndex.getType())) == null) {
                map.put(type, new TreeMap());
            }
            if (map.get(type).get(StockBlankReportHelper.getPrefix(blankIndex.getNumber())) == null) {
                map.get(type).put(StockBlankReportHelper.getPrefix(blankIndex.getNumber()), new StockBlankBatch(beginWithTime, endWithTime));
            }
            map.get(type).get(StockBlankReportHelper.getPrefix(blankIndex.getNumber())).addToPresortedBatches(blankIndex, batchTypes);
        }
        return map;
    }

    public static class StockBlankBatch {
        public final ArrayList<StockBlankReportBatch> before = new ArrayList();
        public final ArrayList<StockBlankReportBatch> receipts = new ArrayList();
        public final ArrayList<StockBlankReportBatch> withdrawals = new ArrayList();
        public final ArrayList<StockBlankReportBatch> moves = new ArrayList();
        public final ArrayList<StockBlankReportBatch> after = new ArrayList();
        private final Date begin;
        private final Date end;

        public StockBlankBatch(Date newBegin, Date newEnd) {
            this.begin = newBegin;
            this.end = newEnd;
        }

        public void addToPresortedBatches(StockBlankIndex blank, ArrayList<BatchTypes> types) {
            for (BatchTypes type : types) {
                switch (type) {
                    case after: {
                        this.addToBatches(this.after, blank);
                        break;
                    }
                    case before: {
                        this.addToBatches(this.before, blank);
                        break;
                    }
                    case move: {
                        this.addToBatches(this.moves, blank);
                        break;
                    }
                    case receipt: {
                        this.addToBatches(this.receipts, blank);
                        break;
                    }
                    case spend: {
                        this.addToBatches(this.withdrawals, blank);
                        break;
                    }
                }
            }
        }

        public void add(StockBlankIndex blank) {
            if (blank.getRegistrationDate().compareTo(this.begin) < 0) {
                this.addToBatches(this.before, blank);
            } else if (blank.getRegistrationDate().compareTo(this.begin) >= 0) {
                this.addToBatches(this.receipts, blank);
            }
            if (blank.getOperationDate() != null && blank.getOperationDate().compareTo(this.end) < 0 || blank.getUsageStatus() != UsageStatus.NEW) {
                this.addToBatches(this.withdrawals, blank);
            } else if (blank.getOperationDate() == null || blank.getOperationDate().compareTo(this.end) > 0) {
                this.addToBatches(this.after, blank);
            }
        }

        private void addToBatches(List<StockBlankReportBatch> batches, StockBlankIndex blank) {
            boolean added = false;
            for (StockBlankReportBatch batch : batches) {
                if (StockBlankReportHelper.getNumber(blank.getNumber()) - batch.getEnd() != 1L) continue;
                batch.add(blank);
                added = true;
                break;
            }
            if (!added) {
                batches.add(new StockBlankReportBatch(blank));
            }
        }

        private static enum BatchTypes {
            before,
            receipt,
            spend,
            move,
            after;

        }
    }

    public static class StockBlankReportBatch {
        private int quantity;
        private boolean printed = false;
        protected String numberFormat;
        private final long begin;
        private long end;

        public boolean hasBeenPrinted() {
            return this.printed;
        }

        public void setPrinted() {
            this.printed = true;
        }

        public int getQuantity() {
            return this.quantity;
        }

        public long getBegin() {
            return this.begin;
        }

        public String getBeginString() {
            return String.format(this.numberFormat, this.begin);
        }

        public long getEnd() {
            return this.end;
        }

        public String getEndString() {
            return String.format(this.numberFormat, this.end);
        }

        public void add(StockBlankIndex blank) {
            this.end = StockBlankReportHelper.getNumber(blank.getNumber());
            ++this.quantity;
        }

        public boolean containsNumber(int number) {
            return (long)number > this.begin;
        }

        public boolean containsBatch(StockBlankReportBatch another) {
            if (another == null) {
                return false;
            }
            return another.getBegin() >= this.begin && another.getBegin() <= this.end || another.getEnd() >= this.begin && another.getEnd() <= this.end;
        }

        public boolean isAfter(StockBlankReportBatch another) {
            if (another == null) {
                return false;
            }
            return another.getBegin() < this.end;
        }

        StockBlankReportBatch(StockBlankIndex blank) {
            this.begin = StockBlankReportHelper.getNumber(blank.getNumber());
            this.end = StockBlankReportHelper.getNumber(blank.getNumber());
            this.quantity = 1;
            Matcher matcher = numberPattern.matcher(blank.getNumber());
            matcher.find();
            this.numberFormat = "%0" + Integer.toString(blank.getNumber().length() - matcher.start()) + "d";
        }
    }
}

