/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.reports.model;

import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.XCloneModelHelper;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.ProductFop;
import com.gridnine.xtrip.common.model.dict.MCOCategory;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.profile.Card;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.util.TextUtil;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.slf4j.LoggerFactory;

public abstract class BaseReportTicket
implements Serializable {
    private static final long serialVersionUID = 6443462196088378278L;
    protected ProductStatus status;
    protected MCOCategory mcoCategory;
    private String uid;
    protected ProductCategory productCategory;
    protected String ticketNumber;
    protected String ticketSeries;
    protected BigDecimal equivalentFare;
    protected EntityReference<Organization> blankOwner;
    protected EntityReference<Person> agent;
    protected Date issueDate;

    public BaseReportTicket() {
        this.ticketNumber = "";
        this.status = null;
        this.mcoCategory = null;
        this.equivalentFare = BigDecimal.ZERO;
        this.issueDate = new Date();
    }

    public BaseReportTicket(Product ticket, List<Message> messages) {
        this.status = ticket.getStatus();
        this.mcoCategory = ticket.getMcoCategory();
        this.productCategory = ticket.getProductCategory();
        this.uid = ticket.getUid();
        this.ticketNumber = ticket.getSystemNumber();
        this.blankOwner = ticket.getBlankOwnerRef();
        this.agent = ticket.getCashier();
        this.equivalentFare = this.status != ProductStatus.VOID ? AirProductHelper.getEquivalentFare((Product)ticket) : BigDecimal.ZERO;
        this.ticketSeries = AirProductHelper.getTicketSeries((Product)ticket);
        this.issueDate = ticket.getIssueDate();
    }

    public EntityReference<Organization> getBlankOwner() {
        return this.blankOwner;
    }

    public EntityReference<Person> getAgent() {
        return this.agent;
    }

    public BigDecimal getEquivalentFare() {
        return this.equivalentFare;
    }

    public Date getIssueDate() {
        return this.issueDate;
    }

    public MCOCategory getMcoCategory() {
        return this.mcoCategory;
    }

    public ProductCategory getProductCategory() {
        return this.productCategory;
    }

    public ProductStatus getStatus() {
        return this.status;
    }

    public String getTicketNumber() {
        return this.ticketNumber;
    }

    public String getTicketSeries() {
        return this.ticketSeries;
    }

    public String getUid() {
        return this.uid;
    }

    public void setBlankOwner(EntityReference<Organization> value) {
        this.blankOwner = value;
    }

    public void setAgent(EntityReference<Person> value) {
        this.agent = value;
    }

    public void setEquivalentFare(BigDecimal value) {
        this.equivalentFare = value;
    }

    public void setIssueDate(Date value) {
        this.issueDate = value;
    }

    public void setMcoCategory(MCOCategory value) {
        this.mcoCategory = value;
    }

    public void setProductCategory(ProductCategory value) {
        this.productCategory = value;
    }

    public void setStatus(ProductStatus value) {
        this.status = value;
    }

    public void setTicketNumber(String value) {
        this.ticketNumber = value;
    }

    public void setTicketSeries(String value) {
        this.ticketSeries = value;
    }

    public void setUid(String value) {
        this.uid = value;
    }

    private static PaymentType findRelatedPaymentType(ProductFop fop, Collection<ProductFop> rfops) {
        if (rfops.size() == 1) {
            return rfops.iterator().next().getType();
        }
        if (fop.getAmount() == null || fop.getAmount().getValue() == null) {
            return null;
        }
        for (ProductFop fp : rfops) {
            if (fp.getAmount() == null || fp.getAmount().getValue() == null || !(Math.abs(fp.getAmount().getValue().subtract(fop.getAmount().getValue()).doubleValue()) < 1.0E-4)) continue;
            return fp.getType();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<ProductFop> collectFops(Product product, boolean client, List<Message> messages) {
        if (product == null) {
            return new ArrayList<ProductFop>();
        }
        ArrayList<ProductFop> result = new ArrayList<ProductFop>();
        List fops = client ? AirProductHelper.getClientFops((Product)product) : AirProductHelper.getVendorFops((Product)product);
        for (ProductFop fop : fops) {
            if (fop == null) {
                SystemHelper.addMessage(messages, (String)"BaseReportTicket_fopNotSet", null, (MessageType)MessageType.ERROR, (Object[])new Object[]{product.getSystemNumber()});
                return null;
            }
            if (PaymentType.TICKET == fop.getType()) {
                if (product.getStatus() == ProductStatus.VOID || fop.getExchangePaymentType() != null) {
                    ArrayList fares = new ArrayList(fop.getFares());
                    ArrayList taxes = new ArrayList(fop.getTaxes());
                    ArrayList commissions = new ArrayList(fop.getCommissions());
                    Card card = fop.getCard();
                    fop.getFares().clear();
                    fop.getCommissions().clear();
                    fop.getTaxes().clear();
                    fop.getCard();
                    ProductFop fop2 = new ProductFop();
                    try {
                        XCloneModelHelper.copy((BaseEntity)fop, (BaseEntity)fop2);
                        fop2.setCard(card);
                        fop2.getCommissions().addAll(commissions);
                        fop2.getTaxes().addAll(taxes);
                        fop2.getFares().addAll(fares);
                        if (fop.getExchangePaymentType() != null) {
                            fop2.setType(fop.getExchangePaymentType());
                        }
                        result.add(fop2);
                        continue;
                    }
                    catch (Exception e) {
                        messages.add(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)"BaseReportTicket_unableToProcessFop", (Object[])new Object[]{product.getSystemNumber()}));
                        LoggerFactory.getLogger(BaseReportTicket.class).error("unable to clone fop", (Throwable)e);
                        ArrayList<ProductFop> arrayList = new ArrayList<ProductFop>();
                        return arrayList;
                    }
                    finally {
                        fop.getFares().addAll(fares);
                        fop.getCommissions().addAll(commissions);
                        fop.getTaxes().addAll(taxes);
                        fop.setCard(card);
                        continue;
                    }
                }
                if (product.getPreviousProduct() == null) {
                    SystemHelper.addMessage(messages, (String)"BaseReportTicket_noTicketToExchange", null, (MessageType)MessageType.ERROR, (Object[])new Object[]{product.getSystemNumber()});
                    return null;
                }
                PaymentType ptype = null;
                Product pProduct = product;
                do {
                    pProduct = pProduct.getPreviousProduct();
                } while ((ptype = BaseReportTicket.findRelatedPaymentType(fop, client ? AirProductHelper.getClientFops((Product)pProduct) : AirProductHelper.getVendorFops((Product)pProduct))) == PaymentType.TICKET);
                if (ptype == null) {
                    SystemHelper.addMessage(messages, (String)"BaseReportTicket_unableToFindFopInExchangeTicket", null, (MessageType)MessageType.ERROR, (Object[])new Object[]{product.getSystemNumber(), PaymentType.TICKET, fop.getAmount() != null && fop.getAmount().getValue() != null ? fop.getAmount().getValue() : BigDecimal.ZERO});
                    return null;
                }
                ProductFop fop2 = new ProductFop();
                try {
                    XCloneModelHelper.copy((BaseEntity)fop, (BaseEntity)fop2, (boolean)true);
                }
                catch (Exception e) {
                    SystemHelper.addMessage(messages, (String)"BaseReportTicket_internalError", (String)TextUtil.getExceptionStackTrace((Throwable)e), (MessageType)MessageType.ERROR, (Object[])new Object[]{product.getSystemNumber()});
                    LoggerFactory.getLogger(BaseReportTicket.class).error("unable to copy FOP", (Throwable)e);
                    return null;
                }
                fop2.setType(ptype);
                fop2.setAgent(fop.getAgent());
                result.add(fop2);
                continue;
            }
            result.add(fop);
        }
        return result;
    }
}

