/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.reports.render;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.excel.ExcelUtils;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.system.ContentType;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.reports.l10n.Messages;
import com.gridnine.xtrip.common.reports.model.BaseReportDocument;
import com.gridnine.xtrip.common.reports.model.ReportBatchData;
import com.gridnine.xtrip.common.reports.model.ReportFile;
import com.gridnine.xtrip.common.reports.model.ReportHelper;
import com.gridnine.xtrip.common.reports.render.PoiWorksheetData;
import com.gridnine.xtrip.common.reports.render.PoiWorksheetDefinition;
import com.gridnine.xtrip.common.reports.render.PoiWorksheetHandler;
import com.gridnine.xtrip.common.reports.render.ReportRenderHandler;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFFormulaEvaluator;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;

public abstract class BasePoiReportRenderHandler<T>
implements ReportRenderHandler {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EntityContainer<? extends BaseReportDocument> renderReport(Map<String, Object> data) throws Exception {
        try (InputStream is = this.getInputStream(data);){
            EntityContainer<BaseReportDocument> entityContainer;
            POIFSFileSystem fs = new POIFSFileSystem(is);
            HSSFWorkbook wb = new HSSFWorkbook(fs);
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            try {
                this.prepareReport(wb, data);
                wb.write((OutputStream)os);
                ReportFile file = new ReportFile();
                file.setTitle(this.getReportTitle(data));
                file.setContentType(ContentType.EXCEL);
                file.setContent(os.toByteArray());
                file.setName(this.getReportFileName(data));
                EntityContainer<BaseReportDocument> result = this.createContainer(file, data);
                ((BaseReportDocument)result.getEntity()).setCreated(new Date());
                entityContainer = result;
            }
            catch (Throwable throwable) {
                os.close();
                throw throwable;
            }
            os.close();
            return entityContainer;
        }
    }

    protected String getReportFileName(Map<String, Object> data) {
        return ReportHelper.cleanUpFileName(this.getReportTitle(data)) + ".xls";
    }

    protected void prepareReport(HSSFWorkbook wb, Map<String, Object> data) throws Exception {
        List<PoiWorksheetData<T>> workbookData = this.createDataList();
        this.initializeDataList(workbookData, data);
        List messages = (List)data.get("key-messages");
        Collections.sort(workbookData, new Comparator<PoiWorksheetData<T>>(){

            @Override
            public int compare(PoiWorksheetData<T> t1, PoiWorksheetData<T> t2) {
                return t1.getProirity() - t2.getProirity();
            }
        });
        for (PoiWorksheetData<T> wData : workbookData) {
            PoiWorksheetDefinition<T> definition = wData.getDefinition();
            if (definition == null) {
                SystemHelper.addMessage((Collection)messages, (String)"BasePoiRenderHandler_noDefinitionForWorksheet", null, (MessageType)MessageType.WARNING, (Object[])new Object[]{wData.getBatchId()});
                continue;
            }
            PoiWorksheetHandler<T> handler = definition.getHandler();
            if (handler == null) {
                SystemHelper.addMessage((Collection)messages, (String)"BasePoiRenderHandler_noHandlerDefined", null, (MessageType)MessageType.WARNING, (Object[])new Object[]{wData.getBatchId()});
                continue;
            }
            HSSFSheet sheet = ExcelUtils.findSheet((HSSFWorkbook)wb, (String)definition.getWorksheetTemplateName());
            if (sheet == null) {
                SystemHelper.addMessage((Collection)messages, (String)"BasePoiRenderHandler_unableToFindSheet", null, (MessageType)MessageType.WARNING, (Object[])new Object[]{definition.getWorksheetTemplateName()});
                continue;
            }
            handler.fill(wb, sheet, wData, data);
        }
        if (wb.getNumberOfSheets() == 0) {
            wb.createSheet();
        }
        HSSFFormulaEvaluator.evaluateAllFormulaCells((HSSFWorkbook)wb);
        wb.setActiveSheet(0);
        wb.setSelectedTab(0);
    }

    protected void initializeDataList(List<PoiWorksheetData<T>> dataList, Map<String, Object> data) {
        List messages = (List)data.get("key-messages");
        List batchDataList = (List)data.get("key-batch-data-list");
        boolean isDivergenceReportWithNoData = Boolean.TRUE.equals(data.get("DIVERGENCE_REPORT_NOT_FOUND"));
        if (batchDataList == null && !isDivergenceReportWithNoData) {
            SystemHelper.addMessage((Collection)messages, (String)"BasePoiRenderHandler_noBatchesPrepared", null, (MessageType)MessageType.ERROR, (Object[])new Object[0]);
            return;
        }
        if (isDivergenceReportWithNoData) {
            SystemHelper.addMessage((Collection)messages, (String)Messages.BasePoiRenderHandler_noBatchesForDivergenceReport, null, (MessageType)MessageType.MESSAGE, (Object[])new Object[0]);
            return;
        }
        for (ReportBatchData batchData : batchDataList) {
            PoiWorksheetData<T> worksheetData = null;
            for (PoiWorksheetData<T> wd : dataList) {
                if (!wd.getBatchId().equals(batchData.getBatchId())) continue;
                worksheetData = wd;
                break;
            }
            if (worksheetData == null) {
                SystemHelper.addMessage((Collection)messages, (String)"unableToFindWorksheetDataForBatch", null, (MessageType)MessageType.WARNING, (Object[])new Object[]{batchData.getBatchId()});
                continue;
            }
            worksheetData.getTickets().addAll(batchData.getTickets());
        }
    }

    protected abstract EntityContainer<? extends BaseReportDocument> createContainer(ReportFile var1, Map<String, Object> var2);

    protected abstract InputStream getInputStream(Map<String, Object> var1) throws Exception;

    protected abstract String getReportTitle(Map<String, Object> var1);

    protected abstract List<PoiWorksheetData<T>> createDataList();
}

